// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockLdapConfigListerMockGet  sync.RWMutex
	lockLdapConfigListerMockList sync.RWMutex
)

// Ensure, that LdapConfigListerMock does implement v31.LdapConfigLister.
// If this is not the case, regenerate this file with moq.
var _ v31.LdapConfigLister = &LdapConfigListerMock{}

// LdapConfigListerMock is a mock implementation of v31.LdapConfigLister.
//
//	    func TestSomethingThatUsesLdapConfigLister(t *testing.T) {
//
//	        // make and configure a mocked v31.LdapConfigLister
//	        mockedLdapConfigLister := &LdapConfigListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.LdapConfig, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.LdapConfig, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedLdapConfigLister in code that requires v31.LdapConfigLister
//	        // and then make assertions.
//
//	    }
type LdapConfigListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.LdapConfig, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.LdapConfig, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *LdapConfigListerMock) Get(namespace string, name string) (*v3.LdapConfig, error) {
	if mock.GetFunc == nil {
		panic("LdapConfigListerMock.GetFunc: method is nil but LdapConfigLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockLdapConfigListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockLdapConfigListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedLdapConfigLister.GetCalls())
func (mock *LdapConfigListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockLdapConfigListerMockGet.RLock()
	calls = mock.calls.Get
	lockLdapConfigListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *LdapConfigListerMock) List(namespace string, selector labels.Selector) ([]*v3.LdapConfig, error) {
	if mock.ListFunc == nil {
		panic("LdapConfigListerMock.ListFunc: method is nil but LdapConfigLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockLdapConfigListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockLdapConfigListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedLdapConfigLister.ListCalls())
func (mock *LdapConfigListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockLdapConfigListerMockList.RLock()
	calls = mock.calls.List
	lockLdapConfigListerMockList.RUnlock()
	return calls
}

var (
	lockLdapConfigControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockLdapConfigControllerMockAddClusterScopedHandler        sync.RWMutex
	lockLdapConfigControllerMockAddFeatureHandler              sync.RWMutex
	lockLdapConfigControllerMockAddHandler                     sync.RWMutex
	lockLdapConfigControllerMockEnqueue                        sync.RWMutex
	lockLdapConfigControllerMockEnqueueAfter                   sync.RWMutex
	lockLdapConfigControllerMockGeneric                        sync.RWMutex
	lockLdapConfigControllerMockInformer                       sync.RWMutex
	lockLdapConfigControllerMockLister                         sync.RWMutex
)

// Ensure, that LdapConfigControllerMock does implement v31.LdapConfigController.
// If this is not the case, regenerate this file with moq.
var _ v31.LdapConfigController = &LdapConfigControllerMock{}

// LdapConfigControllerMock is a mock implementation of v31.LdapConfigController.
//
//	    func TestSomethingThatUsesLdapConfigController(t *testing.T) {
//
//	        // make and configure a mocked v31.LdapConfigController
//	        mockedLdapConfigController := &LdapConfigControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.LdapConfigHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.LdapConfigHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.LdapConfigHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.LdapConfigHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.LdapConfigLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedLdapConfigController in code that requires v31.LdapConfigController
//	        // and then make assertions.
//
//	    }
type LdapConfigControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.LdapConfigHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.LdapConfigHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.LdapConfigHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.LdapConfigHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.LdapConfigLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.LdapConfigHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.LdapConfigHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.LdapConfigHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.LdapConfigHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *LdapConfigControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.LdapConfigHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("LdapConfigControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but LdapConfigController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.LdapConfigHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockLdapConfigControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockLdapConfigControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedLdapConfigController.AddClusterScopedFeatureHandlerCalls())
func (mock *LdapConfigControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.LdapConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.LdapConfigHandlerFunc
	}
	lockLdapConfigControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockLdapConfigControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *LdapConfigControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.LdapConfigHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("LdapConfigControllerMock.AddClusterScopedHandlerFunc: method is nil but LdapConfigController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.LdapConfigHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockLdapConfigControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockLdapConfigControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedLdapConfigController.AddClusterScopedHandlerCalls())
func (mock *LdapConfigControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.LdapConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.LdapConfigHandlerFunc
	}
	lockLdapConfigControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockLdapConfigControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *LdapConfigControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.LdapConfigHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("LdapConfigControllerMock.AddFeatureHandlerFunc: method is nil but LdapConfigController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.LdapConfigHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockLdapConfigControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockLdapConfigControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedLdapConfigController.AddFeatureHandlerCalls())
func (mock *LdapConfigControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.LdapConfigHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.LdapConfigHandlerFunc
	}
	lockLdapConfigControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockLdapConfigControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *LdapConfigControllerMock) AddHandler(ctx context.Context, name string, handler v31.LdapConfigHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("LdapConfigControllerMock.AddHandlerFunc: method is nil but LdapConfigController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.LdapConfigHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockLdapConfigControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockLdapConfigControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedLdapConfigController.AddHandlerCalls())
func (mock *LdapConfigControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.LdapConfigHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.LdapConfigHandlerFunc
	}
	lockLdapConfigControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockLdapConfigControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *LdapConfigControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("LdapConfigControllerMock.EnqueueFunc: method is nil but LdapConfigController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockLdapConfigControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockLdapConfigControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedLdapConfigController.EnqueueCalls())
func (mock *LdapConfigControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockLdapConfigControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockLdapConfigControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *LdapConfigControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("LdapConfigControllerMock.EnqueueAfterFunc: method is nil but LdapConfigController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockLdapConfigControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockLdapConfigControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedLdapConfigController.EnqueueAfterCalls())
func (mock *LdapConfigControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockLdapConfigControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockLdapConfigControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *LdapConfigControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("LdapConfigControllerMock.GenericFunc: method is nil but LdapConfigController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockLdapConfigControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockLdapConfigControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedLdapConfigController.GenericCalls())
func (mock *LdapConfigControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockLdapConfigControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockLdapConfigControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *LdapConfigControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("LdapConfigControllerMock.InformerFunc: method is nil but LdapConfigController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockLdapConfigControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockLdapConfigControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedLdapConfigController.InformerCalls())
func (mock *LdapConfigControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockLdapConfigControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockLdapConfigControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *LdapConfigControllerMock) Lister() v31.LdapConfigLister {
	if mock.ListerFunc == nil {
		panic("LdapConfigControllerMock.ListerFunc: method is nil but LdapConfigController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockLdapConfigControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockLdapConfigControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedLdapConfigController.ListerCalls())
func (mock *LdapConfigControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockLdapConfigControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockLdapConfigControllerMockLister.RUnlock()
	return calls
}

var (
	lockLdapConfigInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockLdapConfigInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockLdapConfigInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockLdapConfigInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockLdapConfigInterfaceMockAddFeatureHandler                sync.RWMutex
	lockLdapConfigInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockLdapConfigInterfaceMockAddHandler                       sync.RWMutex
	lockLdapConfigInterfaceMockAddLifecycle                     sync.RWMutex
	lockLdapConfigInterfaceMockController                       sync.RWMutex
	lockLdapConfigInterfaceMockCreate                           sync.RWMutex
	lockLdapConfigInterfaceMockDelete                           sync.RWMutex
	lockLdapConfigInterfaceMockDeleteCollection                 sync.RWMutex
	lockLdapConfigInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockLdapConfigInterfaceMockGet                              sync.RWMutex
	lockLdapConfigInterfaceMockGetNamespaced                    sync.RWMutex
	lockLdapConfigInterfaceMockList                             sync.RWMutex
	lockLdapConfigInterfaceMockListNamespaced                   sync.RWMutex
	lockLdapConfigInterfaceMockObjectClient                     sync.RWMutex
	lockLdapConfigInterfaceMockUpdate                           sync.RWMutex
	lockLdapConfigInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that LdapConfigInterfaceMock does implement v31.LdapConfigInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.LdapConfigInterface = &LdapConfigInterfaceMock{}

// LdapConfigInterfaceMock is a mock implementation of v31.LdapConfigInterface.
//
//	    func TestSomethingThatUsesLdapConfigInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.LdapConfigInterface
//	        mockedLdapConfigInterface := &LdapConfigInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.LdapConfigHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.LdapConfigLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.LdapConfigHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.LdapConfigLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.LdapConfigHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.LdapConfigLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.LdapConfigHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.LdapConfigLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.LdapConfigController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.LdapConfig) (*v3.LdapConfig, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.LdapConfig, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.LdapConfig, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.LdapConfigList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.LdapConfigList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.LdapConfig) (*v3.LdapConfig, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedLdapConfigInterface in code that requires v31.LdapConfigInterface
//	        // and then make assertions.
//
//	    }
type LdapConfigInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.LdapConfigHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.LdapConfigLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.LdapConfigHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.LdapConfigLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.LdapConfigHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.LdapConfigLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.LdapConfigHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.LdapConfigLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.LdapConfigController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.LdapConfig) (*v3.LdapConfig, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.LdapConfig, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.LdapConfig, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.LdapConfigList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.LdapConfigList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.LdapConfig) (*v3.LdapConfig, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.LdapConfigHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.LdapConfigLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.LdapConfigHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.LdapConfigLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.LdapConfigHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.LdapConfigLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.LdapConfigHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.LdapConfigLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.LdapConfig
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.LdapConfig
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *LdapConfigInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.LdapConfigHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("LdapConfigInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but LdapConfigInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.LdapConfigHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockLdapConfigInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockLdapConfigInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedLdapConfigInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *LdapConfigInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.LdapConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.LdapConfigHandlerFunc
	}
	lockLdapConfigInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockLdapConfigInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *LdapConfigInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.LdapConfigLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("LdapConfigInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but LdapConfigInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.LdapConfigLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockLdapConfigInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockLdapConfigInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedLdapConfigInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *LdapConfigInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.LdapConfigLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.LdapConfigLifecycle
	}
	lockLdapConfigInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockLdapConfigInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *LdapConfigInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.LdapConfigHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("LdapConfigInterfaceMock.AddClusterScopedHandlerFunc: method is nil but LdapConfigInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.LdapConfigHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockLdapConfigInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockLdapConfigInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedLdapConfigInterface.AddClusterScopedHandlerCalls())
func (mock *LdapConfigInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.LdapConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.LdapConfigHandlerFunc
	}
	lockLdapConfigInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockLdapConfigInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *LdapConfigInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.LdapConfigLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("LdapConfigInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but LdapConfigInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.LdapConfigLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockLdapConfigInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockLdapConfigInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedLdapConfigInterface.AddClusterScopedLifecycleCalls())
func (mock *LdapConfigInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.LdapConfigLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.LdapConfigLifecycle
	}
	lockLdapConfigInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockLdapConfigInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *LdapConfigInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.LdapConfigHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("LdapConfigInterfaceMock.AddFeatureHandlerFunc: method is nil but LdapConfigInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.LdapConfigHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockLdapConfigInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockLdapConfigInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedLdapConfigInterface.AddFeatureHandlerCalls())
func (mock *LdapConfigInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.LdapConfigHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.LdapConfigHandlerFunc
	}
	lockLdapConfigInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockLdapConfigInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *LdapConfigInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.LdapConfigLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("LdapConfigInterfaceMock.AddFeatureLifecycleFunc: method is nil but LdapConfigInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.LdapConfigLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockLdapConfigInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockLdapConfigInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedLdapConfigInterface.AddFeatureLifecycleCalls())
func (mock *LdapConfigInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.LdapConfigLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.LdapConfigLifecycle
	}
	lockLdapConfigInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockLdapConfigInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *LdapConfigInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.LdapConfigHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("LdapConfigInterfaceMock.AddHandlerFunc: method is nil but LdapConfigInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.LdapConfigHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockLdapConfigInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockLdapConfigInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedLdapConfigInterface.AddHandlerCalls())
func (mock *LdapConfigInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.LdapConfigHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.LdapConfigHandlerFunc
	}
	lockLdapConfigInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockLdapConfigInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *LdapConfigInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.LdapConfigLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("LdapConfigInterfaceMock.AddLifecycleFunc: method is nil but LdapConfigInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.LdapConfigLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockLdapConfigInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockLdapConfigInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedLdapConfigInterface.AddLifecycleCalls())
func (mock *LdapConfigInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.LdapConfigLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.LdapConfigLifecycle
	}
	lockLdapConfigInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockLdapConfigInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *LdapConfigInterfaceMock) Controller() v31.LdapConfigController {
	if mock.ControllerFunc == nil {
		panic("LdapConfigInterfaceMock.ControllerFunc: method is nil but LdapConfigInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockLdapConfigInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockLdapConfigInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedLdapConfigInterface.ControllerCalls())
func (mock *LdapConfigInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockLdapConfigInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockLdapConfigInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *LdapConfigInterfaceMock) Create(in1 *v3.LdapConfig) (*v3.LdapConfig, error) {
	if mock.CreateFunc == nil {
		panic("LdapConfigInterfaceMock.CreateFunc: method is nil but LdapConfigInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.LdapConfig
	}{
		In1: in1,
	}
	lockLdapConfigInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockLdapConfigInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedLdapConfigInterface.CreateCalls())
func (mock *LdapConfigInterfaceMock) CreateCalls() []struct {
	In1 *v3.LdapConfig
} {
	var calls []struct {
		In1 *v3.LdapConfig
	}
	lockLdapConfigInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockLdapConfigInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *LdapConfigInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("LdapConfigInterfaceMock.DeleteFunc: method is nil but LdapConfigInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockLdapConfigInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockLdapConfigInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedLdapConfigInterface.DeleteCalls())
func (mock *LdapConfigInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockLdapConfigInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockLdapConfigInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *LdapConfigInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("LdapConfigInterfaceMock.DeleteCollectionFunc: method is nil but LdapConfigInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockLdapConfigInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockLdapConfigInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedLdapConfigInterface.DeleteCollectionCalls())
func (mock *LdapConfigInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockLdapConfigInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockLdapConfigInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *LdapConfigInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("LdapConfigInterfaceMock.DeleteNamespacedFunc: method is nil but LdapConfigInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockLdapConfigInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockLdapConfigInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedLdapConfigInterface.DeleteNamespacedCalls())
func (mock *LdapConfigInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockLdapConfigInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockLdapConfigInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *LdapConfigInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.LdapConfig, error) {
	if mock.GetFunc == nil {
		panic("LdapConfigInterfaceMock.GetFunc: method is nil but LdapConfigInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockLdapConfigInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockLdapConfigInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedLdapConfigInterface.GetCalls())
func (mock *LdapConfigInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockLdapConfigInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockLdapConfigInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *LdapConfigInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.LdapConfig, error) {
	if mock.GetNamespacedFunc == nil {
		panic("LdapConfigInterfaceMock.GetNamespacedFunc: method is nil but LdapConfigInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockLdapConfigInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockLdapConfigInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedLdapConfigInterface.GetNamespacedCalls())
func (mock *LdapConfigInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockLdapConfigInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockLdapConfigInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *LdapConfigInterfaceMock) List(opts metav1.ListOptions) (*v3.LdapConfigList, error) {
	if mock.ListFunc == nil {
		panic("LdapConfigInterfaceMock.ListFunc: method is nil but LdapConfigInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockLdapConfigInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockLdapConfigInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedLdapConfigInterface.ListCalls())
func (mock *LdapConfigInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockLdapConfigInterfaceMockList.RLock()
	calls = mock.calls.List
	lockLdapConfigInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *LdapConfigInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.LdapConfigList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("LdapConfigInterfaceMock.ListNamespacedFunc: method is nil but LdapConfigInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockLdapConfigInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockLdapConfigInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedLdapConfigInterface.ListNamespacedCalls())
func (mock *LdapConfigInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockLdapConfigInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockLdapConfigInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *LdapConfigInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("LdapConfigInterfaceMock.ObjectClientFunc: method is nil but LdapConfigInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockLdapConfigInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockLdapConfigInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedLdapConfigInterface.ObjectClientCalls())
func (mock *LdapConfigInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockLdapConfigInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockLdapConfigInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *LdapConfigInterfaceMock) Update(in1 *v3.LdapConfig) (*v3.LdapConfig, error) {
	if mock.UpdateFunc == nil {
		panic("LdapConfigInterfaceMock.UpdateFunc: method is nil but LdapConfigInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.LdapConfig
	}{
		In1: in1,
	}
	lockLdapConfigInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockLdapConfigInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedLdapConfigInterface.UpdateCalls())
func (mock *LdapConfigInterfaceMock) UpdateCalls() []struct {
	In1 *v3.LdapConfig
} {
	var calls []struct {
		In1 *v3.LdapConfig
	}
	lockLdapConfigInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockLdapConfigInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *LdapConfigInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("LdapConfigInterfaceMock.WatchFunc: method is nil but LdapConfigInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockLdapConfigInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockLdapConfigInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedLdapConfigInterface.WatchCalls())
func (mock *LdapConfigInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockLdapConfigInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockLdapConfigInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockLdapConfigsGetterMockLdapConfigs sync.RWMutex
)

// Ensure, that LdapConfigsGetterMock does implement v31.LdapConfigsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.LdapConfigsGetter = &LdapConfigsGetterMock{}

// LdapConfigsGetterMock is a mock implementation of v31.LdapConfigsGetter.
//
//	    func TestSomethingThatUsesLdapConfigsGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.LdapConfigsGetter
//	        mockedLdapConfigsGetter := &LdapConfigsGetterMock{
//	            LdapConfigsFunc: func(namespace string) v31.LdapConfigInterface {
//		               panic("mock out the LdapConfigs method")
//	            },
//	        }
//
//	        // use mockedLdapConfigsGetter in code that requires v31.LdapConfigsGetter
//	        // and then make assertions.
//
//	    }
type LdapConfigsGetterMock struct {
	// LdapConfigsFunc mocks the LdapConfigs method.
	LdapConfigsFunc func(namespace string) v31.LdapConfigInterface

	// calls tracks calls to the methods.
	calls struct {
		// LdapConfigs holds details about calls to the LdapConfigs method.
		LdapConfigs []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// LdapConfigs calls LdapConfigsFunc.
func (mock *LdapConfigsGetterMock) LdapConfigs(namespace string) v31.LdapConfigInterface {
	if mock.LdapConfigsFunc == nil {
		panic("LdapConfigsGetterMock.LdapConfigsFunc: method is nil but LdapConfigsGetter.LdapConfigs was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockLdapConfigsGetterMockLdapConfigs.Lock()
	mock.calls.LdapConfigs = append(mock.calls.LdapConfigs, callInfo)
	lockLdapConfigsGetterMockLdapConfigs.Unlock()
	return mock.LdapConfigsFunc(namespace)
}

// LdapConfigsCalls gets all the calls that were made to LdapConfigs.
// Check the length with:
//
//	len(mockedLdapConfigsGetter.LdapConfigsCalls())
func (mock *LdapConfigsGetterMock) LdapConfigsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockLdapConfigsGetterMockLdapConfigs.RLock()
	calls = mock.calls.LdapConfigs
	lockLdapConfigsGetterMockLdapConfigs.RUnlock()
	return calls
}
