// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockNodeDriverListerMockGet  sync.RWMutex
	lockNodeDriverListerMockList sync.RWMutex
)

// Ensure, that NodeDriverListerMock does implement v31.NodeDriverLister.
// If this is not the case, regenerate this file with moq.
var _ v31.NodeDriverLister = &NodeDriverListerMock{}

// NodeDriverListerMock is a mock implementation of v31.NodeDriverLister.
//
//	    func TestSomethingThatUsesNodeDriverLister(t *testing.T) {
//
//	        // make and configure a mocked v31.NodeDriverLister
//	        mockedNodeDriverLister := &NodeDriverListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.NodeDriver, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.NodeDriver, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedNodeDriverLister in code that requires v31.NodeDriverLister
//	        // and then make assertions.
//
//	    }
type NodeDriverListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.NodeDriver, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.NodeDriver, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *NodeDriverListerMock) Get(namespace string, name string) (*v3.NodeDriver, error) {
	if mock.GetFunc == nil {
		panic("NodeDriverListerMock.GetFunc: method is nil but NodeDriverLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNodeDriverListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNodeDriverListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedNodeDriverLister.GetCalls())
func (mock *NodeDriverListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNodeDriverListerMockGet.RLock()
	calls = mock.calls.Get
	lockNodeDriverListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NodeDriverListerMock) List(namespace string, selector labels.Selector) ([]*v3.NodeDriver, error) {
	if mock.ListFunc == nil {
		panic("NodeDriverListerMock.ListFunc: method is nil but NodeDriverLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockNodeDriverListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNodeDriverListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedNodeDriverLister.ListCalls())
func (mock *NodeDriverListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockNodeDriverListerMockList.RLock()
	calls = mock.calls.List
	lockNodeDriverListerMockList.RUnlock()
	return calls
}

var (
	lockNodeDriverControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockNodeDriverControllerMockAddClusterScopedHandler        sync.RWMutex
	lockNodeDriverControllerMockAddFeatureHandler              sync.RWMutex
	lockNodeDriverControllerMockAddHandler                     sync.RWMutex
	lockNodeDriverControllerMockEnqueue                        sync.RWMutex
	lockNodeDriverControllerMockEnqueueAfter                   sync.RWMutex
	lockNodeDriverControllerMockGeneric                        sync.RWMutex
	lockNodeDriverControllerMockInformer                       sync.RWMutex
	lockNodeDriverControllerMockLister                         sync.RWMutex
)

// Ensure, that NodeDriverControllerMock does implement v31.NodeDriverController.
// If this is not the case, regenerate this file with moq.
var _ v31.NodeDriverController = &NodeDriverControllerMock{}

// NodeDriverControllerMock is a mock implementation of v31.NodeDriverController.
//
//	    func TestSomethingThatUsesNodeDriverController(t *testing.T) {
//
//	        // make and configure a mocked v31.NodeDriverController
//	        mockedNodeDriverController := &NodeDriverControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NodeDriverHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.NodeDriverHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeDriverHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.NodeDriverHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.NodeDriverLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedNodeDriverController in code that requires v31.NodeDriverController
//	        // and then make assertions.
//
//	    }
type NodeDriverControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NodeDriverHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.NodeDriverHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeDriverHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.NodeDriverHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.NodeDriverLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NodeDriverHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NodeDriverHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NodeDriverHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.NodeDriverHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NodeDriverControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NodeDriverHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NodeDriverControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but NodeDriverController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NodeDriverHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNodeDriverControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNodeDriverControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedNodeDriverController.AddClusterScopedFeatureHandlerCalls())
func (mock *NodeDriverControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.NodeDriverHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NodeDriverHandlerFunc
	}
	lockNodeDriverControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNodeDriverControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NodeDriverControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.NodeDriverHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NodeDriverControllerMock.AddClusterScopedHandlerFunc: method is nil but NodeDriverController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NodeDriverHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNodeDriverControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNodeDriverControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedNodeDriverController.AddClusterScopedHandlerCalls())
func (mock *NodeDriverControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.NodeDriverHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NodeDriverHandlerFunc
	}
	lockNodeDriverControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNodeDriverControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NodeDriverControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeDriverHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NodeDriverControllerMock.AddFeatureHandlerFunc: method is nil but NodeDriverController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodeDriverHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNodeDriverControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNodeDriverControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedNodeDriverController.AddFeatureHandlerCalls())
func (mock *NodeDriverControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NodeDriverHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodeDriverHandlerFunc
	}
	lockNodeDriverControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNodeDriverControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NodeDriverControllerMock) AddHandler(ctx context.Context, name string, handler v31.NodeDriverHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NodeDriverControllerMock.AddHandlerFunc: method is nil but NodeDriverController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.NodeDriverHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockNodeDriverControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNodeDriverControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedNodeDriverController.AddHandlerCalls())
func (mock *NodeDriverControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.NodeDriverHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.NodeDriverHandlerFunc
	}
	lockNodeDriverControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNodeDriverControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *NodeDriverControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("NodeDriverControllerMock.EnqueueFunc: method is nil but NodeDriverController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNodeDriverControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockNodeDriverControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedNodeDriverController.EnqueueCalls())
func (mock *NodeDriverControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNodeDriverControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockNodeDriverControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *NodeDriverControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("NodeDriverControllerMock.EnqueueAfterFunc: method is nil but NodeDriverController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockNodeDriverControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockNodeDriverControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedNodeDriverController.EnqueueAfterCalls())
func (mock *NodeDriverControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockNodeDriverControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockNodeDriverControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *NodeDriverControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("NodeDriverControllerMock.GenericFunc: method is nil but NodeDriverController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockNodeDriverControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockNodeDriverControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedNodeDriverController.GenericCalls())
func (mock *NodeDriverControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeDriverControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockNodeDriverControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *NodeDriverControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("NodeDriverControllerMock.InformerFunc: method is nil but NodeDriverController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockNodeDriverControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockNodeDriverControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedNodeDriverController.InformerCalls())
func (mock *NodeDriverControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeDriverControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockNodeDriverControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *NodeDriverControllerMock) Lister() v31.NodeDriverLister {
	if mock.ListerFunc == nil {
		panic("NodeDriverControllerMock.ListerFunc: method is nil but NodeDriverController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockNodeDriverControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockNodeDriverControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedNodeDriverController.ListerCalls())
func (mock *NodeDriverControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeDriverControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockNodeDriverControllerMockLister.RUnlock()
	return calls
}

var (
	lockNodeDriverInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockNodeDriverInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockNodeDriverInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockNodeDriverInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockNodeDriverInterfaceMockAddFeatureHandler                sync.RWMutex
	lockNodeDriverInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockNodeDriverInterfaceMockAddHandler                       sync.RWMutex
	lockNodeDriverInterfaceMockAddLifecycle                     sync.RWMutex
	lockNodeDriverInterfaceMockController                       sync.RWMutex
	lockNodeDriverInterfaceMockCreate                           sync.RWMutex
	lockNodeDriverInterfaceMockDelete                           sync.RWMutex
	lockNodeDriverInterfaceMockDeleteCollection                 sync.RWMutex
	lockNodeDriverInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockNodeDriverInterfaceMockGet                              sync.RWMutex
	lockNodeDriverInterfaceMockGetNamespaced                    sync.RWMutex
	lockNodeDriverInterfaceMockList                             sync.RWMutex
	lockNodeDriverInterfaceMockListNamespaced                   sync.RWMutex
	lockNodeDriverInterfaceMockObjectClient                     sync.RWMutex
	lockNodeDriverInterfaceMockUpdate                           sync.RWMutex
	lockNodeDriverInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that NodeDriverInterfaceMock does implement v31.NodeDriverInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.NodeDriverInterface = &NodeDriverInterfaceMock{}

// NodeDriverInterfaceMock is a mock implementation of v31.NodeDriverInterface.
//
//	    func TestSomethingThatUsesNodeDriverInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.NodeDriverInterface
//	        mockedNodeDriverInterface := &NodeDriverInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NodeDriverHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NodeDriverLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NodeDriverHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.NodeDriverLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeDriverHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NodeDriverLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.NodeDriverHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.NodeDriverLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.NodeDriverController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.NodeDriver) (*v3.NodeDriver, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.NodeDriver, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.NodeDriver, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.NodeDriverList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.NodeDriverList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.NodeDriver) (*v3.NodeDriver, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedNodeDriverInterface in code that requires v31.NodeDriverInterface
//	        // and then make assertions.
//
//	    }
type NodeDriverInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NodeDriverHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NodeDriverLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NodeDriverHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.NodeDriverLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeDriverHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NodeDriverLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.NodeDriverHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.NodeDriverLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.NodeDriverController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.NodeDriver) (*v3.NodeDriver, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.NodeDriver, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.NodeDriver, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.NodeDriverList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.NodeDriverList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.NodeDriver) (*v3.NodeDriver, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NodeDriverHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodeDriverLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NodeDriverHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodeDriverLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NodeDriverHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodeDriverLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NodeDriverHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodeDriverLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.NodeDriver
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.NodeDriver
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NodeDriverInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NodeDriverHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NodeDriverInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but NodeDriverInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NodeDriverHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNodeDriverInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNodeDriverInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedNodeDriverInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *NodeDriverInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.NodeDriverHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NodeDriverHandlerFunc
	}
	lockNodeDriverInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNodeDriverInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *NodeDriverInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NodeDriverLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("NodeDriverInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but NodeDriverInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NodeDriverLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNodeDriverInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockNodeDriverInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedNodeDriverInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *NodeDriverInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.NodeDriverLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NodeDriverLifecycle
	}
	lockNodeDriverInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockNodeDriverInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NodeDriverInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.NodeDriverHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NodeDriverInterfaceMock.AddClusterScopedHandlerFunc: method is nil but NodeDriverInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NodeDriverHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNodeDriverInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNodeDriverInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedNodeDriverInterface.AddClusterScopedHandlerCalls())
func (mock *NodeDriverInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.NodeDriverHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NodeDriverHandlerFunc
	}
	lockNodeDriverInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNodeDriverInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *NodeDriverInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.NodeDriverLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("NodeDriverInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but NodeDriverInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NodeDriverLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNodeDriverInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockNodeDriverInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedNodeDriverInterface.AddClusterScopedLifecycleCalls())
func (mock *NodeDriverInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.NodeDriverLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NodeDriverLifecycle
	}
	lockNodeDriverInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockNodeDriverInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NodeDriverInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeDriverHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NodeDriverInterfaceMock.AddFeatureHandlerFunc: method is nil but NodeDriverInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodeDriverHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNodeDriverInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNodeDriverInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedNodeDriverInterface.AddFeatureHandlerCalls())
func (mock *NodeDriverInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NodeDriverHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodeDriverHandlerFunc
	}
	lockNodeDriverInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNodeDriverInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *NodeDriverInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.NodeDriverLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("NodeDriverInterfaceMock.AddFeatureLifecycleFunc: method is nil but NodeDriverInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NodeDriverLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNodeDriverInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockNodeDriverInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedNodeDriverInterface.AddFeatureLifecycleCalls())
func (mock *NodeDriverInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.NodeDriverLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NodeDriverLifecycle
	}
	lockNodeDriverInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockNodeDriverInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NodeDriverInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.NodeDriverHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NodeDriverInterfaceMock.AddHandlerFunc: method is nil but NodeDriverInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.NodeDriverHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockNodeDriverInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNodeDriverInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedNodeDriverInterface.AddHandlerCalls())
func (mock *NodeDriverInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.NodeDriverHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.NodeDriverHandlerFunc
	}
	lockNodeDriverInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNodeDriverInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *NodeDriverInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.NodeDriverLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("NodeDriverInterfaceMock.AddLifecycleFunc: method is nil but NodeDriverInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NodeDriverLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNodeDriverInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockNodeDriverInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedNodeDriverInterface.AddLifecycleCalls())
func (mock *NodeDriverInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.NodeDriverLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NodeDriverLifecycle
	}
	lockNodeDriverInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockNodeDriverInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *NodeDriverInterfaceMock) Controller() v31.NodeDriverController {
	if mock.ControllerFunc == nil {
		panic("NodeDriverInterfaceMock.ControllerFunc: method is nil but NodeDriverInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockNodeDriverInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockNodeDriverInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedNodeDriverInterface.ControllerCalls())
func (mock *NodeDriverInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeDriverInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockNodeDriverInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *NodeDriverInterfaceMock) Create(in1 *v3.NodeDriver) (*v3.NodeDriver, error) {
	if mock.CreateFunc == nil {
		panic("NodeDriverInterfaceMock.CreateFunc: method is nil but NodeDriverInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.NodeDriver
	}{
		In1: in1,
	}
	lockNodeDriverInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockNodeDriverInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedNodeDriverInterface.CreateCalls())
func (mock *NodeDriverInterfaceMock) CreateCalls() []struct {
	In1 *v3.NodeDriver
} {
	var calls []struct {
		In1 *v3.NodeDriver
	}
	lockNodeDriverInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockNodeDriverInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *NodeDriverInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("NodeDriverInterfaceMock.DeleteFunc: method is nil but NodeDriverInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockNodeDriverInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockNodeDriverInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedNodeDriverInterface.DeleteCalls())
func (mock *NodeDriverInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockNodeDriverInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockNodeDriverInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *NodeDriverInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("NodeDriverInterfaceMock.DeleteCollectionFunc: method is nil but NodeDriverInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockNodeDriverInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockNodeDriverInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedNodeDriverInterface.DeleteCollectionCalls())
func (mock *NodeDriverInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockNodeDriverInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockNodeDriverInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *NodeDriverInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("NodeDriverInterfaceMock.DeleteNamespacedFunc: method is nil but NodeDriverInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockNodeDriverInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockNodeDriverInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedNodeDriverInterface.DeleteNamespacedCalls())
func (mock *NodeDriverInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockNodeDriverInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockNodeDriverInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *NodeDriverInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.NodeDriver, error) {
	if mock.GetFunc == nil {
		panic("NodeDriverInterfaceMock.GetFunc: method is nil but NodeDriverInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockNodeDriverInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNodeDriverInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedNodeDriverInterface.GetCalls())
func (mock *NodeDriverInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockNodeDriverInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockNodeDriverInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *NodeDriverInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.NodeDriver, error) {
	if mock.GetNamespacedFunc == nil {
		panic("NodeDriverInterfaceMock.GetNamespacedFunc: method is nil but NodeDriverInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockNodeDriverInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockNodeDriverInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedNodeDriverInterface.GetNamespacedCalls())
func (mock *NodeDriverInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockNodeDriverInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockNodeDriverInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NodeDriverInterfaceMock) List(opts metav1.ListOptions) (*v3.NodeDriverList, error) {
	if mock.ListFunc == nil {
		panic("NodeDriverInterfaceMock.ListFunc: method is nil but NodeDriverInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNodeDriverInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNodeDriverInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedNodeDriverInterface.ListCalls())
func (mock *NodeDriverInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNodeDriverInterfaceMockList.RLock()
	calls = mock.calls.List
	lockNodeDriverInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *NodeDriverInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.NodeDriverList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("NodeDriverInterfaceMock.ListNamespacedFunc: method is nil but NodeDriverInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockNodeDriverInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockNodeDriverInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedNodeDriverInterface.ListNamespacedCalls())
func (mock *NodeDriverInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockNodeDriverInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockNodeDriverInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *NodeDriverInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("NodeDriverInterfaceMock.ObjectClientFunc: method is nil but NodeDriverInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockNodeDriverInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockNodeDriverInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedNodeDriverInterface.ObjectClientCalls())
func (mock *NodeDriverInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeDriverInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockNodeDriverInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *NodeDriverInterfaceMock) Update(in1 *v3.NodeDriver) (*v3.NodeDriver, error) {
	if mock.UpdateFunc == nil {
		panic("NodeDriverInterfaceMock.UpdateFunc: method is nil but NodeDriverInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.NodeDriver
	}{
		In1: in1,
	}
	lockNodeDriverInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockNodeDriverInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedNodeDriverInterface.UpdateCalls())
func (mock *NodeDriverInterfaceMock) UpdateCalls() []struct {
	In1 *v3.NodeDriver
} {
	var calls []struct {
		In1 *v3.NodeDriver
	}
	lockNodeDriverInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockNodeDriverInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *NodeDriverInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("NodeDriverInterfaceMock.WatchFunc: method is nil but NodeDriverInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNodeDriverInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockNodeDriverInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedNodeDriverInterface.WatchCalls())
func (mock *NodeDriverInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNodeDriverInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockNodeDriverInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockNodeDriversGetterMockNodeDrivers sync.RWMutex
)

// Ensure, that NodeDriversGetterMock does implement v31.NodeDriversGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.NodeDriversGetter = &NodeDriversGetterMock{}

// NodeDriversGetterMock is a mock implementation of v31.NodeDriversGetter.
//
//	    func TestSomethingThatUsesNodeDriversGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.NodeDriversGetter
//	        mockedNodeDriversGetter := &NodeDriversGetterMock{
//	            NodeDriversFunc: func(namespace string) v31.NodeDriverInterface {
//		               panic("mock out the NodeDrivers method")
//	            },
//	        }
//
//	        // use mockedNodeDriversGetter in code that requires v31.NodeDriversGetter
//	        // and then make assertions.
//
//	    }
type NodeDriversGetterMock struct {
	// NodeDriversFunc mocks the NodeDrivers method.
	NodeDriversFunc func(namespace string) v31.NodeDriverInterface

	// calls tracks calls to the methods.
	calls struct {
		// NodeDrivers holds details about calls to the NodeDrivers method.
		NodeDrivers []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// NodeDrivers calls NodeDriversFunc.
func (mock *NodeDriversGetterMock) NodeDrivers(namespace string) v31.NodeDriverInterface {
	if mock.NodeDriversFunc == nil {
		panic("NodeDriversGetterMock.NodeDriversFunc: method is nil but NodeDriversGetter.NodeDrivers was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockNodeDriversGetterMockNodeDrivers.Lock()
	mock.calls.NodeDrivers = append(mock.calls.NodeDrivers, callInfo)
	lockNodeDriversGetterMockNodeDrivers.Unlock()
	return mock.NodeDriversFunc(namespace)
}

// NodeDriversCalls gets all the calls that were made to NodeDrivers.
// Check the length with:
//
//	len(mockedNodeDriversGetter.NodeDriversCalls())
func (mock *NodeDriversGetterMock) NodeDriversCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockNodeDriversGetterMockNodeDrivers.RLock()
	calls = mock.calls.NodeDrivers
	lockNodeDriversGetterMockNodeDrivers.RUnlock()
	return calls
}
