// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockNodePoolListerMockGet  sync.RWMutex
	lockNodePoolListerMockList sync.RWMutex
)

// Ensure, that NodePoolListerMock does implement v31.NodePoolLister.
// If this is not the case, regenerate this file with moq.
var _ v31.NodePoolLister = &NodePoolListerMock{}

// NodePoolListerMock is a mock implementation of v31.NodePoolLister.
//
//	    func TestSomethingThatUsesNodePoolLister(t *testing.T) {
//
//	        // make and configure a mocked v31.NodePoolLister
//	        mockedNodePoolLister := &NodePoolListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.NodePool, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.NodePool, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedNodePoolLister in code that requires v31.NodePoolLister
//	        // and then make assertions.
//
//	    }
type NodePoolListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.NodePool, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.NodePool, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *NodePoolListerMock) Get(namespace string, name string) (*v3.NodePool, error) {
	if mock.GetFunc == nil {
		panic("NodePoolListerMock.GetFunc: method is nil but NodePoolLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNodePoolListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNodePoolListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedNodePoolLister.GetCalls())
func (mock *NodePoolListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNodePoolListerMockGet.RLock()
	calls = mock.calls.Get
	lockNodePoolListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NodePoolListerMock) List(namespace string, selector labels.Selector) ([]*v3.NodePool, error) {
	if mock.ListFunc == nil {
		panic("NodePoolListerMock.ListFunc: method is nil but NodePoolLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockNodePoolListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNodePoolListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedNodePoolLister.ListCalls())
func (mock *NodePoolListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockNodePoolListerMockList.RLock()
	calls = mock.calls.List
	lockNodePoolListerMockList.RUnlock()
	return calls
}

var (
	lockNodePoolControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockNodePoolControllerMockAddClusterScopedHandler        sync.RWMutex
	lockNodePoolControllerMockAddFeatureHandler              sync.RWMutex
	lockNodePoolControllerMockAddHandler                     sync.RWMutex
	lockNodePoolControllerMockEnqueue                        sync.RWMutex
	lockNodePoolControllerMockEnqueueAfter                   sync.RWMutex
	lockNodePoolControllerMockGeneric                        sync.RWMutex
	lockNodePoolControllerMockInformer                       sync.RWMutex
	lockNodePoolControllerMockLister                         sync.RWMutex
)

// Ensure, that NodePoolControllerMock does implement v31.NodePoolController.
// If this is not the case, regenerate this file with moq.
var _ v31.NodePoolController = &NodePoolControllerMock{}

// NodePoolControllerMock is a mock implementation of v31.NodePoolController.
//
//	    func TestSomethingThatUsesNodePoolController(t *testing.T) {
//
//	        // make and configure a mocked v31.NodePoolController
//	        mockedNodePoolController := &NodePoolControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NodePoolHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.NodePoolHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodePoolHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.NodePoolHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.NodePoolLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedNodePoolController in code that requires v31.NodePoolController
//	        // and then make assertions.
//
//	    }
type NodePoolControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NodePoolHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.NodePoolHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodePoolHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.NodePoolHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.NodePoolLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NodePoolHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NodePoolHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NodePoolHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.NodePoolHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NodePoolControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NodePoolHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NodePoolControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but NodePoolController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NodePoolHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNodePoolControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNodePoolControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedNodePoolController.AddClusterScopedFeatureHandlerCalls())
func (mock *NodePoolControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.NodePoolHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NodePoolHandlerFunc
	}
	lockNodePoolControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNodePoolControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NodePoolControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.NodePoolHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NodePoolControllerMock.AddClusterScopedHandlerFunc: method is nil but NodePoolController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NodePoolHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNodePoolControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNodePoolControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedNodePoolController.AddClusterScopedHandlerCalls())
func (mock *NodePoolControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.NodePoolHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NodePoolHandlerFunc
	}
	lockNodePoolControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNodePoolControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NodePoolControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodePoolHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NodePoolControllerMock.AddFeatureHandlerFunc: method is nil but NodePoolController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodePoolHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNodePoolControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNodePoolControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedNodePoolController.AddFeatureHandlerCalls())
func (mock *NodePoolControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NodePoolHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodePoolHandlerFunc
	}
	lockNodePoolControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNodePoolControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NodePoolControllerMock) AddHandler(ctx context.Context, name string, handler v31.NodePoolHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NodePoolControllerMock.AddHandlerFunc: method is nil but NodePoolController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.NodePoolHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockNodePoolControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNodePoolControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedNodePoolController.AddHandlerCalls())
func (mock *NodePoolControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.NodePoolHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.NodePoolHandlerFunc
	}
	lockNodePoolControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNodePoolControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *NodePoolControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("NodePoolControllerMock.EnqueueFunc: method is nil but NodePoolController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNodePoolControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockNodePoolControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedNodePoolController.EnqueueCalls())
func (mock *NodePoolControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNodePoolControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockNodePoolControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *NodePoolControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("NodePoolControllerMock.EnqueueAfterFunc: method is nil but NodePoolController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockNodePoolControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockNodePoolControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedNodePoolController.EnqueueAfterCalls())
func (mock *NodePoolControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockNodePoolControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockNodePoolControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *NodePoolControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("NodePoolControllerMock.GenericFunc: method is nil but NodePoolController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockNodePoolControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockNodePoolControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedNodePoolController.GenericCalls())
func (mock *NodePoolControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockNodePoolControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockNodePoolControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *NodePoolControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("NodePoolControllerMock.InformerFunc: method is nil but NodePoolController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockNodePoolControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockNodePoolControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedNodePoolController.InformerCalls())
func (mock *NodePoolControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockNodePoolControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockNodePoolControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *NodePoolControllerMock) Lister() v31.NodePoolLister {
	if mock.ListerFunc == nil {
		panic("NodePoolControllerMock.ListerFunc: method is nil but NodePoolController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockNodePoolControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockNodePoolControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedNodePoolController.ListerCalls())
func (mock *NodePoolControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockNodePoolControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockNodePoolControllerMockLister.RUnlock()
	return calls
}

var (
	lockNodePoolInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockNodePoolInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockNodePoolInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockNodePoolInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockNodePoolInterfaceMockAddFeatureHandler                sync.RWMutex
	lockNodePoolInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockNodePoolInterfaceMockAddHandler                       sync.RWMutex
	lockNodePoolInterfaceMockAddLifecycle                     sync.RWMutex
	lockNodePoolInterfaceMockController                       sync.RWMutex
	lockNodePoolInterfaceMockCreate                           sync.RWMutex
	lockNodePoolInterfaceMockDelete                           sync.RWMutex
	lockNodePoolInterfaceMockDeleteCollection                 sync.RWMutex
	lockNodePoolInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockNodePoolInterfaceMockGet                              sync.RWMutex
	lockNodePoolInterfaceMockGetNamespaced                    sync.RWMutex
	lockNodePoolInterfaceMockList                             sync.RWMutex
	lockNodePoolInterfaceMockListNamespaced                   sync.RWMutex
	lockNodePoolInterfaceMockObjectClient                     sync.RWMutex
	lockNodePoolInterfaceMockUpdate                           sync.RWMutex
	lockNodePoolInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that NodePoolInterfaceMock does implement v31.NodePoolInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.NodePoolInterface = &NodePoolInterfaceMock{}

// NodePoolInterfaceMock is a mock implementation of v31.NodePoolInterface.
//
//	    func TestSomethingThatUsesNodePoolInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.NodePoolInterface
//	        mockedNodePoolInterface := &NodePoolInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NodePoolHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NodePoolLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NodePoolHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.NodePoolLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodePoolHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NodePoolLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.NodePoolHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.NodePoolLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.NodePoolController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.NodePool) (*v3.NodePool, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.NodePool, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.NodePool, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.NodePoolList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.NodePoolList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.NodePool) (*v3.NodePool, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedNodePoolInterface in code that requires v31.NodePoolInterface
//	        // and then make assertions.
//
//	    }
type NodePoolInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NodePoolHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NodePoolLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NodePoolHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.NodePoolLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodePoolHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NodePoolLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.NodePoolHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.NodePoolLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.NodePoolController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.NodePool) (*v3.NodePool, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.NodePool, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.NodePool, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.NodePoolList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.NodePoolList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.NodePool) (*v3.NodePool, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NodePoolHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodePoolLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NodePoolHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodePoolLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NodePoolHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodePoolLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NodePoolHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodePoolLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.NodePool
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.NodePool
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NodePoolInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NodePoolHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NodePoolInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but NodePoolInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NodePoolHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNodePoolInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNodePoolInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedNodePoolInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *NodePoolInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.NodePoolHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NodePoolHandlerFunc
	}
	lockNodePoolInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNodePoolInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *NodePoolInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NodePoolLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("NodePoolInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but NodePoolInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NodePoolLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNodePoolInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockNodePoolInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedNodePoolInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *NodePoolInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.NodePoolLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NodePoolLifecycle
	}
	lockNodePoolInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockNodePoolInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NodePoolInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.NodePoolHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NodePoolInterfaceMock.AddClusterScopedHandlerFunc: method is nil but NodePoolInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NodePoolHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNodePoolInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNodePoolInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedNodePoolInterface.AddClusterScopedHandlerCalls())
func (mock *NodePoolInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.NodePoolHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NodePoolHandlerFunc
	}
	lockNodePoolInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNodePoolInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *NodePoolInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.NodePoolLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("NodePoolInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but NodePoolInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NodePoolLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNodePoolInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockNodePoolInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedNodePoolInterface.AddClusterScopedLifecycleCalls())
func (mock *NodePoolInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.NodePoolLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NodePoolLifecycle
	}
	lockNodePoolInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockNodePoolInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NodePoolInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodePoolHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NodePoolInterfaceMock.AddFeatureHandlerFunc: method is nil but NodePoolInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodePoolHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNodePoolInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNodePoolInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedNodePoolInterface.AddFeatureHandlerCalls())
func (mock *NodePoolInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NodePoolHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodePoolHandlerFunc
	}
	lockNodePoolInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNodePoolInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *NodePoolInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.NodePoolLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("NodePoolInterfaceMock.AddFeatureLifecycleFunc: method is nil but NodePoolInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NodePoolLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNodePoolInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockNodePoolInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedNodePoolInterface.AddFeatureLifecycleCalls())
func (mock *NodePoolInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.NodePoolLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NodePoolLifecycle
	}
	lockNodePoolInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockNodePoolInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NodePoolInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.NodePoolHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NodePoolInterfaceMock.AddHandlerFunc: method is nil but NodePoolInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.NodePoolHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockNodePoolInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNodePoolInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedNodePoolInterface.AddHandlerCalls())
func (mock *NodePoolInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.NodePoolHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.NodePoolHandlerFunc
	}
	lockNodePoolInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNodePoolInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *NodePoolInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.NodePoolLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("NodePoolInterfaceMock.AddLifecycleFunc: method is nil but NodePoolInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NodePoolLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNodePoolInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockNodePoolInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedNodePoolInterface.AddLifecycleCalls())
func (mock *NodePoolInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.NodePoolLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NodePoolLifecycle
	}
	lockNodePoolInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockNodePoolInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *NodePoolInterfaceMock) Controller() v31.NodePoolController {
	if mock.ControllerFunc == nil {
		panic("NodePoolInterfaceMock.ControllerFunc: method is nil but NodePoolInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockNodePoolInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockNodePoolInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedNodePoolInterface.ControllerCalls())
func (mock *NodePoolInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockNodePoolInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockNodePoolInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *NodePoolInterfaceMock) Create(in1 *v3.NodePool) (*v3.NodePool, error) {
	if mock.CreateFunc == nil {
		panic("NodePoolInterfaceMock.CreateFunc: method is nil but NodePoolInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.NodePool
	}{
		In1: in1,
	}
	lockNodePoolInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockNodePoolInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedNodePoolInterface.CreateCalls())
func (mock *NodePoolInterfaceMock) CreateCalls() []struct {
	In1 *v3.NodePool
} {
	var calls []struct {
		In1 *v3.NodePool
	}
	lockNodePoolInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockNodePoolInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *NodePoolInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("NodePoolInterfaceMock.DeleteFunc: method is nil but NodePoolInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockNodePoolInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockNodePoolInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedNodePoolInterface.DeleteCalls())
func (mock *NodePoolInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockNodePoolInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockNodePoolInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *NodePoolInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("NodePoolInterfaceMock.DeleteCollectionFunc: method is nil but NodePoolInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockNodePoolInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockNodePoolInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedNodePoolInterface.DeleteCollectionCalls())
func (mock *NodePoolInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockNodePoolInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockNodePoolInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *NodePoolInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("NodePoolInterfaceMock.DeleteNamespacedFunc: method is nil but NodePoolInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockNodePoolInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockNodePoolInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedNodePoolInterface.DeleteNamespacedCalls())
func (mock *NodePoolInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockNodePoolInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockNodePoolInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *NodePoolInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.NodePool, error) {
	if mock.GetFunc == nil {
		panic("NodePoolInterfaceMock.GetFunc: method is nil but NodePoolInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockNodePoolInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNodePoolInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedNodePoolInterface.GetCalls())
func (mock *NodePoolInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockNodePoolInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockNodePoolInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *NodePoolInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.NodePool, error) {
	if mock.GetNamespacedFunc == nil {
		panic("NodePoolInterfaceMock.GetNamespacedFunc: method is nil but NodePoolInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockNodePoolInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockNodePoolInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedNodePoolInterface.GetNamespacedCalls())
func (mock *NodePoolInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockNodePoolInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockNodePoolInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NodePoolInterfaceMock) List(opts metav1.ListOptions) (*v3.NodePoolList, error) {
	if mock.ListFunc == nil {
		panic("NodePoolInterfaceMock.ListFunc: method is nil but NodePoolInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNodePoolInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNodePoolInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedNodePoolInterface.ListCalls())
func (mock *NodePoolInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNodePoolInterfaceMockList.RLock()
	calls = mock.calls.List
	lockNodePoolInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *NodePoolInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.NodePoolList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("NodePoolInterfaceMock.ListNamespacedFunc: method is nil but NodePoolInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockNodePoolInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockNodePoolInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedNodePoolInterface.ListNamespacedCalls())
func (mock *NodePoolInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockNodePoolInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockNodePoolInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *NodePoolInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("NodePoolInterfaceMock.ObjectClientFunc: method is nil but NodePoolInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockNodePoolInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockNodePoolInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedNodePoolInterface.ObjectClientCalls())
func (mock *NodePoolInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockNodePoolInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockNodePoolInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *NodePoolInterfaceMock) Update(in1 *v3.NodePool) (*v3.NodePool, error) {
	if mock.UpdateFunc == nil {
		panic("NodePoolInterfaceMock.UpdateFunc: method is nil but NodePoolInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.NodePool
	}{
		In1: in1,
	}
	lockNodePoolInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockNodePoolInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedNodePoolInterface.UpdateCalls())
func (mock *NodePoolInterfaceMock) UpdateCalls() []struct {
	In1 *v3.NodePool
} {
	var calls []struct {
		In1 *v3.NodePool
	}
	lockNodePoolInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockNodePoolInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *NodePoolInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("NodePoolInterfaceMock.WatchFunc: method is nil but NodePoolInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNodePoolInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockNodePoolInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedNodePoolInterface.WatchCalls())
func (mock *NodePoolInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNodePoolInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockNodePoolInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockNodePoolsGetterMockNodePools sync.RWMutex
)

// Ensure, that NodePoolsGetterMock does implement v31.NodePoolsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.NodePoolsGetter = &NodePoolsGetterMock{}

// NodePoolsGetterMock is a mock implementation of v31.NodePoolsGetter.
//
//	    func TestSomethingThatUsesNodePoolsGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.NodePoolsGetter
//	        mockedNodePoolsGetter := &NodePoolsGetterMock{
//	            NodePoolsFunc: func(namespace string) v31.NodePoolInterface {
//		               panic("mock out the NodePools method")
//	            },
//	        }
//
//	        // use mockedNodePoolsGetter in code that requires v31.NodePoolsGetter
//	        // and then make assertions.
//
//	    }
type NodePoolsGetterMock struct {
	// NodePoolsFunc mocks the NodePools method.
	NodePoolsFunc func(namespace string) v31.NodePoolInterface

	// calls tracks calls to the methods.
	calls struct {
		// NodePools holds details about calls to the NodePools method.
		NodePools []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// NodePools calls NodePoolsFunc.
func (mock *NodePoolsGetterMock) NodePools(namespace string) v31.NodePoolInterface {
	if mock.NodePoolsFunc == nil {
		panic("NodePoolsGetterMock.NodePoolsFunc: method is nil but NodePoolsGetter.NodePools was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockNodePoolsGetterMockNodePools.Lock()
	mock.calls.NodePools = append(mock.calls.NodePools, callInfo)
	lockNodePoolsGetterMockNodePools.Unlock()
	return mock.NodePoolsFunc(namespace)
}

// NodePoolsCalls gets all the calls that were made to NodePools.
// Check the length with:
//
//	len(mockedNodePoolsGetter.NodePoolsCalls())
func (mock *NodePoolsGetterMock) NodePoolsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockNodePoolsGetterMockNodePools.RLock()
	calls = mock.calls.NodePools
	lockNodePoolsGetterMockNodePools.RUnlock()
	return calls
}
