// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockOIDCClientListerMockGet  sync.RWMutex
	lockOIDCClientListerMockList sync.RWMutex
)

// Ensure, that OIDCClientListerMock does implement v31.OIDCClientLister.
// If this is not the case, regenerate this file with moq.
var _ v31.OIDCClientLister = &OIDCClientListerMock{}

// OIDCClientListerMock is a mock implementation of v31.OIDCClientLister.
//
//	    func TestSomethingThatUsesOIDCClientLister(t *testing.T) {
//
//	        // make and configure a mocked v31.OIDCClientLister
//	        mockedOIDCClientLister := &OIDCClientListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.OIDCClient, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.OIDCClient, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedOIDCClientLister in code that requires v31.OIDCClientLister
//	        // and then make assertions.
//
//	    }
type OIDCClientListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.OIDCClient, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.OIDCClient, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *OIDCClientListerMock) Get(namespace string, name string) (*v3.OIDCClient, error) {
	if mock.GetFunc == nil {
		panic("OIDCClientListerMock.GetFunc: method is nil but OIDCClientLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockOIDCClientListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockOIDCClientListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedOIDCClientLister.GetCalls())
func (mock *OIDCClientListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockOIDCClientListerMockGet.RLock()
	calls = mock.calls.Get
	lockOIDCClientListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *OIDCClientListerMock) List(namespace string, selector labels.Selector) ([]*v3.OIDCClient, error) {
	if mock.ListFunc == nil {
		panic("OIDCClientListerMock.ListFunc: method is nil but OIDCClientLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockOIDCClientListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockOIDCClientListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedOIDCClientLister.ListCalls())
func (mock *OIDCClientListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockOIDCClientListerMockList.RLock()
	calls = mock.calls.List
	lockOIDCClientListerMockList.RUnlock()
	return calls
}

var (
	lockOIDCClientControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockOIDCClientControllerMockAddClusterScopedHandler        sync.RWMutex
	lockOIDCClientControllerMockAddFeatureHandler              sync.RWMutex
	lockOIDCClientControllerMockAddHandler                     sync.RWMutex
	lockOIDCClientControllerMockEnqueue                        sync.RWMutex
	lockOIDCClientControllerMockEnqueueAfter                   sync.RWMutex
	lockOIDCClientControllerMockGeneric                        sync.RWMutex
	lockOIDCClientControllerMockInformer                       sync.RWMutex
	lockOIDCClientControllerMockLister                         sync.RWMutex
)

// Ensure, that OIDCClientControllerMock does implement v31.OIDCClientController.
// If this is not the case, regenerate this file with moq.
var _ v31.OIDCClientController = &OIDCClientControllerMock{}

// OIDCClientControllerMock is a mock implementation of v31.OIDCClientController.
//
//	    func TestSomethingThatUsesOIDCClientController(t *testing.T) {
//
//	        // make and configure a mocked v31.OIDCClientController
//	        mockedOIDCClientController := &OIDCClientControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.OIDCClientHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.OIDCClientHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.OIDCClientHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.OIDCClientHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.OIDCClientLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedOIDCClientController in code that requires v31.OIDCClientController
//	        // and then make assertions.
//
//	    }
type OIDCClientControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.OIDCClientHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.OIDCClientHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.OIDCClientHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.OIDCClientHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.OIDCClientLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.OIDCClientHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.OIDCClientHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.OIDCClientHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.OIDCClientHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *OIDCClientControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.OIDCClientHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("OIDCClientControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but OIDCClientController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.OIDCClientHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockOIDCClientControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockOIDCClientControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedOIDCClientController.AddClusterScopedFeatureHandlerCalls())
func (mock *OIDCClientControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.OIDCClientHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.OIDCClientHandlerFunc
	}
	lockOIDCClientControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockOIDCClientControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *OIDCClientControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.OIDCClientHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("OIDCClientControllerMock.AddClusterScopedHandlerFunc: method is nil but OIDCClientController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.OIDCClientHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockOIDCClientControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockOIDCClientControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedOIDCClientController.AddClusterScopedHandlerCalls())
func (mock *OIDCClientControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.OIDCClientHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.OIDCClientHandlerFunc
	}
	lockOIDCClientControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockOIDCClientControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *OIDCClientControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.OIDCClientHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("OIDCClientControllerMock.AddFeatureHandlerFunc: method is nil but OIDCClientController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.OIDCClientHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockOIDCClientControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockOIDCClientControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedOIDCClientController.AddFeatureHandlerCalls())
func (mock *OIDCClientControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.OIDCClientHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.OIDCClientHandlerFunc
	}
	lockOIDCClientControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockOIDCClientControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *OIDCClientControllerMock) AddHandler(ctx context.Context, name string, handler v31.OIDCClientHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("OIDCClientControllerMock.AddHandlerFunc: method is nil but OIDCClientController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.OIDCClientHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockOIDCClientControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockOIDCClientControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedOIDCClientController.AddHandlerCalls())
func (mock *OIDCClientControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.OIDCClientHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.OIDCClientHandlerFunc
	}
	lockOIDCClientControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockOIDCClientControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *OIDCClientControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("OIDCClientControllerMock.EnqueueFunc: method is nil but OIDCClientController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockOIDCClientControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockOIDCClientControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedOIDCClientController.EnqueueCalls())
func (mock *OIDCClientControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockOIDCClientControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockOIDCClientControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *OIDCClientControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("OIDCClientControllerMock.EnqueueAfterFunc: method is nil but OIDCClientController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockOIDCClientControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockOIDCClientControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedOIDCClientController.EnqueueAfterCalls())
func (mock *OIDCClientControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockOIDCClientControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockOIDCClientControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *OIDCClientControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("OIDCClientControllerMock.GenericFunc: method is nil but OIDCClientController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockOIDCClientControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockOIDCClientControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedOIDCClientController.GenericCalls())
func (mock *OIDCClientControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockOIDCClientControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockOIDCClientControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *OIDCClientControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("OIDCClientControllerMock.InformerFunc: method is nil but OIDCClientController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockOIDCClientControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockOIDCClientControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedOIDCClientController.InformerCalls())
func (mock *OIDCClientControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockOIDCClientControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockOIDCClientControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *OIDCClientControllerMock) Lister() v31.OIDCClientLister {
	if mock.ListerFunc == nil {
		panic("OIDCClientControllerMock.ListerFunc: method is nil but OIDCClientController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockOIDCClientControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockOIDCClientControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedOIDCClientController.ListerCalls())
func (mock *OIDCClientControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockOIDCClientControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockOIDCClientControllerMockLister.RUnlock()
	return calls
}

var (
	lockOIDCClientInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockOIDCClientInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockOIDCClientInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockOIDCClientInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockOIDCClientInterfaceMockAddFeatureHandler                sync.RWMutex
	lockOIDCClientInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockOIDCClientInterfaceMockAddHandler                       sync.RWMutex
	lockOIDCClientInterfaceMockAddLifecycle                     sync.RWMutex
	lockOIDCClientInterfaceMockController                       sync.RWMutex
	lockOIDCClientInterfaceMockCreate                           sync.RWMutex
	lockOIDCClientInterfaceMockDelete                           sync.RWMutex
	lockOIDCClientInterfaceMockDeleteCollection                 sync.RWMutex
	lockOIDCClientInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockOIDCClientInterfaceMockGet                              sync.RWMutex
	lockOIDCClientInterfaceMockGetNamespaced                    sync.RWMutex
	lockOIDCClientInterfaceMockList                             sync.RWMutex
	lockOIDCClientInterfaceMockListNamespaced                   sync.RWMutex
	lockOIDCClientInterfaceMockObjectClient                     sync.RWMutex
	lockOIDCClientInterfaceMockUpdate                           sync.RWMutex
	lockOIDCClientInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that OIDCClientInterfaceMock does implement v31.OIDCClientInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.OIDCClientInterface = &OIDCClientInterfaceMock{}

// OIDCClientInterfaceMock is a mock implementation of v31.OIDCClientInterface.
//
//	    func TestSomethingThatUsesOIDCClientInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.OIDCClientInterface
//	        mockedOIDCClientInterface := &OIDCClientInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.OIDCClientHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.OIDCClientLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.OIDCClientHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.OIDCClientLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.OIDCClientHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.OIDCClientLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.OIDCClientHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.OIDCClientLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.OIDCClientController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.OIDCClient) (*v3.OIDCClient, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.OIDCClient, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.OIDCClient, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.OIDCClientList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.OIDCClientList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.OIDCClient) (*v3.OIDCClient, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedOIDCClientInterface in code that requires v31.OIDCClientInterface
//	        // and then make assertions.
//
//	    }
type OIDCClientInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.OIDCClientHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.OIDCClientLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.OIDCClientHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.OIDCClientLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.OIDCClientHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.OIDCClientLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.OIDCClientHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.OIDCClientLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.OIDCClientController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.OIDCClient) (*v3.OIDCClient, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.OIDCClient, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.OIDCClient, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.OIDCClientList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.OIDCClientList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.OIDCClient) (*v3.OIDCClient, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.OIDCClientHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.OIDCClientLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.OIDCClientHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.OIDCClientLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.OIDCClientHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.OIDCClientLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.OIDCClientHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.OIDCClientLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.OIDCClient
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.OIDCClient
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *OIDCClientInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.OIDCClientHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("OIDCClientInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but OIDCClientInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.OIDCClientHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockOIDCClientInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockOIDCClientInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedOIDCClientInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *OIDCClientInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.OIDCClientHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.OIDCClientHandlerFunc
	}
	lockOIDCClientInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockOIDCClientInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *OIDCClientInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.OIDCClientLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("OIDCClientInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but OIDCClientInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.OIDCClientLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockOIDCClientInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockOIDCClientInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedOIDCClientInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *OIDCClientInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.OIDCClientLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.OIDCClientLifecycle
	}
	lockOIDCClientInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockOIDCClientInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *OIDCClientInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.OIDCClientHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("OIDCClientInterfaceMock.AddClusterScopedHandlerFunc: method is nil but OIDCClientInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.OIDCClientHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockOIDCClientInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockOIDCClientInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedOIDCClientInterface.AddClusterScopedHandlerCalls())
func (mock *OIDCClientInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.OIDCClientHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.OIDCClientHandlerFunc
	}
	lockOIDCClientInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockOIDCClientInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *OIDCClientInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.OIDCClientLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("OIDCClientInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but OIDCClientInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.OIDCClientLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockOIDCClientInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockOIDCClientInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedOIDCClientInterface.AddClusterScopedLifecycleCalls())
func (mock *OIDCClientInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.OIDCClientLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.OIDCClientLifecycle
	}
	lockOIDCClientInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockOIDCClientInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *OIDCClientInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.OIDCClientHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("OIDCClientInterfaceMock.AddFeatureHandlerFunc: method is nil but OIDCClientInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.OIDCClientHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockOIDCClientInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockOIDCClientInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedOIDCClientInterface.AddFeatureHandlerCalls())
func (mock *OIDCClientInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.OIDCClientHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.OIDCClientHandlerFunc
	}
	lockOIDCClientInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockOIDCClientInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *OIDCClientInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.OIDCClientLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("OIDCClientInterfaceMock.AddFeatureLifecycleFunc: method is nil but OIDCClientInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.OIDCClientLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockOIDCClientInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockOIDCClientInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedOIDCClientInterface.AddFeatureLifecycleCalls())
func (mock *OIDCClientInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.OIDCClientLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.OIDCClientLifecycle
	}
	lockOIDCClientInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockOIDCClientInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *OIDCClientInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.OIDCClientHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("OIDCClientInterfaceMock.AddHandlerFunc: method is nil but OIDCClientInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.OIDCClientHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockOIDCClientInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockOIDCClientInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedOIDCClientInterface.AddHandlerCalls())
func (mock *OIDCClientInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.OIDCClientHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.OIDCClientHandlerFunc
	}
	lockOIDCClientInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockOIDCClientInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *OIDCClientInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.OIDCClientLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("OIDCClientInterfaceMock.AddLifecycleFunc: method is nil but OIDCClientInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.OIDCClientLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockOIDCClientInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockOIDCClientInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedOIDCClientInterface.AddLifecycleCalls())
func (mock *OIDCClientInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.OIDCClientLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.OIDCClientLifecycle
	}
	lockOIDCClientInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockOIDCClientInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *OIDCClientInterfaceMock) Controller() v31.OIDCClientController {
	if mock.ControllerFunc == nil {
		panic("OIDCClientInterfaceMock.ControllerFunc: method is nil but OIDCClientInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockOIDCClientInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockOIDCClientInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedOIDCClientInterface.ControllerCalls())
func (mock *OIDCClientInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockOIDCClientInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockOIDCClientInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *OIDCClientInterfaceMock) Create(in1 *v3.OIDCClient) (*v3.OIDCClient, error) {
	if mock.CreateFunc == nil {
		panic("OIDCClientInterfaceMock.CreateFunc: method is nil but OIDCClientInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.OIDCClient
	}{
		In1: in1,
	}
	lockOIDCClientInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockOIDCClientInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedOIDCClientInterface.CreateCalls())
func (mock *OIDCClientInterfaceMock) CreateCalls() []struct {
	In1 *v3.OIDCClient
} {
	var calls []struct {
		In1 *v3.OIDCClient
	}
	lockOIDCClientInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockOIDCClientInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *OIDCClientInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("OIDCClientInterfaceMock.DeleteFunc: method is nil but OIDCClientInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockOIDCClientInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockOIDCClientInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedOIDCClientInterface.DeleteCalls())
func (mock *OIDCClientInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockOIDCClientInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockOIDCClientInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *OIDCClientInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("OIDCClientInterfaceMock.DeleteCollectionFunc: method is nil but OIDCClientInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockOIDCClientInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockOIDCClientInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedOIDCClientInterface.DeleteCollectionCalls())
func (mock *OIDCClientInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockOIDCClientInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockOIDCClientInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *OIDCClientInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("OIDCClientInterfaceMock.DeleteNamespacedFunc: method is nil but OIDCClientInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockOIDCClientInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockOIDCClientInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedOIDCClientInterface.DeleteNamespacedCalls())
func (mock *OIDCClientInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockOIDCClientInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockOIDCClientInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *OIDCClientInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.OIDCClient, error) {
	if mock.GetFunc == nil {
		panic("OIDCClientInterfaceMock.GetFunc: method is nil but OIDCClientInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockOIDCClientInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockOIDCClientInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedOIDCClientInterface.GetCalls())
func (mock *OIDCClientInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockOIDCClientInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockOIDCClientInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *OIDCClientInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.OIDCClient, error) {
	if mock.GetNamespacedFunc == nil {
		panic("OIDCClientInterfaceMock.GetNamespacedFunc: method is nil but OIDCClientInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockOIDCClientInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockOIDCClientInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedOIDCClientInterface.GetNamespacedCalls())
func (mock *OIDCClientInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockOIDCClientInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockOIDCClientInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *OIDCClientInterfaceMock) List(opts metav1.ListOptions) (*v3.OIDCClientList, error) {
	if mock.ListFunc == nil {
		panic("OIDCClientInterfaceMock.ListFunc: method is nil but OIDCClientInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockOIDCClientInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockOIDCClientInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedOIDCClientInterface.ListCalls())
func (mock *OIDCClientInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockOIDCClientInterfaceMockList.RLock()
	calls = mock.calls.List
	lockOIDCClientInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *OIDCClientInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.OIDCClientList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("OIDCClientInterfaceMock.ListNamespacedFunc: method is nil but OIDCClientInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockOIDCClientInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockOIDCClientInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedOIDCClientInterface.ListNamespacedCalls())
func (mock *OIDCClientInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockOIDCClientInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockOIDCClientInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *OIDCClientInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("OIDCClientInterfaceMock.ObjectClientFunc: method is nil but OIDCClientInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockOIDCClientInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockOIDCClientInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedOIDCClientInterface.ObjectClientCalls())
func (mock *OIDCClientInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockOIDCClientInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockOIDCClientInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *OIDCClientInterfaceMock) Update(in1 *v3.OIDCClient) (*v3.OIDCClient, error) {
	if mock.UpdateFunc == nil {
		panic("OIDCClientInterfaceMock.UpdateFunc: method is nil but OIDCClientInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.OIDCClient
	}{
		In1: in1,
	}
	lockOIDCClientInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockOIDCClientInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedOIDCClientInterface.UpdateCalls())
func (mock *OIDCClientInterfaceMock) UpdateCalls() []struct {
	In1 *v3.OIDCClient
} {
	var calls []struct {
		In1 *v3.OIDCClient
	}
	lockOIDCClientInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockOIDCClientInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *OIDCClientInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("OIDCClientInterfaceMock.WatchFunc: method is nil but OIDCClientInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockOIDCClientInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockOIDCClientInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedOIDCClientInterface.WatchCalls())
func (mock *OIDCClientInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockOIDCClientInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockOIDCClientInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockOIDCClientsGetterMockOIDCClients sync.RWMutex
)

// Ensure, that OIDCClientsGetterMock does implement v31.OIDCClientsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.OIDCClientsGetter = &OIDCClientsGetterMock{}

// OIDCClientsGetterMock is a mock implementation of v31.OIDCClientsGetter.
//
//	    func TestSomethingThatUsesOIDCClientsGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.OIDCClientsGetter
//	        mockedOIDCClientsGetter := &OIDCClientsGetterMock{
//	            OIDCClientsFunc: func(namespace string) v31.OIDCClientInterface {
//		               panic("mock out the OIDCClients method")
//	            },
//	        }
//
//	        // use mockedOIDCClientsGetter in code that requires v31.OIDCClientsGetter
//	        // and then make assertions.
//
//	    }
type OIDCClientsGetterMock struct {
	// OIDCClientsFunc mocks the OIDCClients method.
	OIDCClientsFunc func(namespace string) v31.OIDCClientInterface

	// calls tracks calls to the methods.
	calls struct {
		// OIDCClients holds details about calls to the OIDCClients method.
		OIDCClients []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// OIDCClients calls OIDCClientsFunc.
func (mock *OIDCClientsGetterMock) OIDCClients(namespace string) v31.OIDCClientInterface {
	if mock.OIDCClientsFunc == nil {
		panic("OIDCClientsGetterMock.OIDCClientsFunc: method is nil but OIDCClientsGetter.OIDCClients was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockOIDCClientsGetterMockOIDCClients.Lock()
	mock.calls.OIDCClients = append(mock.calls.OIDCClients, callInfo)
	lockOIDCClientsGetterMockOIDCClients.Unlock()
	return mock.OIDCClientsFunc(namespace)
}

// OIDCClientsCalls gets all the calls that were made to OIDCClients.
// Check the length with:
//
//	len(mockedOIDCClientsGetter.OIDCClientsCalls())
func (mock *OIDCClientsGetterMock) OIDCClientsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockOIDCClientsGetterMockOIDCClients.RLock()
	calls = mock.calls.OIDCClients
	lockOIDCClientsGetterMockOIDCClients.RUnlock()
	return calls
}
