// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockPreferenceListerMockGet  sync.RWMutex
	lockPreferenceListerMockList sync.RWMutex
)

// Ensure, that PreferenceListerMock does implement v31.PreferenceLister.
// If this is not the case, regenerate this file with moq.
var _ v31.PreferenceLister = &PreferenceListerMock{}

// PreferenceListerMock is a mock implementation of v31.PreferenceLister.
//
//	    func TestSomethingThatUsesPreferenceLister(t *testing.T) {
//
//	        // make and configure a mocked v31.PreferenceLister
//	        mockedPreferenceLister := &PreferenceListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.Preference, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.Preference, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedPreferenceLister in code that requires v31.PreferenceLister
//	        // and then make assertions.
//
//	    }
type PreferenceListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.Preference, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.Preference, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *PreferenceListerMock) Get(namespace string, name string) (*v3.Preference, error) {
	if mock.GetFunc == nil {
		panic("PreferenceListerMock.GetFunc: method is nil but PreferenceLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPreferenceListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPreferenceListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedPreferenceLister.GetCalls())
func (mock *PreferenceListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPreferenceListerMockGet.RLock()
	calls = mock.calls.Get
	lockPreferenceListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PreferenceListerMock) List(namespace string, selector labels.Selector) ([]*v3.Preference, error) {
	if mock.ListFunc == nil {
		panic("PreferenceListerMock.ListFunc: method is nil but PreferenceLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockPreferenceListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPreferenceListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedPreferenceLister.ListCalls())
func (mock *PreferenceListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockPreferenceListerMockList.RLock()
	calls = mock.calls.List
	lockPreferenceListerMockList.RUnlock()
	return calls
}

var (
	lockPreferenceControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockPreferenceControllerMockAddClusterScopedHandler        sync.RWMutex
	lockPreferenceControllerMockAddFeatureHandler              sync.RWMutex
	lockPreferenceControllerMockAddHandler                     sync.RWMutex
	lockPreferenceControllerMockEnqueue                        sync.RWMutex
	lockPreferenceControllerMockEnqueueAfter                   sync.RWMutex
	lockPreferenceControllerMockGeneric                        sync.RWMutex
	lockPreferenceControllerMockInformer                       sync.RWMutex
	lockPreferenceControllerMockLister                         sync.RWMutex
)

// Ensure, that PreferenceControllerMock does implement v31.PreferenceController.
// If this is not the case, regenerate this file with moq.
var _ v31.PreferenceController = &PreferenceControllerMock{}

// PreferenceControllerMock is a mock implementation of v31.PreferenceController.
//
//	    func TestSomethingThatUsesPreferenceController(t *testing.T) {
//
//	        // make and configure a mocked v31.PreferenceController
//	        mockedPreferenceController := &PreferenceControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PreferenceHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.PreferenceHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PreferenceHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.PreferenceHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.PreferenceLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedPreferenceController in code that requires v31.PreferenceController
//	        // and then make assertions.
//
//	    }
type PreferenceControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PreferenceHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.PreferenceHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PreferenceHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.PreferenceHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.PreferenceLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.PreferenceHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.PreferenceHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PreferenceHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.PreferenceHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PreferenceControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PreferenceHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PreferenceControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but PreferenceController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.PreferenceHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPreferenceControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPreferenceControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedPreferenceController.AddClusterScopedFeatureHandlerCalls())
func (mock *PreferenceControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.PreferenceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.PreferenceHandlerFunc
	}
	lockPreferenceControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPreferenceControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PreferenceControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.PreferenceHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PreferenceControllerMock.AddClusterScopedHandlerFunc: method is nil but PreferenceController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.PreferenceHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPreferenceControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPreferenceControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedPreferenceController.AddClusterScopedHandlerCalls())
func (mock *PreferenceControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.PreferenceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.PreferenceHandlerFunc
	}
	lockPreferenceControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPreferenceControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PreferenceControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PreferenceHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PreferenceControllerMock.AddFeatureHandlerFunc: method is nil but PreferenceController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PreferenceHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPreferenceControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPreferenceControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedPreferenceController.AddFeatureHandlerCalls())
func (mock *PreferenceControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.PreferenceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PreferenceHandlerFunc
	}
	lockPreferenceControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPreferenceControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PreferenceControllerMock) AddHandler(ctx context.Context, name string, handler v31.PreferenceHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PreferenceControllerMock.AddHandlerFunc: method is nil but PreferenceController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.PreferenceHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockPreferenceControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPreferenceControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedPreferenceController.AddHandlerCalls())
func (mock *PreferenceControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.PreferenceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.PreferenceHandlerFunc
	}
	lockPreferenceControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPreferenceControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *PreferenceControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("PreferenceControllerMock.EnqueueFunc: method is nil but PreferenceController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPreferenceControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockPreferenceControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedPreferenceController.EnqueueCalls())
func (mock *PreferenceControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPreferenceControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockPreferenceControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *PreferenceControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("PreferenceControllerMock.EnqueueAfterFunc: method is nil but PreferenceController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockPreferenceControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockPreferenceControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedPreferenceController.EnqueueAfterCalls())
func (mock *PreferenceControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockPreferenceControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockPreferenceControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *PreferenceControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("PreferenceControllerMock.GenericFunc: method is nil but PreferenceController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockPreferenceControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockPreferenceControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedPreferenceController.GenericCalls())
func (mock *PreferenceControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockPreferenceControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockPreferenceControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *PreferenceControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("PreferenceControllerMock.InformerFunc: method is nil but PreferenceController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockPreferenceControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockPreferenceControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedPreferenceController.InformerCalls())
func (mock *PreferenceControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockPreferenceControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockPreferenceControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *PreferenceControllerMock) Lister() v31.PreferenceLister {
	if mock.ListerFunc == nil {
		panic("PreferenceControllerMock.ListerFunc: method is nil but PreferenceController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockPreferenceControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockPreferenceControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedPreferenceController.ListerCalls())
func (mock *PreferenceControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockPreferenceControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockPreferenceControllerMockLister.RUnlock()
	return calls
}

var (
	lockPreferenceInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockPreferenceInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockPreferenceInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockPreferenceInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockPreferenceInterfaceMockAddFeatureHandler                sync.RWMutex
	lockPreferenceInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockPreferenceInterfaceMockAddHandler                       sync.RWMutex
	lockPreferenceInterfaceMockAddLifecycle                     sync.RWMutex
	lockPreferenceInterfaceMockController                       sync.RWMutex
	lockPreferenceInterfaceMockCreate                           sync.RWMutex
	lockPreferenceInterfaceMockDelete                           sync.RWMutex
	lockPreferenceInterfaceMockDeleteCollection                 sync.RWMutex
	lockPreferenceInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockPreferenceInterfaceMockGet                              sync.RWMutex
	lockPreferenceInterfaceMockGetNamespaced                    sync.RWMutex
	lockPreferenceInterfaceMockList                             sync.RWMutex
	lockPreferenceInterfaceMockListNamespaced                   sync.RWMutex
	lockPreferenceInterfaceMockObjectClient                     sync.RWMutex
	lockPreferenceInterfaceMockUpdate                           sync.RWMutex
	lockPreferenceInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that PreferenceInterfaceMock does implement v31.PreferenceInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.PreferenceInterface = &PreferenceInterfaceMock{}

// PreferenceInterfaceMock is a mock implementation of v31.PreferenceInterface.
//
//	    func TestSomethingThatUsesPreferenceInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.PreferenceInterface
//	        mockedPreferenceInterface := &PreferenceInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PreferenceHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PreferenceLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.PreferenceHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.PreferenceLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PreferenceHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.PreferenceLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.PreferenceHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.PreferenceLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.PreferenceController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.Preference) (*v3.Preference, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.Preference, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.Preference, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.PreferenceList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.PreferenceList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.Preference) (*v3.Preference, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedPreferenceInterface in code that requires v31.PreferenceInterface
//	        // and then make assertions.
//
//	    }
type PreferenceInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PreferenceHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PreferenceLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.PreferenceHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.PreferenceLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PreferenceHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.PreferenceLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.PreferenceHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.PreferenceLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.PreferenceController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.Preference) (*v3.Preference, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.Preference, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.Preference, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.PreferenceList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.PreferenceList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.Preference) (*v3.Preference, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.PreferenceHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PreferenceLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.PreferenceHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PreferenceLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PreferenceHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PreferenceLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PreferenceHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PreferenceLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.Preference
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.Preference
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PreferenceInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PreferenceHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PreferenceInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but PreferenceInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.PreferenceHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPreferenceInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPreferenceInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedPreferenceInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *PreferenceInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.PreferenceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.PreferenceHandlerFunc
	}
	lockPreferenceInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPreferenceInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *PreferenceInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PreferenceLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("PreferenceInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but PreferenceInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.PreferenceLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPreferenceInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockPreferenceInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedPreferenceInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *PreferenceInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.PreferenceLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.PreferenceLifecycle
	}
	lockPreferenceInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockPreferenceInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PreferenceInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.PreferenceHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PreferenceInterfaceMock.AddClusterScopedHandlerFunc: method is nil but PreferenceInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.PreferenceHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPreferenceInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPreferenceInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedPreferenceInterface.AddClusterScopedHandlerCalls())
func (mock *PreferenceInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.PreferenceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.PreferenceHandlerFunc
	}
	lockPreferenceInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPreferenceInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *PreferenceInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.PreferenceLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("PreferenceInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but PreferenceInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.PreferenceLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPreferenceInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockPreferenceInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedPreferenceInterface.AddClusterScopedLifecycleCalls())
func (mock *PreferenceInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.PreferenceLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.PreferenceLifecycle
	}
	lockPreferenceInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockPreferenceInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PreferenceInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PreferenceHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PreferenceInterfaceMock.AddFeatureHandlerFunc: method is nil but PreferenceInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PreferenceHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPreferenceInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPreferenceInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedPreferenceInterface.AddFeatureHandlerCalls())
func (mock *PreferenceInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.PreferenceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PreferenceHandlerFunc
	}
	lockPreferenceInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPreferenceInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *PreferenceInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.PreferenceLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("PreferenceInterfaceMock.AddFeatureLifecycleFunc: method is nil but PreferenceInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.PreferenceLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPreferenceInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockPreferenceInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedPreferenceInterface.AddFeatureLifecycleCalls())
func (mock *PreferenceInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.PreferenceLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.PreferenceLifecycle
	}
	lockPreferenceInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockPreferenceInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PreferenceInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.PreferenceHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PreferenceInterfaceMock.AddHandlerFunc: method is nil but PreferenceInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.PreferenceHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockPreferenceInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPreferenceInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedPreferenceInterface.AddHandlerCalls())
func (mock *PreferenceInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.PreferenceHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.PreferenceHandlerFunc
	}
	lockPreferenceInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPreferenceInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *PreferenceInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.PreferenceLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("PreferenceInterfaceMock.AddLifecycleFunc: method is nil but PreferenceInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.PreferenceLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPreferenceInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockPreferenceInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedPreferenceInterface.AddLifecycleCalls())
func (mock *PreferenceInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.PreferenceLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.PreferenceLifecycle
	}
	lockPreferenceInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockPreferenceInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *PreferenceInterfaceMock) Controller() v31.PreferenceController {
	if mock.ControllerFunc == nil {
		panic("PreferenceInterfaceMock.ControllerFunc: method is nil but PreferenceInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockPreferenceInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockPreferenceInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedPreferenceInterface.ControllerCalls())
func (mock *PreferenceInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockPreferenceInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockPreferenceInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *PreferenceInterfaceMock) Create(in1 *v3.Preference) (*v3.Preference, error) {
	if mock.CreateFunc == nil {
		panic("PreferenceInterfaceMock.CreateFunc: method is nil but PreferenceInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.Preference
	}{
		In1: in1,
	}
	lockPreferenceInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockPreferenceInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedPreferenceInterface.CreateCalls())
func (mock *PreferenceInterfaceMock) CreateCalls() []struct {
	In1 *v3.Preference
} {
	var calls []struct {
		In1 *v3.Preference
	}
	lockPreferenceInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockPreferenceInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *PreferenceInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("PreferenceInterfaceMock.DeleteFunc: method is nil but PreferenceInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockPreferenceInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockPreferenceInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedPreferenceInterface.DeleteCalls())
func (mock *PreferenceInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockPreferenceInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockPreferenceInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *PreferenceInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("PreferenceInterfaceMock.DeleteCollectionFunc: method is nil but PreferenceInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockPreferenceInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockPreferenceInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedPreferenceInterface.DeleteCollectionCalls())
func (mock *PreferenceInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockPreferenceInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockPreferenceInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *PreferenceInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("PreferenceInterfaceMock.DeleteNamespacedFunc: method is nil but PreferenceInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockPreferenceInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockPreferenceInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedPreferenceInterface.DeleteNamespacedCalls())
func (mock *PreferenceInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockPreferenceInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockPreferenceInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *PreferenceInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.Preference, error) {
	if mock.GetFunc == nil {
		panic("PreferenceInterfaceMock.GetFunc: method is nil but PreferenceInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockPreferenceInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPreferenceInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedPreferenceInterface.GetCalls())
func (mock *PreferenceInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockPreferenceInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockPreferenceInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *PreferenceInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.Preference, error) {
	if mock.GetNamespacedFunc == nil {
		panic("PreferenceInterfaceMock.GetNamespacedFunc: method is nil but PreferenceInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockPreferenceInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockPreferenceInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedPreferenceInterface.GetNamespacedCalls())
func (mock *PreferenceInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockPreferenceInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockPreferenceInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PreferenceInterfaceMock) List(opts metav1.ListOptions) (*v3.PreferenceList, error) {
	if mock.ListFunc == nil {
		panic("PreferenceInterfaceMock.ListFunc: method is nil but PreferenceInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPreferenceInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPreferenceInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedPreferenceInterface.ListCalls())
func (mock *PreferenceInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPreferenceInterfaceMockList.RLock()
	calls = mock.calls.List
	lockPreferenceInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *PreferenceInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.PreferenceList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("PreferenceInterfaceMock.ListNamespacedFunc: method is nil but PreferenceInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockPreferenceInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockPreferenceInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedPreferenceInterface.ListNamespacedCalls())
func (mock *PreferenceInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockPreferenceInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockPreferenceInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *PreferenceInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("PreferenceInterfaceMock.ObjectClientFunc: method is nil but PreferenceInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockPreferenceInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockPreferenceInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedPreferenceInterface.ObjectClientCalls())
func (mock *PreferenceInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockPreferenceInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockPreferenceInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *PreferenceInterfaceMock) Update(in1 *v3.Preference) (*v3.Preference, error) {
	if mock.UpdateFunc == nil {
		panic("PreferenceInterfaceMock.UpdateFunc: method is nil but PreferenceInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.Preference
	}{
		In1: in1,
	}
	lockPreferenceInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockPreferenceInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedPreferenceInterface.UpdateCalls())
func (mock *PreferenceInterfaceMock) UpdateCalls() []struct {
	In1 *v3.Preference
} {
	var calls []struct {
		In1 *v3.Preference
	}
	lockPreferenceInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockPreferenceInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *PreferenceInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("PreferenceInterfaceMock.WatchFunc: method is nil but PreferenceInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPreferenceInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockPreferenceInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedPreferenceInterface.WatchCalls())
func (mock *PreferenceInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPreferenceInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockPreferenceInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockPreferencesGetterMockPreferences sync.RWMutex
)

// Ensure, that PreferencesGetterMock does implement v31.PreferencesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.PreferencesGetter = &PreferencesGetterMock{}

// PreferencesGetterMock is a mock implementation of v31.PreferencesGetter.
//
//	    func TestSomethingThatUsesPreferencesGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.PreferencesGetter
//	        mockedPreferencesGetter := &PreferencesGetterMock{
//	            PreferencesFunc: func(namespace string) v31.PreferenceInterface {
//		               panic("mock out the Preferences method")
//	            },
//	        }
//
//	        // use mockedPreferencesGetter in code that requires v31.PreferencesGetter
//	        // and then make assertions.
//
//	    }
type PreferencesGetterMock struct {
	// PreferencesFunc mocks the Preferences method.
	PreferencesFunc func(namespace string) v31.PreferenceInterface

	// calls tracks calls to the methods.
	calls struct {
		// Preferences holds details about calls to the Preferences method.
		Preferences []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Preferences calls PreferencesFunc.
func (mock *PreferencesGetterMock) Preferences(namespace string) v31.PreferenceInterface {
	if mock.PreferencesFunc == nil {
		panic("PreferencesGetterMock.PreferencesFunc: method is nil but PreferencesGetter.Preferences was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockPreferencesGetterMockPreferences.Lock()
	mock.calls.Preferences = append(mock.calls.Preferences, callInfo)
	lockPreferencesGetterMockPreferences.Unlock()
	return mock.PreferencesFunc(namespace)
}

// PreferencesCalls gets all the calls that were made to Preferences.
// Check the length with:
//
//	len(mockedPreferencesGetter.PreferencesCalls())
func (mock *PreferencesGetterMock) PreferencesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockPreferencesGetterMockPreferences.RLock()
	calls = mock.calls.Preferences
	lockPreferencesGetterMockPreferences.RUnlock()
	return calls
}
