// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockRancherUserNotificationListerMockGet  sync.RWMutex
	lockRancherUserNotificationListerMockList sync.RWMutex
)

// Ensure, that RancherUserNotificationListerMock does implement v31.RancherUserNotificationLister.
// If this is not the case, regenerate this file with moq.
var _ v31.RancherUserNotificationLister = &RancherUserNotificationListerMock{}

// RancherUserNotificationListerMock is a mock implementation of v31.RancherUserNotificationLister.
//
//	    func TestSomethingThatUsesRancherUserNotificationLister(t *testing.T) {
//
//	        // make and configure a mocked v31.RancherUserNotificationLister
//	        mockedRancherUserNotificationLister := &RancherUserNotificationListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.RancherUserNotification, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.RancherUserNotification, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedRancherUserNotificationLister in code that requires v31.RancherUserNotificationLister
//	        // and then make assertions.
//
//	    }
type RancherUserNotificationListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.RancherUserNotification, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.RancherUserNotification, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *RancherUserNotificationListerMock) Get(namespace string, name string) (*v3.RancherUserNotification, error) {
	if mock.GetFunc == nil {
		panic("RancherUserNotificationListerMock.GetFunc: method is nil but RancherUserNotificationLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockRancherUserNotificationListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockRancherUserNotificationListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedRancherUserNotificationLister.GetCalls())
func (mock *RancherUserNotificationListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockRancherUserNotificationListerMockGet.RLock()
	calls = mock.calls.Get
	lockRancherUserNotificationListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *RancherUserNotificationListerMock) List(namespace string, selector labels.Selector) ([]*v3.RancherUserNotification, error) {
	if mock.ListFunc == nil {
		panic("RancherUserNotificationListerMock.ListFunc: method is nil but RancherUserNotificationLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockRancherUserNotificationListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockRancherUserNotificationListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedRancherUserNotificationLister.ListCalls())
func (mock *RancherUserNotificationListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockRancherUserNotificationListerMockList.RLock()
	calls = mock.calls.List
	lockRancherUserNotificationListerMockList.RUnlock()
	return calls
}

var (
	lockRancherUserNotificationControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockRancherUserNotificationControllerMockAddClusterScopedHandler        sync.RWMutex
	lockRancherUserNotificationControllerMockAddFeatureHandler              sync.RWMutex
	lockRancherUserNotificationControllerMockAddHandler                     sync.RWMutex
	lockRancherUserNotificationControllerMockEnqueue                        sync.RWMutex
	lockRancherUserNotificationControllerMockEnqueueAfter                   sync.RWMutex
	lockRancherUserNotificationControllerMockGeneric                        sync.RWMutex
	lockRancherUserNotificationControllerMockInformer                       sync.RWMutex
	lockRancherUserNotificationControllerMockLister                         sync.RWMutex
)

// Ensure, that RancherUserNotificationControllerMock does implement v31.RancherUserNotificationController.
// If this is not the case, regenerate this file with moq.
var _ v31.RancherUserNotificationController = &RancherUserNotificationControllerMock{}

// RancherUserNotificationControllerMock is a mock implementation of v31.RancherUserNotificationController.
//
//	    func TestSomethingThatUsesRancherUserNotificationController(t *testing.T) {
//
//	        // make and configure a mocked v31.RancherUserNotificationController
//	        mockedRancherUserNotificationController := &RancherUserNotificationControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RancherUserNotificationHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.RancherUserNotificationHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RancherUserNotificationHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.RancherUserNotificationHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.RancherUserNotificationLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedRancherUserNotificationController in code that requires v31.RancherUserNotificationController
//	        // and then make assertions.
//
//	    }
type RancherUserNotificationControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RancherUserNotificationHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.RancherUserNotificationHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RancherUserNotificationHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.RancherUserNotificationHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.RancherUserNotificationLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.RancherUserNotificationHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.RancherUserNotificationHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RancherUserNotificationHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.RancherUserNotificationHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *RancherUserNotificationControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RancherUserNotificationHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("RancherUserNotificationControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but RancherUserNotificationController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.RancherUserNotificationHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockRancherUserNotificationControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockRancherUserNotificationControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedRancherUserNotificationController.AddClusterScopedFeatureHandlerCalls())
func (mock *RancherUserNotificationControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.RancherUserNotificationHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.RancherUserNotificationHandlerFunc
	}
	lockRancherUserNotificationControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockRancherUserNotificationControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *RancherUserNotificationControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.RancherUserNotificationHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("RancherUserNotificationControllerMock.AddClusterScopedHandlerFunc: method is nil but RancherUserNotificationController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.RancherUserNotificationHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockRancherUserNotificationControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockRancherUserNotificationControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedRancherUserNotificationController.AddClusterScopedHandlerCalls())
func (mock *RancherUserNotificationControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.RancherUserNotificationHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.RancherUserNotificationHandlerFunc
	}
	lockRancherUserNotificationControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockRancherUserNotificationControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *RancherUserNotificationControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RancherUserNotificationHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("RancherUserNotificationControllerMock.AddFeatureHandlerFunc: method is nil but RancherUserNotificationController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RancherUserNotificationHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockRancherUserNotificationControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockRancherUserNotificationControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedRancherUserNotificationController.AddFeatureHandlerCalls())
func (mock *RancherUserNotificationControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.RancherUserNotificationHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RancherUserNotificationHandlerFunc
	}
	lockRancherUserNotificationControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockRancherUserNotificationControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *RancherUserNotificationControllerMock) AddHandler(ctx context.Context, name string, handler v31.RancherUserNotificationHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("RancherUserNotificationControllerMock.AddHandlerFunc: method is nil but RancherUserNotificationController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.RancherUserNotificationHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockRancherUserNotificationControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockRancherUserNotificationControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedRancherUserNotificationController.AddHandlerCalls())
func (mock *RancherUserNotificationControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.RancherUserNotificationHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.RancherUserNotificationHandlerFunc
	}
	lockRancherUserNotificationControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockRancherUserNotificationControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *RancherUserNotificationControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("RancherUserNotificationControllerMock.EnqueueFunc: method is nil but RancherUserNotificationController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockRancherUserNotificationControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockRancherUserNotificationControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedRancherUserNotificationController.EnqueueCalls())
func (mock *RancherUserNotificationControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockRancherUserNotificationControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockRancherUserNotificationControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *RancherUserNotificationControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("RancherUserNotificationControllerMock.EnqueueAfterFunc: method is nil but RancherUserNotificationController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockRancherUserNotificationControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockRancherUserNotificationControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedRancherUserNotificationController.EnqueueAfterCalls())
func (mock *RancherUserNotificationControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockRancherUserNotificationControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockRancherUserNotificationControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *RancherUserNotificationControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("RancherUserNotificationControllerMock.GenericFunc: method is nil but RancherUserNotificationController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockRancherUserNotificationControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockRancherUserNotificationControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedRancherUserNotificationController.GenericCalls())
func (mock *RancherUserNotificationControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockRancherUserNotificationControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockRancherUserNotificationControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *RancherUserNotificationControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("RancherUserNotificationControllerMock.InformerFunc: method is nil but RancherUserNotificationController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockRancherUserNotificationControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockRancherUserNotificationControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedRancherUserNotificationController.InformerCalls())
func (mock *RancherUserNotificationControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockRancherUserNotificationControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockRancherUserNotificationControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *RancherUserNotificationControllerMock) Lister() v31.RancherUserNotificationLister {
	if mock.ListerFunc == nil {
		panic("RancherUserNotificationControllerMock.ListerFunc: method is nil but RancherUserNotificationController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockRancherUserNotificationControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockRancherUserNotificationControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedRancherUserNotificationController.ListerCalls())
func (mock *RancherUserNotificationControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockRancherUserNotificationControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockRancherUserNotificationControllerMockLister.RUnlock()
	return calls
}

var (
	lockRancherUserNotificationInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockRancherUserNotificationInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockRancherUserNotificationInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockRancherUserNotificationInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockRancherUserNotificationInterfaceMockAddFeatureHandler                sync.RWMutex
	lockRancherUserNotificationInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockRancherUserNotificationInterfaceMockAddHandler                       sync.RWMutex
	lockRancherUserNotificationInterfaceMockAddLifecycle                     sync.RWMutex
	lockRancherUserNotificationInterfaceMockController                       sync.RWMutex
	lockRancherUserNotificationInterfaceMockCreate                           sync.RWMutex
	lockRancherUserNotificationInterfaceMockDelete                           sync.RWMutex
	lockRancherUserNotificationInterfaceMockDeleteCollection                 sync.RWMutex
	lockRancherUserNotificationInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockRancherUserNotificationInterfaceMockGet                              sync.RWMutex
	lockRancherUserNotificationInterfaceMockGetNamespaced                    sync.RWMutex
	lockRancherUserNotificationInterfaceMockList                             sync.RWMutex
	lockRancherUserNotificationInterfaceMockListNamespaced                   sync.RWMutex
	lockRancherUserNotificationInterfaceMockObjectClient                     sync.RWMutex
	lockRancherUserNotificationInterfaceMockUpdate                           sync.RWMutex
	lockRancherUserNotificationInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that RancherUserNotificationInterfaceMock does implement v31.RancherUserNotificationInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.RancherUserNotificationInterface = &RancherUserNotificationInterfaceMock{}

// RancherUserNotificationInterfaceMock is a mock implementation of v31.RancherUserNotificationInterface.
//
//	    func TestSomethingThatUsesRancherUserNotificationInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.RancherUserNotificationInterface
//	        mockedRancherUserNotificationInterface := &RancherUserNotificationInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RancherUserNotificationHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RancherUserNotificationLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.RancherUserNotificationHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.RancherUserNotificationLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RancherUserNotificationHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.RancherUserNotificationLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.RancherUserNotificationHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.RancherUserNotificationLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.RancherUserNotificationController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.RancherUserNotification) (*v3.RancherUserNotification, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.RancherUserNotification, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.RancherUserNotification, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.RancherUserNotificationList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.RancherUserNotificationList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.RancherUserNotification) (*v3.RancherUserNotification, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedRancherUserNotificationInterface in code that requires v31.RancherUserNotificationInterface
//	        // and then make assertions.
//
//	    }
type RancherUserNotificationInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RancherUserNotificationHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RancherUserNotificationLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.RancherUserNotificationHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.RancherUserNotificationLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RancherUserNotificationHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.RancherUserNotificationLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.RancherUserNotificationHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.RancherUserNotificationLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.RancherUserNotificationController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.RancherUserNotification) (*v3.RancherUserNotification, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.RancherUserNotification, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.RancherUserNotification, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.RancherUserNotificationList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.RancherUserNotificationList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.RancherUserNotification) (*v3.RancherUserNotification, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.RancherUserNotificationHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RancherUserNotificationLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.RancherUserNotificationHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RancherUserNotificationLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RancherUserNotificationHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RancherUserNotificationLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RancherUserNotificationHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RancherUserNotificationLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.RancherUserNotification
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.RancherUserNotification
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *RancherUserNotificationInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RancherUserNotificationHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("RancherUserNotificationInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but RancherUserNotificationInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.RancherUserNotificationHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockRancherUserNotificationInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockRancherUserNotificationInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *RancherUserNotificationInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.RancherUserNotificationHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.RancherUserNotificationHandlerFunc
	}
	lockRancherUserNotificationInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockRancherUserNotificationInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *RancherUserNotificationInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RancherUserNotificationLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("RancherUserNotificationInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but RancherUserNotificationInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.RancherUserNotificationLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockRancherUserNotificationInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockRancherUserNotificationInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *RancherUserNotificationInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.RancherUserNotificationLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.RancherUserNotificationLifecycle
	}
	lockRancherUserNotificationInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockRancherUserNotificationInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *RancherUserNotificationInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.RancherUserNotificationHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("RancherUserNotificationInterfaceMock.AddClusterScopedHandlerFunc: method is nil but RancherUserNotificationInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.RancherUserNotificationHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockRancherUserNotificationInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockRancherUserNotificationInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.AddClusterScopedHandlerCalls())
func (mock *RancherUserNotificationInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.RancherUserNotificationHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.RancherUserNotificationHandlerFunc
	}
	lockRancherUserNotificationInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockRancherUserNotificationInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *RancherUserNotificationInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.RancherUserNotificationLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("RancherUserNotificationInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but RancherUserNotificationInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.RancherUserNotificationLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockRancherUserNotificationInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockRancherUserNotificationInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.AddClusterScopedLifecycleCalls())
func (mock *RancherUserNotificationInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.RancherUserNotificationLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.RancherUserNotificationLifecycle
	}
	lockRancherUserNotificationInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockRancherUserNotificationInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *RancherUserNotificationInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RancherUserNotificationHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("RancherUserNotificationInterfaceMock.AddFeatureHandlerFunc: method is nil but RancherUserNotificationInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RancherUserNotificationHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockRancherUserNotificationInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockRancherUserNotificationInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.AddFeatureHandlerCalls())
func (mock *RancherUserNotificationInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.RancherUserNotificationHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RancherUserNotificationHandlerFunc
	}
	lockRancherUserNotificationInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockRancherUserNotificationInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *RancherUserNotificationInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.RancherUserNotificationLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("RancherUserNotificationInterfaceMock.AddFeatureLifecycleFunc: method is nil but RancherUserNotificationInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.RancherUserNotificationLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockRancherUserNotificationInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockRancherUserNotificationInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.AddFeatureLifecycleCalls())
func (mock *RancherUserNotificationInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.RancherUserNotificationLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.RancherUserNotificationLifecycle
	}
	lockRancherUserNotificationInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockRancherUserNotificationInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *RancherUserNotificationInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.RancherUserNotificationHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("RancherUserNotificationInterfaceMock.AddHandlerFunc: method is nil but RancherUserNotificationInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.RancherUserNotificationHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockRancherUserNotificationInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockRancherUserNotificationInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.AddHandlerCalls())
func (mock *RancherUserNotificationInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.RancherUserNotificationHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.RancherUserNotificationHandlerFunc
	}
	lockRancherUserNotificationInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockRancherUserNotificationInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *RancherUserNotificationInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.RancherUserNotificationLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("RancherUserNotificationInterfaceMock.AddLifecycleFunc: method is nil but RancherUserNotificationInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.RancherUserNotificationLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockRancherUserNotificationInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockRancherUserNotificationInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.AddLifecycleCalls())
func (mock *RancherUserNotificationInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.RancherUserNotificationLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.RancherUserNotificationLifecycle
	}
	lockRancherUserNotificationInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockRancherUserNotificationInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *RancherUserNotificationInterfaceMock) Controller() v31.RancherUserNotificationController {
	if mock.ControllerFunc == nil {
		panic("RancherUserNotificationInterfaceMock.ControllerFunc: method is nil but RancherUserNotificationInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockRancherUserNotificationInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockRancherUserNotificationInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.ControllerCalls())
func (mock *RancherUserNotificationInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockRancherUserNotificationInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockRancherUserNotificationInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *RancherUserNotificationInterfaceMock) Create(in1 *v3.RancherUserNotification) (*v3.RancherUserNotification, error) {
	if mock.CreateFunc == nil {
		panic("RancherUserNotificationInterfaceMock.CreateFunc: method is nil but RancherUserNotificationInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.RancherUserNotification
	}{
		In1: in1,
	}
	lockRancherUserNotificationInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockRancherUserNotificationInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.CreateCalls())
func (mock *RancherUserNotificationInterfaceMock) CreateCalls() []struct {
	In1 *v3.RancherUserNotification
} {
	var calls []struct {
		In1 *v3.RancherUserNotification
	}
	lockRancherUserNotificationInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockRancherUserNotificationInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *RancherUserNotificationInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("RancherUserNotificationInterfaceMock.DeleteFunc: method is nil but RancherUserNotificationInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockRancherUserNotificationInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockRancherUserNotificationInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.DeleteCalls())
func (mock *RancherUserNotificationInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockRancherUserNotificationInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockRancherUserNotificationInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *RancherUserNotificationInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("RancherUserNotificationInterfaceMock.DeleteCollectionFunc: method is nil but RancherUserNotificationInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockRancherUserNotificationInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockRancherUserNotificationInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.DeleteCollectionCalls())
func (mock *RancherUserNotificationInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockRancherUserNotificationInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockRancherUserNotificationInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *RancherUserNotificationInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("RancherUserNotificationInterfaceMock.DeleteNamespacedFunc: method is nil but RancherUserNotificationInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockRancherUserNotificationInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockRancherUserNotificationInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.DeleteNamespacedCalls())
func (mock *RancherUserNotificationInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockRancherUserNotificationInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockRancherUserNotificationInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *RancherUserNotificationInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.RancherUserNotification, error) {
	if mock.GetFunc == nil {
		panic("RancherUserNotificationInterfaceMock.GetFunc: method is nil but RancherUserNotificationInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockRancherUserNotificationInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockRancherUserNotificationInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.GetCalls())
func (mock *RancherUserNotificationInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockRancherUserNotificationInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockRancherUserNotificationInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *RancherUserNotificationInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.RancherUserNotification, error) {
	if mock.GetNamespacedFunc == nil {
		panic("RancherUserNotificationInterfaceMock.GetNamespacedFunc: method is nil but RancherUserNotificationInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockRancherUserNotificationInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockRancherUserNotificationInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.GetNamespacedCalls())
func (mock *RancherUserNotificationInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockRancherUserNotificationInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockRancherUserNotificationInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *RancherUserNotificationInterfaceMock) List(opts metav1.ListOptions) (*v3.RancherUserNotificationList, error) {
	if mock.ListFunc == nil {
		panic("RancherUserNotificationInterfaceMock.ListFunc: method is nil but RancherUserNotificationInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockRancherUserNotificationInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockRancherUserNotificationInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.ListCalls())
func (mock *RancherUserNotificationInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockRancherUserNotificationInterfaceMockList.RLock()
	calls = mock.calls.List
	lockRancherUserNotificationInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *RancherUserNotificationInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.RancherUserNotificationList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("RancherUserNotificationInterfaceMock.ListNamespacedFunc: method is nil but RancherUserNotificationInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockRancherUserNotificationInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockRancherUserNotificationInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.ListNamespacedCalls())
func (mock *RancherUserNotificationInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockRancherUserNotificationInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockRancherUserNotificationInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *RancherUserNotificationInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("RancherUserNotificationInterfaceMock.ObjectClientFunc: method is nil but RancherUserNotificationInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockRancherUserNotificationInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockRancherUserNotificationInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.ObjectClientCalls())
func (mock *RancherUserNotificationInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockRancherUserNotificationInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockRancherUserNotificationInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *RancherUserNotificationInterfaceMock) Update(in1 *v3.RancherUserNotification) (*v3.RancherUserNotification, error) {
	if mock.UpdateFunc == nil {
		panic("RancherUserNotificationInterfaceMock.UpdateFunc: method is nil but RancherUserNotificationInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.RancherUserNotification
	}{
		In1: in1,
	}
	lockRancherUserNotificationInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockRancherUserNotificationInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.UpdateCalls())
func (mock *RancherUserNotificationInterfaceMock) UpdateCalls() []struct {
	In1 *v3.RancherUserNotification
} {
	var calls []struct {
		In1 *v3.RancherUserNotification
	}
	lockRancherUserNotificationInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockRancherUserNotificationInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *RancherUserNotificationInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("RancherUserNotificationInterfaceMock.WatchFunc: method is nil but RancherUserNotificationInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockRancherUserNotificationInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockRancherUserNotificationInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedRancherUserNotificationInterface.WatchCalls())
func (mock *RancherUserNotificationInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockRancherUserNotificationInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockRancherUserNotificationInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockRancherUserNotificationsGetterMockRancherUserNotifications sync.RWMutex
)

// Ensure, that RancherUserNotificationsGetterMock does implement v31.RancherUserNotificationsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.RancherUserNotificationsGetter = &RancherUserNotificationsGetterMock{}

// RancherUserNotificationsGetterMock is a mock implementation of v31.RancherUserNotificationsGetter.
//
//	    func TestSomethingThatUsesRancherUserNotificationsGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.RancherUserNotificationsGetter
//	        mockedRancherUserNotificationsGetter := &RancherUserNotificationsGetterMock{
//	            RancherUserNotificationsFunc: func(namespace string) v31.RancherUserNotificationInterface {
//		               panic("mock out the RancherUserNotifications method")
//	            },
//	        }
//
//	        // use mockedRancherUserNotificationsGetter in code that requires v31.RancherUserNotificationsGetter
//	        // and then make assertions.
//
//	    }
type RancherUserNotificationsGetterMock struct {
	// RancherUserNotificationsFunc mocks the RancherUserNotifications method.
	RancherUserNotificationsFunc func(namespace string) v31.RancherUserNotificationInterface

	// calls tracks calls to the methods.
	calls struct {
		// RancherUserNotifications holds details about calls to the RancherUserNotifications method.
		RancherUserNotifications []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// RancherUserNotifications calls RancherUserNotificationsFunc.
func (mock *RancherUserNotificationsGetterMock) RancherUserNotifications(namespace string) v31.RancherUserNotificationInterface {
	if mock.RancherUserNotificationsFunc == nil {
		panic("RancherUserNotificationsGetterMock.RancherUserNotificationsFunc: method is nil but RancherUserNotificationsGetter.RancherUserNotifications was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockRancherUserNotificationsGetterMockRancherUserNotifications.Lock()
	mock.calls.RancherUserNotifications = append(mock.calls.RancherUserNotifications, callInfo)
	lockRancherUserNotificationsGetterMockRancherUserNotifications.Unlock()
	return mock.RancherUserNotificationsFunc(namespace)
}

// RancherUserNotificationsCalls gets all the calls that were made to RancherUserNotifications.
// Check the length with:
//
//	len(mockedRancherUserNotificationsGetter.RancherUserNotificationsCalls())
func (mock *RancherUserNotificationsGetterMock) RancherUserNotificationsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockRancherUserNotificationsGetterMockRancherUserNotifications.RLock()
	calls = mock.calls.RancherUserNotifications
	lockRancherUserNotificationsGetterMockRancherUserNotifications.RUnlock()
	return calls
}
