// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockRoleTemplateListerMockGet  sync.RWMutex
	lockRoleTemplateListerMockList sync.RWMutex
)

// Ensure, that RoleTemplateListerMock does implement v31.RoleTemplateLister.
// If this is not the case, regenerate this file with moq.
var _ v31.RoleTemplateLister = &RoleTemplateListerMock{}

// RoleTemplateListerMock is a mock implementation of v31.RoleTemplateLister.
//
//	    func TestSomethingThatUsesRoleTemplateLister(t *testing.T) {
//
//	        // make and configure a mocked v31.RoleTemplateLister
//	        mockedRoleTemplateLister := &RoleTemplateListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.RoleTemplate, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.RoleTemplate, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedRoleTemplateLister in code that requires v31.RoleTemplateLister
//	        // and then make assertions.
//
//	    }
type RoleTemplateListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.RoleTemplate, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.RoleTemplate, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *RoleTemplateListerMock) Get(namespace string, name string) (*v3.RoleTemplate, error) {
	if mock.GetFunc == nil {
		panic("RoleTemplateListerMock.GetFunc: method is nil but RoleTemplateLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockRoleTemplateListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockRoleTemplateListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedRoleTemplateLister.GetCalls())
func (mock *RoleTemplateListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockRoleTemplateListerMockGet.RLock()
	calls = mock.calls.Get
	lockRoleTemplateListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *RoleTemplateListerMock) List(namespace string, selector labels.Selector) ([]*v3.RoleTemplate, error) {
	if mock.ListFunc == nil {
		panic("RoleTemplateListerMock.ListFunc: method is nil but RoleTemplateLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockRoleTemplateListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockRoleTemplateListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedRoleTemplateLister.ListCalls())
func (mock *RoleTemplateListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockRoleTemplateListerMockList.RLock()
	calls = mock.calls.List
	lockRoleTemplateListerMockList.RUnlock()
	return calls
}

var (
	lockRoleTemplateControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockRoleTemplateControllerMockAddClusterScopedHandler        sync.RWMutex
	lockRoleTemplateControllerMockAddFeatureHandler              sync.RWMutex
	lockRoleTemplateControllerMockAddHandler                     sync.RWMutex
	lockRoleTemplateControllerMockEnqueue                        sync.RWMutex
	lockRoleTemplateControllerMockEnqueueAfter                   sync.RWMutex
	lockRoleTemplateControllerMockGeneric                        sync.RWMutex
	lockRoleTemplateControllerMockInformer                       sync.RWMutex
	lockRoleTemplateControllerMockLister                         sync.RWMutex
)

// Ensure, that RoleTemplateControllerMock does implement v31.RoleTemplateController.
// If this is not the case, regenerate this file with moq.
var _ v31.RoleTemplateController = &RoleTemplateControllerMock{}

// RoleTemplateControllerMock is a mock implementation of v31.RoleTemplateController.
//
//	    func TestSomethingThatUsesRoleTemplateController(t *testing.T) {
//
//	        // make and configure a mocked v31.RoleTemplateController
//	        mockedRoleTemplateController := &RoleTemplateControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RoleTemplateHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.RoleTemplateHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RoleTemplateHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.RoleTemplateHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.RoleTemplateLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedRoleTemplateController in code that requires v31.RoleTemplateController
//	        // and then make assertions.
//
//	    }
type RoleTemplateControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RoleTemplateHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.RoleTemplateHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RoleTemplateHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.RoleTemplateHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.RoleTemplateLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.RoleTemplateHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.RoleTemplateHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RoleTemplateHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.RoleTemplateHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *RoleTemplateControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RoleTemplateHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("RoleTemplateControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but RoleTemplateController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.RoleTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockRoleTemplateControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockRoleTemplateControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedRoleTemplateController.AddClusterScopedFeatureHandlerCalls())
func (mock *RoleTemplateControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.RoleTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.RoleTemplateHandlerFunc
	}
	lockRoleTemplateControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockRoleTemplateControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *RoleTemplateControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.RoleTemplateHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("RoleTemplateControllerMock.AddClusterScopedHandlerFunc: method is nil but RoleTemplateController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.RoleTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockRoleTemplateControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockRoleTemplateControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedRoleTemplateController.AddClusterScopedHandlerCalls())
func (mock *RoleTemplateControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.RoleTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.RoleTemplateHandlerFunc
	}
	lockRoleTemplateControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockRoleTemplateControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *RoleTemplateControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RoleTemplateHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("RoleTemplateControllerMock.AddFeatureHandlerFunc: method is nil but RoleTemplateController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RoleTemplateHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockRoleTemplateControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockRoleTemplateControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedRoleTemplateController.AddFeatureHandlerCalls())
func (mock *RoleTemplateControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.RoleTemplateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RoleTemplateHandlerFunc
	}
	lockRoleTemplateControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockRoleTemplateControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *RoleTemplateControllerMock) AddHandler(ctx context.Context, name string, handler v31.RoleTemplateHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("RoleTemplateControllerMock.AddHandlerFunc: method is nil but RoleTemplateController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.RoleTemplateHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockRoleTemplateControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockRoleTemplateControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedRoleTemplateController.AddHandlerCalls())
func (mock *RoleTemplateControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.RoleTemplateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.RoleTemplateHandlerFunc
	}
	lockRoleTemplateControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockRoleTemplateControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *RoleTemplateControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("RoleTemplateControllerMock.EnqueueFunc: method is nil but RoleTemplateController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockRoleTemplateControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockRoleTemplateControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedRoleTemplateController.EnqueueCalls())
func (mock *RoleTemplateControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockRoleTemplateControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockRoleTemplateControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *RoleTemplateControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("RoleTemplateControllerMock.EnqueueAfterFunc: method is nil but RoleTemplateController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockRoleTemplateControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockRoleTemplateControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedRoleTemplateController.EnqueueAfterCalls())
func (mock *RoleTemplateControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockRoleTemplateControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockRoleTemplateControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *RoleTemplateControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("RoleTemplateControllerMock.GenericFunc: method is nil but RoleTemplateController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockRoleTemplateControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockRoleTemplateControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedRoleTemplateController.GenericCalls())
func (mock *RoleTemplateControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleTemplateControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockRoleTemplateControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *RoleTemplateControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("RoleTemplateControllerMock.InformerFunc: method is nil but RoleTemplateController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockRoleTemplateControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockRoleTemplateControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedRoleTemplateController.InformerCalls())
func (mock *RoleTemplateControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleTemplateControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockRoleTemplateControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *RoleTemplateControllerMock) Lister() v31.RoleTemplateLister {
	if mock.ListerFunc == nil {
		panic("RoleTemplateControllerMock.ListerFunc: method is nil but RoleTemplateController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockRoleTemplateControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockRoleTemplateControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedRoleTemplateController.ListerCalls())
func (mock *RoleTemplateControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleTemplateControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockRoleTemplateControllerMockLister.RUnlock()
	return calls
}

var (
	lockRoleTemplateInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockRoleTemplateInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockRoleTemplateInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockRoleTemplateInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockRoleTemplateInterfaceMockAddFeatureHandler                sync.RWMutex
	lockRoleTemplateInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockRoleTemplateInterfaceMockAddHandler                       sync.RWMutex
	lockRoleTemplateInterfaceMockAddLifecycle                     sync.RWMutex
	lockRoleTemplateInterfaceMockController                       sync.RWMutex
	lockRoleTemplateInterfaceMockCreate                           sync.RWMutex
	lockRoleTemplateInterfaceMockDelete                           sync.RWMutex
	lockRoleTemplateInterfaceMockDeleteCollection                 sync.RWMutex
	lockRoleTemplateInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockRoleTemplateInterfaceMockGet                              sync.RWMutex
	lockRoleTemplateInterfaceMockGetNamespaced                    sync.RWMutex
	lockRoleTemplateInterfaceMockList                             sync.RWMutex
	lockRoleTemplateInterfaceMockListNamespaced                   sync.RWMutex
	lockRoleTemplateInterfaceMockObjectClient                     sync.RWMutex
	lockRoleTemplateInterfaceMockUpdate                           sync.RWMutex
	lockRoleTemplateInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that RoleTemplateInterfaceMock does implement v31.RoleTemplateInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.RoleTemplateInterface = &RoleTemplateInterfaceMock{}

// RoleTemplateInterfaceMock is a mock implementation of v31.RoleTemplateInterface.
//
//	    func TestSomethingThatUsesRoleTemplateInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.RoleTemplateInterface
//	        mockedRoleTemplateInterface := &RoleTemplateInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RoleTemplateHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RoleTemplateLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.RoleTemplateHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.RoleTemplateLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RoleTemplateHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.RoleTemplateLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.RoleTemplateHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.RoleTemplateLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.RoleTemplateController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.RoleTemplate) (*v3.RoleTemplate, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.RoleTemplate, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.RoleTemplate, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.RoleTemplateList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.RoleTemplateList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.RoleTemplate) (*v3.RoleTemplate, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedRoleTemplateInterface in code that requires v31.RoleTemplateInterface
//	        // and then make assertions.
//
//	    }
type RoleTemplateInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RoleTemplateHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RoleTemplateLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.RoleTemplateHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.RoleTemplateLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RoleTemplateHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.RoleTemplateLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.RoleTemplateHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.RoleTemplateLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.RoleTemplateController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.RoleTemplate) (*v3.RoleTemplate, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.RoleTemplate, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.RoleTemplate, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.RoleTemplateList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.RoleTemplateList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.RoleTemplate) (*v3.RoleTemplate, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.RoleTemplateHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RoleTemplateLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.RoleTemplateHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RoleTemplateLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RoleTemplateHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RoleTemplateLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RoleTemplateHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RoleTemplateLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.RoleTemplate
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.RoleTemplate
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *RoleTemplateInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RoleTemplateHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("RoleTemplateInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but RoleTemplateInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.RoleTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockRoleTemplateInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockRoleTemplateInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *RoleTemplateInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.RoleTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.RoleTemplateHandlerFunc
	}
	lockRoleTemplateInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockRoleTemplateInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *RoleTemplateInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RoleTemplateLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("RoleTemplateInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but RoleTemplateInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.RoleTemplateLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockRoleTemplateInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockRoleTemplateInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *RoleTemplateInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.RoleTemplateLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.RoleTemplateLifecycle
	}
	lockRoleTemplateInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockRoleTemplateInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *RoleTemplateInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.RoleTemplateHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("RoleTemplateInterfaceMock.AddClusterScopedHandlerFunc: method is nil but RoleTemplateInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.RoleTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockRoleTemplateInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockRoleTemplateInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.AddClusterScopedHandlerCalls())
func (mock *RoleTemplateInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.RoleTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.RoleTemplateHandlerFunc
	}
	lockRoleTemplateInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockRoleTemplateInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *RoleTemplateInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.RoleTemplateLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("RoleTemplateInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but RoleTemplateInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.RoleTemplateLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockRoleTemplateInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockRoleTemplateInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.AddClusterScopedLifecycleCalls())
func (mock *RoleTemplateInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.RoleTemplateLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.RoleTemplateLifecycle
	}
	lockRoleTemplateInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockRoleTemplateInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *RoleTemplateInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RoleTemplateHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("RoleTemplateInterfaceMock.AddFeatureHandlerFunc: method is nil but RoleTemplateInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RoleTemplateHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockRoleTemplateInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockRoleTemplateInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.AddFeatureHandlerCalls())
func (mock *RoleTemplateInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.RoleTemplateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RoleTemplateHandlerFunc
	}
	lockRoleTemplateInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockRoleTemplateInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *RoleTemplateInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.RoleTemplateLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("RoleTemplateInterfaceMock.AddFeatureLifecycleFunc: method is nil but RoleTemplateInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.RoleTemplateLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockRoleTemplateInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockRoleTemplateInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.AddFeatureLifecycleCalls())
func (mock *RoleTemplateInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.RoleTemplateLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.RoleTemplateLifecycle
	}
	lockRoleTemplateInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockRoleTemplateInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *RoleTemplateInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.RoleTemplateHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("RoleTemplateInterfaceMock.AddHandlerFunc: method is nil but RoleTemplateInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.RoleTemplateHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockRoleTemplateInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockRoleTemplateInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.AddHandlerCalls())
func (mock *RoleTemplateInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.RoleTemplateHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.RoleTemplateHandlerFunc
	}
	lockRoleTemplateInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockRoleTemplateInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *RoleTemplateInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.RoleTemplateLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("RoleTemplateInterfaceMock.AddLifecycleFunc: method is nil but RoleTemplateInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.RoleTemplateLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockRoleTemplateInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockRoleTemplateInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.AddLifecycleCalls())
func (mock *RoleTemplateInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.RoleTemplateLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.RoleTemplateLifecycle
	}
	lockRoleTemplateInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockRoleTemplateInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *RoleTemplateInterfaceMock) Controller() v31.RoleTemplateController {
	if mock.ControllerFunc == nil {
		panic("RoleTemplateInterfaceMock.ControllerFunc: method is nil but RoleTemplateInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockRoleTemplateInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockRoleTemplateInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.ControllerCalls())
func (mock *RoleTemplateInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleTemplateInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockRoleTemplateInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *RoleTemplateInterfaceMock) Create(in1 *v3.RoleTemplate) (*v3.RoleTemplate, error) {
	if mock.CreateFunc == nil {
		panic("RoleTemplateInterfaceMock.CreateFunc: method is nil but RoleTemplateInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.RoleTemplate
	}{
		In1: in1,
	}
	lockRoleTemplateInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockRoleTemplateInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.CreateCalls())
func (mock *RoleTemplateInterfaceMock) CreateCalls() []struct {
	In1 *v3.RoleTemplate
} {
	var calls []struct {
		In1 *v3.RoleTemplate
	}
	lockRoleTemplateInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockRoleTemplateInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *RoleTemplateInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("RoleTemplateInterfaceMock.DeleteFunc: method is nil but RoleTemplateInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockRoleTemplateInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockRoleTemplateInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.DeleteCalls())
func (mock *RoleTemplateInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockRoleTemplateInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockRoleTemplateInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *RoleTemplateInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("RoleTemplateInterfaceMock.DeleteCollectionFunc: method is nil but RoleTemplateInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockRoleTemplateInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockRoleTemplateInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.DeleteCollectionCalls())
func (mock *RoleTemplateInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockRoleTemplateInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockRoleTemplateInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *RoleTemplateInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("RoleTemplateInterfaceMock.DeleteNamespacedFunc: method is nil but RoleTemplateInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockRoleTemplateInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockRoleTemplateInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.DeleteNamespacedCalls())
func (mock *RoleTemplateInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockRoleTemplateInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockRoleTemplateInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *RoleTemplateInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.RoleTemplate, error) {
	if mock.GetFunc == nil {
		panic("RoleTemplateInterfaceMock.GetFunc: method is nil but RoleTemplateInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockRoleTemplateInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockRoleTemplateInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.GetCalls())
func (mock *RoleTemplateInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockRoleTemplateInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockRoleTemplateInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *RoleTemplateInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.RoleTemplate, error) {
	if mock.GetNamespacedFunc == nil {
		panic("RoleTemplateInterfaceMock.GetNamespacedFunc: method is nil but RoleTemplateInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockRoleTemplateInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockRoleTemplateInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.GetNamespacedCalls())
func (mock *RoleTemplateInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockRoleTemplateInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockRoleTemplateInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *RoleTemplateInterfaceMock) List(opts metav1.ListOptions) (*v3.RoleTemplateList, error) {
	if mock.ListFunc == nil {
		panic("RoleTemplateInterfaceMock.ListFunc: method is nil but RoleTemplateInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockRoleTemplateInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockRoleTemplateInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.ListCalls())
func (mock *RoleTemplateInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockRoleTemplateInterfaceMockList.RLock()
	calls = mock.calls.List
	lockRoleTemplateInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *RoleTemplateInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.RoleTemplateList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("RoleTemplateInterfaceMock.ListNamespacedFunc: method is nil but RoleTemplateInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockRoleTemplateInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockRoleTemplateInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.ListNamespacedCalls())
func (mock *RoleTemplateInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockRoleTemplateInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockRoleTemplateInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *RoleTemplateInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("RoleTemplateInterfaceMock.ObjectClientFunc: method is nil but RoleTemplateInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockRoleTemplateInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockRoleTemplateInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.ObjectClientCalls())
func (mock *RoleTemplateInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockRoleTemplateInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockRoleTemplateInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *RoleTemplateInterfaceMock) Update(in1 *v3.RoleTemplate) (*v3.RoleTemplate, error) {
	if mock.UpdateFunc == nil {
		panic("RoleTemplateInterfaceMock.UpdateFunc: method is nil but RoleTemplateInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.RoleTemplate
	}{
		In1: in1,
	}
	lockRoleTemplateInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockRoleTemplateInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.UpdateCalls())
func (mock *RoleTemplateInterfaceMock) UpdateCalls() []struct {
	In1 *v3.RoleTemplate
} {
	var calls []struct {
		In1 *v3.RoleTemplate
	}
	lockRoleTemplateInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockRoleTemplateInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *RoleTemplateInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("RoleTemplateInterfaceMock.WatchFunc: method is nil but RoleTemplateInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockRoleTemplateInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockRoleTemplateInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedRoleTemplateInterface.WatchCalls())
func (mock *RoleTemplateInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockRoleTemplateInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockRoleTemplateInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockRoleTemplatesGetterMockRoleTemplates sync.RWMutex
)

// Ensure, that RoleTemplatesGetterMock does implement v31.RoleTemplatesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.RoleTemplatesGetter = &RoleTemplatesGetterMock{}

// RoleTemplatesGetterMock is a mock implementation of v31.RoleTemplatesGetter.
//
//	    func TestSomethingThatUsesRoleTemplatesGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.RoleTemplatesGetter
//	        mockedRoleTemplatesGetter := &RoleTemplatesGetterMock{
//	            RoleTemplatesFunc: func(namespace string) v31.RoleTemplateInterface {
//		               panic("mock out the RoleTemplates method")
//	            },
//	        }
//
//	        // use mockedRoleTemplatesGetter in code that requires v31.RoleTemplatesGetter
//	        // and then make assertions.
//
//	    }
type RoleTemplatesGetterMock struct {
	// RoleTemplatesFunc mocks the RoleTemplates method.
	RoleTemplatesFunc func(namespace string) v31.RoleTemplateInterface

	// calls tracks calls to the methods.
	calls struct {
		// RoleTemplates holds details about calls to the RoleTemplates method.
		RoleTemplates []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// RoleTemplates calls RoleTemplatesFunc.
func (mock *RoleTemplatesGetterMock) RoleTemplates(namespace string) v31.RoleTemplateInterface {
	if mock.RoleTemplatesFunc == nil {
		panic("RoleTemplatesGetterMock.RoleTemplatesFunc: method is nil but RoleTemplatesGetter.RoleTemplates was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockRoleTemplatesGetterMockRoleTemplates.Lock()
	mock.calls.RoleTemplates = append(mock.calls.RoleTemplates, callInfo)
	lockRoleTemplatesGetterMockRoleTemplates.Unlock()
	return mock.RoleTemplatesFunc(namespace)
}

// RoleTemplatesCalls gets all the calls that were made to RoleTemplates.
// Check the length with:
//
//	len(mockedRoleTemplatesGetter.RoleTemplatesCalls())
func (mock *RoleTemplatesGetterMock) RoleTemplatesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockRoleTemplatesGetterMockRoleTemplates.RLock()
	calls = mock.calls.RoleTemplates
	lockRoleTemplatesGetterMockRoleTemplates.RUnlock()
	return calls
}
