// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockSamlTokenListerMockGet  sync.RWMutex
	lockSamlTokenListerMockList sync.RWMutex
)

// Ensure, that SamlTokenListerMock does implement v31.SamlTokenLister.
// If this is not the case, regenerate this file with moq.
var _ v31.SamlTokenLister = &SamlTokenListerMock{}

// SamlTokenListerMock is a mock implementation of v31.SamlTokenLister.
//
//	    func TestSomethingThatUsesSamlTokenLister(t *testing.T) {
//
//	        // make and configure a mocked v31.SamlTokenLister
//	        mockedSamlTokenLister := &SamlTokenListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.SamlToken, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.SamlToken, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedSamlTokenLister in code that requires v31.SamlTokenLister
//	        // and then make assertions.
//
//	    }
type SamlTokenListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.SamlToken, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.SamlToken, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *SamlTokenListerMock) Get(namespace string, name string) (*v3.SamlToken, error) {
	if mock.GetFunc == nil {
		panic("SamlTokenListerMock.GetFunc: method is nil but SamlTokenLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockSamlTokenListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockSamlTokenListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedSamlTokenLister.GetCalls())
func (mock *SamlTokenListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockSamlTokenListerMockGet.RLock()
	calls = mock.calls.Get
	lockSamlTokenListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *SamlTokenListerMock) List(namespace string, selector labels.Selector) ([]*v3.SamlToken, error) {
	if mock.ListFunc == nil {
		panic("SamlTokenListerMock.ListFunc: method is nil but SamlTokenLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockSamlTokenListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockSamlTokenListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedSamlTokenLister.ListCalls())
func (mock *SamlTokenListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockSamlTokenListerMockList.RLock()
	calls = mock.calls.List
	lockSamlTokenListerMockList.RUnlock()
	return calls
}

var (
	lockSamlTokenControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockSamlTokenControllerMockAddClusterScopedHandler        sync.RWMutex
	lockSamlTokenControllerMockAddFeatureHandler              sync.RWMutex
	lockSamlTokenControllerMockAddHandler                     sync.RWMutex
	lockSamlTokenControllerMockEnqueue                        sync.RWMutex
	lockSamlTokenControllerMockEnqueueAfter                   sync.RWMutex
	lockSamlTokenControllerMockGeneric                        sync.RWMutex
	lockSamlTokenControllerMockInformer                       sync.RWMutex
	lockSamlTokenControllerMockLister                         sync.RWMutex
)

// Ensure, that SamlTokenControllerMock does implement v31.SamlTokenController.
// If this is not the case, regenerate this file with moq.
var _ v31.SamlTokenController = &SamlTokenControllerMock{}

// SamlTokenControllerMock is a mock implementation of v31.SamlTokenController.
//
//	    func TestSomethingThatUsesSamlTokenController(t *testing.T) {
//
//	        // make and configure a mocked v31.SamlTokenController
//	        mockedSamlTokenController := &SamlTokenControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SamlTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.SamlTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SamlTokenHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.SamlTokenHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.SamlTokenLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedSamlTokenController in code that requires v31.SamlTokenController
//	        // and then make assertions.
//
//	    }
type SamlTokenControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SamlTokenHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.SamlTokenHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SamlTokenHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.SamlTokenHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.SamlTokenLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.SamlTokenHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.SamlTokenHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SamlTokenHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.SamlTokenHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *SamlTokenControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SamlTokenHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("SamlTokenControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but SamlTokenController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.SamlTokenHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockSamlTokenControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockSamlTokenControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedSamlTokenController.AddClusterScopedFeatureHandlerCalls())
func (mock *SamlTokenControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.SamlTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.SamlTokenHandlerFunc
	}
	lockSamlTokenControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockSamlTokenControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *SamlTokenControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.SamlTokenHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("SamlTokenControllerMock.AddClusterScopedHandlerFunc: method is nil but SamlTokenController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.SamlTokenHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockSamlTokenControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockSamlTokenControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedSamlTokenController.AddClusterScopedHandlerCalls())
func (mock *SamlTokenControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.SamlTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.SamlTokenHandlerFunc
	}
	lockSamlTokenControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockSamlTokenControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *SamlTokenControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SamlTokenHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("SamlTokenControllerMock.AddFeatureHandlerFunc: method is nil but SamlTokenController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SamlTokenHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockSamlTokenControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockSamlTokenControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedSamlTokenController.AddFeatureHandlerCalls())
func (mock *SamlTokenControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.SamlTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SamlTokenHandlerFunc
	}
	lockSamlTokenControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockSamlTokenControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *SamlTokenControllerMock) AddHandler(ctx context.Context, name string, handler v31.SamlTokenHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("SamlTokenControllerMock.AddHandlerFunc: method is nil but SamlTokenController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.SamlTokenHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockSamlTokenControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockSamlTokenControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedSamlTokenController.AddHandlerCalls())
func (mock *SamlTokenControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.SamlTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.SamlTokenHandlerFunc
	}
	lockSamlTokenControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockSamlTokenControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *SamlTokenControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("SamlTokenControllerMock.EnqueueFunc: method is nil but SamlTokenController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockSamlTokenControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockSamlTokenControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedSamlTokenController.EnqueueCalls())
func (mock *SamlTokenControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockSamlTokenControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockSamlTokenControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *SamlTokenControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("SamlTokenControllerMock.EnqueueAfterFunc: method is nil but SamlTokenController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockSamlTokenControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockSamlTokenControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedSamlTokenController.EnqueueAfterCalls())
func (mock *SamlTokenControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockSamlTokenControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockSamlTokenControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *SamlTokenControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("SamlTokenControllerMock.GenericFunc: method is nil but SamlTokenController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockSamlTokenControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockSamlTokenControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedSamlTokenController.GenericCalls())
func (mock *SamlTokenControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockSamlTokenControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockSamlTokenControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *SamlTokenControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("SamlTokenControllerMock.InformerFunc: method is nil but SamlTokenController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockSamlTokenControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockSamlTokenControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedSamlTokenController.InformerCalls())
func (mock *SamlTokenControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockSamlTokenControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockSamlTokenControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *SamlTokenControllerMock) Lister() v31.SamlTokenLister {
	if mock.ListerFunc == nil {
		panic("SamlTokenControllerMock.ListerFunc: method is nil but SamlTokenController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockSamlTokenControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockSamlTokenControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedSamlTokenController.ListerCalls())
func (mock *SamlTokenControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockSamlTokenControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockSamlTokenControllerMockLister.RUnlock()
	return calls
}

var (
	lockSamlTokenInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockSamlTokenInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockSamlTokenInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockSamlTokenInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockSamlTokenInterfaceMockAddFeatureHandler                sync.RWMutex
	lockSamlTokenInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockSamlTokenInterfaceMockAddHandler                       sync.RWMutex
	lockSamlTokenInterfaceMockAddLifecycle                     sync.RWMutex
	lockSamlTokenInterfaceMockController                       sync.RWMutex
	lockSamlTokenInterfaceMockCreate                           sync.RWMutex
	lockSamlTokenInterfaceMockDelete                           sync.RWMutex
	lockSamlTokenInterfaceMockDeleteCollection                 sync.RWMutex
	lockSamlTokenInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockSamlTokenInterfaceMockGet                              sync.RWMutex
	lockSamlTokenInterfaceMockGetNamespaced                    sync.RWMutex
	lockSamlTokenInterfaceMockList                             sync.RWMutex
	lockSamlTokenInterfaceMockListNamespaced                   sync.RWMutex
	lockSamlTokenInterfaceMockObjectClient                     sync.RWMutex
	lockSamlTokenInterfaceMockUpdate                           sync.RWMutex
	lockSamlTokenInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that SamlTokenInterfaceMock does implement v31.SamlTokenInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.SamlTokenInterface = &SamlTokenInterfaceMock{}

// SamlTokenInterfaceMock is a mock implementation of v31.SamlTokenInterface.
//
//	    func TestSomethingThatUsesSamlTokenInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.SamlTokenInterface
//	        mockedSamlTokenInterface := &SamlTokenInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SamlTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SamlTokenLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.SamlTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.SamlTokenLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SamlTokenHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.SamlTokenLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.SamlTokenHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.SamlTokenLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.SamlTokenController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.SamlToken) (*v3.SamlToken, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.SamlToken, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.SamlToken, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.SamlTokenList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.SamlTokenList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.SamlToken) (*v3.SamlToken, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedSamlTokenInterface in code that requires v31.SamlTokenInterface
//	        // and then make assertions.
//
//	    }
type SamlTokenInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SamlTokenHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SamlTokenLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.SamlTokenHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.SamlTokenLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SamlTokenHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.SamlTokenLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.SamlTokenHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.SamlTokenLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.SamlTokenController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.SamlToken) (*v3.SamlToken, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.SamlToken, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.SamlToken, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.SamlTokenList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.SamlTokenList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.SamlToken) (*v3.SamlToken, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.SamlTokenHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SamlTokenLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.SamlTokenHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SamlTokenLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SamlTokenHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SamlTokenLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SamlTokenHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SamlTokenLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.SamlToken
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.SamlToken
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *SamlTokenInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SamlTokenHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("SamlTokenInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but SamlTokenInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.SamlTokenHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockSamlTokenInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockSamlTokenInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedSamlTokenInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *SamlTokenInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.SamlTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.SamlTokenHandlerFunc
	}
	lockSamlTokenInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockSamlTokenInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *SamlTokenInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SamlTokenLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("SamlTokenInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but SamlTokenInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.SamlTokenLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockSamlTokenInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockSamlTokenInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedSamlTokenInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *SamlTokenInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.SamlTokenLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.SamlTokenLifecycle
	}
	lockSamlTokenInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockSamlTokenInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *SamlTokenInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.SamlTokenHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("SamlTokenInterfaceMock.AddClusterScopedHandlerFunc: method is nil but SamlTokenInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.SamlTokenHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockSamlTokenInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockSamlTokenInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedSamlTokenInterface.AddClusterScopedHandlerCalls())
func (mock *SamlTokenInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.SamlTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.SamlTokenHandlerFunc
	}
	lockSamlTokenInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockSamlTokenInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *SamlTokenInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.SamlTokenLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("SamlTokenInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but SamlTokenInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.SamlTokenLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockSamlTokenInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockSamlTokenInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedSamlTokenInterface.AddClusterScopedLifecycleCalls())
func (mock *SamlTokenInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.SamlTokenLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.SamlTokenLifecycle
	}
	lockSamlTokenInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockSamlTokenInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *SamlTokenInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SamlTokenHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("SamlTokenInterfaceMock.AddFeatureHandlerFunc: method is nil but SamlTokenInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SamlTokenHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockSamlTokenInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockSamlTokenInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedSamlTokenInterface.AddFeatureHandlerCalls())
func (mock *SamlTokenInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.SamlTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SamlTokenHandlerFunc
	}
	lockSamlTokenInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockSamlTokenInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *SamlTokenInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.SamlTokenLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("SamlTokenInterfaceMock.AddFeatureLifecycleFunc: method is nil but SamlTokenInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.SamlTokenLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockSamlTokenInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockSamlTokenInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedSamlTokenInterface.AddFeatureLifecycleCalls())
func (mock *SamlTokenInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.SamlTokenLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.SamlTokenLifecycle
	}
	lockSamlTokenInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockSamlTokenInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *SamlTokenInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.SamlTokenHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("SamlTokenInterfaceMock.AddHandlerFunc: method is nil but SamlTokenInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.SamlTokenHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockSamlTokenInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockSamlTokenInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedSamlTokenInterface.AddHandlerCalls())
func (mock *SamlTokenInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.SamlTokenHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.SamlTokenHandlerFunc
	}
	lockSamlTokenInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockSamlTokenInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *SamlTokenInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.SamlTokenLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("SamlTokenInterfaceMock.AddLifecycleFunc: method is nil but SamlTokenInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.SamlTokenLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockSamlTokenInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockSamlTokenInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedSamlTokenInterface.AddLifecycleCalls())
func (mock *SamlTokenInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.SamlTokenLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.SamlTokenLifecycle
	}
	lockSamlTokenInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockSamlTokenInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *SamlTokenInterfaceMock) Controller() v31.SamlTokenController {
	if mock.ControllerFunc == nil {
		panic("SamlTokenInterfaceMock.ControllerFunc: method is nil but SamlTokenInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockSamlTokenInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockSamlTokenInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedSamlTokenInterface.ControllerCalls())
func (mock *SamlTokenInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockSamlTokenInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockSamlTokenInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *SamlTokenInterfaceMock) Create(in1 *v3.SamlToken) (*v3.SamlToken, error) {
	if mock.CreateFunc == nil {
		panic("SamlTokenInterfaceMock.CreateFunc: method is nil but SamlTokenInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.SamlToken
	}{
		In1: in1,
	}
	lockSamlTokenInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockSamlTokenInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedSamlTokenInterface.CreateCalls())
func (mock *SamlTokenInterfaceMock) CreateCalls() []struct {
	In1 *v3.SamlToken
} {
	var calls []struct {
		In1 *v3.SamlToken
	}
	lockSamlTokenInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockSamlTokenInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *SamlTokenInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("SamlTokenInterfaceMock.DeleteFunc: method is nil but SamlTokenInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockSamlTokenInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockSamlTokenInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedSamlTokenInterface.DeleteCalls())
func (mock *SamlTokenInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockSamlTokenInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockSamlTokenInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *SamlTokenInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("SamlTokenInterfaceMock.DeleteCollectionFunc: method is nil but SamlTokenInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockSamlTokenInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockSamlTokenInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedSamlTokenInterface.DeleteCollectionCalls())
func (mock *SamlTokenInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockSamlTokenInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockSamlTokenInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *SamlTokenInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("SamlTokenInterfaceMock.DeleteNamespacedFunc: method is nil but SamlTokenInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockSamlTokenInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockSamlTokenInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedSamlTokenInterface.DeleteNamespacedCalls())
func (mock *SamlTokenInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockSamlTokenInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockSamlTokenInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *SamlTokenInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.SamlToken, error) {
	if mock.GetFunc == nil {
		panic("SamlTokenInterfaceMock.GetFunc: method is nil but SamlTokenInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockSamlTokenInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockSamlTokenInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedSamlTokenInterface.GetCalls())
func (mock *SamlTokenInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockSamlTokenInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockSamlTokenInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *SamlTokenInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.SamlToken, error) {
	if mock.GetNamespacedFunc == nil {
		panic("SamlTokenInterfaceMock.GetNamespacedFunc: method is nil but SamlTokenInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockSamlTokenInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockSamlTokenInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedSamlTokenInterface.GetNamespacedCalls())
func (mock *SamlTokenInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockSamlTokenInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockSamlTokenInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *SamlTokenInterfaceMock) List(opts metav1.ListOptions) (*v3.SamlTokenList, error) {
	if mock.ListFunc == nil {
		panic("SamlTokenInterfaceMock.ListFunc: method is nil but SamlTokenInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockSamlTokenInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockSamlTokenInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedSamlTokenInterface.ListCalls())
func (mock *SamlTokenInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockSamlTokenInterfaceMockList.RLock()
	calls = mock.calls.List
	lockSamlTokenInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *SamlTokenInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.SamlTokenList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("SamlTokenInterfaceMock.ListNamespacedFunc: method is nil but SamlTokenInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockSamlTokenInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockSamlTokenInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedSamlTokenInterface.ListNamespacedCalls())
func (mock *SamlTokenInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockSamlTokenInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockSamlTokenInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *SamlTokenInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("SamlTokenInterfaceMock.ObjectClientFunc: method is nil but SamlTokenInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockSamlTokenInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockSamlTokenInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedSamlTokenInterface.ObjectClientCalls())
func (mock *SamlTokenInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockSamlTokenInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockSamlTokenInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *SamlTokenInterfaceMock) Update(in1 *v3.SamlToken) (*v3.SamlToken, error) {
	if mock.UpdateFunc == nil {
		panic("SamlTokenInterfaceMock.UpdateFunc: method is nil but SamlTokenInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.SamlToken
	}{
		In1: in1,
	}
	lockSamlTokenInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockSamlTokenInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedSamlTokenInterface.UpdateCalls())
func (mock *SamlTokenInterfaceMock) UpdateCalls() []struct {
	In1 *v3.SamlToken
} {
	var calls []struct {
		In1 *v3.SamlToken
	}
	lockSamlTokenInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockSamlTokenInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *SamlTokenInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("SamlTokenInterfaceMock.WatchFunc: method is nil but SamlTokenInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockSamlTokenInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockSamlTokenInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedSamlTokenInterface.WatchCalls())
func (mock *SamlTokenInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockSamlTokenInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockSamlTokenInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockSamlTokensGetterMockSamlTokens sync.RWMutex
)

// Ensure, that SamlTokensGetterMock does implement v31.SamlTokensGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.SamlTokensGetter = &SamlTokensGetterMock{}

// SamlTokensGetterMock is a mock implementation of v31.SamlTokensGetter.
//
//	    func TestSomethingThatUsesSamlTokensGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.SamlTokensGetter
//	        mockedSamlTokensGetter := &SamlTokensGetterMock{
//	            SamlTokensFunc: func(namespace string) v31.SamlTokenInterface {
//		               panic("mock out the SamlTokens method")
//	            },
//	        }
//
//	        // use mockedSamlTokensGetter in code that requires v31.SamlTokensGetter
//	        // and then make assertions.
//
//	    }
type SamlTokensGetterMock struct {
	// SamlTokensFunc mocks the SamlTokens method.
	SamlTokensFunc func(namespace string) v31.SamlTokenInterface

	// calls tracks calls to the methods.
	calls struct {
		// SamlTokens holds details about calls to the SamlTokens method.
		SamlTokens []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// SamlTokens calls SamlTokensFunc.
func (mock *SamlTokensGetterMock) SamlTokens(namespace string) v31.SamlTokenInterface {
	if mock.SamlTokensFunc == nil {
		panic("SamlTokensGetterMock.SamlTokensFunc: method is nil but SamlTokensGetter.SamlTokens was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockSamlTokensGetterMockSamlTokens.Lock()
	mock.calls.SamlTokens = append(mock.calls.SamlTokens, callInfo)
	lockSamlTokensGetterMockSamlTokens.Unlock()
	return mock.SamlTokensFunc(namespace)
}

// SamlTokensCalls gets all the calls that were made to SamlTokens.
// Check the length with:
//
//	len(mockedSamlTokensGetter.SamlTokensCalls())
func (mock *SamlTokensGetterMock) SamlTokensCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockSamlTokensGetterMockSamlTokens.RLock()
	calls = mock.calls.SamlTokens
	lockSamlTokensGetterMockSamlTokens.RUnlock()
	return calls
}
