// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockSettingListerMockGet  sync.RWMutex
	lockSettingListerMockList sync.RWMutex
)

// Ensure, that SettingListerMock does implement v31.SettingLister.
// If this is not the case, regenerate this file with moq.
var _ v31.SettingLister = &SettingListerMock{}

// SettingListerMock is a mock implementation of v31.SettingLister.
//
//	    func TestSomethingThatUsesSettingLister(t *testing.T) {
//
//	        // make and configure a mocked v31.SettingLister
//	        mockedSettingLister := &SettingListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.Setting, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.Setting, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedSettingLister in code that requires v31.SettingLister
//	        // and then make assertions.
//
//	    }
type SettingListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.Setting, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.Setting, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *SettingListerMock) Get(namespace string, name string) (*v3.Setting, error) {
	if mock.GetFunc == nil {
		panic("SettingListerMock.GetFunc: method is nil but SettingLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockSettingListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockSettingListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedSettingLister.GetCalls())
func (mock *SettingListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockSettingListerMockGet.RLock()
	calls = mock.calls.Get
	lockSettingListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *SettingListerMock) List(namespace string, selector labels.Selector) ([]*v3.Setting, error) {
	if mock.ListFunc == nil {
		panic("SettingListerMock.ListFunc: method is nil but SettingLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockSettingListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockSettingListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedSettingLister.ListCalls())
func (mock *SettingListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockSettingListerMockList.RLock()
	calls = mock.calls.List
	lockSettingListerMockList.RUnlock()
	return calls
}

var (
	lockSettingControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockSettingControllerMockAddClusterScopedHandler        sync.RWMutex
	lockSettingControllerMockAddFeatureHandler              sync.RWMutex
	lockSettingControllerMockAddHandler                     sync.RWMutex
	lockSettingControllerMockEnqueue                        sync.RWMutex
	lockSettingControllerMockEnqueueAfter                   sync.RWMutex
	lockSettingControllerMockGeneric                        sync.RWMutex
	lockSettingControllerMockInformer                       sync.RWMutex
	lockSettingControllerMockLister                         sync.RWMutex
)

// Ensure, that SettingControllerMock does implement v31.SettingController.
// If this is not the case, regenerate this file with moq.
var _ v31.SettingController = &SettingControllerMock{}

// SettingControllerMock is a mock implementation of v31.SettingController.
//
//	    func TestSomethingThatUsesSettingController(t *testing.T) {
//
//	        // make and configure a mocked v31.SettingController
//	        mockedSettingController := &SettingControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SettingHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.SettingHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SettingHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.SettingHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.SettingLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedSettingController in code that requires v31.SettingController
//	        // and then make assertions.
//
//	    }
type SettingControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SettingHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.SettingHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SettingHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.SettingHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.SettingLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.SettingHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.SettingHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SettingHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.SettingHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *SettingControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SettingHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("SettingControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but SettingController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.SettingHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockSettingControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockSettingControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedSettingController.AddClusterScopedFeatureHandlerCalls())
func (mock *SettingControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.SettingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.SettingHandlerFunc
	}
	lockSettingControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockSettingControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *SettingControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.SettingHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("SettingControllerMock.AddClusterScopedHandlerFunc: method is nil but SettingController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.SettingHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockSettingControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockSettingControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedSettingController.AddClusterScopedHandlerCalls())
func (mock *SettingControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.SettingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.SettingHandlerFunc
	}
	lockSettingControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockSettingControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *SettingControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SettingHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("SettingControllerMock.AddFeatureHandlerFunc: method is nil but SettingController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SettingHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockSettingControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockSettingControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedSettingController.AddFeatureHandlerCalls())
func (mock *SettingControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.SettingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SettingHandlerFunc
	}
	lockSettingControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockSettingControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *SettingControllerMock) AddHandler(ctx context.Context, name string, handler v31.SettingHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("SettingControllerMock.AddHandlerFunc: method is nil but SettingController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.SettingHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockSettingControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockSettingControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedSettingController.AddHandlerCalls())
func (mock *SettingControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.SettingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.SettingHandlerFunc
	}
	lockSettingControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockSettingControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *SettingControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("SettingControllerMock.EnqueueFunc: method is nil but SettingController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockSettingControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockSettingControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedSettingController.EnqueueCalls())
func (mock *SettingControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockSettingControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockSettingControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *SettingControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("SettingControllerMock.EnqueueAfterFunc: method is nil but SettingController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockSettingControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockSettingControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedSettingController.EnqueueAfterCalls())
func (mock *SettingControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockSettingControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockSettingControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *SettingControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("SettingControllerMock.GenericFunc: method is nil but SettingController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockSettingControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockSettingControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedSettingController.GenericCalls())
func (mock *SettingControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockSettingControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockSettingControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *SettingControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("SettingControllerMock.InformerFunc: method is nil but SettingController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockSettingControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockSettingControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedSettingController.InformerCalls())
func (mock *SettingControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockSettingControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockSettingControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *SettingControllerMock) Lister() v31.SettingLister {
	if mock.ListerFunc == nil {
		panic("SettingControllerMock.ListerFunc: method is nil but SettingController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockSettingControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockSettingControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedSettingController.ListerCalls())
func (mock *SettingControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockSettingControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockSettingControllerMockLister.RUnlock()
	return calls
}

var (
	lockSettingInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockSettingInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockSettingInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockSettingInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockSettingInterfaceMockAddFeatureHandler                sync.RWMutex
	lockSettingInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockSettingInterfaceMockAddHandler                       sync.RWMutex
	lockSettingInterfaceMockAddLifecycle                     sync.RWMutex
	lockSettingInterfaceMockController                       sync.RWMutex
	lockSettingInterfaceMockCreate                           sync.RWMutex
	lockSettingInterfaceMockDelete                           sync.RWMutex
	lockSettingInterfaceMockDeleteCollection                 sync.RWMutex
	lockSettingInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockSettingInterfaceMockGet                              sync.RWMutex
	lockSettingInterfaceMockGetNamespaced                    sync.RWMutex
	lockSettingInterfaceMockList                             sync.RWMutex
	lockSettingInterfaceMockListNamespaced                   sync.RWMutex
	lockSettingInterfaceMockObjectClient                     sync.RWMutex
	lockSettingInterfaceMockUpdate                           sync.RWMutex
	lockSettingInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that SettingInterfaceMock does implement v31.SettingInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.SettingInterface = &SettingInterfaceMock{}

// SettingInterfaceMock is a mock implementation of v31.SettingInterface.
//
//	    func TestSomethingThatUsesSettingInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.SettingInterface
//	        mockedSettingInterface := &SettingInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SettingHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SettingLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.SettingHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.SettingLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SettingHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.SettingLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.SettingHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.SettingLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.SettingController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.Setting) (*v3.Setting, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.Setting, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.Setting, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.SettingList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.SettingList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.Setting) (*v3.Setting, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedSettingInterface in code that requires v31.SettingInterface
//	        // and then make assertions.
//
//	    }
type SettingInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SettingHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SettingLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.SettingHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.SettingLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SettingHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.SettingLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.SettingHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.SettingLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.SettingController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.Setting) (*v3.Setting, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.Setting, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.Setting, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.SettingList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.SettingList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.Setting) (*v3.Setting, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.SettingHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SettingLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.SettingHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SettingLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SettingHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SettingLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SettingHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SettingLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.Setting
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.Setting
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *SettingInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SettingHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("SettingInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but SettingInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.SettingHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockSettingInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockSettingInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedSettingInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *SettingInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.SettingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.SettingHandlerFunc
	}
	lockSettingInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockSettingInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *SettingInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SettingLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("SettingInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but SettingInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.SettingLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockSettingInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockSettingInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedSettingInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *SettingInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.SettingLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.SettingLifecycle
	}
	lockSettingInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockSettingInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *SettingInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.SettingHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("SettingInterfaceMock.AddClusterScopedHandlerFunc: method is nil but SettingInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.SettingHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockSettingInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockSettingInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedSettingInterface.AddClusterScopedHandlerCalls())
func (mock *SettingInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.SettingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.SettingHandlerFunc
	}
	lockSettingInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockSettingInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *SettingInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.SettingLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("SettingInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but SettingInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.SettingLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockSettingInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockSettingInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedSettingInterface.AddClusterScopedLifecycleCalls())
func (mock *SettingInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.SettingLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.SettingLifecycle
	}
	lockSettingInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockSettingInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *SettingInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SettingHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("SettingInterfaceMock.AddFeatureHandlerFunc: method is nil but SettingInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SettingHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockSettingInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockSettingInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedSettingInterface.AddFeatureHandlerCalls())
func (mock *SettingInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.SettingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SettingHandlerFunc
	}
	lockSettingInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockSettingInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *SettingInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.SettingLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("SettingInterfaceMock.AddFeatureLifecycleFunc: method is nil but SettingInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.SettingLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockSettingInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockSettingInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedSettingInterface.AddFeatureLifecycleCalls())
func (mock *SettingInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.SettingLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.SettingLifecycle
	}
	lockSettingInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockSettingInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *SettingInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.SettingHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("SettingInterfaceMock.AddHandlerFunc: method is nil but SettingInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.SettingHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockSettingInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockSettingInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedSettingInterface.AddHandlerCalls())
func (mock *SettingInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.SettingHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.SettingHandlerFunc
	}
	lockSettingInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockSettingInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *SettingInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.SettingLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("SettingInterfaceMock.AddLifecycleFunc: method is nil but SettingInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.SettingLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockSettingInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockSettingInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedSettingInterface.AddLifecycleCalls())
func (mock *SettingInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.SettingLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.SettingLifecycle
	}
	lockSettingInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockSettingInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *SettingInterfaceMock) Controller() v31.SettingController {
	if mock.ControllerFunc == nil {
		panic("SettingInterfaceMock.ControllerFunc: method is nil but SettingInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockSettingInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockSettingInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedSettingInterface.ControllerCalls())
func (mock *SettingInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockSettingInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockSettingInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *SettingInterfaceMock) Create(in1 *v3.Setting) (*v3.Setting, error) {
	if mock.CreateFunc == nil {
		panic("SettingInterfaceMock.CreateFunc: method is nil but SettingInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.Setting
	}{
		In1: in1,
	}
	lockSettingInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockSettingInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedSettingInterface.CreateCalls())
func (mock *SettingInterfaceMock) CreateCalls() []struct {
	In1 *v3.Setting
} {
	var calls []struct {
		In1 *v3.Setting
	}
	lockSettingInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockSettingInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *SettingInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("SettingInterfaceMock.DeleteFunc: method is nil but SettingInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockSettingInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockSettingInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedSettingInterface.DeleteCalls())
func (mock *SettingInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockSettingInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockSettingInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *SettingInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("SettingInterfaceMock.DeleteCollectionFunc: method is nil but SettingInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockSettingInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockSettingInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedSettingInterface.DeleteCollectionCalls())
func (mock *SettingInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockSettingInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockSettingInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *SettingInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("SettingInterfaceMock.DeleteNamespacedFunc: method is nil but SettingInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockSettingInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockSettingInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedSettingInterface.DeleteNamespacedCalls())
func (mock *SettingInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockSettingInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockSettingInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *SettingInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.Setting, error) {
	if mock.GetFunc == nil {
		panic("SettingInterfaceMock.GetFunc: method is nil but SettingInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockSettingInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockSettingInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedSettingInterface.GetCalls())
func (mock *SettingInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockSettingInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockSettingInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *SettingInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.Setting, error) {
	if mock.GetNamespacedFunc == nil {
		panic("SettingInterfaceMock.GetNamespacedFunc: method is nil but SettingInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockSettingInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockSettingInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedSettingInterface.GetNamespacedCalls())
func (mock *SettingInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockSettingInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockSettingInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *SettingInterfaceMock) List(opts metav1.ListOptions) (*v3.SettingList, error) {
	if mock.ListFunc == nil {
		panic("SettingInterfaceMock.ListFunc: method is nil but SettingInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockSettingInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockSettingInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedSettingInterface.ListCalls())
func (mock *SettingInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockSettingInterfaceMockList.RLock()
	calls = mock.calls.List
	lockSettingInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *SettingInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.SettingList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("SettingInterfaceMock.ListNamespacedFunc: method is nil but SettingInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockSettingInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockSettingInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedSettingInterface.ListNamespacedCalls())
func (mock *SettingInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockSettingInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockSettingInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *SettingInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("SettingInterfaceMock.ObjectClientFunc: method is nil but SettingInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockSettingInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockSettingInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedSettingInterface.ObjectClientCalls())
func (mock *SettingInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockSettingInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockSettingInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *SettingInterfaceMock) Update(in1 *v3.Setting) (*v3.Setting, error) {
	if mock.UpdateFunc == nil {
		panic("SettingInterfaceMock.UpdateFunc: method is nil but SettingInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.Setting
	}{
		In1: in1,
	}
	lockSettingInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockSettingInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedSettingInterface.UpdateCalls())
func (mock *SettingInterfaceMock) UpdateCalls() []struct {
	In1 *v3.Setting
} {
	var calls []struct {
		In1 *v3.Setting
	}
	lockSettingInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockSettingInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *SettingInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("SettingInterfaceMock.WatchFunc: method is nil but SettingInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockSettingInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockSettingInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedSettingInterface.WatchCalls())
func (mock *SettingInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockSettingInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockSettingInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockSettingsGetterMockSettings sync.RWMutex
)

// Ensure, that SettingsGetterMock does implement v31.SettingsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.SettingsGetter = &SettingsGetterMock{}

// SettingsGetterMock is a mock implementation of v31.SettingsGetter.
//
//	    func TestSomethingThatUsesSettingsGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.SettingsGetter
//	        mockedSettingsGetter := &SettingsGetterMock{
//	            SettingsFunc: func(namespace string) v31.SettingInterface {
//		               panic("mock out the Settings method")
//	            },
//	        }
//
//	        // use mockedSettingsGetter in code that requires v31.SettingsGetter
//	        // and then make assertions.
//
//	    }
type SettingsGetterMock struct {
	// SettingsFunc mocks the Settings method.
	SettingsFunc func(namespace string) v31.SettingInterface

	// calls tracks calls to the methods.
	calls struct {
		// Settings holds details about calls to the Settings method.
		Settings []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Settings calls SettingsFunc.
func (mock *SettingsGetterMock) Settings(namespace string) v31.SettingInterface {
	if mock.SettingsFunc == nil {
		panic("SettingsGetterMock.SettingsFunc: method is nil but SettingsGetter.Settings was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockSettingsGetterMockSettings.Lock()
	mock.calls.Settings = append(mock.calls.Settings, callInfo)
	lockSettingsGetterMockSettings.Unlock()
	return mock.SettingsFunc(namespace)
}

// SettingsCalls gets all the calls that were made to Settings.
// Check the length with:
//
//	len(mockedSettingsGetter.SettingsCalls())
func (mock *SettingsGetterMock) SettingsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockSettingsGetterMockSettings.RLock()
	calls = mock.calls.Settings
	lockSettingsGetterMockSettings.RUnlock()
	return calls
}
