// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockTokenListerMockGet  sync.RWMutex
	lockTokenListerMockList sync.RWMutex
)

// Ensure, that TokenListerMock does implement v31.TokenLister.
// If this is not the case, regenerate this file with moq.
var _ v31.TokenLister = &TokenListerMock{}

// TokenListerMock is a mock implementation of v31.TokenLister.
//
//	    func TestSomethingThatUsesTokenLister(t *testing.T) {
//
//	        // make and configure a mocked v31.TokenLister
//	        mockedTokenLister := &TokenListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.Token, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.Token, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedTokenLister in code that requires v31.TokenLister
//	        // and then make assertions.
//
//	    }
type TokenListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.Token, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.Token, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *TokenListerMock) Get(namespace string, name string) (*v3.Token, error) {
	if mock.GetFunc == nil {
		panic("TokenListerMock.GetFunc: method is nil but TokenLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockTokenListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockTokenListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedTokenLister.GetCalls())
func (mock *TokenListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockTokenListerMockGet.RLock()
	calls = mock.calls.Get
	lockTokenListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *TokenListerMock) List(namespace string, selector labels.Selector) ([]*v3.Token, error) {
	if mock.ListFunc == nil {
		panic("TokenListerMock.ListFunc: method is nil but TokenLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockTokenListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockTokenListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedTokenLister.ListCalls())
func (mock *TokenListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockTokenListerMockList.RLock()
	calls = mock.calls.List
	lockTokenListerMockList.RUnlock()
	return calls
}

var (
	lockTokenControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockTokenControllerMockAddClusterScopedHandler        sync.RWMutex
	lockTokenControllerMockAddFeatureHandler              sync.RWMutex
	lockTokenControllerMockAddHandler                     sync.RWMutex
	lockTokenControllerMockEnqueue                        sync.RWMutex
	lockTokenControllerMockEnqueueAfter                   sync.RWMutex
	lockTokenControllerMockGeneric                        sync.RWMutex
	lockTokenControllerMockInformer                       sync.RWMutex
	lockTokenControllerMockLister                         sync.RWMutex
)

// Ensure, that TokenControllerMock does implement v31.TokenController.
// If this is not the case, regenerate this file with moq.
var _ v31.TokenController = &TokenControllerMock{}

// TokenControllerMock is a mock implementation of v31.TokenController.
//
//	    func TestSomethingThatUsesTokenController(t *testing.T) {
//
//	        // make and configure a mocked v31.TokenController
//	        mockedTokenController := &TokenControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.TokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.TokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TokenHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.TokenHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.TokenLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedTokenController in code that requires v31.TokenController
//	        // and then make assertions.
//
//	    }
type TokenControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.TokenHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.TokenHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TokenHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.TokenHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.TokenLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.TokenHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.TokenHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.TokenHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.TokenHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *TokenControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.TokenHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("TokenControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but TokenController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.TokenHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockTokenControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockTokenControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedTokenController.AddClusterScopedFeatureHandlerCalls())
func (mock *TokenControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.TokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.TokenHandlerFunc
	}
	lockTokenControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockTokenControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *TokenControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.TokenHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("TokenControllerMock.AddClusterScopedHandlerFunc: method is nil but TokenController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.TokenHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockTokenControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockTokenControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedTokenController.AddClusterScopedHandlerCalls())
func (mock *TokenControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.TokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.TokenHandlerFunc
	}
	lockTokenControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockTokenControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *TokenControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TokenHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("TokenControllerMock.AddFeatureHandlerFunc: method is nil but TokenController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.TokenHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockTokenControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockTokenControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedTokenController.AddFeatureHandlerCalls())
func (mock *TokenControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.TokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.TokenHandlerFunc
	}
	lockTokenControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockTokenControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *TokenControllerMock) AddHandler(ctx context.Context, name string, handler v31.TokenHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("TokenControllerMock.AddHandlerFunc: method is nil but TokenController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.TokenHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockTokenControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockTokenControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedTokenController.AddHandlerCalls())
func (mock *TokenControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.TokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.TokenHandlerFunc
	}
	lockTokenControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockTokenControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *TokenControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("TokenControllerMock.EnqueueFunc: method is nil but TokenController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockTokenControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockTokenControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedTokenController.EnqueueCalls())
func (mock *TokenControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockTokenControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockTokenControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *TokenControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("TokenControllerMock.EnqueueAfterFunc: method is nil but TokenController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockTokenControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockTokenControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedTokenController.EnqueueAfterCalls())
func (mock *TokenControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockTokenControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockTokenControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *TokenControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("TokenControllerMock.GenericFunc: method is nil but TokenController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockTokenControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockTokenControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedTokenController.GenericCalls())
func (mock *TokenControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockTokenControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockTokenControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *TokenControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("TokenControllerMock.InformerFunc: method is nil but TokenController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockTokenControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockTokenControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedTokenController.InformerCalls())
func (mock *TokenControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockTokenControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockTokenControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *TokenControllerMock) Lister() v31.TokenLister {
	if mock.ListerFunc == nil {
		panic("TokenControllerMock.ListerFunc: method is nil but TokenController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockTokenControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockTokenControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedTokenController.ListerCalls())
func (mock *TokenControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockTokenControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockTokenControllerMockLister.RUnlock()
	return calls
}

var (
	lockTokenInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockTokenInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockTokenInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockTokenInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockTokenInterfaceMockAddFeatureHandler                sync.RWMutex
	lockTokenInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockTokenInterfaceMockAddHandler                       sync.RWMutex
	lockTokenInterfaceMockAddLifecycle                     sync.RWMutex
	lockTokenInterfaceMockController                       sync.RWMutex
	lockTokenInterfaceMockCreate                           sync.RWMutex
	lockTokenInterfaceMockDelete                           sync.RWMutex
	lockTokenInterfaceMockDeleteCollection                 sync.RWMutex
	lockTokenInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockTokenInterfaceMockGet                              sync.RWMutex
	lockTokenInterfaceMockGetNamespaced                    sync.RWMutex
	lockTokenInterfaceMockList                             sync.RWMutex
	lockTokenInterfaceMockListNamespaced                   sync.RWMutex
	lockTokenInterfaceMockObjectClient                     sync.RWMutex
	lockTokenInterfaceMockUpdate                           sync.RWMutex
	lockTokenInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that TokenInterfaceMock does implement v31.TokenInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.TokenInterface = &TokenInterfaceMock{}

// TokenInterfaceMock is a mock implementation of v31.TokenInterface.
//
//	    func TestSomethingThatUsesTokenInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.TokenInterface
//	        mockedTokenInterface := &TokenInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.TokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.TokenLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.TokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.TokenLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TokenHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.TokenLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.TokenHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.TokenLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.TokenController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.Token) (*v3.Token, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.Token, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.Token, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.TokenList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.TokenList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.Token) (*v3.Token, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedTokenInterface in code that requires v31.TokenInterface
//	        // and then make assertions.
//
//	    }
type TokenInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.TokenHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.TokenLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.TokenHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.TokenLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TokenHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.TokenLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.TokenHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.TokenLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.TokenController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.Token) (*v3.Token, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.Token, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.Token, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.TokenList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.TokenList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.Token) (*v3.Token, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.TokenHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.TokenLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.TokenHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.TokenLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.TokenHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.TokenLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.TokenHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.TokenLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.Token
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.Token
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *TokenInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.TokenHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("TokenInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but TokenInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.TokenHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockTokenInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockTokenInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedTokenInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *TokenInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.TokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.TokenHandlerFunc
	}
	lockTokenInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockTokenInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *TokenInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.TokenLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("TokenInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but TokenInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.TokenLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockTokenInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockTokenInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedTokenInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *TokenInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.TokenLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.TokenLifecycle
	}
	lockTokenInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockTokenInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *TokenInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.TokenHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("TokenInterfaceMock.AddClusterScopedHandlerFunc: method is nil but TokenInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.TokenHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockTokenInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockTokenInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedTokenInterface.AddClusterScopedHandlerCalls())
func (mock *TokenInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.TokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.TokenHandlerFunc
	}
	lockTokenInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockTokenInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *TokenInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.TokenLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("TokenInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but TokenInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.TokenLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockTokenInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockTokenInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedTokenInterface.AddClusterScopedLifecycleCalls())
func (mock *TokenInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.TokenLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.TokenLifecycle
	}
	lockTokenInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockTokenInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *TokenInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TokenHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("TokenInterfaceMock.AddFeatureHandlerFunc: method is nil but TokenInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.TokenHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockTokenInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockTokenInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedTokenInterface.AddFeatureHandlerCalls())
func (mock *TokenInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.TokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.TokenHandlerFunc
	}
	lockTokenInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockTokenInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *TokenInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.TokenLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("TokenInterfaceMock.AddFeatureLifecycleFunc: method is nil but TokenInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.TokenLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockTokenInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockTokenInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedTokenInterface.AddFeatureLifecycleCalls())
func (mock *TokenInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.TokenLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.TokenLifecycle
	}
	lockTokenInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockTokenInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *TokenInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.TokenHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("TokenInterfaceMock.AddHandlerFunc: method is nil but TokenInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.TokenHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockTokenInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockTokenInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedTokenInterface.AddHandlerCalls())
func (mock *TokenInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.TokenHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.TokenHandlerFunc
	}
	lockTokenInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockTokenInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *TokenInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.TokenLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("TokenInterfaceMock.AddLifecycleFunc: method is nil but TokenInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.TokenLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockTokenInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockTokenInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedTokenInterface.AddLifecycleCalls())
func (mock *TokenInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.TokenLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.TokenLifecycle
	}
	lockTokenInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockTokenInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *TokenInterfaceMock) Controller() v31.TokenController {
	if mock.ControllerFunc == nil {
		panic("TokenInterfaceMock.ControllerFunc: method is nil but TokenInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockTokenInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockTokenInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedTokenInterface.ControllerCalls())
func (mock *TokenInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockTokenInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockTokenInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *TokenInterfaceMock) Create(in1 *v3.Token) (*v3.Token, error) {
	if mock.CreateFunc == nil {
		panic("TokenInterfaceMock.CreateFunc: method is nil but TokenInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.Token
	}{
		In1: in1,
	}
	lockTokenInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockTokenInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedTokenInterface.CreateCalls())
func (mock *TokenInterfaceMock) CreateCalls() []struct {
	In1 *v3.Token
} {
	var calls []struct {
		In1 *v3.Token
	}
	lockTokenInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockTokenInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *TokenInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("TokenInterfaceMock.DeleteFunc: method is nil but TokenInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockTokenInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockTokenInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedTokenInterface.DeleteCalls())
func (mock *TokenInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockTokenInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockTokenInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *TokenInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("TokenInterfaceMock.DeleteCollectionFunc: method is nil but TokenInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockTokenInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockTokenInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedTokenInterface.DeleteCollectionCalls())
func (mock *TokenInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockTokenInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockTokenInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *TokenInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("TokenInterfaceMock.DeleteNamespacedFunc: method is nil but TokenInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockTokenInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockTokenInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedTokenInterface.DeleteNamespacedCalls())
func (mock *TokenInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockTokenInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockTokenInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *TokenInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.Token, error) {
	if mock.GetFunc == nil {
		panic("TokenInterfaceMock.GetFunc: method is nil but TokenInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockTokenInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockTokenInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedTokenInterface.GetCalls())
func (mock *TokenInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockTokenInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockTokenInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *TokenInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.Token, error) {
	if mock.GetNamespacedFunc == nil {
		panic("TokenInterfaceMock.GetNamespacedFunc: method is nil but TokenInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockTokenInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockTokenInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedTokenInterface.GetNamespacedCalls())
func (mock *TokenInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockTokenInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockTokenInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *TokenInterfaceMock) List(opts metav1.ListOptions) (*v3.TokenList, error) {
	if mock.ListFunc == nil {
		panic("TokenInterfaceMock.ListFunc: method is nil but TokenInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockTokenInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockTokenInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedTokenInterface.ListCalls())
func (mock *TokenInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockTokenInterfaceMockList.RLock()
	calls = mock.calls.List
	lockTokenInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *TokenInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.TokenList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("TokenInterfaceMock.ListNamespacedFunc: method is nil but TokenInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockTokenInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockTokenInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedTokenInterface.ListNamespacedCalls())
func (mock *TokenInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockTokenInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockTokenInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *TokenInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("TokenInterfaceMock.ObjectClientFunc: method is nil but TokenInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockTokenInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockTokenInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedTokenInterface.ObjectClientCalls())
func (mock *TokenInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockTokenInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockTokenInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *TokenInterfaceMock) Update(in1 *v3.Token) (*v3.Token, error) {
	if mock.UpdateFunc == nil {
		panic("TokenInterfaceMock.UpdateFunc: method is nil but TokenInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.Token
	}{
		In1: in1,
	}
	lockTokenInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockTokenInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedTokenInterface.UpdateCalls())
func (mock *TokenInterfaceMock) UpdateCalls() []struct {
	In1 *v3.Token
} {
	var calls []struct {
		In1 *v3.Token
	}
	lockTokenInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockTokenInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *TokenInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("TokenInterfaceMock.WatchFunc: method is nil but TokenInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockTokenInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockTokenInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedTokenInterface.WatchCalls())
func (mock *TokenInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockTokenInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockTokenInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockTokensGetterMockTokens sync.RWMutex
)

// Ensure, that TokensGetterMock does implement v31.TokensGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.TokensGetter = &TokensGetterMock{}

// TokensGetterMock is a mock implementation of v31.TokensGetter.
//
//	    func TestSomethingThatUsesTokensGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.TokensGetter
//	        mockedTokensGetter := &TokensGetterMock{
//	            TokensFunc: func(namespace string) v31.TokenInterface {
//		               panic("mock out the Tokens method")
//	            },
//	        }
//
//	        // use mockedTokensGetter in code that requires v31.TokensGetter
//	        // and then make assertions.
//
//	    }
type TokensGetterMock struct {
	// TokensFunc mocks the Tokens method.
	TokensFunc func(namespace string) v31.TokenInterface

	// calls tracks calls to the methods.
	calls struct {
		// Tokens holds details about calls to the Tokens method.
		Tokens []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Tokens calls TokensFunc.
func (mock *TokensGetterMock) Tokens(namespace string) v31.TokenInterface {
	if mock.TokensFunc == nil {
		panic("TokensGetterMock.TokensFunc: method is nil but TokensGetter.Tokens was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockTokensGetterMockTokens.Lock()
	mock.calls.Tokens = append(mock.calls.Tokens, callInfo)
	lockTokensGetterMockTokens.Unlock()
	return mock.TokensFunc(namespace)
}

// TokensCalls gets all the calls that were made to Tokens.
// Check the length with:
//
//	len(mockedTokensGetter.TokensCalls())
func (mock *TokensGetterMock) TokensCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockTokensGetterMockTokens.RLock()
	calls = mock.calls.Tokens
	lockTokensGetterMockTokens.RUnlock()
	return calls
}
