// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockUserAttributeListerMockGet  sync.RWMutex
	lockUserAttributeListerMockList sync.RWMutex
)

// Ensure, that UserAttributeListerMock does implement v31.UserAttributeLister.
// If this is not the case, regenerate this file with moq.
var _ v31.UserAttributeLister = &UserAttributeListerMock{}

// UserAttributeListerMock is a mock implementation of v31.UserAttributeLister.
//
//	    func TestSomethingThatUsesUserAttributeLister(t *testing.T) {
//
//	        // make and configure a mocked v31.UserAttributeLister
//	        mockedUserAttributeLister := &UserAttributeListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.UserAttribute, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.UserAttribute, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedUserAttributeLister in code that requires v31.UserAttributeLister
//	        // and then make assertions.
//
//	    }
type UserAttributeListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.UserAttribute, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.UserAttribute, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *UserAttributeListerMock) Get(namespace string, name string) (*v3.UserAttribute, error) {
	if mock.GetFunc == nil {
		panic("UserAttributeListerMock.GetFunc: method is nil but UserAttributeLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockUserAttributeListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockUserAttributeListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedUserAttributeLister.GetCalls())
func (mock *UserAttributeListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockUserAttributeListerMockGet.RLock()
	calls = mock.calls.Get
	lockUserAttributeListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *UserAttributeListerMock) List(namespace string, selector labels.Selector) ([]*v3.UserAttribute, error) {
	if mock.ListFunc == nil {
		panic("UserAttributeListerMock.ListFunc: method is nil but UserAttributeLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockUserAttributeListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockUserAttributeListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedUserAttributeLister.ListCalls())
func (mock *UserAttributeListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockUserAttributeListerMockList.RLock()
	calls = mock.calls.List
	lockUserAttributeListerMockList.RUnlock()
	return calls
}

var (
	lockUserAttributeControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockUserAttributeControllerMockAddClusterScopedHandler        sync.RWMutex
	lockUserAttributeControllerMockAddFeatureHandler              sync.RWMutex
	lockUserAttributeControllerMockAddHandler                     sync.RWMutex
	lockUserAttributeControllerMockEnqueue                        sync.RWMutex
	lockUserAttributeControllerMockEnqueueAfter                   sync.RWMutex
	lockUserAttributeControllerMockGeneric                        sync.RWMutex
	lockUserAttributeControllerMockInformer                       sync.RWMutex
	lockUserAttributeControllerMockLister                         sync.RWMutex
)

// Ensure, that UserAttributeControllerMock does implement v31.UserAttributeController.
// If this is not the case, regenerate this file with moq.
var _ v31.UserAttributeController = &UserAttributeControllerMock{}

// UserAttributeControllerMock is a mock implementation of v31.UserAttributeController.
//
//	    func TestSomethingThatUsesUserAttributeController(t *testing.T) {
//
//	        // make and configure a mocked v31.UserAttributeController
//	        mockedUserAttributeController := &UserAttributeControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.UserAttributeHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.UserAttributeHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.UserAttributeHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.UserAttributeHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.UserAttributeLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedUserAttributeController in code that requires v31.UserAttributeController
//	        // and then make assertions.
//
//	    }
type UserAttributeControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.UserAttributeHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.UserAttributeHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.UserAttributeHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.UserAttributeHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.UserAttributeLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.UserAttributeHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.UserAttributeHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.UserAttributeHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.UserAttributeHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *UserAttributeControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.UserAttributeHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("UserAttributeControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but UserAttributeController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.UserAttributeHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockUserAttributeControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockUserAttributeControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedUserAttributeController.AddClusterScopedFeatureHandlerCalls())
func (mock *UserAttributeControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.UserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.UserAttributeHandlerFunc
	}
	lockUserAttributeControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockUserAttributeControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *UserAttributeControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.UserAttributeHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("UserAttributeControllerMock.AddClusterScopedHandlerFunc: method is nil but UserAttributeController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.UserAttributeHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockUserAttributeControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockUserAttributeControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedUserAttributeController.AddClusterScopedHandlerCalls())
func (mock *UserAttributeControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.UserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.UserAttributeHandlerFunc
	}
	lockUserAttributeControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockUserAttributeControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *UserAttributeControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.UserAttributeHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("UserAttributeControllerMock.AddFeatureHandlerFunc: method is nil but UserAttributeController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.UserAttributeHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockUserAttributeControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockUserAttributeControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedUserAttributeController.AddFeatureHandlerCalls())
func (mock *UserAttributeControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.UserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.UserAttributeHandlerFunc
	}
	lockUserAttributeControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockUserAttributeControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *UserAttributeControllerMock) AddHandler(ctx context.Context, name string, handler v31.UserAttributeHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("UserAttributeControllerMock.AddHandlerFunc: method is nil but UserAttributeController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.UserAttributeHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockUserAttributeControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockUserAttributeControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedUserAttributeController.AddHandlerCalls())
func (mock *UserAttributeControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.UserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.UserAttributeHandlerFunc
	}
	lockUserAttributeControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockUserAttributeControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *UserAttributeControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("UserAttributeControllerMock.EnqueueFunc: method is nil but UserAttributeController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockUserAttributeControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockUserAttributeControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedUserAttributeController.EnqueueCalls())
func (mock *UserAttributeControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockUserAttributeControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockUserAttributeControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *UserAttributeControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("UserAttributeControllerMock.EnqueueAfterFunc: method is nil but UserAttributeController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockUserAttributeControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockUserAttributeControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedUserAttributeController.EnqueueAfterCalls())
func (mock *UserAttributeControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockUserAttributeControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockUserAttributeControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *UserAttributeControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("UserAttributeControllerMock.GenericFunc: method is nil but UserAttributeController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockUserAttributeControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockUserAttributeControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedUserAttributeController.GenericCalls())
func (mock *UserAttributeControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockUserAttributeControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockUserAttributeControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *UserAttributeControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("UserAttributeControllerMock.InformerFunc: method is nil but UserAttributeController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockUserAttributeControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockUserAttributeControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedUserAttributeController.InformerCalls())
func (mock *UserAttributeControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockUserAttributeControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockUserAttributeControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *UserAttributeControllerMock) Lister() v31.UserAttributeLister {
	if mock.ListerFunc == nil {
		panic("UserAttributeControllerMock.ListerFunc: method is nil but UserAttributeController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockUserAttributeControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockUserAttributeControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedUserAttributeController.ListerCalls())
func (mock *UserAttributeControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockUserAttributeControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockUserAttributeControllerMockLister.RUnlock()
	return calls
}

var (
	lockUserAttributeInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockUserAttributeInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockUserAttributeInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockUserAttributeInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockUserAttributeInterfaceMockAddFeatureHandler                sync.RWMutex
	lockUserAttributeInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockUserAttributeInterfaceMockAddHandler                       sync.RWMutex
	lockUserAttributeInterfaceMockAddLifecycle                     sync.RWMutex
	lockUserAttributeInterfaceMockController                       sync.RWMutex
	lockUserAttributeInterfaceMockCreate                           sync.RWMutex
	lockUserAttributeInterfaceMockDelete                           sync.RWMutex
	lockUserAttributeInterfaceMockDeleteCollection                 sync.RWMutex
	lockUserAttributeInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockUserAttributeInterfaceMockGet                              sync.RWMutex
	lockUserAttributeInterfaceMockGetNamespaced                    sync.RWMutex
	lockUserAttributeInterfaceMockList                             sync.RWMutex
	lockUserAttributeInterfaceMockListNamespaced                   sync.RWMutex
	lockUserAttributeInterfaceMockObjectClient                     sync.RWMutex
	lockUserAttributeInterfaceMockUpdate                           sync.RWMutex
	lockUserAttributeInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that UserAttributeInterfaceMock does implement v31.UserAttributeInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.UserAttributeInterface = &UserAttributeInterfaceMock{}

// UserAttributeInterfaceMock is a mock implementation of v31.UserAttributeInterface.
//
//	    func TestSomethingThatUsesUserAttributeInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.UserAttributeInterface
//	        mockedUserAttributeInterface := &UserAttributeInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.UserAttributeHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.UserAttributeLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.UserAttributeHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.UserAttributeLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.UserAttributeHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.UserAttributeLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.UserAttributeHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.UserAttributeLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.UserAttributeController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.UserAttribute) (*v3.UserAttribute, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.UserAttribute, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.UserAttribute, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.UserAttributeList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.UserAttributeList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.UserAttribute) (*v3.UserAttribute, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedUserAttributeInterface in code that requires v31.UserAttributeInterface
//	        // and then make assertions.
//
//	    }
type UserAttributeInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.UserAttributeHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.UserAttributeLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.UserAttributeHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.UserAttributeLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.UserAttributeHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.UserAttributeLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.UserAttributeHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.UserAttributeLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.UserAttributeController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.UserAttribute) (*v3.UserAttribute, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.UserAttribute, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.UserAttribute, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.UserAttributeList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.UserAttributeList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.UserAttribute) (*v3.UserAttribute, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.UserAttributeHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.UserAttributeLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.UserAttributeHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.UserAttributeLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.UserAttributeHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.UserAttributeLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.UserAttributeHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.UserAttributeLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.UserAttribute
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.UserAttribute
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *UserAttributeInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.UserAttributeHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("UserAttributeInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but UserAttributeInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.UserAttributeHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockUserAttributeInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockUserAttributeInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedUserAttributeInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *UserAttributeInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.UserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.UserAttributeHandlerFunc
	}
	lockUserAttributeInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockUserAttributeInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *UserAttributeInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.UserAttributeLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("UserAttributeInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but UserAttributeInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.UserAttributeLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockUserAttributeInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockUserAttributeInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedUserAttributeInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *UserAttributeInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.UserAttributeLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.UserAttributeLifecycle
	}
	lockUserAttributeInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockUserAttributeInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *UserAttributeInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.UserAttributeHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("UserAttributeInterfaceMock.AddClusterScopedHandlerFunc: method is nil but UserAttributeInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.UserAttributeHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockUserAttributeInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockUserAttributeInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedUserAttributeInterface.AddClusterScopedHandlerCalls())
func (mock *UserAttributeInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.UserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.UserAttributeHandlerFunc
	}
	lockUserAttributeInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockUserAttributeInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *UserAttributeInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.UserAttributeLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("UserAttributeInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but UserAttributeInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.UserAttributeLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockUserAttributeInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockUserAttributeInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedUserAttributeInterface.AddClusterScopedLifecycleCalls())
func (mock *UserAttributeInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.UserAttributeLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.UserAttributeLifecycle
	}
	lockUserAttributeInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockUserAttributeInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *UserAttributeInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.UserAttributeHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("UserAttributeInterfaceMock.AddFeatureHandlerFunc: method is nil but UserAttributeInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.UserAttributeHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockUserAttributeInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockUserAttributeInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedUserAttributeInterface.AddFeatureHandlerCalls())
func (mock *UserAttributeInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.UserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.UserAttributeHandlerFunc
	}
	lockUserAttributeInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockUserAttributeInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *UserAttributeInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.UserAttributeLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("UserAttributeInterfaceMock.AddFeatureLifecycleFunc: method is nil but UserAttributeInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.UserAttributeLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockUserAttributeInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockUserAttributeInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedUserAttributeInterface.AddFeatureLifecycleCalls())
func (mock *UserAttributeInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.UserAttributeLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.UserAttributeLifecycle
	}
	lockUserAttributeInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockUserAttributeInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *UserAttributeInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.UserAttributeHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("UserAttributeInterfaceMock.AddHandlerFunc: method is nil but UserAttributeInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.UserAttributeHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockUserAttributeInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockUserAttributeInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedUserAttributeInterface.AddHandlerCalls())
func (mock *UserAttributeInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.UserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.UserAttributeHandlerFunc
	}
	lockUserAttributeInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockUserAttributeInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *UserAttributeInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.UserAttributeLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("UserAttributeInterfaceMock.AddLifecycleFunc: method is nil but UserAttributeInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.UserAttributeLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockUserAttributeInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockUserAttributeInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedUserAttributeInterface.AddLifecycleCalls())
func (mock *UserAttributeInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.UserAttributeLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.UserAttributeLifecycle
	}
	lockUserAttributeInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockUserAttributeInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *UserAttributeInterfaceMock) Controller() v31.UserAttributeController {
	if mock.ControllerFunc == nil {
		panic("UserAttributeInterfaceMock.ControllerFunc: method is nil but UserAttributeInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockUserAttributeInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockUserAttributeInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedUserAttributeInterface.ControllerCalls())
func (mock *UserAttributeInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockUserAttributeInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockUserAttributeInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *UserAttributeInterfaceMock) Create(in1 *v3.UserAttribute) (*v3.UserAttribute, error) {
	if mock.CreateFunc == nil {
		panic("UserAttributeInterfaceMock.CreateFunc: method is nil but UserAttributeInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.UserAttribute
	}{
		In1: in1,
	}
	lockUserAttributeInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockUserAttributeInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedUserAttributeInterface.CreateCalls())
func (mock *UserAttributeInterfaceMock) CreateCalls() []struct {
	In1 *v3.UserAttribute
} {
	var calls []struct {
		In1 *v3.UserAttribute
	}
	lockUserAttributeInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockUserAttributeInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *UserAttributeInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("UserAttributeInterfaceMock.DeleteFunc: method is nil but UserAttributeInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockUserAttributeInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockUserAttributeInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedUserAttributeInterface.DeleteCalls())
func (mock *UserAttributeInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockUserAttributeInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockUserAttributeInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *UserAttributeInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("UserAttributeInterfaceMock.DeleteCollectionFunc: method is nil but UserAttributeInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockUserAttributeInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockUserAttributeInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedUserAttributeInterface.DeleteCollectionCalls())
func (mock *UserAttributeInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockUserAttributeInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockUserAttributeInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *UserAttributeInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("UserAttributeInterfaceMock.DeleteNamespacedFunc: method is nil but UserAttributeInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockUserAttributeInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockUserAttributeInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedUserAttributeInterface.DeleteNamespacedCalls())
func (mock *UserAttributeInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockUserAttributeInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockUserAttributeInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *UserAttributeInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.UserAttribute, error) {
	if mock.GetFunc == nil {
		panic("UserAttributeInterfaceMock.GetFunc: method is nil but UserAttributeInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockUserAttributeInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockUserAttributeInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedUserAttributeInterface.GetCalls())
func (mock *UserAttributeInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockUserAttributeInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockUserAttributeInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *UserAttributeInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.UserAttribute, error) {
	if mock.GetNamespacedFunc == nil {
		panic("UserAttributeInterfaceMock.GetNamespacedFunc: method is nil but UserAttributeInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockUserAttributeInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockUserAttributeInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedUserAttributeInterface.GetNamespacedCalls())
func (mock *UserAttributeInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockUserAttributeInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockUserAttributeInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *UserAttributeInterfaceMock) List(opts metav1.ListOptions) (*v3.UserAttributeList, error) {
	if mock.ListFunc == nil {
		panic("UserAttributeInterfaceMock.ListFunc: method is nil but UserAttributeInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockUserAttributeInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockUserAttributeInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedUserAttributeInterface.ListCalls())
func (mock *UserAttributeInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockUserAttributeInterfaceMockList.RLock()
	calls = mock.calls.List
	lockUserAttributeInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *UserAttributeInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.UserAttributeList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("UserAttributeInterfaceMock.ListNamespacedFunc: method is nil but UserAttributeInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockUserAttributeInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockUserAttributeInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedUserAttributeInterface.ListNamespacedCalls())
func (mock *UserAttributeInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockUserAttributeInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockUserAttributeInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *UserAttributeInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("UserAttributeInterfaceMock.ObjectClientFunc: method is nil but UserAttributeInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockUserAttributeInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockUserAttributeInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedUserAttributeInterface.ObjectClientCalls())
func (mock *UserAttributeInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockUserAttributeInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockUserAttributeInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *UserAttributeInterfaceMock) Update(in1 *v3.UserAttribute) (*v3.UserAttribute, error) {
	if mock.UpdateFunc == nil {
		panic("UserAttributeInterfaceMock.UpdateFunc: method is nil but UserAttributeInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.UserAttribute
	}{
		In1: in1,
	}
	lockUserAttributeInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockUserAttributeInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedUserAttributeInterface.UpdateCalls())
func (mock *UserAttributeInterfaceMock) UpdateCalls() []struct {
	In1 *v3.UserAttribute
} {
	var calls []struct {
		In1 *v3.UserAttribute
	}
	lockUserAttributeInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockUserAttributeInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *UserAttributeInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("UserAttributeInterfaceMock.WatchFunc: method is nil but UserAttributeInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockUserAttributeInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockUserAttributeInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedUserAttributeInterface.WatchCalls())
func (mock *UserAttributeInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockUserAttributeInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockUserAttributeInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockUserAttributesGetterMockUserAttributes sync.RWMutex
)

// Ensure, that UserAttributesGetterMock does implement v31.UserAttributesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.UserAttributesGetter = &UserAttributesGetterMock{}

// UserAttributesGetterMock is a mock implementation of v31.UserAttributesGetter.
//
//	    func TestSomethingThatUsesUserAttributesGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.UserAttributesGetter
//	        mockedUserAttributesGetter := &UserAttributesGetterMock{
//	            UserAttributesFunc: func(namespace string) v31.UserAttributeInterface {
//		               panic("mock out the UserAttributes method")
//	            },
//	        }
//
//	        // use mockedUserAttributesGetter in code that requires v31.UserAttributesGetter
//	        // and then make assertions.
//
//	    }
type UserAttributesGetterMock struct {
	// UserAttributesFunc mocks the UserAttributes method.
	UserAttributesFunc func(namespace string) v31.UserAttributeInterface

	// calls tracks calls to the methods.
	calls struct {
		// UserAttributes holds details about calls to the UserAttributes method.
		UserAttributes []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// UserAttributes calls UserAttributesFunc.
func (mock *UserAttributesGetterMock) UserAttributes(namespace string) v31.UserAttributeInterface {
	if mock.UserAttributesFunc == nil {
		panic("UserAttributesGetterMock.UserAttributesFunc: method is nil but UserAttributesGetter.UserAttributes was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockUserAttributesGetterMockUserAttributes.Lock()
	mock.calls.UserAttributes = append(mock.calls.UserAttributes, callInfo)
	lockUserAttributesGetterMockUserAttributes.Unlock()
	return mock.UserAttributesFunc(namespace)
}

// UserAttributesCalls gets all the calls that were made to UserAttributes.
// Check the length with:
//
//	len(mockedUserAttributesGetter.UserAttributesCalls())
func (mock *UserAttributesGetterMock) UserAttributesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockUserAttributesGetterMockUserAttributes.RLock()
	calls = mock.calls.UserAttributes
	lockUserAttributesGetterMockUserAttributes.RUnlock()
	return calls
}
