// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/networking.k8s.io/v1"
	v1 "k8s.io/api/networking/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockIngressListerMockGet  sync.RWMutex
	lockIngressListerMockList sync.RWMutex
)

// Ensure, that IngressListerMock does implement v11.IngressLister.
// If this is not the case, regenerate this file with moq.
var _ v11.IngressLister = &IngressListerMock{}

// IngressListerMock is a mock implementation of v11.IngressLister.
//
//	    func TestSomethingThatUsesIngressLister(t *testing.T) {
//
//	        // make and configure a mocked v11.IngressLister
//	        mockedIngressLister := &IngressListerMock{
//	            GetFunc: func(namespace string, name string) (*v1.Ingress, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v1.Ingress, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedIngressLister in code that requires v11.IngressLister
//	        // and then make assertions.
//
//	    }
type IngressListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.Ingress, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.Ingress, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *IngressListerMock) Get(namespace string, name string) (*v1.Ingress, error) {
	if mock.GetFunc == nil {
		panic("IngressListerMock.GetFunc: method is nil but IngressLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockIngressListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockIngressListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedIngressLister.GetCalls())
func (mock *IngressListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockIngressListerMockGet.RLock()
	calls = mock.calls.Get
	lockIngressListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *IngressListerMock) List(namespace string, selector labels.Selector) ([]*v1.Ingress, error) {
	if mock.ListFunc == nil {
		panic("IngressListerMock.ListFunc: method is nil but IngressLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockIngressListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockIngressListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedIngressLister.ListCalls())
func (mock *IngressListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockIngressListerMockList.RLock()
	calls = mock.calls.List
	lockIngressListerMockList.RUnlock()
	return calls
}

var (
	lockIngressControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockIngressControllerMockAddClusterScopedHandler        sync.RWMutex
	lockIngressControllerMockAddFeatureHandler              sync.RWMutex
	lockIngressControllerMockAddHandler                     sync.RWMutex
	lockIngressControllerMockEnqueue                        sync.RWMutex
	lockIngressControllerMockEnqueueAfter                   sync.RWMutex
	lockIngressControllerMockGeneric                        sync.RWMutex
	lockIngressControllerMockInformer                       sync.RWMutex
	lockIngressControllerMockLister                         sync.RWMutex
)

// Ensure, that IngressControllerMock does implement v11.IngressController.
// If this is not the case, regenerate this file with moq.
var _ v11.IngressController = &IngressControllerMock{}

// IngressControllerMock is a mock implementation of v11.IngressController.
//
//	    func TestSomethingThatUsesIngressController(t *testing.T) {
//
//	        // make and configure a mocked v11.IngressController
//	        mockedIngressController := &IngressControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.IngressHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.IngressHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.IngressHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v11.IngressHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v11.IngressLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedIngressController in code that requires v11.IngressController
//	        // and then make assertions.
//
//	    }
type IngressControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.IngressHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.IngressHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.IngressHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.IngressHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.IngressLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.IngressHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.IngressHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.IngressHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.IngressHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *IngressControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.IngressHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("IngressControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but IngressController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.IngressHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockIngressControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockIngressControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedIngressController.AddClusterScopedFeatureHandlerCalls())
func (mock *IngressControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.IngressHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.IngressHandlerFunc
	}
	lockIngressControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockIngressControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *IngressControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.IngressHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("IngressControllerMock.AddClusterScopedHandlerFunc: method is nil but IngressController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.IngressHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockIngressControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockIngressControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedIngressController.AddClusterScopedHandlerCalls())
func (mock *IngressControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.IngressHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.IngressHandlerFunc
	}
	lockIngressControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockIngressControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *IngressControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.IngressHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("IngressControllerMock.AddFeatureHandlerFunc: method is nil but IngressController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.IngressHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockIngressControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockIngressControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedIngressController.AddFeatureHandlerCalls())
func (mock *IngressControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.IngressHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.IngressHandlerFunc
	}
	lockIngressControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockIngressControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *IngressControllerMock) AddHandler(ctx context.Context, name string, handler v11.IngressHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("IngressControllerMock.AddHandlerFunc: method is nil but IngressController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.IngressHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockIngressControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockIngressControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedIngressController.AddHandlerCalls())
func (mock *IngressControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.IngressHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.IngressHandlerFunc
	}
	lockIngressControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockIngressControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *IngressControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("IngressControllerMock.EnqueueFunc: method is nil but IngressController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockIngressControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockIngressControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedIngressController.EnqueueCalls())
func (mock *IngressControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockIngressControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockIngressControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *IngressControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("IngressControllerMock.EnqueueAfterFunc: method is nil but IngressController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockIngressControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockIngressControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedIngressController.EnqueueAfterCalls())
func (mock *IngressControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockIngressControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockIngressControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *IngressControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("IngressControllerMock.GenericFunc: method is nil but IngressController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockIngressControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockIngressControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedIngressController.GenericCalls())
func (mock *IngressControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockIngressControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockIngressControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *IngressControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("IngressControllerMock.InformerFunc: method is nil but IngressController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockIngressControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockIngressControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedIngressController.InformerCalls())
func (mock *IngressControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockIngressControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockIngressControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *IngressControllerMock) Lister() v11.IngressLister {
	if mock.ListerFunc == nil {
		panic("IngressControllerMock.ListerFunc: method is nil but IngressController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockIngressControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockIngressControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedIngressController.ListerCalls())
func (mock *IngressControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockIngressControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockIngressControllerMockLister.RUnlock()
	return calls
}

var (
	lockIngressInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockIngressInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockIngressInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockIngressInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockIngressInterfaceMockAddFeatureHandler                sync.RWMutex
	lockIngressInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockIngressInterfaceMockAddHandler                       sync.RWMutex
	lockIngressInterfaceMockAddLifecycle                     sync.RWMutex
	lockIngressInterfaceMockController                       sync.RWMutex
	lockIngressInterfaceMockCreate                           sync.RWMutex
	lockIngressInterfaceMockDelete                           sync.RWMutex
	lockIngressInterfaceMockDeleteCollection                 sync.RWMutex
	lockIngressInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockIngressInterfaceMockGet                              sync.RWMutex
	lockIngressInterfaceMockGetNamespaced                    sync.RWMutex
	lockIngressInterfaceMockList                             sync.RWMutex
	lockIngressInterfaceMockListNamespaced                   sync.RWMutex
	lockIngressInterfaceMockObjectClient                     sync.RWMutex
	lockIngressInterfaceMockUpdate                           sync.RWMutex
	lockIngressInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that IngressInterfaceMock does implement v11.IngressInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.IngressInterface = &IngressInterfaceMock{}

// IngressInterfaceMock is a mock implementation of v11.IngressInterface.
//
//	    func TestSomethingThatUsesIngressInterface(t *testing.T) {
//
//	        // make and configure a mocked v11.IngressInterface
//	        mockedIngressInterface := &IngressInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.IngressHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.IngressLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.IngressHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.IngressLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.IngressHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.IngressLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.IngressHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.IngressLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v11.IngressController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v1.Ingress) (*v1.Ingress, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v1.Ingress, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.Ingress, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v1.IngressList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.IngressList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v1.Ingress) (*v1.Ingress, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedIngressInterface in code that requires v11.IngressInterface
//	        // and then make assertions.
//
//	    }
type IngressInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.IngressHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.IngressLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.IngressHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.IngressLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.IngressHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.IngressLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.IngressHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.IngressLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.IngressController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.Ingress) (*v1.Ingress, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.Ingress, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.Ingress, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.IngressList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.IngressList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.Ingress) (*v1.Ingress, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.IngressHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.IngressLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.IngressHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.IngressLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.IngressHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.IngressLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.IngressHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.IngressLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.Ingress
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.Ingress
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *IngressInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.IngressHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("IngressInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but IngressInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.IngressHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockIngressInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockIngressInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedIngressInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *IngressInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.IngressHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.IngressHandlerFunc
	}
	lockIngressInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockIngressInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *IngressInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.IngressLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("IngressInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but IngressInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.IngressLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockIngressInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockIngressInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedIngressInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *IngressInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.IngressLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.IngressLifecycle
	}
	lockIngressInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockIngressInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *IngressInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.IngressHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("IngressInterfaceMock.AddClusterScopedHandlerFunc: method is nil but IngressInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.IngressHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockIngressInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockIngressInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedIngressInterface.AddClusterScopedHandlerCalls())
func (mock *IngressInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.IngressHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.IngressHandlerFunc
	}
	lockIngressInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockIngressInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *IngressInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.IngressLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("IngressInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but IngressInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.IngressLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockIngressInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockIngressInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedIngressInterface.AddClusterScopedLifecycleCalls())
func (mock *IngressInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.IngressLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.IngressLifecycle
	}
	lockIngressInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockIngressInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *IngressInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.IngressHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("IngressInterfaceMock.AddFeatureHandlerFunc: method is nil but IngressInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.IngressHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockIngressInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockIngressInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedIngressInterface.AddFeatureHandlerCalls())
func (mock *IngressInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.IngressHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.IngressHandlerFunc
	}
	lockIngressInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockIngressInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *IngressInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.IngressLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("IngressInterfaceMock.AddFeatureLifecycleFunc: method is nil but IngressInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.IngressLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockIngressInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockIngressInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedIngressInterface.AddFeatureLifecycleCalls())
func (mock *IngressInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.IngressLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.IngressLifecycle
	}
	lockIngressInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockIngressInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *IngressInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.IngressHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("IngressInterfaceMock.AddHandlerFunc: method is nil but IngressInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.IngressHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockIngressInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockIngressInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedIngressInterface.AddHandlerCalls())
func (mock *IngressInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.IngressHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.IngressHandlerFunc
	}
	lockIngressInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockIngressInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *IngressInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.IngressLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("IngressInterfaceMock.AddLifecycleFunc: method is nil but IngressInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.IngressLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockIngressInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockIngressInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedIngressInterface.AddLifecycleCalls())
func (mock *IngressInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.IngressLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.IngressLifecycle
	}
	lockIngressInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockIngressInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *IngressInterfaceMock) Controller() v11.IngressController {
	if mock.ControllerFunc == nil {
		panic("IngressInterfaceMock.ControllerFunc: method is nil but IngressInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockIngressInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockIngressInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedIngressInterface.ControllerCalls())
func (mock *IngressInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockIngressInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockIngressInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *IngressInterfaceMock) Create(in1 *v1.Ingress) (*v1.Ingress, error) {
	if mock.CreateFunc == nil {
		panic("IngressInterfaceMock.CreateFunc: method is nil but IngressInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.Ingress
	}{
		In1: in1,
	}
	lockIngressInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockIngressInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedIngressInterface.CreateCalls())
func (mock *IngressInterfaceMock) CreateCalls() []struct {
	In1 *v1.Ingress
} {
	var calls []struct {
		In1 *v1.Ingress
	}
	lockIngressInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockIngressInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *IngressInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("IngressInterfaceMock.DeleteFunc: method is nil but IngressInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockIngressInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockIngressInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedIngressInterface.DeleteCalls())
func (mock *IngressInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockIngressInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockIngressInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *IngressInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("IngressInterfaceMock.DeleteCollectionFunc: method is nil but IngressInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockIngressInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockIngressInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedIngressInterface.DeleteCollectionCalls())
func (mock *IngressInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockIngressInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockIngressInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *IngressInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("IngressInterfaceMock.DeleteNamespacedFunc: method is nil but IngressInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockIngressInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockIngressInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedIngressInterface.DeleteNamespacedCalls())
func (mock *IngressInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockIngressInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockIngressInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *IngressInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.Ingress, error) {
	if mock.GetFunc == nil {
		panic("IngressInterfaceMock.GetFunc: method is nil but IngressInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockIngressInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockIngressInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedIngressInterface.GetCalls())
func (mock *IngressInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockIngressInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockIngressInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *IngressInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.Ingress, error) {
	if mock.GetNamespacedFunc == nil {
		panic("IngressInterfaceMock.GetNamespacedFunc: method is nil but IngressInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockIngressInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockIngressInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedIngressInterface.GetNamespacedCalls())
func (mock *IngressInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockIngressInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockIngressInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *IngressInterfaceMock) List(opts metav1.ListOptions) (*v1.IngressList, error) {
	if mock.ListFunc == nil {
		panic("IngressInterfaceMock.ListFunc: method is nil but IngressInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockIngressInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockIngressInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedIngressInterface.ListCalls())
func (mock *IngressInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockIngressInterfaceMockList.RLock()
	calls = mock.calls.List
	lockIngressInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *IngressInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.IngressList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("IngressInterfaceMock.ListNamespacedFunc: method is nil but IngressInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockIngressInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockIngressInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedIngressInterface.ListNamespacedCalls())
func (mock *IngressInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockIngressInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockIngressInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *IngressInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("IngressInterfaceMock.ObjectClientFunc: method is nil but IngressInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockIngressInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockIngressInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedIngressInterface.ObjectClientCalls())
func (mock *IngressInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockIngressInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockIngressInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *IngressInterfaceMock) Update(in1 *v1.Ingress) (*v1.Ingress, error) {
	if mock.UpdateFunc == nil {
		panic("IngressInterfaceMock.UpdateFunc: method is nil but IngressInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.Ingress
	}{
		In1: in1,
	}
	lockIngressInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockIngressInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedIngressInterface.UpdateCalls())
func (mock *IngressInterfaceMock) UpdateCalls() []struct {
	In1 *v1.Ingress
} {
	var calls []struct {
		In1 *v1.Ingress
	}
	lockIngressInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockIngressInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *IngressInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("IngressInterfaceMock.WatchFunc: method is nil but IngressInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockIngressInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockIngressInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedIngressInterface.WatchCalls())
func (mock *IngressInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockIngressInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockIngressInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockIngressesGetterMockIngresses sync.RWMutex
)

// Ensure, that IngressesGetterMock does implement v11.IngressesGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.IngressesGetter = &IngressesGetterMock{}

// IngressesGetterMock is a mock implementation of v11.IngressesGetter.
//
//	    func TestSomethingThatUsesIngressesGetter(t *testing.T) {
//
//	        // make and configure a mocked v11.IngressesGetter
//	        mockedIngressesGetter := &IngressesGetterMock{
//	            IngressesFunc: func(namespace string) v11.IngressInterface {
//		               panic("mock out the Ingresses method")
//	            },
//	        }
//
//	        // use mockedIngressesGetter in code that requires v11.IngressesGetter
//	        // and then make assertions.
//
//	    }
type IngressesGetterMock struct {
	// IngressesFunc mocks the Ingresses method.
	IngressesFunc func(namespace string) v11.IngressInterface

	// calls tracks calls to the methods.
	calls struct {
		// Ingresses holds details about calls to the Ingresses method.
		Ingresses []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Ingresses calls IngressesFunc.
func (mock *IngressesGetterMock) Ingresses(namespace string) v11.IngressInterface {
	if mock.IngressesFunc == nil {
		panic("IngressesGetterMock.IngressesFunc: method is nil but IngressesGetter.Ingresses was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockIngressesGetterMockIngresses.Lock()
	mock.calls.Ingresses = append(mock.calls.Ingresses, callInfo)
	lockIngressesGetterMockIngresses.Unlock()
	return mock.IngressesFunc(namespace)
}

// IngressesCalls gets all the calls that were made to Ingresses.
// Check the length with:
//
//	len(mockedIngressesGetter.IngressesCalls())
func (mock *IngressesGetterMock) IngressesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockIngressesGetterMockIngresses.RLock()
	calls = mock.calls.Ingresses
	lockIngressesGetterMockIngresses.RUnlock()
	return calls
}
