// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockBasicAuthListerMockGet  sync.RWMutex
	lockBasicAuthListerMockList sync.RWMutex
)

// Ensure, that BasicAuthListerMock does implement v31.BasicAuthLister.
// If this is not the case, regenerate this file with moq.
var _ v31.BasicAuthLister = &BasicAuthListerMock{}

// BasicAuthListerMock is a mock implementation of v31.BasicAuthLister.
//
//	    func TestSomethingThatUsesBasicAuthLister(t *testing.T) {
//
//	        // make and configure a mocked v31.BasicAuthLister
//	        mockedBasicAuthLister := &BasicAuthListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.BasicAuth, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.BasicAuth, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedBasicAuthLister in code that requires v31.BasicAuthLister
//	        // and then make assertions.
//
//	    }
type BasicAuthListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.BasicAuth, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.BasicAuth, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *BasicAuthListerMock) Get(namespace string, name string) (*v3.BasicAuth, error) {
	if mock.GetFunc == nil {
		panic("BasicAuthListerMock.GetFunc: method is nil but BasicAuthLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockBasicAuthListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockBasicAuthListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedBasicAuthLister.GetCalls())
func (mock *BasicAuthListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockBasicAuthListerMockGet.RLock()
	calls = mock.calls.Get
	lockBasicAuthListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *BasicAuthListerMock) List(namespace string, selector labels.Selector) ([]*v3.BasicAuth, error) {
	if mock.ListFunc == nil {
		panic("BasicAuthListerMock.ListFunc: method is nil but BasicAuthLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockBasicAuthListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockBasicAuthListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedBasicAuthLister.ListCalls())
func (mock *BasicAuthListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockBasicAuthListerMockList.RLock()
	calls = mock.calls.List
	lockBasicAuthListerMockList.RUnlock()
	return calls
}

var (
	lockBasicAuthControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockBasicAuthControllerMockAddClusterScopedHandler        sync.RWMutex
	lockBasicAuthControllerMockAddFeatureHandler              sync.RWMutex
	lockBasicAuthControllerMockAddHandler                     sync.RWMutex
	lockBasicAuthControllerMockEnqueue                        sync.RWMutex
	lockBasicAuthControllerMockEnqueueAfter                   sync.RWMutex
	lockBasicAuthControllerMockGeneric                        sync.RWMutex
	lockBasicAuthControllerMockInformer                       sync.RWMutex
	lockBasicAuthControllerMockLister                         sync.RWMutex
)

// Ensure, that BasicAuthControllerMock does implement v31.BasicAuthController.
// If this is not the case, regenerate this file with moq.
var _ v31.BasicAuthController = &BasicAuthControllerMock{}

// BasicAuthControllerMock is a mock implementation of v31.BasicAuthController.
//
//	    func TestSomethingThatUsesBasicAuthController(t *testing.T) {
//
//	        // make and configure a mocked v31.BasicAuthController
//	        mockedBasicAuthController := &BasicAuthControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.BasicAuthHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.BasicAuthHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.BasicAuthHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.BasicAuthHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.BasicAuthLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedBasicAuthController in code that requires v31.BasicAuthController
//	        // and then make assertions.
//
//	    }
type BasicAuthControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.BasicAuthHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.BasicAuthHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.BasicAuthHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.BasicAuthHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.BasicAuthLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.BasicAuthHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.BasicAuthHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.BasicAuthHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.BasicAuthHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *BasicAuthControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.BasicAuthHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("BasicAuthControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but BasicAuthController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.BasicAuthHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockBasicAuthControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockBasicAuthControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedBasicAuthController.AddClusterScopedFeatureHandlerCalls())
func (mock *BasicAuthControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.BasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.BasicAuthHandlerFunc
	}
	lockBasicAuthControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockBasicAuthControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *BasicAuthControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.BasicAuthHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("BasicAuthControllerMock.AddClusterScopedHandlerFunc: method is nil but BasicAuthController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.BasicAuthHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockBasicAuthControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockBasicAuthControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedBasicAuthController.AddClusterScopedHandlerCalls())
func (mock *BasicAuthControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.BasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.BasicAuthHandlerFunc
	}
	lockBasicAuthControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockBasicAuthControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *BasicAuthControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.BasicAuthHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("BasicAuthControllerMock.AddFeatureHandlerFunc: method is nil but BasicAuthController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.BasicAuthHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockBasicAuthControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockBasicAuthControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedBasicAuthController.AddFeatureHandlerCalls())
func (mock *BasicAuthControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.BasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.BasicAuthHandlerFunc
	}
	lockBasicAuthControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockBasicAuthControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *BasicAuthControllerMock) AddHandler(ctx context.Context, name string, handler v31.BasicAuthHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("BasicAuthControllerMock.AddHandlerFunc: method is nil but BasicAuthController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.BasicAuthHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockBasicAuthControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockBasicAuthControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedBasicAuthController.AddHandlerCalls())
func (mock *BasicAuthControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.BasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.BasicAuthHandlerFunc
	}
	lockBasicAuthControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockBasicAuthControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *BasicAuthControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("BasicAuthControllerMock.EnqueueFunc: method is nil but BasicAuthController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockBasicAuthControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockBasicAuthControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedBasicAuthController.EnqueueCalls())
func (mock *BasicAuthControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockBasicAuthControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockBasicAuthControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *BasicAuthControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("BasicAuthControllerMock.EnqueueAfterFunc: method is nil but BasicAuthController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockBasicAuthControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockBasicAuthControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedBasicAuthController.EnqueueAfterCalls())
func (mock *BasicAuthControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockBasicAuthControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockBasicAuthControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *BasicAuthControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("BasicAuthControllerMock.GenericFunc: method is nil but BasicAuthController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockBasicAuthControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockBasicAuthControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedBasicAuthController.GenericCalls())
func (mock *BasicAuthControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockBasicAuthControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockBasicAuthControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *BasicAuthControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("BasicAuthControllerMock.InformerFunc: method is nil but BasicAuthController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockBasicAuthControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockBasicAuthControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedBasicAuthController.InformerCalls())
func (mock *BasicAuthControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockBasicAuthControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockBasicAuthControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *BasicAuthControllerMock) Lister() v31.BasicAuthLister {
	if mock.ListerFunc == nil {
		panic("BasicAuthControllerMock.ListerFunc: method is nil but BasicAuthController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockBasicAuthControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockBasicAuthControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedBasicAuthController.ListerCalls())
func (mock *BasicAuthControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockBasicAuthControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockBasicAuthControllerMockLister.RUnlock()
	return calls
}

var (
	lockBasicAuthInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockBasicAuthInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockBasicAuthInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockBasicAuthInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockBasicAuthInterfaceMockAddFeatureHandler                sync.RWMutex
	lockBasicAuthInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockBasicAuthInterfaceMockAddHandler                       sync.RWMutex
	lockBasicAuthInterfaceMockAddLifecycle                     sync.RWMutex
	lockBasicAuthInterfaceMockController                       sync.RWMutex
	lockBasicAuthInterfaceMockCreate                           sync.RWMutex
	lockBasicAuthInterfaceMockDelete                           sync.RWMutex
	lockBasicAuthInterfaceMockDeleteCollection                 sync.RWMutex
	lockBasicAuthInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockBasicAuthInterfaceMockGet                              sync.RWMutex
	lockBasicAuthInterfaceMockGetNamespaced                    sync.RWMutex
	lockBasicAuthInterfaceMockList                             sync.RWMutex
	lockBasicAuthInterfaceMockListNamespaced                   sync.RWMutex
	lockBasicAuthInterfaceMockObjectClient                     sync.RWMutex
	lockBasicAuthInterfaceMockUpdate                           sync.RWMutex
	lockBasicAuthInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that BasicAuthInterfaceMock does implement v31.BasicAuthInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.BasicAuthInterface = &BasicAuthInterfaceMock{}

// BasicAuthInterfaceMock is a mock implementation of v31.BasicAuthInterface.
//
//	    func TestSomethingThatUsesBasicAuthInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.BasicAuthInterface
//	        mockedBasicAuthInterface := &BasicAuthInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.BasicAuthHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.BasicAuthLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.BasicAuthHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.BasicAuthLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.BasicAuthHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.BasicAuthLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.BasicAuthHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.BasicAuthLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.BasicAuthController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.BasicAuth) (*v3.BasicAuth, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.BasicAuth, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.BasicAuth, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.BasicAuthList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.BasicAuthList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.BasicAuth) (*v3.BasicAuth, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedBasicAuthInterface in code that requires v31.BasicAuthInterface
//	        // and then make assertions.
//
//	    }
type BasicAuthInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.BasicAuthHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.BasicAuthLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.BasicAuthHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.BasicAuthLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.BasicAuthHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.BasicAuthLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.BasicAuthHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.BasicAuthLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.BasicAuthController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.BasicAuth) (*v3.BasicAuth, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.BasicAuth, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.BasicAuth, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.BasicAuthList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.BasicAuthList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.BasicAuth) (*v3.BasicAuth, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.BasicAuthHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.BasicAuthLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.BasicAuthHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.BasicAuthLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.BasicAuthHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.BasicAuthLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.BasicAuthHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.BasicAuthLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.BasicAuth
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.BasicAuth
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *BasicAuthInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.BasicAuthHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("BasicAuthInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but BasicAuthInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.BasicAuthHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockBasicAuthInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockBasicAuthInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedBasicAuthInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *BasicAuthInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.BasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.BasicAuthHandlerFunc
	}
	lockBasicAuthInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockBasicAuthInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *BasicAuthInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.BasicAuthLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("BasicAuthInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but BasicAuthInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.BasicAuthLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockBasicAuthInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockBasicAuthInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedBasicAuthInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *BasicAuthInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.BasicAuthLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.BasicAuthLifecycle
	}
	lockBasicAuthInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockBasicAuthInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *BasicAuthInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.BasicAuthHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("BasicAuthInterfaceMock.AddClusterScopedHandlerFunc: method is nil but BasicAuthInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.BasicAuthHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockBasicAuthInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockBasicAuthInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedBasicAuthInterface.AddClusterScopedHandlerCalls())
func (mock *BasicAuthInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.BasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.BasicAuthHandlerFunc
	}
	lockBasicAuthInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockBasicAuthInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *BasicAuthInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.BasicAuthLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("BasicAuthInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but BasicAuthInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.BasicAuthLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockBasicAuthInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockBasicAuthInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedBasicAuthInterface.AddClusterScopedLifecycleCalls())
func (mock *BasicAuthInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.BasicAuthLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.BasicAuthLifecycle
	}
	lockBasicAuthInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockBasicAuthInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *BasicAuthInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.BasicAuthHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("BasicAuthInterfaceMock.AddFeatureHandlerFunc: method is nil but BasicAuthInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.BasicAuthHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockBasicAuthInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockBasicAuthInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedBasicAuthInterface.AddFeatureHandlerCalls())
func (mock *BasicAuthInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.BasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.BasicAuthHandlerFunc
	}
	lockBasicAuthInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockBasicAuthInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *BasicAuthInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.BasicAuthLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("BasicAuthInterfaceMock.AddFeatureLifecycleFunc: method is nil but BasicAuthInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.BasicAuthLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockBasicAuthInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockBasicAuthInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedBasicAuthInterface.AddFeatureLifecycleCalls())
func (mock *BasicAuthInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.BasicAuthLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.BasicAuthLifecycle
	}
	lockBasicAuthInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockBasicAuthInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *BasicAuthInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.BasicAuthHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("BasicAuthInterfaceMock.AddHandlerFunc: method is nil but BasicAuthInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.BasicAuthHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockBasicAuthInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockBasicAuthInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedBasicAuthInterface.AddHandlerCalls())
func (mock *BasicAuthInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.BasicAuthHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.BasicAuthHandlerFunc
	}
	lockBasicAuthInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockBasicAuthInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *BasicAuthInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.BasicAuthLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("BasicAuthInterfaceMock.AddLifecycleFunc: method is nil but BasicAuthInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.BasicAuthLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockBasicAuthInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockBasicAuthInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedBasicAuthInterface.AddLifecycleCalls())
func (mock *BasicAuthInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.BasicAuthLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.BasicAuthLifecycle
	}
	lockBasicAuthInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockBasicAuthInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *BasicAuthInterfaceMock) Controller() v31.BasicAuthController {
	if mock.ControllerFunc == nil {
		panic("BasicAuthInterfaceMock.ControllerFunc: method is nil but BasicAuthInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockBasicAuthInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockBasicAuthInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedBasicAuthInterface.ControllerCalls())
func (mock *BasicAuthInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockBasicAuthInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockBasicAuthInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *BasicAuthInterfaceMock) Create(in1 *v3.BasicAuth) (*v3.BasicAuth, error) {
	if mock.CreateFunc == nil {
		panic("BasicAuthInterfaceMock.CreateFunc: method is nil but BasicAuthInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.BasicAuth
	}{
		In1: in1,
	}
	lockBasicAuthInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockBasicAuthInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedBasicAuthInterface.CreateCalls())
func (mock *BasicAuthInterfaceMock) CreateCalls() []struct {
	In1 *v3.BasicAuth
} {
	var calls []struct {
		In1 *v3.BasicAuth
	}
	lockBasicAuthInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockBasicAuthInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *BasicAuthInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("BasicAuthInterfaceMock.DeleteFunc: method is nil but BasicAuthInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockBasicAuthInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockBasicAuthInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedBasicAuthInterface.DeleteCalls())
func (mock *BasicAuthInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockBasicAuthInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockBasicAuthInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *BasicAuthInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("BasicAuthInterfaceMock.DeleteCollectionFunc: method is nil but BasicAuthInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockBasicAuthInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockBasicAuthInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedBasicAuthInterface.DeleteCollectionCalls())
func (mock *BasicAuthInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockBasicAuthInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockBasicAuthInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *BasicAuthInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("BasicAuthInterfaceMock.DeleteNamespacedFunc: method is nil but BasicAuthInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockBasicAuthInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockBasicAuthInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedBasicAuthInterface.DeleteNamespacedCalls())
func (mock *BasicAuthInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockBasicAuthInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockBasicAuthInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *BasicAuthInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.BasicAuth, error) {
	if mock.GetFunc == nil {
		panic("BasicAuthInterfaceMock.GetFunc: method is nil but BasicAuthInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockBasicAuthInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockBasicAuthInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedBasicAuthInterface.GetCalls())
func (mock *BasicAuthInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockBasicAuthInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockBasicAuthInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *BasicAuthInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.BasicAuth, error) {
	if mock.GetNamespacedFunc == nil {
		panic("BasicAuthInterfaceMock.GetNamespacedFunc: method is nil but BasicAuthInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockBasicAuthInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockBasicAuthInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedBasicAuthInterface.GetNamespacedCalls())
func (mock *BasicAuthInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockBasicAuthInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockBasicAuthInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *BasicAuthInterfaceMock) List(opts metav1.ListOptions) (*v3.BasicAuthList, error) {
	if mock.ListFunc == nil {
		panic("BasicAuthInterfaceMock.ListFunc: method is nil but BasicAuthInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockBasicAuthInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockBasicAuthInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedBasicAuthInterface.ListCalls())
func (mock *BasicAuthInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockBasicAuthInterfaceMockList.RLock()
	calls = mock.calls.List
	lockBasicAuthInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *BasicAuthInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.BasicAuthList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("BasicAuthInterfaceMock.ListNamespacedFunc: method is nil but BasicAuthInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockBasicAuthInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockBasicAuthInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedBasicAuthInterface.ListNamespacedCalls())
func (mock *BasicAuthInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockBasicAuthInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockBasicAuthInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *BasicAuthInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("BasicAuthInterfaceMock.ObjectClientFunc: method is nil but BasicAuthInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockBasicAuthInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockBasicAuthInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedBasicAuthInterface.ObjectClientCalls())
func (mock *BasicAuthInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockBasicAuthInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockBasicAuthInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *BasicAuthInterfaceMock) Update(in1 *v3.BasicAuth) (*v3.BasicAuth, error) {
	if mock.UpdateFunc == nil {
		panic("BasicAuthInterfaceMock.UpdateFunc: method is nil but BasicAuthInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.BasicAuth
	}{
		In1: in1,
	}
	lockBasicAuthInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockBasicAuthInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedBasicAuthInterface.UpdateCalls())
func (mock *BasicAuthInterfaceMock) UpdateCalls() []struct {
	In1 *v3.BasicAuth
} {
	var calls []struct {
		In1 *v3.BasicAuth
	}
	lockBasicAuthInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockBasicAuthInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *BasicAuthInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("BasicAuthInterfaceMock.WatchFunc: method is nil but BasicAuthInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockBasicAuthInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockBasicAuthInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedBasicAuthInterface.WatchCalls())
func (mock *BasicAuthInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockBasicAuthInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockBasicAuthInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockBasicAuthsGetterMockBasicAuths sync.RWMutex
)

// Ensure, that BasicAuthsGetterMock does implement v31.BasicAuthsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.BasicAuthsGetter = &BasicAuthsGetterMock{}

// BasicAuthsGetterMock is a mock implementation of v31.BasicAuthsGetter.
//
//	    func TestSomethingThatUsesBasicAuthsGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.BasicAuthsGetter
//	        mockedBasicAuthsGetter := &BasicAuthsGetterMock{
//	            BasicAuthsFunc: func(namespace string) v31.BasicAuthInterface {
//		               panic("mock out the BasicAuths method")
//	            },
//	        }
//
//	        // use mockedBasicAuthsGetter in code that requires v31.BasicAuthsGetter
//	        // and then make assertions.
//
//	    }
type BasicAuthsGetterMock struct {
	// BasicAuthsFunc mocks the BasicAuths method.
	BasicAuthsFunc func(namespace string) v31.BasicAuthInterface

	// calls tracks calls to the methods.
	calls struct {
		// BasicAuths holds details about calls to the BasicAuths method.
		BasicAuths []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// BasicAuths calls BasicAuthsFunc.
func (mock *BasicAuthsGetterMock) BasicAuths(namespace string) v31.BasicAuthInterface {
	if mock.BasicAuthsFunc == nil {
		panic("BasicAuthsGetterMock.BasicAuthsFunc: method is nil but BasicAuthsGetter.BasicAuths was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockBasicAuthsGetterMockBasicAuths.Lock()
	mock.calls.BasicAuths = append(mock.calls.BasicAuths, callInfo)
	lockBasicAuthsGetterMockBasicAuths.Unlock()
	return mock.BasicAuthsFunc(namespace)
}

// BasicAuthsCalls gets all the calls that were made to BasicAuths.
// Check the length with:
//
//	len(mockedBasicAuthsGetter.BasicAuthsCalls())
func (mock *BasicAuthsGetterMock) BasicAuthsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockBasicAuthsGetterMockBasicAuths.RLock()
	calls = mock.calls.BasicAuths
	lockBasicAuthsGetterMockBasicAuths.RUnlock()
	return calls
}
