// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockNamespacedCertificateListerMockGet  sync.RWMutex
	lockNamespacedCertificateListerMockList sync.RWMutex
)

// Ensure, that NamespacedCertificateListerMock does implement v31.NamespacedCertificateLister.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedCertificateLister = &NamespacedCertificateListerMock{}

// NamespacedCertificateListerMock is a mock implementation of v31.NamespacedCertificateLister.
//
//	    func TestSomethingThatUsesNamespacedCertificateLister(t *testing.T) {
//
//	        // make and configure a mocked v31.NamespacedCertificateLister
//	        mockedNamespacedCertificateLister := &NamespacedCertificateListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.NamespacedCertificate, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.NamespacedCertificate, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedNamespacedCertificateLister in code that requires v31.NamespacedCertificateLister
//	        // and then make assertions.
//
//	    }
type NamespacedCertificateListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.NamespacedCertificate, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.NamespacedCertificate, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *NamespacedCertificateListerMock) Get(namespace string, name string) (*v3.NamespacedCertificate, error) {
	if mock.GetFunc == nil {
		panic("NamespacedCertificateListerMock.GetFunc: method is nil but NamespacedCertificateLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNamespacedCertificateListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNamespacedCertificateListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedNamespacedCertificateLister.GetCalls())
func (mock *NamespacedCertificateListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNamespacedCertificateListerMockGet.RLock()
	calls = mock.calls.Get
	lockNamespacedCertificateListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NamespacedCertificateListerMock) List(namespace string, selector labels.Selector) ([]*v3.NamespacedCertificate, error) {
	if mock.ListFunc == nil {
		panic("NamespacedCertificateListerMock.ListFunc: method is nil but NamespacedCertificateLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockNamespacedCertificateListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNamespacedCertificateListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedNamespacedCertificateLister.ListCalls())
func (mock *NamespacedCertificateListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockNamespacedCertificateListerMockList.RLock()
	calls = mock.calls.List
	lockNamespacedCertificateListerMockList.RUnlock()
	return calls
}

var (
	lockNamespacedCertificateControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockNamespacedCertificateControllerMockAddClusterScopedHandler        sync.RWMutex
	lockNamespacedCertificateControllerMockAddFeatureHandler              sync.RWMutex
	lockNamespacedCertificateControllerMockAddHandler                     sync.RWMutex
	lockNamespacedCertificateControllerMockEnqueue                        sync.RWMutex
	lockNamespacedCertificateControllerMockEnqueueAfter                   sync.RWMutex
	lockNamespacedCertificateControllerMockGeneric                        sync.RWMutex
	lockNamespacedCertificateControllerMockInformer                       sync.RWMutex
	lockNamespacedCertificateControllerMockLister                         sync.RWMutex
)

// Ensure, that NamespacedCertificateControllerMock does implement v31.NamespacedCertificateController.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedCertificateController = &NamespacedCertificateControllerMock{}

// NamespacedCertificateControllerMock is a mock implementation of v31.NamespacedCertificateController.
//
//	    func TestSomethingThatUsesNamespacedCertificateController(t *testing.T) {
//
//	        // make and configure a mocked v31.NamespacedCertificateController
//	        mockedNamespacedCertificateController := &NamespacedCertificateControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedCertificateHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.NamespacedCertificateHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedCertificateHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.NamespacedCertificateHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.NamespacedCertificateLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedNamespacedCertificateController in code that requires v31.NamespacedCertificateController
//	        // and then make assertions.
//
//	    }
type NamespacedCertificateControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedCertificateHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.NamespacedCertificateHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedCertificateHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.NamespacedCertificateHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.NamespacedCertificateLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NamespacedCertificateHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NamespacedCertificateHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedCertificateHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.NamespacedCertificateHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NamespacedCertificateControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedCertificateHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NamespacedCertificateControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but NamespacedCertificateController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NamespacedCertificateHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNamespacedCertificateControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNamespacedCertificateControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedNamespacedCertificateController.AddClusterScopedFeatureHandlerCalls())
func (mock *NamespacedCertificateControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.NamespacedCertificateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NamespacedCertificateHandlerFunc
	}
	lockNamespacedCertificateControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNamespacedCertificateControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NamespacedCertificateControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.NamespacedCertificateHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NamespacedCertificateControllerMock.AddClusterScopedHandlerFunc: method is nil but NamespacedCertificateController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NamespacedCertificateHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNamespacedCertificateControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNamespacedCertificateControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedNamespacedCertificateController.AddClusterScopedHandlerCalls())
func (mock *NamespacedCertificateControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.NamespacedCertificateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NamespacedCertificateHandlerFunc
	}
	lockNamespacedCertificateControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNamespacedCertificateControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NamespacedCertificateControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedCertificateHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NamespacedCertificateControllerMock.AddFeatureHandlerFunc: method is nil but NamespacedCertificateController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedCertificateHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNamespacedCertificateControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNamespacedCertificateControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedNamespacedCertificateController.AddFeatureHandlerCalls())
func (mock *NamespacedCertificateControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NamespacedCertificateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedCertificateHandlerFunc
	}
	lockNamespacedCertificateControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNamespacedCertificateControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NamespacedCertificateControllerMock) AddHandler(ctx context.Context, name string, handler v31.NamespacedCertificateHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NamespacedCertificateControllerMock.AddHandlerFunc: method is nil but NamespacedCertificateController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.NamespacedCertificateHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockNamespacedCertificateControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNamespacedCertificateControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedNamespacedCertificateController.AddHandlerCalls())
func (mock *NamespacedCertificateControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.NamespacedCertificateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.NamespacedCertificateHandlerFunc
	}
	lockNamespacedCertificateControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNamespacedCertificateControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *NamespacedCertificateControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("NamespacedCertificateControllerMock.EnqueueFunc: method is nil but NamespacedCertificateController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNamespacedCertificateControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockNamespacedCertificateControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedNamespacedCertificateController.EnqueueCalls())
func (mock *NamespacedCertificateControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNamespacedCertificateControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockNamespacedCertificateControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *NamespacedCertificateControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("NamespacedCertificateControllerMock.EnqueueAfterFunc: method is nil but NamespacedCertificateController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockNamespacedCertificateControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockNamespacedCertificateControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedNamespacedCertificateController.EnqueueAfterCalls())
func (mock *NamespacedCertificateControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockNamespacedCertificateControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockNamespacedCertificateControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *NamespacedCertificateControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("NamespacedCertificateControllerMock.GenericFunc: method is nil but NamespacedCertificateController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedCertificateControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockNamespacedCertificateControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedNamespacedCertificateController.GenericCalls())
func (mock *NamespacedCertificateControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedCertificateControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockNamespacedCertificateControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *NamespacedCertificateControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("NamespacedCertificateControllerMock.InformerFunc: method is nil but NamespacedCertificateController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedCertificateControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockNamespacedCertificateControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedNamespacedCertificateController.InformerCalls())
func (mock *NamespacedCertificateControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedCertificateControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockNamespacedCertificateControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *NamespacedCertificateControllerMock) Lister() v31.NamespacedCertificateLister {
	if mock.ListerFunc == nil {
		panic("NamespacedCertificateControllerMock.ListerFunc: method is nil but NamespacedCertificateController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedCertificateControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockNamespacedCertificateControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedNamespacedCertificateController.ListerCalls())
func (mock *NamespacedCertificateControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedCertificateControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockNamespacedCertificateControllerMockLister.RUnlock()
	return calls
}

var (
	lockNamespacedCertificateInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockNamespacedCertificateInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockNamespacedCertificateInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockNamespacedCertificateInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockNamespacedCertificateInterfaceMockAddFeatureHandler                sync.RWMutex
	lockNamespacedCertificateInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockNamespacedCertificateInterfaceMockAddHandler                       sync.RWMutex
	lockNamespacedCertificateInterfaceMockAddLifecycle                     sync.RWMutex
	lockNamespacedCertificateInterfaceMockController                       sync.RWMutex
	lockNamespacedCertificateInterfaceMockCreate                           sync.RWMutex
	lockNamespacedCertificateInterfaceMockDelete                           sync.RWMutex
	lockNamespacedCertificateInterfaceMockDeleteCollection                 sync.RWMutex
	lockNamespacedCertificateInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockNamespacedCertificateInterfaceMockGet                              sync.RWMutex
	lockNamespacedCertificateInterfaceMockGetNamespaced                    sync.RWMutex
	lockNamespacedCertificateInterfaceMockList                             sync.RWMutex
	lockNamespacedCertificateInterfaceMockListNamespaced                   sync.RWMutex
	lockNamespacedCertificateInterfaceMockObjectClient                     sync.RWMutex
	lockNamespacedCertificateInterfaceMockUpdate                           sync.RWMutex
	lockNamespacedCertificateInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that NamespacedCertificateInterfaceMock does implement v31.NamespacedCertificateInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedCertificateInterface = &NamespacedCertificateInterfaceMock{}

// NamespacedCertificateInterfaceMock is a mock implementation of v31.NamespacedCertificateInterface.
//
//	    func TestSomethingThatUsesNamespacedCertificateInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.NamespacedCertificateInterface
//	        mockedNamespacedCertificateInterface := &NamespacedCertificateInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedCertificateHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedCertificateLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedCertificateHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedCertificateLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedCertificateHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedCertificateLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.NamespacedCertificateHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.NamespacedCertificateLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.NamespacedCertificateController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.NamespacedCertificate) (*v3.NamespacedCertificate, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.NamespacedCertificate, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedCertificate, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.NamespacedCertificateList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.NamespacedCertificateList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.NamespacedCertificate) (*v3.NamespacedCertificate, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedNamespacedCertificateInterface in code that requires v31.NamespacedCertificateInterface
//	        // and then make assertions.
//
//	    }
type NamespacedCertificateInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedCertificateHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedCertificateLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedCertificateHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedCertificateLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedCertificateHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedCertificateLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.NamespacedCertificateHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.NamespacedCertificateLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.NamespacedCertificateController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.NamespacedCertificate) (*v3.NamespacedCertificate, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.NamespacedCertificate, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedCertificate, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.NamespacedCertificateList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.NamespacedCertificateList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.NamespacedCertificate) (*v3.NamespacedCertificate, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NamespacedCertificateHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedCertificateLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NamespacedCertificateHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedCertificateLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedCertificateHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedCertificateLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedCertificateHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedCertificateLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.NamespacedCertificate
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.NamespacedCertificate
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NamespacedCertificateInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedCertificateHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NamespacedCertificateInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but NamespacedCertificateInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NamespacedCertificateHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNamespacedCertificateInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNamespacedCertificateInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *NamespacedCertificateInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.NamespacedCertificateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NamespacedCertificateHandlerFunc
	}
	lockNamespacedCertificateInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNamespacedCertificateInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *NamespacedCertificateInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedCertificateLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("NamespacedCertificateInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but NamespacedCertificateInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedCertificateLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNamespacedCertificateInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockNamespacedCertificateInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *NamespacedCertificateInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.NamespacedCertificateLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedCertificateLifecycle
	}
	lockNamespacedCertificateInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockNamespacedCertificateInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NamespacedCertificateInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedCertificateHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NamespacedCertificateInterfaceMock.AddClusterScopedHandlerFunc: method is nil but NamespacedCertificateInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NamespacedCertificateHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNamespacedCertificateInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNamespacedCertificateInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.AddClusterScopedHandlerCalls())
func (mock *NamespacedCertificateInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.NamespacedCertificateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NamespacedCertificateHandlerFunc
	}
	lockNamespacedCertificateInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNamespacedCertificateInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *NamespacedCertificateInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedCertificateLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("NamespacedCertificateInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but NamespacedCertificateInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedCertificateLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNamespacedCertificateInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockNamespacedCertificateInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.AddClusterScopedLifecycleCalls())
func (mock *NamespacedCertificateInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.NamespacedCertificateLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedCertificateLifecycle
	}
	lockNamespacedCertificateInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockNamespacedCertificateInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NamespacedCertificateInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedCertificateHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NamespacedCertificateInterfaceMock.AddFeatureHandlerFunc: method is nil but NamespacedCertificateInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedCertificateHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNamespacedCertificateInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNamespacedCertificateInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.AddFeatureHandlerCalls())
func (mock *NamespacedCertificateInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NamespacedCertificateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedCertificateHandlerFunc
	}
	lockNamespacedCertificateInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNamespacedCertificateInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *NamespacedCertificateInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedCertificateLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("NamespacedCertificateInterfaceMock.AddFeatureLifecycleFunc: method is nil but NamespacedCertificateInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NamespacedCertificateLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNamespacedCertificateInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockNamespacedCertificateInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.AddFeatureLifecycleCalls())
func (mock *NamespacedCertificateInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.NamespacedCertificateLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NamespacedCertificateLifecycle
	}
	lockNamespacedCertificateInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockNamespacedCertificateInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NamespacedCertificateInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.NamespacedCertificateHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NamespacedCertificateInterfaceMock.AddHandlerFunc: method is nil but NamespacedCertificateInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.NamespacedCertificateHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockNamespacedCertificateInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNamespacedCertificateInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.AddHandlerCalls())
func (mock *NamespacedCertificateInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.NamespacedCertificateHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.NamespacedCertificateHandlerFunc
	}
	lockNamespacedCertificateInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNamespacedCertificateInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *NamespacedCertificateInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.NamespacedCertificateLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("NamespacedCertificateInterfaceMock.AddLifecycleFunc: method is nil but NamespacedCertificateInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NamespacedCertificateLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNamespacedCertificateInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockNamespacedCertificateInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.AddLifecycleCalls())
func (mock *NamespacedCertificateInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.NamespacedCertificateLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NamespacedCertificateLifecycle
	}
	lockNamespacedCertificateInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockNamespacedCertificateInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *NamespacedCertificateInterfaceMock) Controller() v31.NamespacedCertificateController {
	if mock.ControllerFunc == nil {
		panic("NamespacedCertificateInterfaceMock.ControllerFunc: method is nil but NamespacedCertificateInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedCertificateInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockNamespacedCertificateInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.ControllerCalls())
func (mock *NamespacedCertificateInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedCertificateInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockNamespacedCertificateInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *NamespacedCertificateInterfaceMock) Create(in1 *v3.NamespacedCertificate) (*v3.NamespacedCertificate, error) {
	if mock.CreateFunc == nil {
		panic("NamespacedCertificateInterfaceMock.CreateFunc: method is nil but NamespacedCertificateInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.NamespacedCertificate
	}{
		In1: in1,
	}
	lockNamespacedCertificateInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockNamespacedCertificateInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.CreateCalls())
func (mock *NamespacedCertificateInterfaceMock) CreateCalls() []struct {
	In1 *v3.NamespacedCertificate
} {
	var calls []struct {
		In1 *v3.NamespacedCertificate
	}
	lockNamespacedCertificateInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockNamespacedCertificateInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *NamespacedCertificateInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("NamespacedCertificateInterfaceMock.DeleteFunc: method is nil but NamespacedCertificateInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockNamespacedCertificateInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockNamespacedCertificateInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.DeleteCalls())
func (mock *NamespacedCertificateInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockNamespacedCertificateInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockNamespacedCertificateInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *NamespacedCertificateInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("NamespacedCertificateInterfaceMock.DeleteCollectionFunc: method is nil but NamespacedCertificateInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockNamespacedCertificateInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockNamespacedCertificateInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.DeleteCollectionCalls())
func (mock *NamespacedCertificateInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockNamespacedCertificateInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockNamespacedCertificateInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *NamespacedCertificateInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("NamespacedCertificateInterfaceMock.DeleteNamespacedFunc: method is nil but NamespacedCertificateInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockNamespacedCertificateInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockNamespacedCertificateInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.DeleteNamespacedCalls())
func (mock *NamespacedCertificateInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockNamespacedCertificateInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockNamespacedCertificateInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *NamespacedCertificateInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.NamespacedCertificate, error) {
	if mock.GetFunc == nil {
		panic("NamespacedCertificateInterfaceMock.GetFunc: method is nil but NamespacedCertificateInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockNamespacedCertificateInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNamespacedCertificateInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.GetCalls())
func (mock *NamespacedCertificateInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockNamespacedCertificateInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockNamespacedCertificateInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *NamespacedCertificateInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedCertificate, error) {
	if mock.GetNamespacedFunc == nil {
		panic("NamespacedCertificateInterfaceMock.GetNamespacedFunc: method is nil but NamespacedCertificateInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockNamespacedCertificateInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockNamespacedCertificateInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.GetNamespacedCalls())
func (mock *NamespacedCertificateInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockNamespacedCertificateInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockNamespacedCertificateInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NamespacedCertificateInterfaceMock) List(opts metav1.ListOptions) (*v3.NamespacedCertificateList, error) {
	if mock.ListFunc == nil {
		panic("NamespacedCertificateInterfaceMock.ListFunc: method is nil but NamespacedCertificateInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNamespacedCertificateInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNamespacedCertificateInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.ListCalls())
func (mock *NamespacedCertificateInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNamespacedCertificateInterfaceMockList.RLock()
	calls = mock.calls.List
	lockNamespacedCertificateInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *NamespacedCertificateInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.NamespacedCertificateList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("NamespacedCertificateInterfaceMock.ListNamespacedFunc: method is nil but NamespacedCertificateInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockNamespacedCertificateInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockNamespacedCertificateInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.ListNamespacedCalls())
func (mock *NamespacedCertificateInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockNamespacedCertificateInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockNamespacedCertificateInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *NamespacedCertificateInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("NamespacedCertificateInterfaceMock.ObjectClientFunc: method is nil but NamespacedCertificateInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedCertificateInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockNamespacedCertificateInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.ObjectClientCalls())
func (mock *NamespacedCertificateInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedCertificateInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockNamespacedCertificateInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *NamespacedCertificateInterfaceMock) Update(in1 *v3.NamespacedCertificate) (*v3.NamespacedCertificate, error) {
	if mock.UpdateFunc == nil {
		panic("NamespacedCertificateInterfaceMock.UpdateFunc: method is nil but NamespacedCertificateInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.NamespacedCertificate
	}{
		In1: in1,
	}
	lockNamespacedCertificateInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockNamespacedCertificateInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.UpdateCalls())
func (mock *NamespacedCertificateInterfaceMock) UpdateCalls() []struct {
	In1 *v3.NamespacedCertificate
} {
	var calls []struct {
		In1 *v3.NamespacedCertificate
	}
	lockNamespacedCertificateInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockNamespacedCertificateInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *NamespacedCertificateInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("NamespacedCertificateInterfaceMock.WatchFunc: method is nil but NamespacedCertificateInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNamespacedCertificateInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockNamespacedCertificateInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedNamespacedCertificateInterface.WatchCalls())
func (mock *NamespacedCertificateInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNamespacedCertificateInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockNamespacedCertificateInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockNamespacedCertificatesGetterMockNamespacedCertificates sync.RWMutex
)

// Ensure, that NamespacedCertificatesGetterMock does implement v31.NamespacedCertificatesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedCertificatesGetter = &NamespacedCertificatesGetterMock{}

// NamespacedCertificatesGetterMock is a mock implementation of v31.NamespacedCertificatesGetter.
//
//	    func TestSomethingThatUsesNamespacedCertificatesGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.NamespacedCertificatesGetter
//	        mockedNamespacedCertificatesGetter := &NamespacedCertificatesGetterMock{
//	            NamespacedCertificatesFunc: func(namespace string) v31.NamespacedCertificateInterface {
//		               panic("mock out the NamespacedCertificates method")
//	            },
//	        }
//
//	        // use mockedNamespacedCertificatesGetter in code that requires v31.NamespacedCertificatesGetter
//	        // and then make assertions.
//
//	    }
type NamespacedCertificatesGetterMock struct {
	// NamespacedCertificatesFunc mocks the NamespacedCertificates method.
	NamespacedCertificatesFunc func(namespace string) v31.NamespacedCertificateInterface

	// calls tracks calls to the methods.
	calls struct {
		// NamespacedCertificates holds details about calls to the NamespacedCertificates method.
		NamespacedCertificates []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// NamespacedCertificates calls NamespacedCertificatesFunc.
func (mock *NamespacedCertificatesGetterMock) NamespacedCertificates(namespace string) v31.NamespacedCertificateInterface {
	if mock.NamespacedCertificatesFunc == nil {
		panic("NamespacedCertificatesGetterMock.NamespacedCertificatesFunc: method is nil but NamespacedCertificatesGetter.NamespacedCertificates was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockNamespacedCertificatesGetterMockNamespacedCertificates.Lock()
	mock.calls.NamespacedCertificates = append(mock.calls.NamespacedCertificates, callInfo)
	lockNamespacedCertificatesGetterMockNamespacedCertificates.Unlock()
	return mock.NamespacedCertificatesFunc(namespace)
}

// NamespacedCertificatesCalls gets all the calls that were made to NamespacedCertificates.
// Check the length with:
//
//	len(mockedNamespacedCertificatesGetter.NamespacedCertificatesCalls())
func (mock *NamespacedCertificatesGetterMock) NamespacedCertificatesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockNamespacedCertificatesGetterMockNamespacedCertificates.RLock()
	calls = mock.calls.NamespacedCertificates
	lockNamespacedCertificatesGetterMockNamespacedCertificates.RUnlock()
	return calls
}
