// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockNamespacedServiceAccountTokenListerMockGet  sync.RWMutex
	lockNamespacedServiceAccountTokenListerMockList sync.RWMutex
)

// Ensure, that NamespacedServiceAccountTokenListerMock does implement v31.NamespacedServiceAccountTokenLister.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedServiceAccountTokenLister = &NamespacedServiceAccountTokenListerMock{}

// NamespacedServiceAccountTokenListerMock is a mock implementation of v31.NamespacedServiceAccountTokenLister.
//
//	    func TestSomethingThatUsesNamespacedServiceAccountTokenLister(t *testing.T) {
//
//	        // make and configure a mocked v31.NamespacedServiceAccountTokenLister
//	        mockedNamespacedServiceAccountTokenLister := &NamespacedServiceAccountTokenListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.NamespacedServiceAccountToken, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.NamespacedServiceAccountToken, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedNamespacedServiceAccountTokenLister in code that requires v31.NamespacedServiceAccountTokenLister
//	        // and then make assertions.
//
//	    }
type NamespacedServiceAccountTokenListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.NamespacedServiceAccountToken, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.NamespacedServiceAccountToken, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *NamespacedServiceAccountTokenListerMock) Get(namespace string, name string) (*v3.NamespacedServiceAccountToken, error) {
	if mock.GetFunc == nil {
		panic("NamespacedServiceAccountTokenListerMock.GetFunc: method is nil but NamespacedServiceAccountTokenLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNamespacedServiceAccountTokenListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNamespacedServiceAccountTokenListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenLister.GetCalls())
func (mock *NamespacedServiceAccountTokenListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNamespacedServiceAccountTokenListerMockGet.RLock()
	calls = mock.calls.Get
	lockNamespacedServiceAccountTokenListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NamespacedServiceAccountTokenListerMock) List(namespace string, selector labels.Selector) ([]*v3.NamespacedServiceAccountToken, error) {
	if mock.ListFunc == nil {
		panic("NamespacedServiceAccountTokenListerMock.ListFunc: method is nil but NamespacedServiceAccountTokenLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockNamespacedServiceAccountTokenListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNamespacedServiceAccountTokenListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenLister.ListCalls())
func (mock *NamespacedServiceAccountTokenListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockNamespacedServiceAccountTokenListerMockList.RLock()
	calls = mock.calls.List
	lockNamespacedServiceAccountTokenListerMockList.RUnlock()
	return calls
}

var (
	lockNamespacedServiceAccountTokenControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockNamespacedServiceAccountTokenControllerMockAddClusterScopedHandler        sync.RWMutex
	lockNamespacedServiceAccountTokenControllerMockAddFeatureHandler              sync.RWMutex
	lockNamespacedServiceAccountTokenControllerMockAddHandler                     sync.RWMutex
	lockNamespacedServiceAccountTokenControllerMockEnqueue                        sync.RWMutex
	lockNamespacedServiceAccountTokenControllerMockEnqueueAfter                   sync.RWMutex
	lockNamespacedServiceAccountTokenControllerMockGeneric                        sync.RWMutex
	lockNamespacedServiceAccountTokenControllerMockInformer                       sync.RWMutex
	lockNamespacedServiceAccountTokenControllerMockLister                         sync.RWMutex
)

// Ensure, that NamespacedServiceAccountTokenControllerMock does implement v31.NamespacedServiceAccountTokenController.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedServiceAccountTokenController = &NamespacedServiceAccountTokenControllerMock{}

// NamespacedServiceAccountTokenControllerMock is a mock implementation of v31.NamespacedServiceAccountTokenController.
//
//	    func TestSomethingThatUsesNamespacedServiceAccountTokenController(t *testing.T) {
//
//	        // make and configure a mocked v31.NamespacedServiceAccountTokenController
//	        mockedNamespacedServiceAccountTokenController := &NamespacedServiceAccountTokenControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.NamespacedServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.NamespacedServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.NamespacedServiceAccountTokenLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedNamespacedServiceAccountTokenController in code that requires v31.NamespacedServiceAccountTokenController
//	        // and then make assertions.
//
//	    }
type NamespacedServiceAccountTokenControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedServiceAccountTokenHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.NamespacedServiceAccountTokenHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.NamespacedServiceAccountTokenHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.NamespacedServiceAccountTokenLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NamespacedServiceAccountTokenHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NamespacedServiceAccountTokenHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedServiceAccountTokenHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.NamespacedServiceAccountTokenHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NamespacedServiceAccountTokenControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedServiceAccountTokenHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NamespacedServiceAccountTokenControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but NamespacedServiceAccountTokenController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NamespacedServiceAccountTokenHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNamespacedServiceAccountTokenControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNamespacedServiceAccountTokenControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenController.AddClusterScopedFeatureHandlerCalls())
func (mock *NamespacedServiceAccountTokenControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.NamespacedServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NamespacedServiceAccountTokenHandlerFunc
	}
	lockNamespacedServiceAccountTokenControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNamespacedServiceAccountTokenControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NamespacedServiceAccountTokenControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.NamespacedServiceAccountTokenHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NamespacedServiceAccountTokenControllerMock.AddClusterScopedHandlerFunc: method is nil but NamespacedServiceAccountTokenController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NamespacedServiceAccountTokenHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNamespacedServiceAccountTokenControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNamespacedServiceAccountTokenControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenController.AddClusterScopedHandlerCalls())
func (mock *NamespacedServiceAccountTokenControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.NamespacedServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NamespacedServiceAccountTokenHandlerFunc
	}
	lockNamespacedServiceAccountTokenControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNamespacedServiceAccountTokenControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NamespacedServiceAccountTokenControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NamespacedServiceAccountTokenControllerMock.AddFeatureHandlerFunc: method is nil but NamespacedServiceAccountTokenController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedServiceAccountTokenHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNamespacedServiceAccountTokenControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNamespacedServiceAccountTokenControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenController.AddFeatureHandlerCalls())
func (mock *NamespacedServiceAccountTokenControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NamespacedServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedServiceAccountTokenHandlerFunc
	}
	lockNamespacedServiceAccountTokenControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNamespacedServiceAccountTokenControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NamespacedServiceAccountTokenControllerMock) AddHandler(ctx context.Context, name string, handler v31.NamespacedServiceAccountTokenHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NamespacedServiceAccountTokenControllerMock.AddHandlerFunc: method is nil but NamespacedServiceAccountTokenController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.NamespacedServiceAccountTokenHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockNamespacedServiceAccountTokenControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNamespacedServiceAccountTokenControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenController.AddHandlerCalls())
func (mock *NamespacedServiceAccountTokenControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.NamespacedServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.NamespacedServiceAccountTokenHandlerFunc
	}
	lockNamespacedServiceAccountTokenControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNamespacedServiceAccountTokenControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *NamespacedServiceAccountTokenControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("NamespacedServiceAccountTokenControllerMock.EnqueueFunc: method is nil but NamespacedServiceAccountTokenController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNamespacedServiceAccountTokenControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockNamespacedServiceAccountTokenControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenController.EnqueueCalls())
func (mock *NamespacedServiceAccountTokenControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNamespacedServiceAccountTokenControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockNamespacedServiceAccountTokenControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *NamespacedServiceAccountTokenControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("NamespacedServiceAccountTokenControllerMock.EnqueueAfterFunc: method is nil but NamespacedServiceAccountTokenController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockNamespacedServiceAccountTokenControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockNamespacedServiceAccountTokenControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenController.EnqueueAfterCalls())
func (mock *NamespacedServiceAccountTokenControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockNamespacedServiceAccountTokenControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockNamespacedServiceAccountTokenControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *NamespacedServiceAccountTokenControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("NamespacedServiceAccountTokenControllerMock.GenericFunc: method is nil but NamespacedServiceAccountTokenController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedServiceAccountTokenControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockNamespacedServiceAccountTokenControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenController.GenericCalls())
func (mock *NamespacedServiceAccountTokenControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedServiceAccountTokenControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockNamespacedServiceAccountTokenControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *NamespacedServiceAccountTokenControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("NamespacedServiceAccountTokenControllerMock.InformerFunc: method is nil but NamespacedServiceAccountTokenController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedServiceAccountTokenControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockNamespacedServiceAccountTokenControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenController.InformerCalls())
func (mock *NamespacedServiceAccountTokenControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedServiceAccountTokenControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockNamespacedServiceAccountTokenControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *NamespacedServiceAccountTokenControllerMock) Lister() v31.NamespacedServiceAccountTokenLister {
	if mock.ListerFunc == nil {
		panic("NamespacedServiceAccountTokenControllerMock.ListerFunc: method is nil but NamespacedServiceAccountTokenController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedServiceAccountTokenControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockNamespacedServiceAccountTokenControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenController.ListerCalls())
func (mock *NamespacedServiceAccountTokenControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedServiceAccountTokenControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockNamespacedServiceAccountTokenControllerMockLister.RUnlock()
	return calls
}

var (
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockAddFeatureHandler                sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockAddHandler                       sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockAddLifecycle                     sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockController                       sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockCreate                           sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockDelete                           sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockDeleteCollection                 sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockGet                              sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockGetNamespaced                    sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockList                             sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockListNamespaced                   sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockObjectClient                     sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockUpdate                           sync.RWMutex
	lockNamespacedServiceAccountTokenInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that NamespacedServiceAccountTokenInterfaceMock does implement v31.NamespacedServiceAccountTokenInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedServiceAccountTokenInterface = &NamespacedServiceAccountTokenInterfaceMock{}

// NamespacedServiceAccountTokenInterfaceMock is a mock implementation of v31.NamespacedServiceAccountTokenInterface.
//
//	    func TestSomethingThatUsesNamespacedServiceAccountTokenInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.NamespacedServiceAccountTokenInterface
//	        mockedNamespacedServiceAccountTokenInterface := &NamespacedServiceAccountTokenInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedServiceAccountTokenLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedServiceAccountTokenLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedServiceAccountTokenLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.NamespacedServiceAccountTokenLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.NamespacedServiceAccountTokenController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.NamespacedServiceAccountToken) (*v3.NamespacedServiceAccountToken, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.NamespacedServiceAccountToken, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedServiceAccountToken, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.NamespacedServiceAccountTokenList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.NamespacedServiceAccountTokenList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.NamespacedServiceAccountToken) (*v3.NamespacedServiceAccountToken, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedNamespacedServiceAccountTokenInterface in code that requires v31.NamespacedServiceAccountTokenInterface
//	        // and then make assertions.
//
//	    }
type NamespacedServiceAccountTokenInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedServiceAccountTokenLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedServiceAccountTokenLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedServiceAccountTokenLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.NamespacedServiceAccountTokenLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.NamespacedServiceAccountTokenController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.NamespacedServiceAccountToken) (*v3.NamespacedServiceAccountToken, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.NamespacedServiceAccountToken, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedServiceAccountToken, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.NamespacedServiceAccountTokenList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.NamespacedServiceAccountTokenList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.NamespacedServiceAccountToken) (*v3.NamespacedServiceAccountToken, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NamespacedServiceAccountTokenHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedServiceAccountTokenLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NamespacedServiceAccountTokenHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedServiceAccountTokenLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedServiceAccountTokenHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedServiceAccountTokenLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedServiceAccountTokenHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedServiceAccountTokenLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.NamespacedServiceAccountToken
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.NamespacedServiceAccountToken
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but NamespacedServiceAccountTokenInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NamespacedServiceAccountTokenHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.NamespacedServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NamespacedServiceAccountTokenHandlerFunc
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedServiceAccountTokenLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but NamespacedServiceAccountTokenInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedServiceAccountTokenLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.NamespacedServiceAccountTokenLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedServiceAccountTokenLifecycle
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.AddClusterScopedHandlerFunc: method is nil but NamespacedServiceAccountTokenInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NamespacedServiceAccountTokenHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.AddClusterScopedHandlerCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.NamespacedServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NamespacedServiceAccountTokenHandlerFunc
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedServiceAccountTokenLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but NamespacedServiceAccountTokenInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedServiceAccountTokenLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.AddClusterScopedLifecycleCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.NamespacedServiceAccountTokenLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedServiceAccountTokenLifecycle
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockNamespacedServiceAccountTokenInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.AddFeatureHandlerFunc: method is nil but NamespacedServiceAccountTokenInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedServiceAccountTokenHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.AddFeatureHandlerCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NamespacedServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedServiceAccountTokenHandlerFunc
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNamespacedServiceAccountTokenInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedServiceAccountTokenLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.AddFeatureLifecycleFunc: method is nil but NamespacedServiceAccountTokenInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NamespacedServiceAccountTokenLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.AddFeatureLifecycleCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.NamespacedServiceAccountTokenLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NamespacedServiceAccountTokenLifecycle
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockNamespacedServiceAccountTokenInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.NamespacedServiceAccountTokenHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.AddHandlerFunc: method is nil but NamespacedServiceAccountTokenInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.NamespacedServiceAccountTokenHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.AddHandlerCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.NamespacedServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.NamespacedServiceAccountTokenHandlerFunc
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNamespacedServiceAccountTokenInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.NamespacedServiceAccountTokenLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.AddLifecycleFunc: method is nil but NamespacedServiceAccountTokenInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NamespacedServiceAccountTokenLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.AddLifecycleCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.NamespacedServiceAccountTokenLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NamespacedServiceAccountTokenLifecycle
	}
	lockNamespacedServiceAccountTokenInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockNamespacedServiceAccountTokenInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) Controller() v31.NamespacedServiceAccountTokenController {
	if mock.ControllerFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.ControllerFunc: method is nil but NamespacedServiceAccountTokenInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedServiceAccountTokenInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.ControllerCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedServiceAccountTokenInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockNamespacedServiceAccountTokenInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) Create(in1 *v3.NamespacedServiceAccountToken) (*v3.NamespacedServiceAccountToken, error) {
	if mock.CreateFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.CreateFunc: method is nil but NamespacedServiceAccountTokenInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.NamespacedServiceAccountToken
	}{
		In1: in1,
	}
	lockNamespacedServiceAccountTokenInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.CreateCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) CreateCalls() []struct {
	In1 *v3.NamespacedServiceAccountToken
} {
	var calls []struct {
		In1 *v3.NamespacedServiceAccountToken
	}
	lockNamespacedServiceAccountTokenInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockNamespacedServiceAccountTokenInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.DeleteFunc: method is nil but NamespacedServiceAccountTokenInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockNamespacedServiceAccountTokenInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.DeleteCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockNamespacedServiceAccountTokenInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockNamespacedServiceAccountTokenInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.DeleteCollectionFunc: method is nil but NamespacedServiceAccountTokenInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockNamespacedServiceAccountTokenInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.DeleteCollectionCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockNamespacedServiceAccountTokenInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockNamespacedServiceAccountTokenInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.DeleteNamespacedFunc: method is nil but NamespacedServiceAccountTokenInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockNamespacedServiceAccountTokenInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.DeleteNamespacedCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockNamespacedServiceAccountTokenInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockNamespacedServiceAccountTokenInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.NamespacedServiceAccountToken, error) {
	if mock.GetFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.GetFunc: method is nil but NamespacedServiceAccountTokenInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockNamespacedServiceAccountTokenInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.GetCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockNamespacedServiceAccountTokenInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockNamespacedServiceAccountTokenInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedServiceAccountToken, error) {
	if mock.GetNamespacedFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.GetNamespacedFunc: method is nil but NamespacedServiceAccountTokenInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockNamespacedServiceAccountTokenInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.GetNamespacedCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockNamespacedServiceAccountTokenInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockNamespacedServiceAccountTokenInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) List(opts metav1.ListOptions) (*v3.NamespacedServiceAccountTokenList, error) {
	if mock.ListFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.ListFunc: method is nil but NamespacedServiceAccountTokenInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNamespacedServiceAccountTokenInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.ListCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNamespacedServiceAccountTokenInterfaceMockList.RLock()
	calls = mock.calls.List
	lockNamespacedServiceAccountTokenInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.NamespacedServiceAccountTokenList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.ListNamespacedFunc: method is nil but NamespacedServiceAccountTokenInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockNamespacedServiceAccountTokenInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.ListNamespacedCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockNamespacedServiceAccountTokenInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockNamespacedServiceAccountTokenInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.ObjectClientFunc: method is nil but NamespacedServiceAccountTokenInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedServiceAccountTokenInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.ObjectClientCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedServiceAccountTokenInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockNamespacedServiceAccountTokenInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) Update(in1 *v3.NamespacedServiceAccountToken) (*v3.NamespacedServiceAccountToken, error) {
	if mock.UpdateFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.UpdateFunc: method is nil but NamespacedServiceAccountTokenInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.NamespacedServiceAccountToken
	}{
		In1: in1,
	}
	lockNamespacedServiceAccountTokenInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.UpdateCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) UpdateCalls() []struct {
	In1 *v3.NamespacedServiceAccountToken
} {
	var calls []struct {
		In1 *v3.NamespacedServiceAccountToken
	}
	lockNamespacedServiceAccountTokenInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockNamespacedServiceAccountTokenInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *NamespacedServiceAccountTokenInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("NamespacedServiceAccountTokenInterfaceMock.WatchFunc: method is nil but NamespacedServiceAccountTokenInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNamespacedServiceAccountTokenInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockNamespacedServiceAccountTokenInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokenInterface.WatchCalls())
func (mock *NamespacedServiceAccountTokenInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNamespacedServiceAccountTokenInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockNamespacedServiceAccountTokenInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockNamespacedServiceAccountTokensGetterMockNamespacedServiceAccountTokens sync.RWMutex
)

// Ensure, that NamespacedServiceAccountTokensGetterMock does implement v31.NamespacedServiceAccountTokensGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedServiceAccountTokensGetter = &NamespacedServiceAccountTokensGetterMock{}

// NamespacedServiceAccountTokensGetterMock is a mock implementation of v31.NamespacedServiceAccountTokensGetter.
//
//	    func TestSomethingThatUsesNamespacedServiceAccountTokensGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.NamespacedServiceAccountTokensGetter
//	        mockedNamespacedServiceAccountTokensGetter := &NamespacedServiceAccountTokensGetterMock{
//	            NamespacedServiceAccountTokensFunc: func(namespace string) v31.NamespacedServiceAccountTokenInterface {
//		               panic("mock out the NamespacedServiceAccountTokens method")
//	            },
//	        }
//
//	        // use mockedNamespacedServiceAccountTokensGetter in code that requires v31.NamespacedServiceAccountTokensGetter
//	        // and then make assertions.
//
//	    }
type NamespacedServiceAccountTokensGetterMock struct {
	// NamespacedServiceAccountTokensFunc mocks the NamespacedServiceAccountTokens method.
	NamespacedServiceAccountTokensFunc func(namespace string) v31.NamespacedServiceAccountTokenInterface

	// calls tracks calls to the methods.
	calls struct {
		// NamespacedServiceAccountTokens holds details about calls to the NamespacedServiceAccountTokens method.
		NamespacedServiceAccountTokens []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// NamespacedServiceAccountTokens calls NamespacedServiceAccountTokensFunc.
func (mock *NamespacedServiceAccountTokensGetterMock) NamespacedServiceAccountTokens(namespace string) v31.NamespacedServiceAccountTokenInterface {
	if mock.NamespacedServiceAccountTokensFunc == nil {
		panic("NamespacedServiceAccountTokensGetterMock.NamespacedServiceAccountTokensFunc: method is nil but NamespacedServiceAccountTokensGetter.NamespacedServiceAccountTokens was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockNamespacedServiceAccountTokensGetterMockNamespacedServiceAccountTokens.Lock()
	mock.calls.NamespacedServiceAccountTokens = append(mock.calls.NamespacedServiceAccountTokens, callInfo)
	lockNamespacedServiceAccountTokensGetterMockNamespacedServiceAccountTokens.Unlock()
	return mock.NamespacedServiceAccountTokensFunc(namespace)
}

// NamespacedServiceAccountTokensCalls gets all the calls that were made to NamespacedServiceAccountTokens.
// Check the length with:
//
//	len(mockedNamespacedServiceAccountTokensGetter.NamespacedServiceAccountTokensCalls())
func (mock *NamespacedServiceAccountTokensGetterMock) NamespacedServiceAccountTokensCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockNamespacedServiceAccountTokensGetterMockNamespacedServiceAccountTokens.RLock()
	calls = mock.calls.NamespacedServiceAccountTokens
	lockNamespacedServiceAccountTokensGetterMockNamespacedServiceAccountTokens.RUnlock()
	return calls
}
