// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockNamespacedSSHAuthListerMockGet  sync.RWMutex
	lockNamespacedSSHAuthListerMockList sync.RWMutex
)

// Ensure, that NamespacedSSHAuthListerMock does implement v31.NamespacedSSHAuthLister.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedSSHAuthLister = &NamespacedSSHAuthListerMock{}

// NamespacedSSHAuthListerMock is a mock implementation of v31.NamespacedSSHAuthLister.
//
//	    func TestSomethingThatUsesNamespacedSSHAuthLister(t *testing.T) {
//
//	        // make and configure a mocked v31.NamespacedSSHAuthLister
//	        mockedNamespacedSSHAuthLister := &NamespacedSSHAuthListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.NamespacedSSHAuth, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.NamespacedSSHAuth, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedNamespacedSSHAuthLister in code that requires v31.NamespacedSSHAuthLister
//	        // and then make assertions.
//
//	    }
type NamespacedSSHAuthListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.NamespacedSSHAuth, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.NamespacedSSHAuth, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *NamespacedSSHAuthListerMock) Get(namespace string, name string) (*v3.NamespacedSSHAuth, error) {
	if mock.GetFunc == nil {
		panic("NamespacedSSHAuthListerMock.GetFunc: method is nil but NamespacedSSHAuthLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNamespacedSSHAuthListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNamespacedSSHAuthListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthLister.GetCalls())
func (mock *NamespacedSSHAuthListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNamespacedSSHAuthListerMockGet.RLock()
	calls = mock.calls.Get
	lockNamespacedSSHAuthListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NamespacedSSHAuthListerMock) List(namespace string, selector labels.Selector) ([]*v3.NamespacedSSHAuth, error) {
	if mock.ListFunc == nil {
		panic("NamespacedSSHAuthListerMock.ListFunc: method is nil but NamespacedSSHAuthLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockNamespacedSSHAuthListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNamespacedSSHAuthListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthLister.ListCalls())
func (mock *NamespacedSSHAuthListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockNamespacedSSHAuthListerMockList.RLock()
	calls = mock.calls.List
	lockNamespacedSSHAuthListerMockList.RUnlock()
	return calls
}

var (
	lockNamespacedSSHAuthControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockNamespacedSSHAuthControllerMockAddClusterScopedHandler        sync.RWMutex
	lockNamespacedSSHAuthControllerMockAddFeatureHandler              sync.RWMutex
	lockNamespacedSSHAuthControllerMockAddHandler                     sync.RWMutex
	lockNamespacedSSHAuthControllerMockEnqueue                        sync.RWMutex
	lockNamespacedSSHAuthControllerMockEnqueueAfter                   sync.RWMutex
	lockNamespacedSSHAuthControllerMockGeneric                        sync.RWMutex
	lockNamespacedSSHAuthControllerMockInformer                       sync.RWMutex
	lockNamespacedSSHAuthControllerMockLister                         sync.RWMutex
)

// Ensure, that NamespacedSSHAuthControllerMock does implement v31.NamespacedSSHAuthController.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedSSHAuthController = &NamespacedSSHAuthControllerMock{}

// NamespacedSSHAuthControllerMock is a mock implementation of v31.NamespacedSSHAuthController.
//
//	    func TestSomethingThatUsesNamespacedSSHAuthController(t *testing.T) {
//
//	        // make and configure a mocked v31.NamespacedSSHAuthController
//	        mockedNamespacedSSHAuthController := &NamespacedSSHAuthControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedSSHAuthHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.NamespacedSSHAuthHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.NamespacedSSHAuthHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.NamespacedSSHAuthLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedNamespacedSSHAuthController in code that requires v31.NamespacedSSHAuthController
//	        // and then make assertions.
//
//	    }
type NamespacedSSHAuthControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedSSHAuthHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.NamespacedSSHAuthHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.NamespacedSSHAuthHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.NamespacedSSHAuthLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NamespacedSSHAuthHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NamespacedSSHAuthHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedSSHAuthHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.NamespacedSSHAuthHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NamespacedSSHAuthControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NamespacedSSHAuthHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NamespacedSSHAuthControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but NamespacedSSHAuthController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NamespacedSSHAuthHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNamespacedSSHAuthControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNamespacedSSHAuthControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthController.AddClusterScopedFeatureHandlerCalls())
func (mock *NamespacedSSHAuthControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.NamespacedSSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NamespacedSSHAuthHandlerFunc
	}
	lockNamespacedSSHAuthControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNamespacedSSHAuthControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NamespacedSSHAuthControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.NamespacedSSHAuthHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NamespacedSSHAuthControllerMock.AddClusterScopedHandlerFunc: method is nil but NamespacedSSHAuthController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NamespacedSSHAuthHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNamespacedSSHAuthControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNamespacedSSHAuthControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthController.AddClusterScopedHandlerCalls())
func (mock *NamespacedSSHAuthControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.NamespacedSSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NamespacedSSHAuthHandlerFunc
	}
	lockNamespacedSSHAuthControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNamespacedSSHAuthControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NamespacedSSHAuthControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NamespacedSSHAuthControllerMock.AddFeatureHandlerFunc: method is nil but NamespacedSSHAuthController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedSSHAuthHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNamespacedSSHAuthControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNamespacedSSHAuthControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthController.AddFeatureHandlerCalls())
func (mock *NamespacedSSHAuthControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NamespacedSSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedSSHAuthHandlerFunc
	}
	lockNamespacedSSHAuthControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNamespacedSSHAuthControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NamespacedSSHAuthControllerMock) AddHandler(ctx context.Context, name string, handler v31.NamespacedSSHAuthHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NamespacedSSHAuthControllerMock.AddHandlerFunc: method is nil but NamespacedSSHAuthController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.NamespacedSSHAuthHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockNamespacedSSHAuthControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNamespacedSSHAuthControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthController.AddHandlerCalls())
func (mock *NamespacedSSHAuthControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.NamespacedSSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.NamespacedSSHAuthHandlerFunc
	}
	lockNamespacedSSHAuthControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNamespacedSSHAuthControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *NamespacedSSHAuthControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("NamespacedSSHAuthControllerMock.EnqueueFunc: method is nil but NamespacedSSHAuthController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNamespacedSSHAuthControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockNamespacedSSHAuthControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthController.EnqueueCalls())
func (mock *NamespacedSSHAuthControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNamespacedSSHAuthControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockNamespacedSSHAuthControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *NamespacedSSHAuthControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("NamespacedSSHAuthControllerMock.EnqueueAfterFunc: method is nil but NamespacedSSHAuthController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockNamespacedSSHAuthControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockNamespacedSSHAuthControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthController.EnqueueAfterCalls())
func (mock *NamespacedSSHAuthControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockNamespacedSSHAuthControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockNamespacedSSHAuthControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *NamespacedSSHAuthControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("NamespacedSSHAuthControllerMock.GenericFunc: method is nil but NamespacedSSHAuthController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedSSHAuthControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockNamespacedSSHAuthControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthController.GenericCalls())
func (mock *NamespacedSSHAuthControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedSSHAuthControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockNamespacedSSHAuthControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *NamespacedSSHAuthControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("NamespacedSSHAuthControllerMock.InformerFunc: method is nil but NamespacedSSHAuthController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedSSHAuthControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockNamespacedSSHAuthControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthController.InformerCalls())
func (mock *NamespacedSSHAuthControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedSSHAuthControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockNamespacedSSHAuthControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *NamespacedSSHAuthControllerMock) Lister() v31.NamespacedSSHAuthLister {
	if mock.ListerFunc == nil {
		panic("NamespacedSSHAuthControllerMock.ListerFunc: method is nil but NamespacedSSHAuthController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedSSHAuthControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockNamespacedSSHAuthControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthController.ListerCalls())
func (mock *NamespacedSSHAuthControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedSSHAuthControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockNamespacedSSHAuthControllerMockLister.RUnlock()
	return calls
}

var (
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockAddFeatureHandler                sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockAddHandler                       sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockAddLifecycle                     sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockController                       sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockCreate                           sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockDelete                           sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockDeleteCollection                 sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockGet                              sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockGetNamespaced                    sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockList                             sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockListNamespaced                   sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockObjectClient                     sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockUpdate                           sync.RWMutex
	lockNamespacedSSHAuthInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that NamespacedSSHAuthInterfaceMock does implement v31.NamespacedSSHAuthInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedSSHAuthInterface = &NamespacedSSHAuthInterfaceMock{}

// NamespacedSSHAuthInterfaceMock is a mock implementation of v31.NamespacedSSHAuthInterface.
//
//	    func TestSomethingThatUsesNamespacedSSHAuthInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.NamespacedSSHAuthInterface
//	        mockedNamespacedSSHAuthInterface := &NamespacedSSHAuthInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedSSHAuthLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedSSHAuthLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedSSHAuthLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.NamespacedSSHAuthLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.NamespacedSSHAuthController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.NamespacedSSHAuth) (*v3.NamespacedSSHAuth, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.NamespacedSSHAuth, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedSSHAuth, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.NamespacedSSHAuthList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.NamespacedSSHAuthList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.NamespacedSSHAuth) (*v3.NamespacedSSHAuth, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedNamespacedSSHAuthInterface in code that requires v31.NamespacedSSHAuthInterface
//	        // and then make assertions.
//
//	    }
type NamespacedSSHAuthInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedSSHAuthLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedSSHAuthLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedSSHAuthLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.NamespacedSSHAuthLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.NamespacedSSHAuthController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.NamespacedSSHAuth) (*v3.NamespacedSSHAuth, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.NamespacedSSHAuth, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedSSHAuth, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.NamespacedSSHAuthList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.NamespacedSSHAuthList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.NamespacedSSHAuth) (*v3.NamespacedSSHAuth, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NamespacedSSHAuthHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedSSHAuthLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NamespacedSSHAuthHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedSSHAuthLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedSSHAuthHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedSSHAuthLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NamespacedSSHAuthHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NamespacedSSHAuthLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.NamespacedSSHAuth
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.NamespacedSSHAuth
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NamespacedSSHAuthInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but NamespacedSSHAuthInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NamespacedSSHAuthHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *NamespacedSSHAuthInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.NamespacedSSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NamespacedSSHAuthHandlerFunc
	}
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *NamespacedSSHAuthInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NamespacedSSHAuthLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but NamespacedSSHAuthInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedSSHAuthLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *NamespacedSSHAuthInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.NamespacedSSHAuthLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedSSHAuthLifecycle
	}
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NamespacedSSHAuthInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.AddClusterScopedHandlerFunc: method is nil but NamespacedSSHAuthInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NamespacedSSHAuthHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.AddClusterScopedHandlerCalls())
func (mock *NamespacedSSHAuthInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.NamespacedSSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NamespacedSSHAuthHandlerFunc
	}
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *NamespacedSSHAuthInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.NamespacedSSHAuthLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but NamespacedSSHAuthInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedSSHAuthLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.AddClusterScopedLifecycleCalls())
func (mock *NamespacedSSHAuthInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.NamespacedSSHAuthLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NamespacedSSHAuthLifecycle
	}
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockNamespacedSSHAuthInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NamespacedSSHAuthInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.AddFeatureHandlerFunc: method is nil but NamespacedSSHAuthInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedSSHAuthHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNamespacedSSHAuthInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNamespacedSSHAuthInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.AddFeatureHandlerCalls())
func (mock *NamespacedSSHAuthInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NamespacedSSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NamespacedSSHAuthHandlerFunc
	}
	lockNamespacedSSHAuthInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNamespacedSSHAuthInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *NamespacedSSHAuthInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.NamespacedSSHAuthLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.AddFeatureLifecycleFunc: method is nil but NamespacedSSHAuthInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NamespacedSSHAuthLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNamespacedSSHAuthInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockNamespacedSSHAuthInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.AddFeatureLifecycleCalls())
func (mock *NamespacedSSHAuthInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.NamespacedSSHAuthLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NamespacedSSHAuthLifecycle
	}
	lockNamespacedSSHAuthInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockNamespacedSSHAuthInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NamespacedSSHAuthInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.NamespacedSSHAuthHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.AddHandlerFunc: method is nil but NamespacedSSHAuthInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.NamespacedSSHAuthHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockNamespacedSSHAuthInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNamespacedSSHAuthInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.AddHandlerCalls())
func (mock *NamespacedSSHAuthInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.NamespacedSSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.NamespacedSSHAuthHandlerFunc
	}
	lockNamespacedSSHAuthInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNamespacedSSHAuthInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *NamespacedSSHAuthInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.NamespacedSSHAuthLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.AddLifecycleFunc: method is nil but NamespacedSSHAuthInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NamespacedSSHAuthLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNamespacedSSHAuthInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockNamespacedSSHAuthInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.AddLifecycleCalls())
func (mock *NamespacedSSHAuthInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.NamespacedSSHAuthLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NamespacedSSHAuthLifecycle
	}
	lockNamespacedSSHAuthInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockNamespacedSSHAuthInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *NamespacedSSHAuthInterfaceMock) Controller() v31.NamespacedSSHAuthController {
	if mock.ControllerFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.ControllerFunc: method is nil but NamespacedSSHAuthInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedSSHAuthInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockNamespacedSSHAuthInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.ControllerCalls())
func (mock *NamespacedSSHAuthInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedSSHAuthInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockNamespacedSSHAuthInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *NamespacedSSHAuthInterfaceMock) Create(in1 *v3.NamespacedSSHAuth) (*v3.NamespacedSSHAuth, error) {
	if mock.CreateFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.CreateFunc: method is nil but NamespacedSSHAuthInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.NamespacedSSHAuth
	}{
		In1: in1,
	}
	lockNamespacedSSHAuthInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockNamespacedSSHAuthInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.CreateCalls())
func (mock *NamespacedSSHAuthInterfaceMock) CreateCalls() []struct {
	In1 *v3.NamespacedSSHAuth
} {
	var calls []struct {
		In1 *v3.NamespacedSSHAuth
	}
	lockNamespacedSSHAuthInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockNamespacedSSHAuthInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *NamespacedSSHAuthInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.DeleteFunc: method is nil but NamespacedSSHAuthInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockNamespacedSSHAuthInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockNamespacedSSHAuthInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.DeleteCalls())
func (mock *NamespacedSSHAuthInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockNamespacedSSHAuthInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockNamespacedSSHAuthInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *NamespacedSSHAuthInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.DeleteCollectionFunc: method is nil but NamespacedSSHAuthInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockNamespacedSSHAuthInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockNamespacedSSHAuthInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.DeleteCollectionCalls())
func (mock *NamespacedSSHAuthInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockNamespacedSSHAuthInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockNamespacedSSHAuthInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *NamespacedSSHAuthInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.DeleteNamespacedFunc: method is nil but NamespacedSSHAuthInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockNamespacedSSHAuthInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockNamespacedSSHAuthInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.DeleteNamespacedCalls())
func (mock *NamespacedSSHAuthInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockNamespacedSSHAuthInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockNamespacedSSHAuthInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *NamespacedSSHAuthInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.NamespacedSSHAuth, error) {
	if mock.GetFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.GetFunc: method is nil but NamespacedSSHAuthInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockNamespacedSSHAuthInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNamespacedSSHAuthInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.GetCalls())
func (mock *NamespacedSSHAuthInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockNamespacedSSHAuthInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockNamespacedSSHAuthInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *NamespacedSSHAuthInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.NamespacedSSHAuth, error) {
	if mock.GetNamespacedFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.GetNamespacedFunc: method is nil but NamespacedSSHAuthInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockNamespacedSSHAuthInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockNamespacedSSHAuthInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.GetNamespacedCalls())
func (mock *NamespacedSSHAuthInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockNamespacedSSHAuthInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockNamespacedSSHAuthInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NamespacedSSHAuthInterfaceMock) List(opts metav1.ListOptions) (*v3.NamespacedSSHAuthList, error) {
	if mock.ListFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.ListFunc: method is nil but NamespacedSSHAuthInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNamespacedSSHAuthInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNamespacedSSHAuthInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.ListCalls())
func (mock *NamespacedSSHAuthInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNamespacedSSHAuthInterfaceMockList.RLock()
	calls = mock.calls.List
	lockNamespacedSSHAuthInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *NamespacedSSHAuthInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.NamespacedSSHAuthList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.ListNamespacedFunc: method is nil but NamespacedSSHAuthInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockNamespacedSSHAuthInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockNamespacedSSHAuthInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.ListNamespacedCalls())
func (mock *NamespacedSSHAuthInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockNamespacedSSHAuthInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockNamespacedSSHAuthInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *NamespacedSSHAuthInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.ObjectClientFunc: method is nil but NamespacedSSHAuthInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockNamespacedSSHAuthInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockNamespacedSSHAuthInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.ObjectClientCalls())
func (mock *NamespacedSSHAuthInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespacedSSHAuthInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockNamespacedSSHAuthInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *NamespacedSSHAuthInterfaceMock) Update(in1 *v3.NamespacedSSHAuth) (*v3.NamespacedSSHAuth, error) {
	if mock.UpdateFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.UpdateFunc: method is nil but NamespacedSSHAuthInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.NamespacedSSHAuth
	}{
		In1: in1,
	}
	lockNamespacedSSHAuthInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockNamespacedSSHAuthInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.UpdateCalls())
func (mock *NamespacedSSHAuthInterfaceMock) UpdateCalls() []struct {
	In1 *v3.NamespacedSSHAuth
} {
	var calls []struct {
		In1 *v3.NamespacedSSHAuth
	}
	lockNamespacedSSHAuthInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockNamespacedSSHAuthInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *NamespacedSSHAuthInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("NamespacedSSHAuthInterfaceMock.WatchFunc: method is nil but NamespacedSSHAuthInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNamespacedSSHAuthInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockNamespacedSSHAuthInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthInterface.WatchCalls())
func (mock *NamespacedSSHAuthInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNamespacedSSHAuthInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockNamespacedSSHAuthInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockNamespacedSSHAuthsGetterMockNamespacedSSHAuths sync.RWMutex
)

// Ensure, that NamespacedSSHAuthsGetterMock does implement v31.NamespacedSSHAuthsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.NamespacedSSHAuthsGetter = &NamespacedSSHAuthsGetterMock{}

// NamespacedSSHAuthsGetterMock is a mock implementation of v31.NamespacedSSHAuthsGetter.
//
//	    func TestSomethingThatUsesNamespacedSSHAuthsGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.NamespacedSSHAuthsGetter
//	        mockedNamespacedSSHAuthsGetter := &NamespacedSSHAuthsGetterMock{
//	            NamespacedSSHAuthsFunc: func(namespace string) v31.NamespacedSSHAuthInterface {
//		               panic("mock out the NamespacedSSHAuths method")
//	            },
//	        }
//
//	        // use mockedNamespacedSSHAuthsGetter in code that requires v31.NamespacedSSHAuthsGetter
//	        // and then make assertions.
//
//	    }
type NamespacedSSHAuthsGetterMock struct {
	// NamespacedSSHAuthsFunc mocks the NamespacedSSHAuths method.
	NamespacedSSHAuthsFunc func(namespace string) v31.NamespacedSSHAuthInterface

	// calls tracks calls to the methods.
	calls struct {
		// NamespacedSSHAuths holds details about calls to the NamespacedSSHAuths method.
		NamespacedSSHAuths []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// NamespacedSSHAuths calls NamespacedSSHAuthsFunc.
func (mock *NamespacedSSHAuthsGetterMock) NamespacedSSHAuths(namespace string) v31.NamespacedSSHAuthInterface {
	if mock.NamespacedSSHAuthsFunc == nil {
		panic("NamespacedSSHAuthsGetterMock.NamespacedSSHAuthsFunc: method is nil but NamespacedSSHAuthsGetter.NamespacedSSHAuths was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockNamespacedSSHAuthsGetterMockNamespacedSSHAuths.Lock()
	mock.calls.NamespacedSSHAuths = append(mock.calls.NamespacedSSHAuths, callInfo)
	lockNamespacedSSHAuthsGetterMockNamespacedSSHAuths.Unlock()
	return mock.NamespacedSSHAuthsFunc(namespace)
}

// NamespacedSSHAuthsCalls gets all the calls that were made to NamespacedSSHAuths.
// Check the length with:
//
//	len(mockedNamespacedSSHAuthsGetter.NamespacedSSHAuthsCalls())
func (mock *NamespacedSSHAuthsGetterMock) NamespacedSSHAuthsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockNamespacedSSHAuthsGetterMockNamespacedSSHAuths.RLock()
	calls = mock.calls.NamespacedSSHAuths
	lockNamespacedSSHAuthsGetterMockNamespacedSSHAuths.RUnlock()
	return calls
}
