// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockServiceAccountTokenListerMockGet  sync.RWMutex
	lockServiceAccountTokenListerMockList sync.RWMutex
)

// Ensure, that ServiceAccountTokenListerMock does implement v31.ServiceAccountTokenLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ServiceAccountTokenLister = &ServiceAccountTokenListerMock{}

// ServiceAccountTokenListerMock is a mock implementation of v31.ServiceAccountTokenLister.
//
//	    func TestSomethingThatUsesServiceAccountTokenLister(t *testing.T) {
//
//	        // make and configure a mocked v31.ServiceAccountTokenLister
//	        mockedServiceAccountTokenLister := &ServiceAccountTokenListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.ServiceAccountToken, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ServiceAccountToken, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedServiceAccountTokenLister in code that requires v31.ServiceAccountTokenLister
//	        // and then make assertions.
//
//	    }
type ServiceAccountTokenListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ServiceAccountToken, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ServiceAccountToken, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ServiceAccountTokenListerMock) Get(namespace string, name string) (*v3.ServiceAccountToken, error) {
	if mock.GetFunc == nil {
		panic("ServiceAccountTokenListerMock.GetFunc: method is nil but ServiceAccountTokenLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockServiceAccountTokenListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockServiceAccountTokenListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedServiceAccountTokenLister.GetCalls())
func (mock *ServiceAccountTokenListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockServiceAccountTokenListerMockGet.RLock()
	calls = mock.calls.Get
	lockServiceAccountTokenListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ServiceAccountTokenListerMock) List(namespace string, selector labels.Selector) ([]*v3.ServiceAccountToken, error) {
	if mock.ListFunc == nil {
		panic("ServiceAccountTokenListerMock.ListFunc: method is nil but ServiceAccountTokenLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockServiceAccountTokenListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockServiceAccountTokenListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedServiceAccountTokenLister.ListCalls())
func (mock *ServiceAccountTokenListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockServiceAccountTokenListerMockList.RLock()
	calls = mock.calls.List
	lockServiceAccountTokenListerMockList.RUnlock()
	return calls
}

var (
	lockServiceAccountTokenControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockServiceAccountTokenControllerMockAddClusterScopedHandler        sync.RWMutex
	lockServiceAccountTokenControllerMockAddFeatureHandler              sync.RWMutex
	lockServiceAccountTokenControllerMockAddHandler                     sync.RWMutex
	lockServiceAccountTokenControllerMockEnqueue                        sync.RWMutex
	lockServiceAccountTokenControllerMockEnqueueAfter                   sync.RWMutex
	lockServiceAccountTokenControllerMockGeneric                        sync.RWMutex
	lockServiceAccountTokenControllerMockInformer                       sync.RWMutex
	lockServiceAccountTokenControllerMockLister                         sync.RWMutex
)

// Ensure, that ServiceAccountTokenControllerMock does implement v31.ServiceAccountTokenController.
// If this is not the case, regenerate this file with moq.
var _ v31.ServiceAccountTokenController = &ServiceAccountTokenControllerMock{}

// ServiceAccountTokenControllerMock is a mock implementation of v31.ServiceAccountTokenController.
//
//	    func TestSomethingThatUsesServiceAccountTokenController(t *testing.T) {
//
//	        // make and configure a mocked v31.ServiceAccountTokenController
//	        mockedServiceAccountTokenController := &ServiceAccountTokenControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.ServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.ServiceAccountTokenLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedServiceAccountTokenController in code that requires v31.ServiceAccountTokenController
//	        // and then make assertions.
//
//	    }
type ServiceAccountTokenControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ServiceAccountTokenHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ServiceAccountTokenHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ServiceAccountTokenHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ServiceAccountTokenHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ServiceAccountTokenLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ServiceAccountTokenHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ServiceAccountTokenHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ServiceAccountTokenHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ServiceAccountTokenHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ServiceAccountTokenControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ServiceAccountTokenHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ServiceAccountTokenControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ServiceAccountTokenController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ServiceAccountTokenHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockServiceAccountTokenControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockServiceAccountTokenControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedServiceAccountTokenController.AddClusterScopedFeatureHandlerCalls())
func (mock *ServiceAccountTokenControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ServiceAccountTokenHandlerFunc
	}
	lockServiceAccountTokenControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockServiceAccountTokenControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ServiceAccountTokenControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ServiceAccountTokenHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ServiceAccountTokenControllerMock.AddClusterScopedHandlerFunc: method is nil but ServiceAccountTokenController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ServiceAccountTokenHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockServiceAccountTokenControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockServiceAccountTokenControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedServiceAccountTokenController.AddClusterScopedHandlerCalls())
func (mock *ServiceAccountTokenControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ServiceAccountTokenHandlerFunc
	}
	lockServiceAccountTokenControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockServiceAccountTokenControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ServiceAccountTokenControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ServiceAccountTokenHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ServiceAccountTokenControllerMock.AddFeatureHandlerFunc: method is nil but ServiceAccountTokenController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ServiceAccountTokenHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockServiceAccountTokenControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockServiceAccountTokenControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedServiceAccountTokenController.AddFeatureHandlerCalls())
func (mock *ServiceAccountTokenControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ServiceAccountTokenHandlerFunc
	}
	lockServiceAccountTokenControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockServiceAccountTokenControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ServiceAccountTokenControllerMock) AddHandler(ctx context.Context, name string, handler v31.ServiceAccountTokenHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ServiceAccountTokenControllerMock.AddHandlerFunc: method is nil but ServiceAccountTokenController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ServiceAccountTokenHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockServiceAccountTokenControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockServiceAccountTokenControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedServiceAccountTokenController.AddHandlerCalls())
func (mock *ServiceAccountTokenControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ServiceAccountTokenHandlerFunc
	}
	lockServiceAccountTokenControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockServiceAccountTokenControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ServiceAccountTokenControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ServiceAccountTokenControllerMock.EnqueueFunc: method is nil but ServiceAccountTokenController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockServiceAccountTokenControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockServiceAccountTokenControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedServiceAccountTokenController.EnqueueCalls())
func (mock *ServiceAccountTokenControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockServiceAccountTokenControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockServiceAccountTokenControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ServiceAccountTokenControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ServiceAccountTokenControllerMock.EnqueueAfterFunc: method is nil but ServiceAccountTokenController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockServiceAccountTokenControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockServiceAccountTokenControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedServiceAccountTokenController.EnqueueAfterCalls())
func (mock *ServiceAccountTokenControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockServiceAccountTokenControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockServiceAccountTokenControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ServiceAccountTokenControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ServiceAccountTokenControllerMock.GenericFunc: method is nil but ServiceAccountTokenController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockServiceAccountTokenControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockServiceAccountTokenControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedServiceAccountTokenController.GenericCalls())
func (mock *ServiceAccountTokenControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceAccountTokenControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockServiceAccountTokenControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ServiceAccountTokenControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ServiceAccountTokenControllerMock.InformerFunc: method is nil but ServiceAccountTokenController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockServiceAccountTokenControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockServiceAccountTokenControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedServiceAccountTokenController.InformerCalls())
func (mock *ServiceAccountTokenControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceAccountTokenControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockServiceAccountTokenControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ServiceAccountTokenControllerMock) Lister() v31.ServiceAccountTokenLister {
	if mock.ListerFunc == nil {
		panic("ServiceAccountTokenControllerMock.ListerFunc: method is nil but ServiceAccountTokenController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockServiceAccountTokenControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockServiceAccountTokenControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedServiceAccountTokenController.ListerCalls())
func (mock *ServiceAccountTokenControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceAccountTokenControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockServiceAccountTokenControllerMockLister.RUnlock()
	return calls
}

var (
	lockServiceAccountTokenInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockServiceAccountTokenInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockServiceAccountTokenInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockServiceAccountTokenInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockServiceAccountTokenInterfaceMockAddFeatureHandler                sync.RWMutex
	lockServiceAccountTokenInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockServiceAccountTokenInterfaceMockAddHandler                       sync.RWMutex
	lockServiceAccountTokenInterfaceMockAddLifecycle                     sync.RWMutex
	lockServiceAccountTokenInterfaceMockController                       sync.RWMutex
	lockServiceAccountTokenInterfaceMockCreate                           sync.RWMutex
	lockServiceAccountTokenInterfaceMockDelete                           sync.RWMutex
	lockServiceAccountTokenInterfaceMockDeleteCollection                 sync.RWMutex
	lockServiceAccountTokenInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockServiceAccountTokenInterfaceMockGet                              sync.RWMutex
	lockServiceAccountTokenInterfaceMockGetNamespaced                    sync.RWMutex
	lockServiceAccountTokenInterfaceMockList                             sync.RWMutex
	lockServiceAccountTokenInterfaceMockListNamespaced                   sync.RWMutex
	lockServiceAccountTokenInterfaceMockObjectClient                     sync.RWMutex
	lockServiceAccountTokenInterfaceMockUpdate                           sync.RWMutex
	lockServiceAccountTokenInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ServiceAccountTokenInterfaceMock does implement v31.ServiceAccountTokenInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ServiceAccountTokenInterface = &ServiceAccountTokenInterfaceMock{}

// ServiceAccountTokenInterfaceMock is a mock implementation of v31.ServiceAccountTokenInterface.
//
//	    func TestSomethingThatUsesServiceAccountTokenInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.ServiceAccountTokenInterface
//	        mockedServiceAccountTokenInterface := &ServiceAccountTokenInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ServiceAccountTokenLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ServiceAccountTokenLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ServiceAccountTokenLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ServiceAccountTokenHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ServiceAccountTokenLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.ServiceAccountTokenController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.ServiceAccountToken) (*v3.ServiceAccountToken, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.ServiceAccountToken, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ServiceAccountToken, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.ServiceAccountTokenList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ServiceAccountTokenList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.ServiceAccountToken) (*v3.ServiceAccountToken, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedServiceAccountTokenInterface in code that requires v31.ServiceAccountTokenInterface
//	        // and then make assertions.
//
//	    }
type ServiceAccountTokenInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ServiceAccountTokenHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ServiceAccountTokenLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ServiceAccountTokenHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ServiceAccountTokenLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ServiceAccountTokenHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ServiceAccountTokenLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ServiceAccountTokenHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ServiceAccountTokenLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ServiceAccountTokenController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ServiceAccountToken) (*v3.ServiceAccountToken, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ServiceAccountToken, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ServiceAccountToken, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ServiceAccountTokenList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ServiceAccountTokenList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ServiceAccountToken) (*v3.ServiceAccountToken, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ServiceAccountTokenHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ServiceAccountTokenLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ServiceAccountTokenHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ServiceAccountTokenLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ServiceAccountTokenHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ServiceAccountTokenLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ServiceAccountTokenHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ServiceAccountTokenLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ServiceAccountToken
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ServiceAccountToken
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ServiceAccountTokenInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ServiceAccountTokenHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ServiceAccountTokenInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ServiceAccountTokenHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockServiceAccountTokenInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockServiceAccountTokenInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ServiceAccountTokenInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ServiceAccountTokenHandlerFunc
	}
	lockServiceAccountTokenInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockServiceAccountTokenInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ServiceAccountTokenInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ServiceAccountTokenLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ServiceAccountTokenInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ServiceAccountTokenLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockServiceAccountTokenInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockServiceAccountTokenInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ServiceAccountTokenInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ServiceAccountTokenLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ServiceAccountTokenLifecycle
	}
	lockServiceAccountTokenInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockServiceAccountTokenInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ServiceAccountTokenInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ServiceAccountTokenHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ServiceAccountTokenInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ServiceAccountTokenHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockServiceAccountTokenInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockServiceAccountTokenInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.AddClusterScopedHandlerCalls())
func (mock *ServiceAccountTokenInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ServiceAccountTokenHandlerFunc
	}
	lockServiceAccountTokenInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockServiceAccountTokenInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ServiceAccountTokenInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ServiceAccountTokenLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ServiceAccountTokenInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ServiceAccountTokenLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockServiceAccountTokenInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockServiceAccountTokenInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.AddClusterScopedLifecycleCalls())
func (mock *ServiceAccountTokenInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ServiceAccountTokenLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ServiceAccountTokenLifecycle
	}
	lockServiceAccountTokenInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockServiceAccountTokenInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ServiceAccountTokenInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ServiceAccountTokenHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.AddFeatureHandlerFunc: method is nil but ServiceAccountTokenInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ServiceAccountTokenHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockServiceAccountTokenInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockServiceAccountTokenInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.AddFeatureHandlerCalls())
func (mock *ServiceAccountTokenInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ServiceAccountTokenHandlerFunc
	}
	lockServiceAccountTokenInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockServiceAccountTokenInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ServiceAccountTokenInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ServiceAccountTokenLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.AddFeatureLifecycleFunc: method is nil but ServiceAccountTokenInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ServiceAccountTokenLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockServiceAccountTokenInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockServiceAccountTokenInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.AddFeatureLifecycleCalls())
func (mock *ServiceAccountTokenInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ServiceAccountTokenLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ServiceAccountTokenLifecycle
	}
	lockServiceAccountTokenInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockServiceAccountTokenInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ServiceAccountTokenInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ServiceAccountTokenHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.AddHandlerFunc: method is nil but ServiceAccountTokenInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ServiceAccountTokenHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockServiceAccountTokenInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockServiceAccountTokenInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.AddHandlerCalls())
func (mock *ServiceAccountTokenInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ServiceAccountTokenHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ServiceAccountTokenHandlerFunc
	}
	lockServiceAccountTokenInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockServiceAccountTokenInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ServiceAccountTokenInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ServiceAccountTokenLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.AddLifecycleFunc: method is nil but ServiceAccountTokenInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ServiceAccountTokenLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockServiceAccountTokenInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockServiceAccountTokenInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.AddLifecycleCalls())
func (mock *ServiceAccountTokenInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ServiceAccountTokenLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ServiceAccountTokenLifecycle
	}
	lockServiceAccountTokenInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockServiceAccountTokenInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ServiceAccountTokenInterfaceMock) Controller() v31.ServiceAccountTokenController {
	if mock.ControllerFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.ControllerFunc: method is nil but ServiceAccountTokenInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockServiceAccountTokenInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockServiceAccountTokenInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.ControllerCalls())
func (mock *ServiceAccountTokenInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceAccountTokenInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockServiceAccountTokenInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ServiceAccountTokenInterfaceMock) Create(in1 *v3.ServiceAccountToken) (*v3.ServiceAccountToken, error) {
	if mock.CreateFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.CreateFunc: method is nil but ServiceAccountTokenInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ServiceAccountToken
	}{
		In1: in1,
	}
	lockServiceAccountTokenInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockServiceAccountTokenInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.CreateCalls())
func (mock *ServiceAccountTokenInterfaceMock) CreateCalls() []struct {
	In1 *v3.ServiceAccountToken
} {
	var calls []struct {
		In1 *v3.ServiceAccountToken
	}
	lockServiceAccountTokenInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockServiceAccountTokenInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ServiceAccountTokenInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.DeleteFunc: method is nil but ServiceAccountTokenInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockServiceAccountTokenInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockServiceAccountTokenInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.DeleteCalls())
func (mock *ServiceAccountTokenInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockServiceAccountTokenInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockServiceAccountTokenInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ServiceAccountTokenInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.DeleteCollectionFunc: method is nil but ServiceAccountTokenInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockServiceAccountTokenInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockServiceAccountTokenInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.DeleteCollectionCalls())
func (mock *ServiceAccountTokenInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockServiceAccountTokenInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockServiceAccountTokenInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ServiceAccountTokenInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.DeleteNamespacedFunc: method is nil but ServiceAccountTokenInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockServiceAccountTokenInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockServiceAccountTokenInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.DeleteNamespacedCalls())
func (mock *ServiceAccountTokenInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockServiceAccountTokenInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockServiceAccountTokenInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ServiceAccountTokenInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ServiceAccountToken, error) {
	if mock.GetFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.GetFunc: method is nil but ServiceAccountTokenInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockServiceAccountTokenInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockServiceAccountTokenInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.GetCalls())
func (mock *ServiceAccountTokenInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockServiceAccountTokenInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockServiceAccountTokenInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ServiceAccountTokenInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ServiceAccountToken, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.GetNamespacedFunc: method is nil but ServiceAccountTokenInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockServiceAccountTokenInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockServiceAccountTokenInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.GetNamespacedCalls())
func (mock *ServiceAccountTokenInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockServiceAccountTokenInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockServiceAccountTokenInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ServiceAccountTokenInterfaceMock) List(opts metav1.ListOptions) (*v3.ServiceAccountTokenList, error) {
	if mock.ListFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.ListFunc: method is nil but ServiceAccountTokenInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockServiceAccountTokenInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockServiceAccountTokenInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.ListCalls())
func (mock *ServiceAccountTokenInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockServiceAccountTokenInterfaceMockList.RLock()
	calls = mock.calls.List
	lockServiceAccountTokenInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ServiceAccountTokenInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ServiceAccountTokenList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.ListNamespacedFunc: method is nil but ServiceAccountTokenInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockServiceAccountTokenInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockServiceAccountTokenInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.ListNamespacedCalls())
func (mock *ServiceAccountTokenInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockServiceAccountTokenInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockServiceAccountTokenInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ServiceAccountTokenInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.ObjectClientFunc: method is nil but ServiceAccountTokenInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockServiceAccountTokenInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockServiceAccountTokenInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.ObjectClientCalls())
func (mock *ServiceAccountTokenInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceAccountTokenInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockServiceAccountTokenInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ServiceAccountTokenInterfaceMock) Update(in1 *v3.ServiceAccountToken) (*v3.ServiceAccountToken, error) {
	if mock.UpdateFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.UpdateFunc: method is nil but ServiceAccountTokenInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ServiceAccountToken
	}{
		In1: in1,
	}
	lockServiceAccountTokenInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockServiceAccountTokenInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.UpdateCalls())
func (mock *ServiceAccountTokenInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ServiceAccountToken
} {
	var calls []struct {
		In1 *v3.ServiceAccountToken
	}
	lockServiceAccountTokenInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockServiceAccountTokenInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ServiceAccountTokenInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ServiceAccountTokenInterfaceMock.WatchFunc: method is nil but ServiceAccountTokenInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockServiceAccountTokenInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockServiceAccountTokenInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedServiceAccountTokenInterface.WatchCalls())
func (mock *ServiceAccountTokenInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockServiceAccountTokenInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockServiceAccountTokenInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockServiceAccountTokensGetterMockServiceAccountTokens sync.RWMutex
)

// Ensure, that ServiceAccountTokensGetterMock does implement v31.ServiceAccountTokensGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ServiceAccountTokensGetter = &ServiceAccountTokensGetterMock{}

// ServiceAccountTokensGetterMock is a mock implementation of v31.ServiceAccountTokensGetter.
//
//	    func TestSomethingThatUsesServiceAccountTokensGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.ServiceAccountTokensGetter
//	        mockedServiceAccountTokensGetter := &ServiceAccountTokensGetterMock{
//	            ServiceAccountTokensFunc: func(namespace string) v31.ServiceAccountTokenInterface {
//		               panic("mock out the ServiceAccountTokens method")
//	            },
//	        }
//
//	        // use mockedServiceAccountTokensGetter in code that requires v31.ServiceAccountTokensGetter
//	        // and then make assertions.
//
//	    }
type ServiceAccountTokensGetterMock struct {
	// ServiceAccountTokensFunc mocks the ServiceAccountTokens method.
	ServiceAccountTokensFunc func(namespace string) v31.ServiceAccountTokenInterface

	// calls tracks calls to the methods.
	calls struct {
		// ServiceAccountTokens holds details about calls to the ServiceAccountTokens method.
		ServiceAccountTokens []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ServiceAccountTokens calls ServiceAccountTokensFunc.
func (mock *ServiceAccountTokensGetterMock) ServiceAccountTokens(namespace string) v31.ServiceAccountTokenInterface {
	if mock.ServiceAccountTokensFunc == nil {
		panic("ServiceAccountTokensGetterMock.ServiceAccountTokensFunc: method is nil but ServiceAccountTokensGetter.ServiceAccountTokens was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockServiceAccountTokensGetterMockServiceAccountTokens.Lock()
	mock.calls.ServiceAccountTokens = append(mock.calls.ServiceAccountTokens, callInfo)
	lockServiceAccountTokensGetterMockServiceAccountTokens.Unlock()
	return mock.ServiceAccountTokensFunc(namespace)
}

// ServiceAccountTokensCalls gets all the calls that were made to ServiceAccountTokens.
// Check the length with:
//
//	len(mockedServiceAccountTokensGetter.ServiceAccountTokensCalls())
func (mock *ServiceAccountTokensGetterMock) ServiceAccountTokensCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockServiceAccountTokensGetterMockServiceAccountTokens.RLock()
	calls = mock.calls.ServiceAccountTokens
	lockServiceAccountTokensGetterMockServiceAccountTokens.RUnlock()
	return calls
}
