// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockSSHAuthListerMockGet  sync.RWMutex
	lockSSHAuthListerMockList sync.RWMutex
)

// Ensure, that SSHAuthListerMock does implement v31.SSHAuthLister.
// If this is not the case, regenerate this file with moq.
var _ v31.SSHAuthLister = &SSHAuthListerMock{}

// SSHAuthListerMock is a mock implementation of v31.SSHAuthLister.
//
//	    func TestSomethingThatUsesSSHAuthLister(t *testing.T) {
//
//	        // make and configure a mocked v31.SSHAuthLister
//	        mockedSSHAuthLister := &SSHAuthListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.SSHAuth, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.SSHAuth, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedSSHAuthLister in code that requires v31.SSHAuthLister
//	        // and then make assertions.
//
//	    }
type SSHAuthListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.SSHAuth, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.SSHAuth, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *SSHAuthListerMock) Get(namespace string, name string) (*v3.SSHAuth, error) {
	if mock.GetFunc == nil {
		panic("SSHAuthListerMock.GetFunc: method is nil but SSHAuthLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockSSHAuthListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockSSHAuthListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedSSHAuthLister.GetCalls())
func (mock *SSHAuthListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockSSHAuthListerMockGet.RLock()
	calls = mock.calls.Get
	lockSSHAuthListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *SSHAuthListerMock) List(namespace string, selector labels.Selector) ([]*v3.SSHAuth, error) {
	if mock.ListFunc == nil {
		panic("SSHAuthListerMock.ListFunc: method is nil but SSHAuthLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockSSHAuthListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockSSHAuthListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedSSHAuthLister.ListCalls())
func (mock *SSHAuthListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockSSHAuthListerMockList.RLock()
	calls = mock.calls.List
	lockSSHAuthListerMockList.RUnlock()
	return calls
}

var (
	lockSSHAuthControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockSSHAuthControllerMockAddClusterScopedHandler        sync.RWMutex
	lockSSHAuthControllerMockAddFeatureHandler              sync.RWMutex
	lockSSHAuthControllerMockAddHandler                     sync.RWMutex
	lockSSHAuthControllerMockEnqueue                        sync.RWMutex
	lockSSHAuthControllerMockEnqueueAfter                   sync.RWMutex
	lockSSHAuthControllerMockGeneric                        sync.RWMutex
	lockSSHAuthControllerMockInformer                       sync.RWMutex
	lockSSHAuthControllerMockLister                         sync.RWMutex
)

// Ensure, that SSHAuthControllerMock does implement v31.SSHAuthController.
// If this is not the case, regenerate this file with moq.
var _ v31.SSHAuthController = &SSHAuthControllerMock{}

// SSHAuthControllerMock is a mock implementation of v31.SSHAuthController.
//
//	    func TestSomethingThatUsesSSHAuthController(t *testing.T) {
//
//	        // make and configure a mocked v31.SSHAuthController
//	        mockedSSHAuthController := &SSHAuthControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SSHAuthHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.SSHAuthHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SSHAuthHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.SSHAuthHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.SSHAuthLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedSSHAuthController in code that requires v31.SSHAuthController
//	        // and then make assertions.
//
//	    }
type SSHAuthControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SSHAuthHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.SSHAuthHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SSHAuthHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.SSHAuthHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.SSHAuthLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.SSHAuthHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.SSHAuthHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SSHAuthHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.SSHAuthHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *SSHAuthControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.SSHAuthHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("SSHAuthControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but SSHAuthController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.SSHAuthHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockSSHAuthControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockSSHAuthControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedSSHAuthController.AddClusterScopedFeatureHandlerCalls())
func (mock *SSHAuthControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.SSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.SSHAuthHandlerFunc
	}
	lockSSHAuthControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockSSHAuthControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *SSHAuthControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.SSHAuthHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("SSHAuthControllerMock.AddClusterScopedHandlerFunc: method is nil but SSHAuthController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.SSHAuthHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockSSHAuthControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockSSHAuthControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedSSHAuthController.AddClusterScopedHandlerCalls())
func (mock *SSHAuthControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.SSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.SSHAuthHandlerFunc
	}
	lockSSHAuthControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockSSHAuthControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *SSHAuthControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SSHAuthHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("SSHAuthControllerMock.AddFeatureHandlerFunc: method is nil but SSHAuthController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SSHAuthHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockSSHAuthControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockSSHAuthControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedSSHAuthController.AddFeatureHandlerCalls())
func (mock *SSHAuthControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.SSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SSHAuthHandlerFunc
	}
	lockSSHAuthControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockSSHAuthControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *SSHAuthControllerMock) AddHandler(ctx context.Context, name string, handler v31.SSHAuthHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("SSHAuthControllerMock.AddHandlerFunc: method is nil but SSHAuthController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.SSHAuthHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockSSHAuthControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockSSHAuthControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedSSHAuthController.AddHandlerCalls())
func (mock *SSHAuthControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.SSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.SSHAuthHandlerFunc
	}
	lockSSHAuthControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockSSHAuthControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *SSHAuthControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("SSHAuthControllerMock.EnqueueFunc: method is nil but SSHAuthController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockSSHAuthControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockSSHAuthControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedSSHAuthController.EnqueueCalls())
func (mock *SSHAuthControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockSSHAuthControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockSSHAuthControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *SSHAuthControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("SSHAuthControllerMock.EnqueueAfterFunc: method is nil but SSHAuthController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockSSHAuthControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockSSHAuthControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedSSHAuthController.EnqueueAfterCalls())
func (mock *SSHAuthControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockSSHAuthControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockSSHAuthControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *SSHAuthControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("SSHAuthControllerMock.GenericFunc: method is nil but SSHAuthController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockSSHAuthControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockSSHAuthControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedSSHAuthController.GenericCalls())
func (mock *SSHAuthControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockSSHAuthControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockSSHAuthControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *SSHAuthControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("SSHAuthControllerMock.InformerFunc: method is nil but SSHAuthController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockSSHAuthControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockSSHAuthControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedSSHAuthController.InformerCalls())
func (mock *SSHAuthControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockSSHAuthControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockSSHAuthControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *SSHAuthControllerMock) Lister() v31.SSHAuthLister {
	if mock.ListerFunc == nil {
		panic("SSHAuthControllerMock.ListerFunc: method is nil but SSHAuthController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockSSHAuthControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockSSHAuthControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedSSHAuthController.ListerCalls())
func (mock *SSHAuthControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockSSHAuthControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockSSHAuthControllerMockLister.RUnlock()
	return calls
}

var (
	lockSSHAuthInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockSSHAuthInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockSSHAuthInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockSSHAuthInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockSSHAuthInterfaceMockAddFeatureHandler                sync.RWMutex
	lockSSHAuthInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockSSHAuthInterfaceMockAddHandler                       sync.RWMutex
	lockSSHAuthInterfaceMockAddLifecycle                     sync.RWMutex
	lockSSHAuthInterfaceMockController                       sync.RWMutex
	lockSSHAuthInterfaceMockCreate                           sync.RWMutex
	lockSSHAuthInterfaceMockDelete                           sync.RWMutex
	lockSSHAuthInterfaceMockDeleteCollection                 sync.RWMutex
	lockSSHAuthInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockSSHAuthInterfaceMockGet                              sync.RWMutex
	lockSSHAuthInterfaceMockGetNamespaced                    sync.RWMutex
	lockSSHAuthInterfaceMockList                             sync.RWMutex
	lockSSHAuthInterfaceMockListNamespaced                   sync.RWMutex
	lockSSHAuthInterfaceMockObjectClient                     sync.RWMutex
	lockSSHAuthInterfaceMockUpdate                           sync.RWMutex
	lockSSHAuthInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that SSHAuthInterfaceMock does implement v31.SSHAuthInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.SSHAuthInterface = &SSHAuthInterfaceMock{}

// SSHAuthInterfaceMock is a mock implementation of v31.SSHAuthInterface.
//
//	    func TestSomethingThatUsesSSHAuthInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.SSHAuthInterface
//	        mockedSSHAuthInterface := &SSHAuthInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SSHAuthHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SSHAuthLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.SSHAuthHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.SSHAuthLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SSHAuthHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.SSHAuthLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.SSHAuthHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.SSHAuthLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.SSHAuthController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.SSHAuth) (*v3.SSHAuth, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.SSHAuth, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.SSHAuth, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.SSHAuthList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.SSHAuthList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.SSHAuth) (*v3.SSHAuth, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedSSHAuthInterface in code that requires v31.SSHAuthInterface
//	        // and then make assertions.
//
//	    }
type SSHAuthInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SSHAuthHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SSHAuthLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.SSHAuthHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.SSHAuthLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SSHAuthHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.SSHAuthLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.SSHAuthHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.SSHAuthLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.SSHAuthController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.SSHAuth) (*v3.SSHAuth, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.SSHAuth, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.SSHAuth, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.SSHAuthList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.SSHAuthList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.SSHAuth) (*v3.SSHAuth, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.SSHAuthHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SSHAuthLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.SSHAuthHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SSHAuthLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SSHAuthHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SSHAuthLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.SSHAuthHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.SSHAuthLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.SSHAuth
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.SSHAuth
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *SSHAuthInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.SSHAuthHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("SSHAuthInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but SSHAuthInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.SSHAuthHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockSSHAuthInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockSSHAuthInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedSSHAuthInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *SSHAuthInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.SSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.SSHAuthHandlerFunc
	}
	lockSSHAuthInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockSSHAuthInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *SSHAuthInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.SSHAuthLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("SSHAuthInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but SSHAuthInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.SSHAuthLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockSSHAuthInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockSSHAuthInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedSSHAuthInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *SSHAuthInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.SSHAuthLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.SSHAuthLifecycle
	}
	lockSSHAuthInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockSSHAuthInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *SSHAuthInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.SSHAuthHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("SSHAuthInterfaceMock.AddClusterScopedHandlerFunc: method is nil but SSHAuthInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.SSHAuthHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockSSHAuthInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockSSHAuthInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedSSHAuthInterface.AddClusterScopedHandlerCalls())
func (mock *SSHAuthInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.SSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.SSHAuthHandlerFunc
	}
	lockSSHAuthInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockSSHAuthInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *SSHAuthInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.SSHAuthLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("SSHAuthInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but SSHAuthInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.SSHAuthLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockSSHAuthInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockSSHAuthInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedSSHAuthInterface.AddClusterScopedLifecycleCalls())
func (mock *SSHAuthInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.SSHAuthLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.SSHAuthLifecycle
	}
	lockSSHAuthInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockSSHAuthInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *SSHAuthInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.SSHAuthHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("SSHAuthInterfaceMock.AddFeatureHandlerFunc: method is nil but SSHAuthInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SSHAuthHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockSSHAuthInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockSSHAuthInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedSSHAuthInterface.AddFeatureHandlerCalls())
func (mock *SSHAuthInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.SSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.SSHAuthHandlerFunc
	}
	lockSSHAuthInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockSSHAuthInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *SSHAuthInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.SSHAuthLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("SSHAuthInterfaceMock.AddFeatureLifecycleFunc: method is nil but SSHAuthInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.SSHAuthLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockSSHAuthInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockSSHAuthInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedSSHAuthInterface.AddFeatureLifecycleCalls())
func (mock *SSHAuthInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.SSHAuthLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.SSHAuthLifecycle
	}
	lockSSHAuthInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockSSHAuthInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *SSHAuthInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.SSHAuthHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("SSHAuthInterfaceMock.AddHandlerFunc: method is nil but SSHAuthInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.SSHAuthHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockSSHAuthInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockSSHAuthInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedSSHAuthInterface.AddHandlerCalls())
func (mock *SSHAuthInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.SSHAuthHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.SSHAuthHandlerFunc
	}
	lockSSHAuthInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockSSHAuthInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *SSHAuthInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.SSHAuthLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("SSHAuthInterfaceMock.AddLifecycleFunc: method is nil but SSHAuthInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.SSHAuthLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockSSHAuthInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockSSHAuthInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedSSHAuthInterface.AddLifecycleCalls())
func (mock *SSHAuthInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.SSHAuthLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.SSHAuthLifecycle
	}
	lockSSHAuthInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockSSHAuthInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *SSHAuthInterfaceMock) Controller() v31.SSHAuthController {
	if mock.ControllerFunc == nil {
		panic("SSHAuthInterfaceMock.ControllerFunc: method is nil but SSHAuthInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockSSHAuthInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockSSHAuthInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedSSHAuthInterface.ControllerCalls())
func (mock *SSHAuthInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockSSHAuthInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockSSHAuthInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *SSHAuthInterfaceMock) Create(in1 *v3.SSHAuth) (*v3.SSHAuth, error) {
	if mock.CreateFunc == nil {
		panic("SSHAuthInterfaceMock.CreateFunc: method is nil but SSHAuthInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.SSHAuth
	}{
		In1: in1,
	}
	lockSSHAuthInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockSSHAuthInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedSSHAuthInterface.CreateCalls())
func (mock *SSHAuthInterfaceMock) CreateCalls() []struct {
	In1 *v3.SSHAuth
} {
	var calls []struct {
		In1 *v3.SSHAuth
	}
	lockSSHAuthInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockSSHAuthInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *SSHAuthInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("SSHAuthInterfaceMock.DeleteFunc: method is nil but SSHAuthInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockSSHAuthInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockSSHAuthInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedSSHAuthInterface.DeleteCalls())
func (mock *SSHAuthInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockSSHAuthInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockSSHAuthInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *SSHAuthInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("SSHAuthInterfaceMock.DeleteCollectionFunc: method is nil but SSHAuthInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockSSHAuthInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockSSHAuthInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedSSHAuthInterface.DeleteCollectionCalls())
func (mock *SSHAuthInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockSSHAuthInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockSSHAuthInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *SSHAuthInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("SSHAuthInterfaceMock.DeleteNamespacedFunc: method is nil but SSHAuthInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockSSHAuthInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockSSHAuthInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedSSHAuthInterface.DeleteNamespacedCalls())
func (mock *SSHAuthInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockSSHAuthInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockSSHAuthInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *SSHAuthInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.SSHAuth, error) {
	if mock.GetFunc == nil {
		panic("SSHAuthInterfaceMock.GetFunc: method is nil but SSHAuthInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockSSHAuthInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockSSHAuthInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedSSHAuthInterface.GetCalls())
func (mock *SSHAuthInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockSSHAuthInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockSSHAuthInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *SSHAuthInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.SSHAuth, error) {
	if mock.GetNamespacedFunc == nil {
		panic("SSHAuthInterfaceMock.GetNamespacedFunc: method is nil but SSHAuthInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockSSHAuthInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockSSHAuthInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedSSHAuthInterface.GetNamespacedCalls())
func (mock *SSHAuthInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockSSHAuthInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockSSHAuthInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *SSHAuthInterfaceMock) List(opts metav1.ListOptions) (*v3.SSHAuthList, error) {
	if mock.ListFunc == nil {
		panic("SSHAuthInterfaceMock.ListFunc: method is nil but SSHAuthInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockSSHAuthInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockSSHAuthInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedSSHAuthInterface.ListCalls())
func (mock *SSHAuthInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockSSHAuthInterfaceMockList.RLock()
	calls = mock.calls.List
	lockSSHAuthInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *SSHAuthInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.SSHAuthList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("SSHAuthInterfaceMock.ListNamespacedFunc: method is nil but SSHAuthInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockSSHAuthInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockSSHAuthInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedSSHAuthInterface.ListNamespacedCalls())
func (mock *SSHAuthInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockSSHAuthInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockSSHAuthInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *SSHAuthInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("SSHAuthInterfaceMock.ObjectClientFunc: method is nil but SSHAuthInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockSSHAuthInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockSSHAuthInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedSSHAuthInterface.ObjectClientCalls())
func (mock *SSHAuthInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockSSHAuthInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockSSHAuthInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *SSHAuthInterfaceMock) Update(in1 *v3.SSHAuth) (*v3.SSHAuth, error) {
	if mock.UpdateFunc == nil {
		panic("SSHAuthInterfaceMock.UpdateFunc: method is nil but SSHAuthInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.SSHAuth
	}{
		In1: in1,
	}
	lockSSHAuthInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockSSHAuthInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedSSHAuthInterface.UpdateCalls())
func (mock *SSHAuthInterfaceMock) UpdateCalls() []struct {
	In1 *v3.SSHAuth
} {
	var calls []struct {
		In1 *v3.SSHAuth
	}
	lockSSHAuthInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockSSHAuthInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *SSHAuthInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("SSHAuthInterfaceMock.WatchFunc: method is nil but SSHAuthInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockSSHAuthInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockSSHAuthInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedSSHAuthInterface.WatchCalls())
func (mock *SSHAuthInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockSSHAuthInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockSSHAuthInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockSSHAuthsGetterMockSSHAuths sync.RWMutex
)

// Ensure, that SSHAuthsGetterMock does implement v31.SSHAuthsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.SSHAuthsGetter = &SSHAuthsGetterMock{}

// SSHAuthsGetterMock is a mock implementation of v31.SSHAuthsGetter.
//
//	    func TestSomethingThatUsesSSHAuthsGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.SSHAuthsGetter
//	        mockedSSHAuthsGetter := &SSHAuthsGetterMock{
//	            SSHAuthsFunc: func(namespace string) v31.SSHAuthInterface {
//		               panic("mock out the SSHAuths method")
//	            },
//	        }
//
//	        // use mockedSSHAuthsGetter in code that requires v31.SSHAuthsGetter
//	        // and then make assertions.
//
//	    }
type SSHAuthsGetterMock struct {
	// SSHAuthsFunc mocks the SSHAuths method.
	SSHAuthsFunc func(namespace string) v31.SSHAuthInterface

	// calls tracks calls to the methods.
	calls struct {
		// SSHAuths holds details about calls to the SSHAuths method.
		SSHAuths []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// SSHAuths calls SSHAuthsFunc.
func (mock *SSHAuthsGetterMock) SSHAuths(namespace string) v31.SSHAuthInterface {
	if mock.SSHAuthsFunc == nil {
		panic("SSHAuthsGetterMock.SSHAuthsFunc: method is nil but SSHAuthsGetter.SSHAuths was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockSSHAuthsGetterMockSSHAuths.Lock()
	mock.calls.SSHAuths = append(mock.calls.SSHAuths, callInfo)
	lockSSHAuthsGetterMockSSHAuths.Unlock()
	return mock.SSHAuthsFunc(namespace)
}

// SSHAuthsCalls gets all the calls that were made to SSHAuths.
// Check the length with:
//
//	len(mockedSSHAuthsGetter.SSHAuthsCalls())
func (mock *SSHAuthsGetterMock) SSHAuthsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockSSHAuthsGetterMockSSHAuths.RLock()
	calls = mock.calls.SSHAuths
	lockSSHAuthsGetterMockSSHAuths.RUnlock()
	return calls
}
