// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/project.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockWorkloadListerMockGet  sync.RWMutex
	lockWorkloadListerMockList sync.RWMutex
)

// Ensure, that WorkloadListerMock does implement v31.WorkloadLister.
// If this is not the case, regenerate this file with moq.
var _ v31.WorkloadLister = &WorkloadListerMock{}

// WorkloadListerMock is a mock implementation of v31.WorkloadLister.
//
//	    func TestSomethingThatUsesWorkloadLister(t *testing.T) {
//
//	        // make and configure a mocked v31.WorkloadLister
//	        mockedWorkloadLister := &WorkloadListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.Workload, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.Workload, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedWorkloadLister in code that requires v31.WorkloadLister
//	        // and then make assertions.
//
//	    }
type WorkloadListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.Workload, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.Workload, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *WorkloadListerMock) Get(namespace string, name string) (*v3.Workload, error) {
	if mock.GetFunc == nil {
		panic("WorkloadListerMock.GetFunc: method is nil but WorkloadLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockWorkloadListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockWorkloadListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedWorkloadLister.GetCalls())
func (mock *WorkloadListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockWorkloadListerMockGet.RLock()
	calls = mock.calls.Get
	lockWorkloadListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *WorkloadListerMock) List(namespace string, selector labels.Selector) ([]*v3.Workload, error) {
	if mock.ListFunc == nil {
		panic("WorkloadListerMock.ListFunc: method is nil but WorkloadLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockWorkloadListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockWorkloadListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedWorkloadLister.ListCalls())
func (mock *WorkloadListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockWorkloadListerMockList.RLock()
	calls = mock.calls.List
	lockWorkloadListerMockList.RUnlock()
	return calls
}

var (
	lockWorkloadControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockWorkloadControllerMockAddClusterScopedHandler        sync.RWMutex
	lockWorkloadControllerMockAddFeatureHandler              sync.RWMutex
	lockWorkloadControllerMockAddHandler                     sync.RWMutex
	lockWorkloadControllerMockEnqueue                        sync.RWMutex
	lockWorkloadControllerMockEnqueueAfter                   sync.RWMutex
	lockWorkloadControllerMockGeneric                        sync.RWMutex
	lockWorkloadControllerMockInformer                       sync.RWMutex
	lockWorkloadControllerMockLister                         sync.RWMutex
)

// Ensure, that WorkloadControllerMock does implement v31.WorkloadController.
// If this is not the case, regenerate this file with moq.
var _ v31.WorkloadController = &WorkloadControllerMock{}

// WorkloadControllerMock is a mock implementation of v31.WorkloadController.
//
//	    func TestSomethingThatUsesWorkloadController(t *testing.T) {
//
//	        // make and configure a mocked v31.WorkloadController
//	        mockedWorkloadController := &WorkloadControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.WorkloadHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.WorkloadHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.WorkloadHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.WorkloadHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.WorkloadLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedWorkloadController in code that requires v31.WorkloadController
//	        // and then make assertions.
//
//	    }
type WorkloadControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.WorkloadHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.WorkloadHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.WorkloadHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.WorkloadHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.WorkloadLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.WorkloadHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.WorkloadHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.WorkloadHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.WorkloadHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *WorkloadControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.WorkloadHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("WorkloadControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but WorkloadController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.WorkloadHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockWorkloadControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockWorkloadControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedWorkloadController.AddClusterScopedFeatureHandlerCalls())
func (mock *WorkloadControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.WorkloadHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.WorkloadHandlerFunc
	}
	lockWorkloadControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockWorkloadControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *WorkloadControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.WorkloadHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("WorkloadControllerMock.AddClusterScopedHandlerFunc: method is nil but WorkloadController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.WorkloadHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockWorkloadControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockWorkloadControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedWorkloadController.AddClusterScopedHandlerCalls())
func (mock *WorkloadControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.WorkloadHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.WorkloadHandlerFunc
	}
	lockWorkloadControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockWorkloadControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *WorkloadControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.WorkloadHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("WorkloadControllerMock.AddFeatureHandlerFunc: method is nil but WorkloadController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.WorkloadHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockWorkloadControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockWorkloadControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedWorkloadController.AddFeatureHandlerCalls())
func (mock *WorkloadControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.WorkloadHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.WorkloadHandlerFunc
	}
	lockWorkloadControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockWorkloadControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *WorkloadControllerMock) AddHandler(ctx context.Context, name string, handler v31.WorkloadHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("WorkloadControllerMock.AddHandlerFunc: method is nil but WorkloadController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.WorkloadHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockWorkloadControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockWorkloadControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedWorkloadController.AddHandlerCalls())
func (mock *WorkloadControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.WorkloadHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.WorkloadHandlerFunc
	}
	lockWorkloadControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockWorkloadControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *WorkloadControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("WorkloadControllerMock.EnqueueFunc: method is nil but WorkloadController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockWorkloadControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockWorkloadControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedWorkloadController.EnqueueCalls())
func (mock *WorkloadControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockWorkloadControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockWorkloadControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *WorkloadControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("WorkloadControllerMock.EnqueueAfterFunc: method is nil but WorkloadController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockWorkloadControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockWorkloadControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedWorkloadController.EnqueueAfterCalls())
func (mock *WorkloadControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockWorkloadControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockWorkloadControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *WorkloadControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("WorkloadControllerMock.GenericFunc: method is nil but WorkloadController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockWorkloadControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockWorkloadControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedWorkloadController.GenericCalls())
func (mock *WorkloadControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockWorkloadControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockWorkloadControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *WorkloadControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("WorkloadControllerMock.InformerFunc: method is nil but WorkloadController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockWorkloadControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockWorkloadControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedWorkloadController.InformerCalls())
func (mock *WorkloadControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockWorkloadControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockWorkloadControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *WorkloadControllerMock) Lister() v31.WorkloadLister {
	if mock.ListerFunc == nil {
		panic("WorkloadControllerMock.ListerFunc: method is nil but WorkloadController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockWorkloadControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockWorkloadControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedWorkloadController.ListerCalls())
func (mock *WorkloadControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockWorkloadControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockWorkloadControllerMockLister.RUnlock()
	return calls
}

var (
	lockWorkloadInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockWorkloadInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockWorkloadInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockWorkloadInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockWorkloadInterfaceMockAddFeatureHandler                sync.RWMutex
	lockWorkloadInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockWorkloadInterfaceMockAddHandler                       sync.RWMutex
	lockWorkloadInterfaceMockAddLifecycle                     sync.RWMutex
	lockWorkloadInterfaceMockController                       sync.RWMutex
	lockWorkloadInterfaceMockCreate                           sync.RWMutex
	lockWorkloadInterfaceMockDelete                           sync.RWMutex
	lockWorkloadInterfaceMockDeleteCollection                 sync.RWMutex
	lockWorkloadInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockWorkloadInterfaceMockGet                              sync.RWMutex
	lockWorkloadInterfaceMockGetNamespaced                    sync.RWMutex
	lockWorkloadInterfaceMockList                             sync.RWMutex
	lockWorkloadInterfaceMockListNamespaced                   sync.RWMutex
	lockWorkloadInterfaceMockObjectClient                     sync.RWMutex
	lockWorkloadInterfaceMockUpdate                           sync.RWMutex
	lockWorkloadInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that WorkloadInterfaceMock does implement v31.WorkloadInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.WorkloadInterface = &WorkloadInterfaceMock{}

// WorkloadInterfaceMock is a mock implementation of v31.WorkloadInterface.
//
//	    func TestSomethingThatUsesWorkloadInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.WorkloadInterface
//	        mockedWorkloadInterface := &WorkloadInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.WorkloadHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.WorkloadLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.WorkloadHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.WorkloadLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.WorkloadHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.WorkloadLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.WorkloadHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.WorkloadLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.WorkloadController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.Workload) (*v3.Workload, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.Workload, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.Workload, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.WorkloadList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.WorkloadList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.Workload) (*v3.Workload, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedWorkloadInterface in code that requires v31.WorkloadInterface
//	        // and then make assertions.
//
//	    }
type WorkloadInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.WorkloadHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.WorkloadLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.WorkloadHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.WorkloadLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.WorkloadHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.WorkloadLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.WorkloadHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.WorkloadLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.WorkloadController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.Workload) (*v3.Workload, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.Workload, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.Workload, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.WorkloadList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.WorkloadList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.Workload) (*v3.Workload, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.WorkloadHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.WorkloadLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.WorkloadHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.WorkloadLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.WorkloadHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.WorkloadLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.WorkloadHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.WorkloadLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.Workload
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.Workload
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *WorkloadInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.WorkloadHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("WorkloadInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but WorkloadInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.WorkloadHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockWorkloadInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockWorkloadInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedWorkloadInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *WorkloadInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.WorkloadHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.WorkloadHandlerFunc
	}
	lockWorkloadInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockWorkloadInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *WorkloadInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.WorkloadLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("WorkloadInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but WorkloadInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.WorkloadLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockWorkloadInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockWorkloadInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedWorkloadInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *WorkloadInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.WorkloadLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.WorkloadLifecycle
	}
	lockWorkloadInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockWorkloadInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *WorkloadInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.WorkloadHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("WorkloadInterfaceMock.AddClusterScopedHandlerFunc: method is nil but WorkloadInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.WorkloadHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockWorkloadInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockWorkloadInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedWorkloadInterface.AddClusterScopedHandlerCalls())
func (mock *WorkloadInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.WorkloadHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.WorkloadHandlerFunc
	}
	lockWorkloadInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockWorkloadInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *WorkloadInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.WorkloadLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("WorkloadInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but WorkloadInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.WorkloadLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockWorkloadInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockWorkloadInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedWorkloadInterface.AddClusterScopedLifecycleCalls())
func (mock *WorkloadInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.WorkloadLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.WorkloadLifecycle
	}
	lockWorkloadInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockWorkloadInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *WorkloadInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.WorkloadHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("WorkloadInterfaceMock.AddFeatureHandlerFunc: method is nil but WorkloadInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.WorkloadHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockWorkloadInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockWorkloadInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedWorkloadInterface.AddFeatureHandlerCalls())
func (mock *WorkloadInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.WorkloadHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.WorkloadHandlerFunc
	}
	lockWorkloadInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockWorkloadInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *WorkloadInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.WorkloadLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("WorkloadInterfaceMock.AddFeatureLifecycleFunc: method is nil but WorkloadInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.WorkloadLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockWorkloadInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockWorkloadInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedWorkloadInterface.AddFeatureLifecycleCalls())
func (mock *WorkloadInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.WorkloadLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.WorkloadLifecycle
	}
	lockWorkloadInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockWorkloadInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *WorkloadInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.WorkloadHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("WorkloadInterfaceMock.AddHandlerFunc: method is nil but WorkloadInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.WorkloadHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockWorkloadInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockWorkloadInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedWorkloadInterface.AddHandlerCalls())
func (mock *WorkloadInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.WorkloadHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.WorkloadHandlerFunc
	}
	lockWorkloadInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockWorkloadInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *WorkloadInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.WorkloadLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("WorkloadInterfaceMock.AddLifecycleFunc: method is nil but WorkloadInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.WorkloadLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockWorkloadInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockWorkloadInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedWorkloadInterface.AddLifecycleCalls())
func (mock *WorkloadInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.WorkloadLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.WorkloadLifecycle
	}
	lockWorkloadInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockWorkloadInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *WorkloadInterfaceMock) Controller() v31.WorkloadController {
	if mock.ControllerFunc == nil {
		panic("WorkloadInterfaceMock.ControllerFunc: method is nil but WorkloadInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockWorkloadInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockWorkloadInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedWorkloadInterface.ControllerCalls())
func (mock *WorkloadInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockWorkloadInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockWorkloadInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *WorkloadInterfaceMock) Create(in1 *v3.Workload) (*v3.Workload, error) {
	if mock.CreateFunc == nil {
		panic("WorkloadInterfaceMock.CreateFunc: method is nil but WorkloadInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.Workload
	}{
		In1: in1,
	}
	lockWorkloadInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockWorkloadInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedWorkloadInterface.CreateCalls())
func (mock *WorkloadInterfaceMock) CreateCalls() []struct {
	In1 *v3.Workload
} {
	var calls []struct {
		In1 *v3.Workload
	}
	lockWorkloadInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockWorkloadInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *WorkloadInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("WorkloadInterfaceMock.DeleteFunc: method is nil but WorkloadInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockWorkloadInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockWorkloadInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedWorkloadInterface.DeleteCalls())
func (mock *WorkloadInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockWorkloadInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockWorkloadInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *WorkloadInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("WorkloadInterfaceMock.DeleteCollectionFunc: method is nil but WorkloadInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockWorkloadInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockWorkloadInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedWorkloadInterface.DeleteCollectionCalls())
func (mock *WorkloadInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockWorkloadInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockWorkloadInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *WorkloadInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("WorkloadInterfaceMock.DeleteNamespacedFunc: method is nil but WorkloadInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockWorkloadInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockWorkloadInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedWorkloadInterface.DeleteNamespacedCalls())
func (mock *WorkloadInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockWorkloadInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockWorkloadInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *WorkloadInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.Workload, error) {
	if mock.GetFunc == nil {
		panic("WorkloadInterfaceMock.GetFunc: method is nil but WorkloadInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockWorkloadInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockWorkloadInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedWorkloadInterface.GetCalls())
func (mock *WorkloadInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockWorkloadInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockWorkloadInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *WorkloadInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.Workload, error) {
	if mock.GetNamespacedFunc == nil {
		panic("WorkloadInterfaceMock.GetNamespacedFunc: method is nil but WorkloadInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockWorkloadInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockWorkloadInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedWorkloadInterface.GetNamespacedCalls())
func (mock *WorkloadInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockWorkloadInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockWorkloadInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *WorkloadInterfaceMock) List(opts metav1.ListOptions) (*v3.WorkloadList, error) {
	if mock.ListFunc == nil {
		panic("WorkloadInterfaceMock.ListFunc: method is nil but WorkloadInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockWorkloadInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockWorkloadInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedWorkloadInterface.ListCalls())
func (mock *WorkloadInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockWorkloadInterfaceMockList.RLock()
	calls = mock.calls.List
	lockWorkloadInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *WorkloadInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.WorkloadList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("WorkloadInterfaceMock.ListNamespacedFunc: method is nil but WorkloadInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockWorkloadInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockWorkloadInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedWorkloadInterface.ListNamespacedCalls())
func (mock *WorkloadInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockWorkloadInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockWorkloadInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *WorkloadInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("WorkloadInterfaceMock.ObjectClientFunc: method is nil but WorkloadInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockWorkloadInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockWorkloadInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedWorkloadInterface.ObjectClientCalls())
func (mock *WorkloadInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockWorkloadInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockWorkloadInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *WorkloadInterfaceMock) Update(in1 *v3.Workload) (*v3.Workload, error) {
	if mock.UpdateFunc == nil {
		panic("WorkloadInterfaceMock.UpdateFunc: method is nil but WorkloadInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.Workload
	}{
		In1: in1,
	}
	lockWorkloadInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockWorkloadInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedWorkloadInterface.UpdateCalls())
func (mock *WorkloadInterfaceMock) UpdateCalls() []struct {
	In1 *v3.Workload
} {
	var calls []struct {
		In1 *v3.Workload
	}
	lockWorkloadInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockWorkloadInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *WorkloadInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("WorkloadInterfaceMock.WatchFunc: method is nil but WorkloadInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockWorkloadInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockWorkloadInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedWorkloadInterface.WatchCalls())
func (mock *WorkloadInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockWorkloadInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockWorkloadInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockWorkloadsGetterMockWorkloads sync.RWMutex
)

// Ensure, that WorkloadsGetterMock does implement v31.WorkloadsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.WorkloadsGetter = &WorkloadsGetterMock{}

// WorkloadsGetterMock is a mock implementation of v31.WorkloadsGetter.
//
//	    func TestSomethingThatUsesWorkloadsGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.WorkloadsGetter
//	        mockedWorkloadsGetter := &WorkloadsGetterMock{
//	            WorkloadsFunc: func(namespace string) v31.WorkloadInterface {
//		               panic("mock out the Workloads method")
//	            },
//	        }
//
//	        // use mockedWorkloadsGetter in code that requires v31.WorkloadsGetter
//	        // and then make assertions.
//
//	    }
type WorkloadsGetterMock struct {
	// WorkloadsFunc mocks the Workloads method.
	WorkloadsFunc func(namespace string) v31.WorkloadInterface

	// calls tracks calls to the methods.
	calls struct {
		// Workloads holds details about calls to the Workloads method.
		Workloads []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Workloads calls WorkloadsFunc.
func (mock *WorkloadsGetterMock) Workloads(namespace string) v31.WorkloadInterface {
	if mock.WorkloadsFunc == nil {
		panic("WorkloadsGetterMock.WorkloadsFunc: method is nil but WorkloadsGetter.Workloads was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockWorkloadsGetterMockWorkloads.Lock()
	mock.calls.Workloads = append(mock.calls.Workloads, callInfo)
	lockWorkloadsGetterMockWorkloads.Unlock()
	return mock.WorkloadsFunc(namespace)
}

// WorkloadsCalls gets all the calls that were made to Workloads.
// Check the length with:
//
//	len(mockedWorkloadsGetter.WorkloadsCalls())
func (mock *WorkloadsGetterMock) WorkloadsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockWorkloadsGetterMockWorkloads.RLock()
	calls = mock.calls.Workloads
	lockWorkloadsGetterMockWorkloads.RUnlock()
	return calls
}
