// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/rbac.authorization.k8s.io/v1"
	v1 "k8s.io/api/rbac/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockClusterRoleBindingListerMockGet  sync.RWMutex
	lockClusterRoleBindingListerMockList sync.RWMutex
)

// Ensure, that ClusterRoleBindingListerMock does implement v11.ClusterRoleBindingLister.
// If this is not the case, regenerate this file with moq.
var _ v11.ClusterRoleBindingLister = &ClusterRoleBindingListerMock{}

// ClusterRoleBindingListerMock is a mock implementation of v11.ClusterRoleBindingLister.
//
//	    func TestSomethingThatUsesClusterRoleBindingLister(t *testing.T) {
//
//	        // make and configure a mocked v11.ClusterRoleBindingLister
//	        mockedClusterRoleBindingLister := &ClusterRoleBindingListerMock{
//	            GetFunc: func(namespace string, name string) (*v1.ClusterRoleBinding, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v1.ClusterRoleBinding, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedClusterRoleBindingLister in code that requires v11.ClusterRoleBindingLister
//	        // and then make assertions.
//
//	    }
type ClusterRoleBindingListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.ClusterRoleBinding, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.ClusterRoleBinding, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ClusterRoleBindingListerMock) Get(namespace string, name string) (*v1.ClusterRoleBinding, error) {
	if mock.GetFunc == nil {
		panic("ClusterRoleBindingListerMock.GetFunc: method is nil but ClusterRoleBindingLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterRoleBindingListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterRoleBindingListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedClusterRoleBindingLister.GetCalls())
func (mock *ClusterRoleBindingListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterRoleBindingListerMockGet.RLock()
	calls = mock.calls.Get
	lockClusterRoleBindingListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterRoleBindingListerMock) List(namespace string, selector labels.Selector) ([]*v1.ClusterRoleBinding, error) {
	if mock.ListFunc == nil {
		panic("ClusterRoleBindingListerMock.ListFunc: method is nil but ClusterRoleBindingLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockClusterRoleBindingListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterRoleBindingListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedClusterRoleBindingLister.ListCalls())
func (mock *ClusterRoleBindingListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockClusterRoleBindingListerMockList.RLock()
	calls = mock.calls.List
	lockClusterRoleBindingListerMockList.RUnlock()
	return calls
}

var (
	lockClusterRoleBindingControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockClusterRoleBindingControllerMockAddClusterScopedHandler        sync.RWMutex
	lockClusterRoleBindingControllerMockAddFeatureHandler              sync.RWMutex
	lockClusterRoleBindingControllerMockAddHandler                     sync.RWMutex
	lockClusterRoleBindingControllerMockEnqueue                        sync.RWMutex
	lockClusterRoleBindingControllerMockEnqueueAfter                   sync.RWMutex
	lockClusterRoleBindingControllerMockGeneric                        sync.RWMutex
	lockClusterRoleBindingControllerMockInformer                       sync.RWMutex
	lockClusterRoleBindingControllerMockLister                         sync.RWMutex
)

// Ensure, that ClusterRoleBindingControllerMock does implement v11.ClusterRoleBindingController.
// If this is not the case, regenerate this file with moq.
var _ v11.ClusterRoleBindingController = &ClusterRoleBindingControllerMock{}

// ClusterRoleBindingControllerMock is a mock implementation of v11.ClusterRoleBindingController.
//
//	    func TestSomethingThatUsesClusterRoleBindingController(t *testing.T) {
//
//	        // make and configure a mocked v11.ClusterRoleBindingController
//	        mockedClusterRoleBindingController := &ClusterRoleBindingControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ClusterRoleBindingHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.ClusterRoleBindingHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ClusterRoleBindingHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v11.ClusterRoleBindingHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v11.ClusterRoleBindingLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedClusterRoleBindingController in code that requires v11.ClusterRoleBindingController
//	        // and then make assertions.
//
//	    }
type ClusterRoleBindingControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ClusterRoleBindingHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.ClusterRoleBindingHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ClusterRoleBindingHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.ClusterRoleBindingHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.ClusterRoleBindingLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ClusterRoleBindingHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ClusterRoleBindingHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ClusterRoleBindingHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.ClusterRoleBindingHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterRoleBindingControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ClusterRoleBindingHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterRoleBindingControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterRoleBindingController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ClusterRoleBindingHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterRoleBindingControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterRoleBindingControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedClusterRoleBindingController.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterRoleBindingControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.ClusterRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ClusterRoleBindingHandlerFunc
	}
	lockClusterRoleBindingControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterRoleBindingControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterRoleBindingControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.ClusterRoleBindingHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterRoleBindingControllerMock.AddClusterScopedHandlerFunc: method is nil but ClusterRoleBindingController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ClusterRoleBindingHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterRoleBindingControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterRoleBindingControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedClusterRoleBindingController.AddClusterScopedHandlerCalls())
func (mock *ClusterRoleBindingControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.ClusterRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ClusterRoleBindingHandlerFunc
	}
	lockClusterRoleBindingControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterRoleBindingControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterRoleBindingControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ClusterRoleBindingHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterRoleBindingControllerMock.AddFeatureHandlerFunc: method is nil but ClusterRoleBindingController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ClusterRoleBindingHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterRoleBindingControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterRoleBindingControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedClusterRoleBindingController.AddFeatureHandlerCalls())
func (mock *ClusterRoleBindingControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ClusterRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ClusterRoleBindingHandlerFunc
	}
	lockClusterRoleBindingControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterRoleBindingControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterRoleBindingControllerMock) AddHandler(ctx context.Context, name string, handler v11.ClusterRoleBindingHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterRoleBindingControllerMock.AddHandlerFunc: method is nil but ClusterRoleBindingController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.ClusterRoleBindingHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockClusterRoleBindingControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterRoleBindingControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedClusterRoleBindingController.AddHandlerCalls())
func (mock *ClusterRoleBindingControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.ClusterRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.ClusterRoleBindingHandlerFunc
	}
	lockClusterRoleBindingControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterRoleBindingControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ClusterRoleBindingControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ClusterRoleBindingControllerMock.EnqueueFunc: method is nil but ClusterRoleBindingController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterRoleBindingControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockClusterRoleBindingControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedClusterRoleBindingController.EnqueueCalls())
func (mock *ClusterRoleBindingControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterRoleBindingControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockClusterRoleBindingControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ClusterRoleBindingControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ClusterRoleBindingControllerMock.EnqueueAfterFunc: method is nil but ClusterRoleBindingController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockClusterRoleBindingControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockClusterRoleBindingControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedClusterRoleBindingController.EnqueueAfterCalls())
func (mock *ClusterRoleBindingControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockClusterRoleBindingControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockClusterRoleBindingControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ClusterRoleBindingControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ClusterRoleBindingControllerMock.GenericFunc: method is nil but ClusterRoleBindingController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRoleBindingControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockClusterRoleBindingControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedClusterRoleBindingController.GenericCalls())
func (mock *ClusterRoleBindingControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRoleBindingControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockClusterRoleBindingControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ClusterRoleBindingControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ClusterRoleBindingControllerMock.InformerFunc: method is nil but ClusterRoleBindingController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRoleBindingControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockClusterRoleBindingControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedClusterRoleBindingController.InformerCalls())
func (mock *ClusterRoleBindingControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRoleBindingControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockClusterRoleBindingControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ClusterRoleBindingControllerMock) Lister() v11.ClusterRoleBindingLister {
	if mock.ListerFunc == nil {
		panic("ClusterRoleBindingControllerMock.ListerFunc: method is nil but ClusterRoleBindingController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRoleBindingControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockClusterRoleBindingControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedClusterRoleBindingController.ListerCalls())
func (mock *ClusterRoleBindingControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRoleBindingControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockClusterRoleBindingControllerMockLister.RUnlock()
	return calls
}

var (
	lockClusterRoleBindingInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockClusterRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockClusterRoleBindingInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockClusterRoleBindingInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockClusterRoleBindingInterfaceMockAddFeatureHandler                sync.RWMutex
	lockClusterRoleBindingInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockClusterRoleBindingInterfaceMockAddHandler                       sync.RWMutex
	lockClusterRoleBindingInterfaceMockAddLifecycle                     sync.RWMutex
	lockClusterRoleBindingInterfaceMockController                       sync.RWMutex
	lockClusterRoleBindingInterfaceMockCreate                           sync.RWMutex
	lockClusterRoleBindingInterfaceMockDelete                           sync.RWMutex
	lockClusterRoleBindingInterfaceMockDeleteCollection                 sync.RWMutex
	lockClusterRoleBindingInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockClusterRoleBindingInterfaceMockGet                              sync.RWMutex
	lockClusterRoleBindingInterfaceMockGetNamespaced                    sync.RWMutex
	lockClusterRoleBindingInterfaceMockList                             sync.RWMutex
	lockClusterRoleBindingInterfaceMockListNamespaced                   sync.RWMutex
	lockClusterRoleBindingInterfaceMockObjectClient                     sync.RWMutex
	lockClusterRoleBindingInterfaceMockUpdate                           sync.RWMutex
	lockClusterRoleBindingInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ClusterRoleBindingInterfaceMock does implement v11.ClusterRoleBindingInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.ClusterRoleBindingInterface = &ClusterRoleBindingInterfaceMock{}

// ClusterRoleBindingInterfaceMock is a mock implementation of v11.ClusterRoleBindingInterface.
//
//	    func TestSomethingThatUsesClusterRoleBindingInterface(t *testing.T) {
//
//	        // make and configure a mocked v11.ClusterRoleBindingInterface
//	        mockedClusterRoleBindingInterface := &ClusterRoleBindingInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ClusterRoleBindingHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ClusterRoleBindingLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ClusterRoleBindingHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.ClusterRoleBindingLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ClusterRoleBindingHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ClusterRoleBindingLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.ClusterRoleBindingHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.ClusterRoleBindingLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v11.ClusterRoleBindingController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v1.ClusterRoleBinding) (*v1.ClusterRoleBinding, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v1.ClusterRoleBinding, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.ClusterRoleBinding, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v1.ClusterRoleBindingList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.ClusterRoleBindingList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v1.ClusterRoleBinding) (*v1.ClusterRoleBinding, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedClusterRoleBindingInterface in code that requires v11.ClusterRoleBindingInterface
//	        // and then make assertions.
//
//	    }
type ClusterRoleBindingInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ClusterRoleBindingHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ClusterRoleBindingLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ClusterRoleBindingHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.ClusterRoleBindingLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ClusterRoleBindingHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ClusterRoleBindingLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.ClusterRoleBindingHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.ClusterRoleBindingLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.ClusterRoleBindingController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.ClusterRoleBinding) (*v1.ClusterRoleBinding, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.ClusterRoleBinding, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.ClusterRoleBinding, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.ClusterRoleBindingList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.ClusterRoleBindingList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.ClusterRoleBinding) (*v1.ClusterRoleBinding, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ClusterRoleBindingHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ClusterRoleBindingLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ClusterRoleBindingHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ClusterRoleBindingLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ClusterRoleBindingHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ClusterRoleBindingLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ClusterRoleBindingHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ClusterRoleBindingLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.ClusterRoleBinding
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.ClusterRoleBinding
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterRoleBindingInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ClusterRoleBindingHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterRoleBindingInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ClusterRoleBindingHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterRoleBindingInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterRoleBindingInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterRoleBindingInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.ClusterRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ClusterRoleBindingHandlerFunc
	}
	lockClusterRoleBindingInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterRoleBindingInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ClusterRoleBindingInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ClusterRoleBindingLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ClusterRoleBindingInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ClusterRoleBindingLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockClusterRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ClusterRoleBindingInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.ClusterRoleBindingLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ClusterRoleBindingLifecycle
	}
	lockClusterRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockClusterRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterRoleBindingInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.ClusterRoleBindingHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ClusterRoleBindingInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ClusterRoleBindingHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterRoleBindingInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterRoleBindingInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.AddClusterScopedHandlerCalls())
func (mock *ClusterRoleBindingInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.ClusterRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ClusterRoleBindingHandlerFunc
	}
	lockClusterRoleBindingInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterRoleBindingInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ClusterRoleBindingInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.ClusterRoleBindingLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ClusterRoleBindingInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ClusterRoleBindingLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterRoleBindingInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockClusterRoleBindingInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.AddClusterScopedLifecycleCalls())
func (mock *ClusterRoleBindingInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.ClusterRoleBindingLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ClusterRoleBindingLifecycle
	}
	lockClusterRoleBindingInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockClusterRoleBindingInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterRoleBindingInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ClusterRoleBindingHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.AddFeatureHandlerFunc: method is nil but ClusterRoleBindingInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ClusterRoleBindingHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterRoleBindingInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterRoleBindingInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.AddFeatureHandlerCalls())
func (mock *ClusterRoleBindingInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ClusterRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ClusterRoleBindingHandlerFunc
	}
	lockClusterRoleBindingInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterRoleBindingInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ClusterRoleBindingInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.ClusterRoleBindingLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.AddFeatureLifecycleFunc: method is nil but ClusterRoleBindingInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ClusterRoleBindingLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterRoleBindingInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockClusterRoleBindingInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.AddFeatureLifecycleCalls())
func (mock *ClusterRoleBindingInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.ClusterRoleBindingLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ClusterRoleBindingLifecycle
	}
	lockClusterRoleBindingInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockClusterRoleBindingInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterRoleBindingInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.ClusterRoleBindingHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.AddHandlerFunc: method is nil but ClusterRoleBindingInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.ClusterRoleBindingHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockClusterRoleBindingInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterRoleBindingInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.AddHandlerCalls())
func (mock *ClusterRoleBindingInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.ClusterRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.ClusterRoleBindingHandlerFunc
	}
	lockClusterRoleBindingInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterRoleBindingInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ClusterRoleBindingInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.ClusterRoleBindingLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.AddLifecycleFunc: method is nil but ClusterRoleBindingInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ClusterRoleBindingLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterRoleBindingInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockClusterRoleBindingInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.AddLifecycleCalls())
func (mock *ClusterRoleBindingInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.ClusterRoleBindingLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ClusterRoleBindingLifecycle
	}
	lockClusterRoleBindingInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockClusterRoleBindingInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ClusterRoleBindingInterfaceMock) Controller() v11.ClusterRoleBindingController {
	if mock.ControllerFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.ControllerFunc: method is nil but ClusterRoleBindingInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRoleBindingInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockClusterRoleBindingInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.ControllerCalls())
func (mock *ClusterRoleBindingInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRoleBindingInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockClusterRoleBindingInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ClusterRoleBindingInterfaceMock) Create(in1 *v1.ClusterRoleBinding) (*v1.ClusterRoleBinding, error) {
	if mock.CreateFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.CreateFunc: method is nil but ClusterRoleBindingInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.ClusterRoleBinding
	}{
		In1: in1,
	}
	lockClusterRoleBindingInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockClusterRoleBindingInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.CreateCalls())
func (mock *ClusterRoleBindingInterfaceMock) CreateCalls() []struct {
	In1 *v1.ClusterRoleBinding
} {
	var calls []struct {
		In1 *v1.ClusterRoleBinding
	}
	lockClusterRoleBindingInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockClusterRoleBindingInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ClusterRoleBindingInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.DeleteFunc: method is nil but ClusterRoleBindingInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockClusterRoleBindingInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockClusterRoleBindingInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.DeleteCalls())
func (mock *ClusterRoleBindingInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockClusterRoleBindingInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockClusterRoleBindingInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ClusterRoleBindingInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.DeleteCollectionFunc: method is nil but ClusterRoleBindingInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockClusterRoleBindingInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockClusterRoleBindingInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.DeleteCollectionCalls())
func (mock *ClusterRoleBindingInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockClusterRoleBindingInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockClusterRoleBindingInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ClusterRoleBindingInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.DeleteNamespacedFunc: method is nil but ClusterRoleBindingInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockClusterRoleBindingInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockClusterRoleBindingInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.DeleteNamespacedCalls())
func (mock *ClusterRoleBindingInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockClusterRoleBindingInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockClusterRoleBindingInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ClusterRoleBindingInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.ClusterRoleBinding, error) {
	if mock.GetFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.GetFunc: method is nil but ClusterRoleBindingInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockClusterRoleBindingInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterRoleBindingInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.GetCalls())
func (mock *ClusterRoleBindingInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockClusterRoleBindingInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockClusterRoleBindingInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ClusterRoleBindingInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.ClusterRoleBinding, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.GetNamespacedFunc: method is nil but ClusterRoleBindingInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockClusterRoleBindingInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockClusterRoleBindingInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.GetNamespacedCalls())
func (mock *ClusterRoleBindingInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockClusterRoleBindingInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockClusterRoleBindingInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterRoleBindingInterfaceMock) List(opts metav1.ListOptions) (*v1.ClusterRoleBindingList, error) {
	if mock.ListFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.ListFunc: method is nil but ClusterRoleBindingInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterRoleBindingInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterRoleBindingInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.ListCalls())
func (mock *ClusterRoleBindingInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterRoleBindingInterfaceMockList.RLock()
	calls = mock.calls.List
	lockClusterRoleBindingInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ClusterRoleBindingInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.ClusterRoleBindingList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.ListNamespacedFunc: method is nil but ClusterRoleBindingInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockClusterRoleBindingInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockClusterRoleBindingInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.ListNamespacedCalls())
func (mock *ClusterRoleBindingInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockClusterRoleBindingInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockClusterRoleBindingInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ClusterRoleBindingInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.ObjectClientFunc: method is nil but ClusterRoleBindingInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRoleBindingInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockClusterRoleBindingInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.ObjectClientCalls())
func (mock *ClusterRoleBindingInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRoleBindingInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockClusterRoleBindingInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ClusterRoleBindingInterfaceMock) Update(in1 *v1.ClusterRoleBinding) (*v1.ClusterRoleBinding, error) {
	if mock.UpdateFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.UpdateFunc: method is nil but ClusterRoleBindingInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.ClusterRoleBinding
	}{
		In1: in1,
	}
	lockClusterRoleBindingInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockClusterRoleBindingInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.UpdateCalls())
func (mock *ClusterRoleBindingInterfaceMock) UpdateCalls() []struct {
	In1 *v1.ClusterRoleBinding
} {
	var calls []struct {
		In1 *v1.ClusterRoleBinding
	}
	lockClusterRoleBindingInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockClusterRoleBindingInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ClusterRoleBindingInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ClusterRoleBindingInterfaceMock.WatchFunc: method is nil but ClusterRoleBindingInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterRoleBindingInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockClusterRoleBindingInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedClusterRoleBindingInterface.WatchCalls())
func (mock *ClusterRoleBindingInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterRoleBindingInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockClusterRoleBindingInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockClusterRoleBindingsGetterMockClusterRoleBindings sync.RWMutex
)

// Ensure, that ClusterRoleBindingsGetterMock does implement v11.ClusterRoleBindingsGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.ClusterRoleBindingsGetter = &ClusterRoleBindingsGetterMock{}

// ClusterRoleBindingsGetterMock is a mock implementation of v11.ClusterRoleBindingsGetter.
//
//	    func TestSomethingThatUsesClusterRoleBindingsGetter(t *testing.T) {
//
//	        // make and configure a mocked v11.ClusterRoleBindingsGetter
//	        mockedClusterRoleBindingsGetter := &ClusterRoleBindingsGetterMock{
//	            ClusterRoleBindingsFunc: func(namespace string) v11.ClusterRoleBindingInterface {
//		               panic("mock out the ClusterRoleBindings method")
//	            },
//	        }
//
//	        // use mockedClusterRoleBindingsGetter in code that requires v11.ClusterRoleBindingsGetter
//	        // and then make assertions.
//
//	    }
type ClusterRoleBindingsGetterMock struct {
	// ClusterRoleBindingsFunc mocks the ClusterRoleBindings method.
	ClusterRoleBindingsFunc func(namespace string) v11.ClusterRoleBindingInterface

	// calls tracks calls to the methods.
	calls struct {
		// ClusterRoleBindings holds details about calls to the ClusterRoleBindings method.
		ClusterRoleBindings []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ClusterRoleBindings calls ClusterRoleBindingsFunc.
func (mock *ClusterRoleBindingsGetterMock) ClusterRoleBindings(namespace string) v11.ClusterRoleBindingInterface {
	if mock.ClusterRoleBindingsFunc == nil {
		panic("ClusterRoleBindingsGetterMock.ClusterRoleBindingsFunc: method is nil but ClusterRoleBindingsGetter.ClusterRoleBindings was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockClusterRoleBindingsGetterMockClusterRoleBindings.Lock()
	mock.calls.ClusterRoleBindings = append(mock.calls.ClusterRoleBindings, callInfo)
	lockClusterRoleBindingsGetterMockClusterRoleBindings.Unlock()
	return mock.ClusterRoleBindingsFunc(namespace)
}

// ClusterRoleBindingsCalls gets all the calls that were made to ClusterRoleBindings.
// Check the length with:
//
//	len(mockedClusterRoleBindingsGetter.ClusterRoleBindingsCalls())
func (mock *ClusterRoleBindingsGetterMock) ClusterRoleBindingsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockClusterRoleBindingsGetterMockClusterRoleBindings.RLock()
	calls = mock.calls.ClusterRoleBindings
	lockClusterRoleBindingsGetterMockClusterRoleBindings.RUnlock()
	return calls
}
