// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/rbac.authorization.k8s.io/v1"
	v1 "k8s.io/api/rbac/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockClusterRoleListerMockGet  sync.RWMutex
	lockClusterRoleListerMockList sync.RWMutex
)

// Ensure, that ClusterRoleListerMock does implement v11.ClusterRoleLister.
// If this is not the case, regenerate this file with moq.
var _ v11.ClusterRoleLister = &ClusterRoleListerMock{}

// ClusterRoleListerMock is a mock implementation of v11.ClusterRoleLister.
//
//	    func TestSomethingThatUsesClusterRoleLister(t *testing.T) {
//
//	        // make and configure a mocked v11.ClusterRoleLister
//	        mockedClusterRoleLister := &ClusterRoleListerMock{
//	            GetFunc: func(namespace string, name string) (*v1.ClusterRole, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v1.ClusterRole, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedClusterRoleLister in code that requires v11.ClusterRoleLister
//	        // and then make assertions.
//
//	    }
type ClusterRoleListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.ClusterRole, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.ClusterRole, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ClusterRoleListerMock) Get(namespace string, name string) (*v1.ClusterRole, error) {
	if mock.GetFunc == nil {
		panic("ClusterRoleListerMock.GetFunc: method is nil but ClusterRoleLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterRoleListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterRoleListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedClusterRoleLister.GetCalls())
func (mock *ClusterRoleListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterRoleListerMockGet.RLock()
	calls = mock.calls.Get
	lockClusterRoleListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterRoleListerMock) List(namespace string, selector labels.Selector) ([]*v1.ClusterRole, error) {
	if mock.ListFunc == nil {
		panic("ClusterRoleListerMock.ListFunc: method is nil but ClusterRoleLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockClusterRoleListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterRoleListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedClusterRoleLister.ListCalls())
func (mock *ClusterRoleListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockClusterRoleListerMockList.RLock()
	calls = mock.calls.List
	lockClusterRoleListerMockList.RUnlock()
	return calls
}

var (
	lockClusterRoleControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockClusterRoleControllerMockAddClusterScopedHandler        sync.RWMutex
	lockClusterRoleControllerMockAddFeatureHandler              sync.RWMutex
	lockClusterRoleControllerMockAddHandler                     sync.RWMutex
	lockClusterRoleControllerMockEnqueue                        sync.RWMutex
	lockClusterRoleControllerMockEnqueueAfter                   sync.RWMutex
	lockClusterRoleControllerMockGeneric                        sync.RWMutex
	lockClusterRoleControllerMockInformer                       sync.RWMutex
	lockClusterRoleControllerMockLister                         sync.RWMutex
)

// Ensure, that ClusterRoleControllerMock does implement v11.ClusterRoleController.
// If this is not the case, regenerate this file with moq.
var _ v11.ClusterRoleController = &ClusterRoleControllerMock{}

// ClusterRoleControllerMock is a mock implementation of v11.ClusterRoleController.
//
//	    func TestSomethingThatUsesClusterRoleController(t *testing.T) {
//
//	        // make and configure a mocked v11.ClusterRoleController
//	        mockedClusterRoleController := &ClusterRoleControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ClusterRoleHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.ClusterRoleHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ClusterRoleHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v11.ClusterRoleHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v11.ClusterRoleLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedClusterRoleController in code that requires v11.ClusterRoleController
//	        // and then make assertions.
//
//	    }
type ClusterRoleControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ClusterRoleHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.ClusterRoleHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ClusterRoleHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.ClusterRoleHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.ClusterRoleLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ClusterRoleHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ClusterRoleHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ClusterRoleHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.ClusterRoleHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterRoleControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ClusterRoleHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterRoleControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterRoleController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ClusterRoleHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterRoleControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterRoleControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedClusterRoleController.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterRoleControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.ClusterRoleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ClusterRoleHandlerFunc
	}
	lockClusterRoleControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterRoleControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterRoleControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.ClusterRoleHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterRoleControllerMock.AddClusterScopedHandlerFunc: method is nil but ClusterRoleController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ClusterRoleHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterRoleControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterRoleControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedClusterRoleController.AddClusterScopedHandlerCalls())
func (mock *ClusterRoleControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.ClusterRoleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ClusterRoleHandlerFunc
	}
	lockClusterRoleControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterRoleControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterRoleControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ClusterRoleHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterRoleControllerMock.AddFeatureHandlerFunc: method is nil but ClusterRoleController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ClusterRoleHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterRoleControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterRoleControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedClusterRoleController.AddFeatureHandlerCalls())
func (mock *ClusterRoleControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ClusterRoleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ClusterRoleHandlerFunc
	}
	lockClusterRoleControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterRoleControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterRoleControllerMock) AddHandler(ctx context.Context, name string, handler v11.ClusterRoleHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterRoleControllerMock.AddHandlerFunc: method is nil but ClusterRoleController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.ClusterRoleHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockClusterRoleControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterRoleControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedClusterRoleController.AddHandlerCalls())
func (mock *ClusterRoleControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.ClusterRoleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.ClusterRoleHandlerFunc
	}
	lockClusterRoleControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterRoleControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ClusterRoleControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ClusterRoleControllerMock.EnqueueFunc: method is nil but ClusterRoleController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterRoleControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockClusterRoleControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedClusterRoleController.EnqueueCalls())
func (mock *ClusterRoleControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterRoleControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockClusterRoleControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ClusterRoleControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ClusterRoleControllerMock.EnqueueAfterFunc: method is nil but ClusterRoleController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockClusterRoleControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockClusterRoleControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedClusterRoleController.EnqueueAfterCalls())
func (mock *ClusterRoleControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockClusterRoleControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockClusterRoleControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ClusterRoleControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ClusterRoleControllerMock.GenericFunc: method is nil but ClusterRoleController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRoleControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockClusterRoleControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedClusterRoleController.GenericCalls())
func (mock *ClusterRoleControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRoleControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockClusterRoleControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ClusterRoleControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ClusterRoleControllerMock.InformerFunc: method is nil but ClusterRoleController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRoleControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockClusterRoleControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedClusterRoleController.InformerCalls())
func (mock *ClusterRoleControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRoleControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockClusterRoleControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ClusterRoleControllerMock) Lister() v11.ClusterRoleLister {
	if mock.ListerFunc == nil {
		panic("ClusterRoleControllerMock.ListerFunc: method is nil but ClusterRoleController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRoleControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockClusterRoleControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedClusterRoleController.ListerCalls())
func (mock *ClusterRoleControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRoleControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockClusterRoleControllerMockLister.RUnlock()
	return calls
}

var (
	lockClusterRoleInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockClusterRoleInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockClusterRoleInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockClusterRoleInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockClusterRoleInterfaceMockAddFeatureHandler                sync.RWMutex
	lockClusterRoleInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockClusterRoleInterfaceMockAddHandler                       sync.RWMutex
	lockClusterRoleInterfaceMockAddLifecycle                     sync.RWMutex
	lockClusterRoleInterfaceMockController                       sync.RWMutex
	lockClusterRoleInterfaceMockCreate                           sync.RWMutex
	lockClusterRoleInterfaceMockDelete                           sync.RWMutex
	lockClusterRoleInterfaceMockDeleteCollection                 sync.RWMutex
	lockClusterRoleInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockClusterRoleInterfaceMockGet                              sync.RWMutex
	lockClusterRoleInterfaceMockGetNamespaced                    sync.RWMutex
	lockClusterRoleInterfaceMockList                             sync.RWMutex
	lockClusterRoleInterfaceMockListNamespaced                   sync.RWMutex
	lockClusterRoleInterfaceMockObjectClient                     sync.RWMutex
	lockClusterRoleInterfaceMockUpdate                           sync.RWMutex
	lockClusterRoleInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ClusterRoleInterfaceMock does implement v11.ClusterRoleInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.ClusterRoleInterface = &ClusterRoleInterfaceMock{}

// ClusterRoleInterfaceMock is a mock implementation of v11.ClusterRoleInterface.
//
//	    func TestSomethingThatUsesClusterRoleInterface(t *testing.T) {
//
//	        // make and configure a mocked v11.ClusterRoleInterface
//	        mockedClusterRoleInterface := &ClusterRoleInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ClusterRoleHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ClusterRoleLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ClusterRoleHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.ClusterRoleLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ClusterRoleHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ClusterRoleLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.ClusterRoleHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.ClusterRoleLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v11.ClusterRoleController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v1.ClusterRole) (*v1.ClusterRole, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v1.ClusterRole, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.ClusterRole, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v1.ClusterRoleList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.ClusterRoleList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v1.ClusterRole) (*v1.ClusterRole, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedClusterRoleInterface in code that requires v11.ClusterRoleInterface
//	        // and then make assertions.
//
//	    }
type ClusterRoleInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ClusterRoleHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ClusterRoleLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ClusterRoleHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.ClusterRoleLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ClusterRoleHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ClusterRoleLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.ClusterRoleHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.ClusterRoleLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.ClusterRoleController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.ClusterRole) (*v1.ClusterRole, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.ClusterRole, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.ClusterRole, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.ClusterRoleList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.ClusterRoleList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.ClusterRole) (*v1.ClusterRole, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ClusterRoleHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ClusterRoleLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ClusterRoleHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ClusterRoleLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ClusterRoleHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ClusterRoleLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ClusterRoleHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ClusterRoleLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.ClusterRole
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.ClusterRole
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterRoleInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ClusterRoleHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterRoleInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterRoleInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ClusterRoleHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterRoleInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterRoleInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedClusterRoleInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterRoleInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.ClusterRoleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ClusterRoleHandlerFunc
	}
	lockClusterRoleInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterRoleInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ClusterRoleInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ClusterRoleLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ClusterRoleInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ClusterRoleInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ClusterRoleLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterRoleInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockClusterRoleInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedClusterRoleInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ClusterRoleInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.ClusterRoleLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ClusterRoleLifecycle
	}
	lockClusterRoleInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockClusterRoleInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterRoleInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.ClusterRoleHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterRoleInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ClusterRoleInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ClusterRoleHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterRoleInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterRoleInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedClusterRoleInterface.AddClusterScopedHandlerCalls())
func (mock *ClusterRoleInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.ClusterRoleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ClusterRoleHandlerFunc
	}
	lockClusterRoleInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterRoleInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ClusterRoleInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.ClusterRoleLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ClusterRoleInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ClusterRoleInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ClusterRoleLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterRoleInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockClusterRoleInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedClusterRoleInterface.AddClusterScopedLifecycleCalls())
func (mock *ClusterRoleInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.ClusterRoleLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ClusterRoleLifecycle
	}
	lockClusterRoleInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockClusterRoleInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterRoleInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ClusterRoleHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterRoleInterfaceMock.AddFeatureHandlerFunc: method is nil but ClusterRoleInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ClusterRoleHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterRoleInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterRoleInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedClusterRoleInterface.AddFeatureHandlerCalls())
func (mock *ClusterRoleInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ClusterRoleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ClusterRoleHandlerFunc
	}
	lockClusterRoleInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterRoleInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ClusterRoleInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.ClusterRoleLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ClusterRoleInterfaceMock.AddFeatureLifecycleFunc: method is nil but ClusterRoleInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ClusterRoleLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterRoleInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockClusterRoleInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedClusterRoleInterface.AddFeatureLifecycleCalls())
func (mock *ClusterRoleInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.ClusterRoleLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ClusterRoleLifecycle
	}
	lockClusterRoleInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockClusterRoleInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterRoleInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.ClusterRoleHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterRoleInterfaceMock.AddHandlerFunc: method is nil but ClusterRoleInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.ClusterRoleHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockClusterRoleInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterRoleInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedClusterRoleInterface.AddHandlerCalls())
func (mock *ClusterRoleInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.ClusterRoleHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.ClusterRoleHandlerFunc
	}
	lockClusterRoleInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterRoleInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ClusterRoleInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.ClusterRoleLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ClusterRoleInterfaceMock.AddLifecycleFunc: method is nil but ClusterRoleInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ClusterRoleLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterRoleInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockClusterRoleInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedClusterRoleInterface.AddLifecycleCalls())
func (mock *ClusterRoleInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.ClusterRoleLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ClusterRoleLifecycle
	}
	lockClusterRoleInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockClusterRoleInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ClusterRoleInterfaceMock) Controller() v11.ClusterRoleController {
	if mock.ControllerFunc == nil {
		panic("ClusterRoleInterfaceMock.ControllerFunc: method is nil but ClusterRoleInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRoleInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockClusterRoleInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedClusterRoleInterface.ControllerCalls())
func (mock *ClusterRoleInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRoleInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockClusterRoleInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ClusterRoleInterfaceMock) Create(in1 *v1.ClusterRole) (*v1.ClusterRole, error) {
	if mock.CreateFunc == nil {
		panic("ClusterRoleInterfaceMock.CreateFunc: method is nil but ClusterRoleInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.ClusterRole
	}{
		In1: in1,
	}
	lockClusterRoleInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockClusterRoleInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedClusterRoleInterface.CreateCalls())
func (mock *ClusterRoleInterfaceMock) CreateCalls() []struct {
	In1 *v1.ClusterRole
} {
	var calls []struct {
		In1 *v1.ClusterRole
	}
	lockClusterRoleInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockClusterRoleInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ClusterRoleInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ClusterRoleInterfaceMock.DeleteFunc: method is nil but ClusterRoleInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockClusterRoleInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockClusterRoleInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedClusterRoleInterface.DeleteCalls())
func (mock *ClusterRoleInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockClusterRoleInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockClusterRoleInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ClusterRoleInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ClusterRoleInterfaceMock.DeleteCollectionFunc: method is nil but ClusterRoleInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockClusterRoleInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockClusterRoleInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedClusterRoleInterface.DeleteCollectionCalls())
func (mock *ClusterRoleInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockClusterRoleInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockClusterRoleInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ClusterRoleInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ClusterRoleInterfaceMock.DeleteNamespacedFunc: method is nil but ClusterRoleInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockClusterRoleInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockClusterRoleInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedClusterRoleInterface.DeleteNamespacedCalls())
func (mock *ClusterRoleInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockClusterRoleInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockClusterRoleInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ClusterRoleInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.ClusterRole, error) {
	if mock.GetFunc == nil {
		panic("ClusterRoleInterfaceMock.GetFunc: method is nil but ClusterRoleInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockClusterRoleInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterRoleInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedClusterRoleInterface.GetCalls())
func (mock *ClusterRoleInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockClusterRoleInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockClusterRoleInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ClusterRoleInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.ClusterRole, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ClusterRoleInterfaceMock.GetNamespacedFunc: method is nil but ClusterRoleInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockClusterRoleInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockClusterRoleInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedClusterRoleInterface.GetNamespacedCalls())
func (mock *ClusterRoleInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockClusterRoleInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockClusterRoleInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterRoleInterfaceMock) List(opts metav1.ListOptions) (*v1.ClusterRoleList, error) {
	if mock.ListFunc == nil {
		panic("ClusterRoleInterfaceMock.ListFunc: method is nil but ClusterRoleInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterRoleInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterRoleInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedClusterRoleInterface.ListCalls())
func (mock *ClusterRoleInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterRoleInterfaceMockList.RLock()
	calls = mock.calls.List
	lockClusterRoleInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ClusterRoleInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.ClusterRoleList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ClusterRoleInterfaceMock.ListNamespacedFunc: method is nil but ClusterRoleInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockClusterRoleInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockClusterRoleInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedClusterRoleInterface.ListNamespacedCalls())
func (mock *ClusterRoleInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockClusterRoleInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockClusterRoleInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ClusterRoleInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ClusterRoleInterfaceMock.ObjectClientFunc: method is nil but ClusterRoleInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRoleInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockClusterRoleInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedClusterRoleInterface.ObjectClientCalls())
func (mock *ClusterRoleInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRoleInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockClusterRoleInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ClusterRoleInterfaceMock) Update(in1 *v1.ClusterRole) (*v1.ClusterRole, error) {
	if mock.UpdateFunc == nil {
		panic("ClusterRoleInterfaceMock.UpdateFunc: method is nil but ClusterRoleInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.ClusterRole
	}{
		In1: in1,
	}
	lockClusterRoleInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockClusterRoleInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedClusterRoleInterface.UpdateCalls())
func (mock *ClusterRoleInterfaceMock) UpdateCalls() []struct {
	In1 *v1.ClusterRole
} {
	var calls []struct {
		In1 *v1.ClusterRole
	}
	lockClusterRoleInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockClusterRoleInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ClusterRoleInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ClusterRoleInterfaceMock.WatchFunc: method is nil but ClusterRoleInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterRoleInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockClusterRoleInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedClusterRoleInterface.WatchCalls())
func (mock *ClusterRoleInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterRoleInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockClusterRoleInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockClusterRolesGetterMockClusterRoles sync.RWMutex
)

// Ensure, that ClusterRolesGetterMock does implement v11.ClusterRolesGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.ClusterRolesGetter = &ClusterRolesGetterMock{}

// ClusterRolesGetterMock is a mock implementation of v11.ClusterRolesGetter.
//
//	    func TestSomethingThatUsesClusterRolesGetter(t *testing.T) {
//
//	        // make and configure a mocked v11.ClusterRolesGetter
//	        mockedClusterRolesGetter := &ClusterRolesGetterMock{
//	            ClusterRolesFunc: func(namespace string) v11.ClusterRoleInterface {
//		               panic("mock out the ClusterRoles method")
//	            },
//	        }
//
//	        // use mockedClusterRolesGetter in code that requires v11.ClusterRolesGetter
//	        // and then make assertions.
//
//	    }
type ClusterRolesGetterMock struct {
	// ClusterRolesFunc mocks the ClusterRoles method.
	ClusterRolesFunc func(namespace string) v11.ClusterRoleInterface

	// calls tracks calls to the methods.
	calls struct {
		// ClusterRoles holds details about calls to the ClusterRoles method.
		ClusterRoles []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ClusterRoles calls ClusterRolesFunc.
func (mock *ClusterRolesGetterMock) ClusterRoles(namespace string) v11.ClusterRoleInterface {
	if mock.ClusterRolesFunc == nil {
		panic("ClusterRolesGetterMock.ClusterRolesFunc: method is nil but ClusterRolesGetter.ClusterRoles was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockClusterRolesGetterMockClusterRoles.Lock()
	mock.calls.ClusterRoles = append(mock.calls.ClusterRoles, callInfo)
	lockClusterRolesGetterMockClusterRoles.Unlock()
	return mock.ClusterRolesFunc(namespace)
}

// ClusterRolesCalls gets all the calls that were made to ClusterRoles.
// Check the length with:
//
//	len(mockedClusterRolesGetter.ClusterRolesCalls())
func (mock *ClusterRolesGetterMock) ClusterRolesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockClusterRolesGetterMockClusterRoles.RLock()
	calls = mock.calls.ClusterRoles
	lockClusterRolesGetterMockClusterRoles.RUnlock()
	return calls
}
