<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
Copyright (C) 2014  Web3king - Alberto Bonacina

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class Calendar extends CI_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model(array('users_model','menu_model','ingredient_model','dish_model'));
	}
	
    function index(){
    	$nextDays = $this->arrayProssimiGiorni();
        $data['typesFromDb'] = $this->ingredient_model->getAllTypes($this->session->userdata('id')); 
    	$data['prossimi_giorni'] = $nextDays; 
        $nextNames = $this->fromNumbersToNamesDay();
        $data['prossimi_giorni_nome'] = $nextNames;
    	//Chiamo la funzione che mi riporta i prossimi menu
    	$data['prossimi_menu'] = $this->menu_model->nextMenu($nextDays,$this->session->userdata('id'));

        $data['sidebar_content'] = 'workspace/sidebar';
        $data['main_content'] = 'workspace/calendarView';
        $this->load->view('includes/templateWorkspaceView', $data);
    }  

    function confirmShoppingList(){

        $menuCorrispondenti = $this->menu_model->menuBetweenTwoDates($this->session->userdata('id'));

        //Conto quanti
        $idProgressivoMenu = 0;
        $arrayTuttiMenu = array();

        //Faccio scorrere tutti i menu che mi sono stati restituiti
        foreach($menuCorrispondenti->result() as $singolo){

            //mi creo un array per ogni portata
            $un_starter = json_decode($singolo->starter_array);
            $un_first = json_decode($singolo->first_array);
            $un_second = json_decode($singolo->second_array);
            $un_sweet = json_decode($singolo->sweet_array);
            $un_other = json_decode($singolo->other_array);

            //Controllo se mi è stato ritornato qualcosa e creo una matrice con dentro tutte le informazioni
            if($un_starter){ 
                $i = 0;
                foreach ($un_starter as $st) { 
                    //Inserisco informazione nella cella giusta dell'array
                    $arrayTuttiMenu[$idProgressivoMenu][0][$i] = $this->dish_model->singleDish($st);
                    $i += 1;
                } 
            }
            if($un_first){ 
                $i = 0;
                foreach ($un_first as $ft) { 
                    $arrayTuttiMenu[$idProgressivoMenu][1][$i] = $this->dish_model->singleDish($ft);
                    $i += 1;
                } 
            }
            if($un_second){ 
                $i = 0;
                foreach ($un_second as $se) { 
                    $arrayTuttiMenu[$idProgressivoMenu][2][$i] = $this->dish_model->singleDish($se);
                    $i += 1;
                } 
            }
            if($un_sweet){ 
                $i = 0;
                foreach ($un_sweet as $sw) { 
                    $arrayTuttiMenu[$idProgressivoMenu][3][$i] = $this->dish_model->singleDish($sw);
                    $i += 1;
                } 
            }
            if($un_other){ 
                $i = 0;
                foreach ($un_other as $ot) { 
                    $arrayTuttiMenu[$idProgressivoMenu][4][$i] = $this->dish_model->singleDish($ot);
                    $i++;
                } 
            }
            $idProgressivoMenu++;
        }

        $data['arrayTuttiMenu'] = $arrayTuttiMenu;

        $data['dataInizio'] = $this->input->post('start-date');
        $data['dataFine'] = $this->input->post('end-date');

        $data['sidebar_content'] = 'workspace/sidebar';
        $data['main_content'] = 'workspace/confirmShoppingListView';
        $this->load->view('includes/templateWorkspaceView', $data);
    }

    // function createShoppingList(){

    //     //array multimensionale unico (del tipo array[][][][]) che deve tenere tutte le informazioni sugli ingredienti che vengono usati 
    //     $arrayIngredientQuantity = array();

    //     $arrayPiattiDaForm = $this->input->post('id');
    //     $arrayPeopleDaForm = $this->input->post('people');

    //     //Contatore dei piatti che sono stati inseriti
    //     $contatorePiatti = count($arrayPeopleDaForm);

    //     for ($i=0; $i < $contatorePiatti; $i++) { 
    //         //Chiamo la funzione che crea la riga con tutte le informazioni che mi servono
    //         //Accodo l'informazione che ho ottenuto nell'array generale
    //         $intPeopleForm = intval($arrayPeopleDaForm[$i]); //Trasformo il valore in un intero
    //         $arrayIngredientQuantity = $this->createRowIngredientQuantityAndPushInArray($arrayPiattiDaForm[$i],$intPeopleForm,$arrayIngredientQuantity);
    //     }

    //     //Creo un array di array di array che simula il raggruppamento per ingredient_id
    //     $arrayIngredientQuantity = $this->groupByArray($arrayIngredientQuantity, 'ingredient_id');

    //     //Ciclo per ogni array
    //     foreach ($arrayIngredientQuantity as $ingredienteRaggruppato) {

    //         //variabili temporanee per tenere traccia dell'id dell'ingrediente e della quantità totale che si deve comprare
    //         $idIngredienteRaggruppato = '';
    //         $nameIngredienteRaggruppato = '';
    //         $measureIngredienteRaggruppato = '';
    //         $quantityIngredienteRaggruppato = 0;

    //         foreach ($ingredienteRaggruppato as $singoloIngredienteRaggruppato) {
    //             $idIngredienteRaggruppato = $singoloIngredienteRaggruppato['ingredient_id'];
                
    //             $allInfoIngredienteRaggruppato = $this->ingredient_model->getAllIngredientInfoFromId($idIngredienteRaggruppato);
    //             $nameIngredienteRaggruppato = $allInfoIngredienteRaggruppato->name;
    //             $measureIngredienteRaggruppato = $allInfoIngredienteRaggruppato->measure;

    //             $quantityIngredienteRaggruppato += $singoloIngredienteRaggruppato['quantity'];
    //         }

    //         echo "<br>";
    //         echo "Ingredient: ".$nameIngredienteRaggruppato." Quantity: ".$quantityIngredienteRaggruppato." ".$measureIngredienteRaggruppato."<br>";
    //     }
    // }

    // //Funzione accessoria a createShoppingList per il group_by dell'array $arrayIngredientQuantityPeopleProcapite
    // function groupByArray($array, $key) {
    //     $return = array();
    //     foreach($array as $v) {
    //         $return[$v[$key]][] = $v;
    //     }
    //     return $return;
    // }

    // /*Prendo l'id del piatto e creo delle righe all'interno dell'array che mi viene passato una per ogni ingrediente
    // * in cui i campi sono [id dell'ingrediente][quantità di quell'ingrediente][numero di persone su cui è tarata quella ricetta][quantità pro capite]
    // *
    // * i due campi veramente necessari sono il primo e l'ultimo, gli altri li ho lasciati per completezza ma per i calcoli
    // * successivi non sono necessari
    // */
    // function createRowIngredientQuantityAndPushInArray($idPiatto,$personeRichieste,$generalArray){
    //     //ingredienti per quel piatto
    //     $ingredienti = $this->ingredient_model->getAllIngredientsFromDish($idPiatto);
    //     //persone calcolate per quel piatto
    //     $persone = $this->dish_model->getPeopleFromDish($idPiatto);
    //     foreach ($ingredienti->result() as $i) {
    //         //Calcolo la quantità dell'ingrediente sulla base della quantità totale, del numero di persone per quella ricetta e di quelle richieste
    //         $rapportoPersone = ((float) $personeRichieste) / ((float) $persone);
    //         $tempQuantita = (float)(((float)$i->quantity) * ((float)$rapportoPersone));
    //         //Creo un array chiave=>valore in modo che poi possa ordinarli e raggrupparli
    //         array_push($generalArray, array("ingredient_id" => $i->ingredient_id, 
    //                                         "quantity" => $tempQuantita));
    //     }
    //     return $generalArray;
    // }

    //calcolo 6 giorni da oggi
    function arrayProssimiGiorni(){
    	$today0 = date("Y/m/d");
    	$today1 = date("Y/m/d",strtotime($today0 . ' + 1 day'));
    	$today2 = date("Y/m/d",strtotime($today0 . ' + 2 day'));
    	$today3 = date("Y/m/d",strtotime($today0 . ' + 3 day'));
    	$today4 = date("Y/m/d",strtotime($today0 . ' + 4 day'));
    	$today5 = date("Y/m/d",strtotime($today0 . ' + 5 day'));
        $today6 = date("Y/m/d",strtotime($today0 . ' + 6 day'));
        $today7 = date("Y/m/d",strtotime($today0 . ' + 7 day'));

    	return array($today0,$today1,$today2,$today3,$today4,$today5,$today6,$today7); 
    }

    //Calcolo che giorn della settimana è 
    function fromNumbersToNamesDay(){
        $name0 = date('l');
        $name1 = date('l',strtotime($name0 . ' + 1 day'));
        $name2 = date('l',strtotime($name0 . ' + 2 day'));
        $name3 = date('l',strtotime($name0 . ' + 3 day'));
        $name4 = date('l',strtotime($name0 . ' + 4 day'));
        $name5 = date('l',strtotime($name0 . ' + 5 day'));
        $name6 = date('l',strtotime($name0 . ' + 6 day'));
        $name7 = date('l',strtotime($name0 . ' + 7 day'));

        return array($name0,$name1,$name2,$name3,$name4,$name5,$name6,$name7);
    }
}
?>