<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
Copyright (C) 2014  Web3king - Alberto Bonacina

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class Dish extends CI_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model(array('users_model','ingredient_model','dish_model'));
	}
	
    function index(){
    	//Array per farmi dare tutti gli ingredienti
    	$data['ingredentsFromDb'] = $this->ingredient_model->getAllIngredients($this->session->userdata('id'));

        //prendo il tipo di piatto e creo un array associativo
        $data['typesFromDb'] = $this->ingredient_model->getAllTypes($this->session->userdata('id')); 
        $data['dishFromDb'] = $this->dish_model->getAllDishes($this->session->userdata('id'));

        $data['sidebar_content'] = 'workspace/sidebar';
        $data['main_content'] = 'workspace/dishView';
        $this->load->view('includes/templateWorkspaceView', $data);
    }  

    function modifySingleDish(){
        $idDish = $this->uri->segment(3);

        $data['singledish'] = $this->dish_model->singleDish($idDish);
        $data['typesFromDb'] = $this->ingredient_model->getAllTypes($this->session->userdata('id'));
        $data['ingredientsFromDb'] = $this->ingredient_model->getAllIngredients($this->session->userdata('id'));
        $data['ingredientsFromDish'] = $this->ingredient_model->getAllIngredientsFromDish($idDish);

        $data['sidebar_content'] = 'workspace/sidebar';
        $data['main_content'] = 'workspace/singleDishView';
        $this -> load -> view('includes/templateWorkspaceView', $data);
    }

    function deleteDishDb(){
        $idDish = $this->uri->segment(3);
        $this->dish_model->deleteDish($idDish,$this->session->userdata('id'));
        redirect('dish');
    }

    function createDishDb(){
    	$this->dish_model->createDish($this->session->userdata('id'));
        redirect('dish');
    }

    function updateDishDb(){
        //echo $this->input->post('ingredients');
        $idDish = $this->input->post('id');
        $this->dish_model->updateDish($idDish,$this->session->userdata('id'));
        redirect('dish/modifySingleDish/'.$idDish);
    }
}
?>