<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
Copyright (C) 2014  Web3king - Alberto Bonacina

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class Menu extends CI_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model(array('users_model','dish_model','menu_model'));
	}
	
    function index(){

    	//Mi prendo tutti i vari tipi di piatti
    	$data['starter'] = $this->dish_model->getAllDishFromType('1');
    	$data['first'] = $this->dish_model->getAllDishFromType('2');
    	$data['second'] = $this->dish_model->getAllDishFromType('3');
    	$data['sweet'] = $this->dish_model->getAllDishFromType('4');
    	$data['other'] = $this->dish_model->getAllDishFromType('5');
    	$data['wine'] = $this->dish_model->getAllDishFromType('6');

        $data['menuFromDb'] = $this->menu_model->getAllMenu($this->session->userdata('id'));

        $data['sidebar_content'] = 'workspace/sidebar';
        $data['main_content'] = 'workspace/menuView';
        $this->load->view('includes/templateWorkspaceView', $data);
    }  

    //Funzione che modifica un menu dal db
    function modifySinglemenu(){
        $idMenu = $this->uri->segment(3);

        $tempSingleMenu = $this->menu_model->singleMenu($idMenu);

        //Prendo quello che c'è nel db per l'array delle varie sezioni, lo decodifico base64encode/decode e ne faccio unserialize
        // per il motivo leggere qui: http://davidwalsh.name/php-serialize-unserialize-issues
        $tempSingleMenu_starter = json_decode($tempSingleMenu['starter_array']);
        $tempSingleMenu_first = json_decode($tempSingleMenu['first_array']);
        $tempSingleMenu_second = json_decode($tempSingleMenu['second_array']);
        $tempSingleMenu_sweet = json_decode($tempSingleMenu['sweet_array']);
        $tempSingleMenu_other = json_decode($tempSingleMenu['other_array']);
        $tempSingleMenu_wine = json_decode($tempSingleMenu['wine_array']);

        //Per ogni portata creo un array che contiene id del piatto e il suo nome
        $data['singlemenu_starter'] = $this->fromMenuSectionToArrayDish($tempSingleMenu_starter);
        $data['singlemenu_first'] = $this->fromMenuSectionToArrayDish($tempSingleMenu_first);
        $data['singlemenu_second'] = $this->fromMenuSectionToArrayDish($tempSingleMenu_second);
        $data['singlemenu_sweet'] = $this->fromMenuSectionToArrayDish($tempSingleMenu_sweet);
        $data['singlemenu_other'] = $this->fromMenuSectionToArrayDish($tempSingleMenu_other);
        $data['singlemenu_wine'] = $this->fromMenuSectionToArrayDish($tempSingleMenu_wine);

        $data['singlemenu'] = $tempSingleMenu;

        //Mi prendo tutti i vari tipi di piatti
        $data['starter'] = $this->dish_model->getAllDishFromType('1');
        $data['first'] = $this->dish_model->getAllDishFromType('2');
        $data['second'] = $this->dish_model->getAllDishFromType('3');
        $data['sweet'] = $this->dish_model->getAllDishFromType('4');
        $data['other'] = $this->dish_model->getAllDishFromType('5');
        $data['wine'] = $this->dish_model->getAllDishFromType('6');

        $data['sidebar_content'] = 'workspace/sidebar';
        $data['main_content'] = 'workspace/singleMenuView';
        $this->load->view('includes/templateWorkspaceView', $data);
    }

    //Funzione che elimina un menu dal db
    function deleteMenuDb(){
        $idMenu = $this->uri->segment(3);
        $this->menu_model->deleteMenu($idMenu,$this->session->userdata('id'));
        redirect('menu');
    }

    function createMenuDb(){
    	//Tutte le funzioni per la creazione del menu
    	$this->menu_model->createMenu($this->session->userdata('id'));
        redirect('menu');
    }

    function updateMenuDb(){
        //echo $this->input->post('ingredients');
        $idMenu = $this->input->post('id');
        $this->menu_model->updateMenu($idMenu,$this->session->userdata('id'));
        redirect('menu/modifySingleMenu/'.$idMenu);
    }

    /*Funzioni accessorie*/
    //Funzione che dato l'array proveniente dall'unserialize mi ritorna un array chiave->valore
    //con id e nome di ogni piatto
    function fromMenuSectionToArrayDish($array){
        $arrayRitorno = array();

        //Controllo se array è valido
        if($array){
            foreach ($array as $arr) {
                $tempDish = $this->dish_model->singleDish($arr);
                array_push($arrayRitorno,array("id" => $tempDish['id'], "name" => $tempDish['name']));
            }
        }

        return $arrayRitorno;
    }
    
}
?>