<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
Copyright (C) 2014  Web3king - Alberto Bonacina

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class Pdf extends CI_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model(array('users_model','menu_model','ingredient_model','dish_model'));
        $this->load->library('dompdf_gen');
		// Your own constructor code
	}

	//Funzione che stampa il pdf con il resoconto dei pagamenti che ancora restano da fare ai venditori
    function createShoppingList(){
        
        //array multimensionale unico (del tipo array[][][][]) che deve tenere tutte le informazioni sugli ingredienti che vengono usati 
        $arrayIngredientQuantity = array();

        $arrayPiattiDaForm = $this->input->post('id');
        $arrayPeopleDaForm = $this->input->post('people');
        $dataInizio = $this->input->post('start-date');
        $dataFine = $this->input->post('end-date');

        echo "<h3>Ingredients from ".$dataInizio." to ".$dataFine."</h3>";
        echo "<ul>";

        //Contatore dei piatti che sono stati inseriti
        $contatorePiatti = count($arrayPeopleDaForm);

        for ($i=0; $i < $contatorePiatti; $i++) { 
            //Chiamo la funzione che crea la riga con tutte le informazioni che mi servono
            //Accodo l'informazione che ho ottenuto nell'array generale
            $intPeopleForm = intval($arrayPeopleDaForm[$i]); //Trasformo il valore in un intero
            $arrayIngredientQuantity = $this->createRowIngredientQuantityAndPushInArray($arrayPiattiDaForm[$i],$intPeopleForm,$arrayIngredientQuantity);
        }

        //Creo un array di array di array che simula il raggruppamento per ingredient_id
        $arrayIngredientQuantity = $this->groupByArray($arrayIngredientQuantity, 'ingredient_id');

        //Ciclo per ogni array
        foreach ($arrayIngredientQuantity as $ingredienteRaggruppato) {

            //variabili temporanee per tenere traccia dell'id dell'ingrediente e della quantità totale che si deve comprare
            $idIngredienteRaggruppato = '';
            $nameIngredienteRaggruppato = '';
            $measureIngredienteRaggruppato = '';
            $quantityIngredienteRaggruppato = 0;

            foreach ($ingredienteRaggruppato as $singoloIngredienteRaggruppato) {
                $idIngredienteRaggruppato = $singoloIngredienteRaggruppato['ingredient_id'];
                
                $allInfoIngredienteRaggruppato = $this->ingredient_model->getAllIngredientInfoFromId($idIngredienteRaggruppato);
                $nameIngredienteRaggruppato = $allInfoIngredienteRaggruppato->name;
                $measureIngredienteRaggruppato = $allInfoIngredienteRaggruppato->measure;

                $quantityIngredienteRaggruppato += $singoloIngredienteRaggruppato['quantity'];
            }

            echo "<li>Ingredient: ".$nameIngredienteRaggruppato." Quantity: ".$quantityIngredienteRaggruppato." ".$measureIngredienteRaggruppato."</li>";
        }
        echo "</ul>";
    }

    //funzione per stampare un singolo pdf del menu del giorno
    function printDayMenu(){

        //Stringa che deve contenere tutto
        $con = '';

        $y = $this->uri->segment(3);
        $m = $this->uri->segment(4);
        $d = $this->uri->segment(5);

        //preparo gli array che conterranno i vari piatti
        $breakfast = array(); $lunch = array(); $dinner = array();

        $dataFormattata = $y."/".$m."/".$d;

        $menuDelGiorno = $this->menu_model->getMenufromDay($dataFormattata);

        $data['intromenu'] = "Menu on date ".$y."/".$m."/".$d;

        $i = 0;
        foreach ($menuDelGiorno as $singleID) {
            //Controllo se mi è stato ritornato qualcosa
            if($singleID != '0'){

                //Stampo il titolo corretto
                switch ($i) {
                    case 0:
                        $breakfast = $this->compilaArrayPasto($breakfast,$singleID);
                        break;
                    case 1:
                        $lunch = $this->compilaArrayPasto($lunch,$singleID);
                        break;
                    case 2:
                        $dinner = $this->compilaArrayPasto($dinner,$singleID);
                        break;
                }   
            }
            $i += 1; 
        }

        $data['template'] = $this->users_model->getTemplateByUserID($this->session->userdata('id'),'1');
        $data['breakfast'] = $breakfast;
        $data['lunch'] = $lunch;
        $data['dinner'] = $dinner;

        $this->load->view('includes/templatePrintView', $data);
    }

    //Funzione per stampare un singolo menu
    function printSingleMenu(){

        $idMenu = $this->uri->segment(3);

        //array per il singolo pasto
        $single = array();
        $single = $this->compilaArrayPasto($single,$idMenu);

        $data['single'] = $single;
        $data['template'] = $this->users_model->getTemplateByUserID($this->session->userdata('id'),'2');
        $this->load->view('includes/templatePrintView', $data);
    }

    //Funzione accessoria a createShoppingList per il group_by dell'array $arrayIngredientQuantityPeopleProcapite
    function groupByArray($array, $key) {
        $return = array();
        foreach($array as $v) {
            $return[$v[$key]][] = $v;
        }
        return $return;
    }

    /*Funzione che dato un id di un pasto compila correttamente l'array che mi server per 
    compilare il template*/
    function compilaArrayPasto($arr,$single){

        $tuttiPasti = $this->menu_model->singleMenu($single);
        $arr['title'] = $tuttiPasti['title'];
        
        //Prendo quello che c'è nel db per l'array delle varie sezioni, lo decodifico base64encode/decode e ne faccio unserialize
        $tempSingleMenu_starter = json_decode($tuttiPasti['starter_array']);
        $tempSingleMenu_first = json_decode($tuttiPasti['first_array']);
        $tempSingleMenu_second = json_decode($tuttiPasti['second_array']);
        $tempSingleMenu_sweet = json_decode($tuttiPasti['sweet_array']);
        $tempSingleMenu_other = json_decode($tuttiPasti['other_array']);
        $tempSingleMenu_wine = json_decode($tuttiPasti['wine_array']);

        //Creo un array per gli antipasti che contiene il suo nome e il prezzo
        $singlemenu_starter = $this->fromMenuSectionToArrayDish($tempSingleMenu_starter);
        if($singlemenu_starter){
            $tempStarter = array();
            foreach ($singlemenu_starter as $st) {
                array_push($tempStarter,array("name" => $st['name'],"price" => $st['price']));
            }
            $arr['starter'] = $tempStarter;
        }else{
            $arr['starter'] = '';
        }

        //Creo un array per i primi che contiene il suo nome e il prezzo
        $singlemenu_first = $this->fromMenuSectionToArrayDish($tempSingleMenu_first);
        if($singlemenu_first){
            $tempFirst = array();
            foreach ($singlemenu_first as $fs) {
                array_push($tempFirst,array("name" => $fs['name'],"price" => $fs['price']));
            }
            $arr['first'] = $tempFirst;
        }else{
            $arr['first'] = '';
        }

        //Creo un array per i secondi che contiene il suo nome e il prezzo
        $singlemenu_second = $this->fromMenuSectionToArrayDish($tempSingleMenu_second);
        if($singlemenu_second){
            $tempSecond = array();
            foreach ($singlemenu_second as $sd) {
                array_push($tempSecond,array("name" => $sd['name'],"price" => $sd['price']));
            }
            $arr['second'] = $tempSecond;
        }else{
            $arr['second'] = '';
        }

        //Creo un array per i dolci che contiene il suo nome e il prezzo
        $singlemenu_sweet = $this->fromMenuSectionToArrayDish($tempSingleMenu_sweet);
        if($singlemenu_sweet){
            $tempSweet = array();
            foreach ($singlemenu_sweet as $sw) {
                array_push($tempSweet,array("name" => $sw['name'],"price" => $sw['price']));
            }
            $arr['sweet'] = $tempSweet;
        }else{
            $arr['sweet'] = '';
        }

        //Creo un array per i contorni che contiene il suo nome e il prezzo
        $singlemenu_other = $this->fromMenuSectionToArrayDish($tempSingleMenu_other);
        if($singlemenu_other){
            $tempOther = array();
            foreach ($singlemenu_other as $ot) {
                array_push($tempOther,array("name" => $ot['name'],"price" => $ot['price']));
            }
            $arr['other'] = $tempOther;
        }else{
            $arr['other'] = '';
        }

        //Creo un array per i vini che contiene il suo nome e il prezzo
        $singlemenu_wine = $this->fromMenuSectionToArrayDish($tempSingleMenu_wine);
        if($singlemenu_wine){
            $tempWine = array();
            foreach ($singlemenu_wine as $wn) {
                array_push($tempWine,array("name" => $wn['name'],"price" => $wn['price']));
            }
            $arr['wine'] = $tempWine;
        }else{
            $arr['wine'] = '';
        }

        return $arr;
    }

    /*Prendo l'id del piatto e creo delle righe all'interno dell'array che mi viene passato una per ogni ingrediente
    * in cui i campi sono [id dell'ingrediente][quantità di quell'ingrediente][numero di persone su cui è tarata quella ricetta][quantità pro capite]
    * i due campi veramente necessari sono il primo e l'ultimo, gli altri li ho lasciati per completezza ma per i calcoli
    * successivi non sono necessari
    */
    function createRowIngredientQuantityAndPushInArray($idPiatto,$personeRichieste,$generalArray){
        //ingredienti per quel piatto
        $ingredienti = $this->ingredient_model->getAllIngredientsFromDish($idPiatto);
        //persone calcolate per quel piatto
        $persone = $this->dish_model->getPeopleFromDish($idPiatto);
        foreach ($ingredienti->result() as $i) {
            //Calcolo la quantità dell'ingrediente sulla base della quantità totale, del numero di persone per quella ricetta e di quelle richieste
            $rapportoPersone = ((float) $personeRichieste) / ((float) $persone);
            $tempQuantita = (float)(((float)$i->quantity) * ((float)$rapportoPersone));
            //Creo un array chiave=>valore in modo che poi possa ordinarli e raggrupparli
            array_push($generalArray, array("ingredient_id" => $i->ingredient_id, 
                                            "quantity" => $tempQuantita));
        }
        return $generalArray;
    }

    /*Funzioni accessorie*/
    //Funzione che dato l'array proveniente dall'unserialize mi ritorna un array chiave->valore
    //con id e nome di ogni piatto
    //******** La funzione originaria è fromMenuSectionToArrayDish nel controller Menu
    function fromMenuSectionToArrayDish($array){
        $arrayRitorno = array();

        //Controllo se array è valido
        if($array){
            foreach ($array as $arr) {
                $tempDish = $this->dish_model->singleDish($arr);
                array_push($arrayRitorno,array("id" => $tempDish['id'], "name" => $tempDish['name'], "price" => $tempDish['price']));
            }
        }

        return $arrayRitorno;
    }

    /*function testPrint(){
        // Load all views as normal
        $this->load->view('welcome_message');
        // Get output html
        $html = $this->output->get_output();
        
        // Convert to PDF
        $this->dompdf->load_html($html);
        $this->dompdf->render();
        $this->dompdf->stream("welcome.pdf");
    }*/

}
?>