<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
Copyright (C) 2014  Web3king - Alberto Bonacina

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
 
class Dish_model extends CI_Model{
        
    function __construct(){
        // Call the Model constructor
        parent::__construct();
    } 

    function getAllDishes($id){
        $this->db->select('*');
        $this->db->from('dish');
        $this->db->order_by('name','asc');
        $query = $this->db->get();
        return $query;
    }

    function getAllDishFromType($id){
        $this->db->select('*');
        $this->db->from('dish');
        $this->db->where('type',$id);
        $this->db->order_by('name','asc');
        $query = $this->db->get();
        return $query;
    }

    function createDish($id){
    	$data = array(
            'name' => $this->input->post('name'),
            'kcal' => $this->input->post('kcal'),
            'people' => $this->input->post('people'),
            'type' => $this->input->post('type'),
            'price' => $this->input->post('price'),
            'description' => $this->input->post('description')
        );
        $insert = $this->db->insert('dish',$data);

        //seleziono il max id dei piatti, per prendere l'ultimo
        $this->db->select_max('id', 'massimo');
        $queryMax = $this->db->get('dish');
        foreach ($queryMax->result() as $rowMax){
           $massimo = $rowMax->massimo;
        }

        //Array che contiene gli ingredienti selezionati
        $ingredientiSelezionati = $this->input->post('ingredients');
        //Array che contiene le quantità immesse per ogni prodotto
        $quantitaImmesse = $this->input->post('quantity');
        //metto nella tabella gli ingredinti e le quantità
        if($ingredientiSelezionati){
            //aggiungo gli ingredienti con id che ho appena trovato
            foreach ($ingredientiSelezionati as $ing) {
                $piattoIng = array(
                    'dish_id' => $massimo,
                    'ingredient_id' => $ing,
                    'quantity' => $quantitaImmesse[$ing]
                );
                $insertPiattoIng = $this->db->insert('dish_ingredient',$piattoIng);
            }
        } 

        return $insert;
    }

    function getPeopleFromDish($idDish){
        $this->db->select('people');
        $this->db->where('id',$idDish);
        $queryPeople = $this->db->get('dish');
        foreach ($queryPeople->result() as $p){
           $persone = $p->people;
        }
        return $persone;
    }

    function singleDish($idDish){
        $this->db->select('*');
        $this->db->from('dish');
        $this->db->where('id',$idDish);
        $query = $this->db->get();
        return $query->row_array();
    }

    function deleteDish($idDish,$idUser){
        //Elimino il piatto
        $this->db->delete('dish', array('id' => $idDish)); 
        //Elimino tutte le associazioni che aveva il piatto con gli ingredienti
        $this->db->delete('dish_ingredient', array('dish_id' => $idDish));
    }

    function updateDish($idDish,$idUser){
        //Elimino tutte le associazioni che aveva il piatto con gli ingredienti così ho meno problemi con gli update
        $this->db->delete('dish_ingredient', array('dish_id' => $idDish));

        //Faccio update delle informazioni sul piatto
        $data = array(
            'name' => $this->input->post('name'),
            'kcal' => $this->input->post('kcal'),
            'people' => $this->input->post('people'),
            'type' => $this->input->post('type'),
            'price' => $this->input->post('price'),
            'description' => $this->input->post('description')
        );
        $this->db->where('id', $idDish);
        $this->db->update('dish', $data);
        
        //Salvo gli ingredienti con quel piatto
        $ingredientiSelezionati = $this->input->post('ingredients');
        //Array che contiene le quantità immesse per ogni prodotto
        $quantitaImmesse = $this->input->post('quantity');
        //metto nella tabella gli ingredinti e le quantità
        if($ingredientiSelezionati){
            //aggiungo gli ingredienti con id che ho appena trovato
            foreach ($ingredientiSelezionati as $ing) {
                $piattoIng = array(
                    'dish_id' => $idDish,
                    'ingredient_id' => $ing,
                    'quantity' => $quantitaImmesse[$ing]
                );
                $insertPiattoIng = $this->db->insert('dish_ingredient',$piattoIng);
            }
        }
    }

}

?>