<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
Copyright (C) 2014  Web3king - Alberto Bonacina

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
 
class Ingredient_model extends CI_Model{
        
    function __construct(){
        // Call the Model constructor
        parent::__construct();
    } 

    function getAllIngredients($id){
        $this->db->select('ingredient.id as id,ingredient.name as name, ingredient.measure as measure, measure_type.name as measurename');
        $this->db->from('ingredient');
        $this->db->join('measure_type', 'ingredient.measure = measure_type.id');
        $this->db->order_by('name','asc');
        //$this->db->order_by('id','asc');
        $query = $this->db->get();
        return $query;
    }

    function getAllIngredientsFromDish($idDish){
        $this->db->select('*');
        $this->db->from('dish_ingredient');
        $this->db->where('dish_id',$idDish);
        $this->db->order_by('id','asc');
        $query = $this->db->get();
        return $query;
    }

    function getAllMeasure($id){
        $this->db->select('*');
        $this->db->from('measure_type');
        $this->db->order_by('id','asc');
        $query = $this->db->get();
        return $query;
    }

    function getAllTypes($id){
        $this->db->select('*');
        $this->db->from('dish_type');
        $this->db->order_by('id','asc');
        $query = $this->db->get();
        return $query;
    }

    function getAllIngredientInfoFromId($id){
        $this->db->select('ingredient.id as id, ingredient.name as name, measure_type.name as measure');
        $this->db->from('ingredient');
        $this->db->join('measure_type', 'ingredient.measure = measure_type.id');
        $this->db->where('ingredient.id',$id);
        $query = $this->db->get();
        return $query->row(0);
    }

    function createIngredient($id){
    	$data = array(
            'name' => $this->input->post('ingredient-name'),
            'measure' => $this->input->post('measure')
        );
        $insert = $this->db->insert('ingredient',$data);
        return $insert;
    }

    function updateIngredient($id){
        $data = array(
                    'name' => $this->input->post('nome'),
                    'measure' => $this->input->post('measure'),
                );
        $where = "id = '".$this->input->post('id')."'";
        $update = $this->db->update_string('ingredient',$data,$where);
        $query = $this->db->query($update);
    }

}

?>