<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
Copyright (C) 2014  Web3king - Alberto Bonacina

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class Menu_model extends CI_Model{
        
    function __construct(){
        // Call the Model constructor
        parent::__construct();
    } 

    //Funzione che mi ritorna tutti i menu creati
    function getAllMenu($id){
        $this->db->select('*');
        $this->db->from('menu');
        $this->db->order_by('date','asc');
        $query = $this->db->get();
        return $query;
    }

    function singleMenu($idMenu){
        $this->db->select('*');
        $this->db->from('menu');
        $this->db->where('id',$idMenu);
        $query = $this->db->get();
        return $query->row_array();
    }

    //Funzione per creare un menu
    function createMenu(){

        //Salvo in variabili locali le informazioni che mi passa nel form
        $thisDate = $this->input->post('date'); 
        $thisType = $this->input->post('type'); 
        $thisTitle = $this->input->post('title'); 
        $thisStarterName = $this->input->post('starter-name'); 
        $thisFirstName = $this->input->post('first-name'); 
        $thisSecondName = $this->input->post('second-name'); 
        $thisSweetName = $this->input->post('sweet-name'); 
        $thisOtherName = $this->input->post('other-name'); 
        $thisWineName = $this->input->post('wine-name');
        
        //Serializzo l'array che mi viene passato per metterlo nel db
        $starterString = json_encode($this->input->post('starter'));
        $firstString = json_encode($this->input->post('first'));
        $secondString = json_encode($this->input->post('second'));
        $sweetString = json_encode($this->input->post('sweet'));
        $otherString = json_encode($this->input->post('other'));
        $wineString = json_encode($this->input->post('wine'));

        $data = array(
            'date' => $thisDate,
            'type' => $thisType,
            'title' => $thisTitle,
            'starter_name' => $thisStarterName,
            'first_name' => $thisFirstName,
            'second_name' => $thisSecondName,
            'sweet_name' => $thisSweetName,
            'other_name' => $thisOtherName,
            'wine_name' => $thisWineName,
            'starter_array' => $starterString,
            'first_array' => $firstString,
            'second_array' => $secondString,
            'sweet_array' => $sweetString,
            'other_array' => $otherString,
            'wine_array' => $wineString
        );  
        $insert = $this->db->insert('menu',$data);
    }

    //Funzione che fa update di un menu già esistente
    function updateMenu($idMenu,$idUser){

        //Salvo in variabili locali le informazioni che mi passa nel form
        $thisDate = $this->input->post('date'); 
        $thisType = $this->input->post('type'); 
        $thisTitle = $this->input->post('title'); 
        $thisStarterName = $this->input->post('starter-name'); 
        $thisFirstName = $this->input->post('first-name'); 
        $thisSecondName = $this->input->post('second-name'); 
        $thisSweetName = $this->input->post('sweet-name'); 
        $thisOtherName = $this->input->post('other-name'); 
        $thisWineName = $this->input->post('wine-name');
        
        //Serializzo l'array che mi viene passato per metterlo nel db
        $starterString = json_encode($this->input->post('starter'));
        $firstString = json_encode($this->input->post('first'));
        $secondString = json_encode($this->input->post('second'));
        $sweetString = json_encode($this->input->post('sweet'));
        $otherString = json_encode($this->input->post('other'));
        $wineString = json_encode($this->input->post('wine'));

        $data = array(
            'date' => $thisDate,
            'type' => $thisType,
            'title' => $thisTitle,
            'starter_name' => $thisStarterName,
            'first_name' => $thisFirstName,
            'second_name' => $thisSecondName,
            'sweet_name' => $thisSweetName,
            'other_name' => $thisOtherName,
            'wine_name' => $thisWineName,
            'starter_array' => $starterString,
            'first_array' => $firstString,
            'second_array' => $secondString,
            'sweet_array' => $sweetString,
            'other_array' => $otherString,
            'wine_array' => $wineString
        ); 
        $this->db->where('id', $idMenu);
        $this->db->update('menu', $data);
    }

    //Funzione che elimina il menu con id = idMenu
    function deleteMenu($idMenu,$idUser){
        //Elimino il menu
        $this->db->delete('menu', array('id' => $idMenu)); 
    }

    /* Mi ritorna una "matrice" con 6 righe (i prossimi 6 giorni compreso oggi)
    *  e 3 colonne (i pasti di un determinato giorno).
    *  Se la componente è [i][j] è 0 allora non è stato ancora creato un menù per quel giorno
    *  altrimenti viene riportato l'id della riga corrispondente
    */
    function nextMenu($days,$idUser){
        $menu = array(
            $this->getMenufromDay($days[0]),
            $this->getMenufromDay($days[1]),
            $this->getMenufromDay($days[2]),
            $this->getMenufromDay($days[3]),
            $this->getMenufromDay($days[4]),
            $this->getMenufromDay($days[5]),
            $this->getMenufromDay($days[6]),
            $this->getMenufromDay($days[7])
        );
        //array[0] = $this->getMenufromDay($days[0]);
        return $menu;
    }

    //Mi faccio ritornare tutti i menu che sono compresi tra due date
    function menuBetweenTwoDates($id){
        $prima = $this->input->post('start-date');
        $seconda = $this->input->post('end-date');

        $this->db->select('*');
        $this->db->from('menu');
        $this->db->where('date >=',$prima);
        $this->db->where('date <=',$seconda);
        $this->db->order_by('date','asc'); 
        $this->db->order_by('type','asc'); 
        $query = $this->db->get();
        return $query;

    }

    //Mi ritorna un array di 3 componenti che rappresentano i 3 pasti del giorno
    //se la componente è 0 allora non è stato messo nessun menu altrimenti riporta id del menu
    function getMenufromDay($day){
        $dayMenuArray = array(
            $this->getMenuFromDayAndType($day,'1'),
            $this->getMenuFromDayAndType($day,'2'),
            $this->getMenuFromDayAndType($day,'3')
        );
        return $dayMenuArray;
    }

    //Mi ritorna l'id del menu se esiste o 0 se non è stato creato ancora nulla
    function getMenuFromDayAndType($day,$type){
        $this->db->select('*');
        $this->db->from('menu');
        $this->db->where('date',$day);
        $this->db->where('type',$type);
        $query = $this->db->get();
        if($query->num_rows() > 0){//Mi ha ritornato qualcosa
            $row = $query->row_array(); 
            return $row['id'];
        }else{
            return '0';
        }
    }
}

?>