<!--Copyright (C) 2014  Web3king - Alberto Bonacina

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<h1>Manage Ingredient</h1>

<div class="col-lg-12">
	<div class="panel panel-info">
		<div class="panel-heading">Create a new ingredient</div>
		<div class="panel-body">
		    
		    <?php   
                    $attributes = array('role' => 'form', 'class' => 'form-horizontal');

                    echo form_open('ingredient/createIngredientDb',$attributes);                    

                    echo "<div class='row'><div style='margin-left:1em;' class='col-md-4'>";
                    	echo "<div class='form-group'>";
		                    $nome_array = array('type' => 'text',
		                        'name' => 'ingredient-name',
		                        'class' => 'form-control',
		                        'placeholder' => 'Ingredient'
		                    );
		                    echo form_input($nome_array);
		                    echo "</div>";
		                echo "</div>";

	                	echo "<div style='margin-left:1em;' class='col-md-3'>";
			                echo "<div class='form-group'>";
			                    echo '<div class="col-md-12">';
			                    	echo '<select name="measure" class="form-control">';

			                    	foreach($measureFromDb->result() as $measure){
				                    	echo '<option value="'.$measure->id.'">'.$measure->name.'</option>';
									};
									$measureFromDb->free_result(); 
									echo "</select>";
			                    echo '</div>';
		                    echo "</div>";
		                echo "</div>";
	                    
	                    echo "<div style='margin-left:1em;' class='col-md-2'><div class='form-group'>";
		                    $button_array = array('class' => 'btn btn-primary btn-block',
		                        'type' => 'submit',
		                        'name' => 'submit',
		                        'value' => 'Add Ingredient' 
		                    );
		                    echo form_submit($button_array);
		                    echo "</div>";
		                echo "</div>";
		               	echo form_close();
		            echo "</div>";                       
            ?>

		</div>	
	</div>
</div>	

<div class="col-lg-12" style="margin-bottom:2em;">

	<div class="panel panel-info">
		<div class="panel-heading">Ingredient List</div> 
		<div class="panel-body">
			<div class="table-responsive">
				<table class="table table-striped table-bordered" id="myTable">
			                    <thead>
			                            <tr>
			                                    <th>Ingredient</th>
			                                    <th>Measure</th>
			                                    <th>Actions</th>
			                            </tr>
			                    </thead>
			                    <tbody>
			                        <?php foreach($ingredentsFromDb->result() as $row): ?>
			                        <tr>
			                            <td><?php echo $row->name; ?></td>
			                            <td><?php echo $row->measurename; ?></td>
			                            <td>
			                                <div class="btn-group">
			                                    <a href="#editRow<?php echo $row->id;?>" data-toggle="modal" class="btn btn-info"><i class="fa fa-pencil"></i></a>
			                                    <!--<a class="btn btn-danger" href="<?php echo base_url();?>index.php/workspace/eliminaViaDb/<?php echo $via->id;?>"><i class="icon-trash icon-white"></i></a>-->
			                                </div>
			                            </td>
			                        </tr>

			                        <!--Parte dedicata ai modal-->
			                        <div class="modal fade" id="editRow<?php echo $row->id;?>" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
			                        	<div class="modal-dialog">
			                        		<div class="modal-content">
					                            <div class="modal-header">
					                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
					                                <h3 class="modal-title" id="myModalLabel">Edit Ingredient</h3>
					                            </div>
					                            <div class="modal-body">
						                            Modify ingredient and then clik <i>Edit</i></b>
						                            <?php
						                                echo form_open('ingredient/updateIngredientDb/');
						                                echo form_hidden('id',$row->id);

						                                echo "<div class='form-group'>";
						                                $nome_array = array('type' => 'text', 
						                                                    'name' => 'nome', 
						                                                    'class' => 'form-control',
						                                                    'value' => $row->name);  
						                                echo form_input($nome_array);
						                                echo "</div>";

						                                echo '<select name="measure" class="form-control">';
									                    	foreach($measureFromDb->result() as $measure){
									                    		if($measure->id == $row->measure){
										                    		echo '<option selected="selected" value="'.$measure->id.'">'.$measure->name.'</option>';
										                    	}else{
										                    		echo '<option value="'.$measure->id.'">'.$measure->name.'</option>';
										                    	}
															};
															$measureFromDb->free_result(); 
														echo "</select>";

														echo "<div class='form-group' style='margin-top:1em;'>";
							                                $button_array = array('class' => 'btn btn-success', 'type' => 'submit', 'name' => 'submit', 'value' => 'Edit');
							                                echo form_submit($button_array);
						                                echo "</div>";

						                                echo form_close();
						                            ?>
					                            </div>
					                        </div>
				                        </div>
			                        </div>

			                        <?php endforeach; ?>
			                    </tbody>
			    </table>
			</div>
		</div>
	</div>
</div>

