<?php 
// SiT! Language File - German (de-DE) by Patrick Liebhardt & Raffael Luthiger
// 2011-08-25: Translation improved by Gabriele Pohl (contact@dipohl.de)

$languagestring = 'German (de-DE)';
$i18ncharset = 'UTF-8';

// List of letters of the alphabet for this language
// in standard alphabetical order (upper case, where applicable)
$i18nAlphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';

// list of strings (Alphabetical by key)
$str0MeansUnlimited = '0 bedeutet unbegrenzt';

$str1Day = '1 Tag';
$str1Minute = '1 Minute';
$str1Month = '1 Monat';
$str1Hour = '1 Stunde';
$str1IncidentsLoggedViaPortal = 'Eine Anfrage ging im Portal ein';
$str1Second = '1 Sekunde';
# e.g 1st day of month
$str1st = 'erstes';
$str1Year = '1 Jahr';

$str2nd = 'zweites';

# e.g 3rd day of month
$str3rd = 'drittes';

# e.g. About this site, i.e. more information
$strAbout = 'Über uns';
# e.g. About John Smith
$strAboutPerson = 'Über %s';
$strAboutXMinutesAgo = 'Vor ungefähr %d Min.';
$strAboveMustBeCompletedToAllowDeductions = 'Das obige vollständig ausfüllen um Abzüge zu ermöglichen';
$strAbsentSick = 'Abwesend (Krank)';
$strAcceptingIncidents = 'Nehme Tickets an';
$strAccountManager = 'Account Manager';
$strActual = 'zur Zeit';
$strAcknowledge = 'Annehmen';
# e.g. Accepting incidents
$strAccepting = 'Nehme Aufgaben an';
$strAccessDetails = 'Zugriffsberechtigungen';
$strAction = 'Aktion';
$strActions = 'Aktionen';
$strActionNeeded = 'Aktion notwendig';
$strActionPlan = 'Aktionsplan';
$strActionPlanBy = 'Aktionsplan erstellt von %s';
$strActionPlanHasBeenMade = 'Ein Aktionsplan wurde erstellt';
$strActionTaken = 'Aktion durchgeführt';
$strActive = 'Aktiv';
$strActiveContracts = 'Aktive Verträge';
$strActiveUnassigned = 'Aktiv (nicht zugewiesen)';
$strActivities = 'Tätigkeiten';
$strActivitiesForX = 'Tätigkeiten für %s';
$strActivity = 'Tätigkeit';
$strActivityAdded = 'Tätigkeit hinzugefügt';
$strActivityBilling = 'Tätigkeitsverrechnung';
$strActivityBillingInfo = 'Nur abgeschlossene Tätigkeiten werden zur Berechnung angezeigt.';
$strActivityCompleted = 'Tätigkeit abgeschlossen: %s, Dauer war: %s minutes';
$strActivityContainsNoNotes = 'Tätigkeit beinhaltet keine Notizen';
$strActivityForIncidentX = 'Tätigkeit für Anfrage %s';
$strActivityList = 'Tätigkeitenliste';
$strActivityMarkedCompleteSuccessfully = 'Tätigkeit wurde als erledigt gekennzeichnet.';
$strActivityStarted = 'Ativität gestartet: %s';
# i.e. Create, New
$strAdd = 'Hinzufügen';
$strAddAction = 'Aktion hinzufügen';
$strAddActionToXTrigger = 'Aktion zu Trigger \'%s\' hinzufügen';
$strAddContact = 'Kontaktperson hinzufügen';
$strAddContract = 'Vertrag hinzufügen';
$strAddContractConfirm = 'Wollen Sie diese Kontaktperson wirklich hinzufügen?';
$strAdded = 'Hinzugefügt';
$strAddEmailConfirm = 'Wollen Sie wirklich diesen E-Mail Typ anlegen?';
$strAddEmailTemplate = 'Email-Vorlage hinzufügen';
$strAddFeedbackForm = 'Abfrageformular hinzufügen';
$strAddFeedbackQuestion = 'Neue Frage hinzufügen';
$strAddIncident = 'Ticket hinzufügen';
$strAdditional = 'Zusätzlich';
$strAdditionalInfo = 'Zusätzliche Informationen';
$strAddKBArticle = 'Beitrag für Wissensfundus hinzufügen';
$strAddLink = 'Verknüpfung hinzufügen';
$strAddNew = 'Neu anlegen';
$strAddNewSiteContact = 'Ansprechpartner/in hinzufügen';
$strAddNewSupportedContact = 'Kontaktperson hinzufügen';
$strAddNote = 'Notiz hinzufügen';
$strAddProduct = 'Produkt hinzufügen';
$strAddProductInformation = 'Produkt Information hinzufügen';
$strAddProductQuestion = 'Produktspezifische Fragestellung ergänzen';
$strAddReseller = 'Wiederverkäufer/in anlegen';
$strAddress = 'Adresse';
$strAddress1 = 'Adresse1';
$strAddress2 = 'Adresse2';
$strAddRole = 'Rolle hinzufügen';
$strAddRSSAtomFeed = 'RSS/Atom Feed hinzufügen';
$strAddService = 'Dienstleistung hinzufügen';
$strAddServiceLevel = 'Dienstezusage hinzufügen';
$strAddsIncidentBasedOnEmail = 'Neues Ticket aus E-Mail erstellen';
# i.e. Physical site
$strAddSite = 'Niederlassung hinzufügen';
$strAddSiteFailed = 'Eintrag der Niederlassung fehlgeschlagen';
# i.e. Addition of site failed
$strAddXfailed = 'Hinzufügen von %s fehlgeschlagen';
$strAddSiteSupportIncident = 'Ticket für Kunde anlegen';
$strAddSkill = 'Fachbereich hinzufügen';
$strAddTask = 'Aufgabe hinzufügen';
$strAddTemplate = 'Vorlage hinzufügen';
$strAdditionFail = 'Hinzufügen fehlgeschlagen';
$strADuplicateAlreadyExists = 'Ein doppelter Eintrag existiert';
$strAddUser = 'Bearbeiter/in hinzufügen';
$strAddVendor = 'Lieferant/in hinzufügen';
$strAdjust = 'Anpassen';
$strAdjustActivityDuration = 'Tätigkeitsdauer anpassen';
$strAdmin = 'Admin';
$strAdminContact = 'Adminkontakt';
$strAdminContactForContracts = 'Sie sind für folgende Verträge der Adminkontakt. Sie können auswählen, wer diese Tickets im Portal sehen kann.';
$strAdministratorsOnly = 'Nur für Admins';
$strAdminOnly = 'Nur für Admin';
$strAdvanced = 'Erweitert';
$strAfternoon = 'Nachmittag';
$strAfterXSurveys = 'nach %s Umfragen';
$strAge = 'Alter';
# e.g. 4 hours ago
$strAgo = 'seit %s';
$strAListOfAvailableTriggers = 'Liste der verfügbaren Trigger und Aktionen, die von diesen ausgelöst werden';
$strAll = 'Alle';
$strAllActivities = 'Alle Tätigkeiten';
$strAllClosed = 'Alle Erledigten';
$strAllContacts = 'Alle Kontaktpersonen';
$strAllDay = 'den ganzen Tag';
$strAllIncidents = 'Alle Tickets';
$strAllOnline = 'Alle';
$strAllOpen = 'Alle Offenen';
$strAllTasks = 'Alle Aufgaben';
$strAllowIncidentReopen = 'Erlaube das Wiederöffnen von Tickets';
$strAllSiteContactsSupported = 'Alle Kontaktpersonen der Niederlassung werden unterstützt';
# i.e. Sorted by alphabet
$strAlphabetically = 'Alphabetisch';
$strAlternative = 'Alternativ';
$strAmount = 'Betrag';
$strAmountToEditBy = 'Betrag kann mit +ve/-ve bearbeitet werden';
# i.e. before noon
$strAM = 'Vormittags';
$strAnswer = 'Antwort';
# e.g. SiT is an application
$strApplication = 'Anwendung';
$strApprovalStatusUnknown = 'Freigabestatus unbekannt';
$strApprove = 'Freigeben';
$strApproveAll = 'Alle freigeben';
$strApproveTimesheets = 'Stundenabrechnung freigeben';
$strApproved = 'frei gegeben';
$strApproveFree = 'Freigabe bestätigen';
$strApprovedFree = 'Als freigegeben bestätigt';
$strApproveHolidays = 'Urlaub gewähren';
# Short for April
$strAprAbbr = 'Apr';
# Month number 4: April
$strApril = 'April';
$strArchivedApproved = 'Archivierung bestätigt';
$strArchivedApprovedFree = 'Archiviert: Freigabe \'Frei\'';
$strArchiveDaysBookedPriorToX = 'Archiviere Tage, die vor %s gebucht wurden';
$strArchivedDenied = 'Archivierung abgelehnt';
$strArchivedNotRequested = 'Archivierung nicht angefragt';
$strArchivedRequested = 'Archivierung angefragt';
$strArticlesPublishedRecently = 'Zuletzt veröffentlichte Beiträge';
$strArticlesPublishedToday = 'Heute veröffentlichte Beiträge';
# Which area of the product does the problem occur in?
$strArea = 'Fachbereich';
$strAreYouSureAdd = 'Wollen Sie dies wirklich hinzufügen?';
$strAreYouSureAddContract = 'Vertrag hinzufügen. Fortsetzen?';
$strAreYouSureAddEscalationPath = 'Eskalationspfad hinzufügen. Fortsetzen?';
$strAreYouSureAddReseller = 'Wiederverkäufer/in hinzufügen. Fortsetzen?';
$strAreYouSureAddProduct = 'Produkt hinzufügen. Fortsetzen?';
$strAreYouSureAddProductInfo = 'Produktinformation ergänzen. Fortsetzen?';
$strAreYouSureAddSite = 'Niederlassung hinzufügen. Fortsetzen?';
$strAreYouSureAddSkill = 'Fachbereich hinzufügen. Fortsetzen?';
$strAreYouSureAddUser = 'Bearbeiter/in hinzufügen. Fortsetzen?';
$strAreYouSureAddVendor = 'Lieferant/in hinzufügen. Fortsetzen?';
$strAreYouSureDelete = 'Dieser Eintrag wird dauerhaft gelöscht! Fortsetzen?';
$strAreYouSureDeleteMaintenceContract = 'Wenn die Kontaktperson gelöscht wird, können Sie ihre Aufträge im Rahmen dieses Vertrags nicht mehr verfolgen. Fortsetzen?';
$strAreYouSureEditEmailTemplate = 'Vorlage bearbeiten. Fortsetzen?';
$strAreYouSureEditEscalationPath = 'Eskalationspfad bearbeiten. Fortsetzen?';
$strAreYouSureMakeTheseChanges = 'Änderungen abspeichern. Fortsetzen?';
$strAreYouSureSendEmail = 'E-Mail versenden. Fortsetzen?';
$strAreYouSureUpdateLastBilled = 'Datum der letzten Rechnungsstellung ändern. Fortsetzen?';
$strARecordAlreadyExistsWithTheSameName = 'Ein Datensatz unter diesem Namen existiert schon.';
$strArticle = 'Artikel';
$strAssign = 'Zuordnen';
$strAssignedAsFollows = 'Folgendermassen zuordnen:';
$strAssignTemporarily = 'Temporär zuordnen';
$strAssignTemporarilyTo = 'Temporär zuordnen an';
$strAssignTo = 'Zuordnen zu';
$strAssignToBackup = 'Dem Vertreter zuordnen';
$strAssignToOther = 'Jemand anderem zuordnen';
$strAssociateContactWithContract = 'Diese Kontaktperson einem bestehenden Vertrag zuordnen.';
$strAtLunch = 'Mittagspause';
$strAttachFile = 'Datei anhängen';
$strAttachment = 'Anhang';
$strAttachments = 'Anhänge';
$strAttachedIsBillableIncidentsForAbovePeriod ='Angehängt finden Sie die für den angegebenen Zeitraum zu zahlenden Posten.';
# Short for August
$strAugAbbr = 'Aug';
# Month number 8: August
$strAugust = 'August';
$strAuthor = 'Autor';
$strAuthors = 'Autoren';
$strAutoReassignmentsThatCouldntBeMade = 'Automatische Wiederzuordnungen, weil der Bearbeiter/in-Status die Zuordnung nicht zuließ.';
$strAvailableBalance = 'Kontostand';
# Average Assigned per month
$strAvgAssignedMonth = 'Durchschnittlich zugewiesen (Monat)';
# Average Closed per month
$strAvgClosedMonth = 'Durchschnittlich geschlossen (Monat)';
# Average Escalated per month
$strAvgEscalatedMonth =  'Durchschnittlich eskaliert (Monat)';
$strAverageIncidentDuration = 'Durchschnittliche Bearbeitungsdauer';
$strAvoidDupes = 'Bitte überprüfen Sie, ob der Eintrag nicht bereits existiert.';
$strAwaitingApproval = 'Wartet auf Freigabe';
$strAwaitingClosure = 'Wartet auf Abschluss';
$strAwaitingClosureVar =  'Ob die Anfrage jetzt geschlossen oder als abzuschliessen gekennzeichnet wird.';
$strAwaitingColleagueResponse = 'Wartet auf Rückmeldung von Mitarbeiter/in';
$strAwaitingCustomerAction = 'Wartet auf Reaktion des Kunden';
$strAwaitingSupportResponse = 'Wartet auf Antwort des Supports';
$strAwaitingYourResponse = 'Wartet auf Ihre Rückmeldung';

$strBackToList = 'Zurück zur Liste';
$strBackToLoginPage = 'Zurück zur Login Seite';
$strBackToSites = 'Zurück zur Niederlassung';
$strBackOneYear = 'Ein Jahr zurück';
$strBalance = 'Bilanz';
$strBCC = 'BCC';
$strBeforeDeleteContact = 'Vor der Löschung müsssen Sie zunächst eine andere Kontaktperson auswählen, die die Aufgaben und Verträge übernimmt.';
# noun, a bill to pay money
$strBill = 'Rechnung';
$strBillableIncidentApproved = 'Zu zahlenden Posten freigegeben';
$strBillableIncidentApprovedDesc = 'Erscheint wenn ein zu zahlender Posten freigegeben wird.';
$strBillableIncidents = 'Zu zahlende Posten';
$strBillableIncidentsForPeriodXtoX = 'Zu zahlende Posten im Zeitraum von %s bis %s';
$strBillableIncidentsReport = 'Bericht über zu zahlende Posten';
$strBilling = 'Rechnungsstellung';
$strBillingCustomerPeriod = 'Berechnungseinheit (Kunde)';
$strBillingEngineerPeriod = 'Berechnungseinheit (Techniker/in)';
$strBillingSummary = 'Rechnungszusammenfassung';
# verb, to book a holiday
$strBook = 'Buchen';
$strBookHoliday = 'Urlaub eintragen';
$strBoth = 'Beide';
$strBrowse = 'Auflisten';
$strBrowseContacts = 'Kontaktperson suchen';
$strBrowseContracts = 'Verträge ansehen';
$strBrowseContractsBySite = 'nach Niederlassung';
$strBrowseFeedback = 'Rückmeldungen';
$strBrowseFeedbackForms = 'Abfrageformulare';
$strBrowseJournal = 'Journal durchsuchen';
$strBrowseKB = 'Im Wissensfundus nachschlagen';
$strBrowseSites = 'Niederlassung suchen';
$strBulkModify = 'Sammel-Änderung';

# e.g. by Fred
$strby = 'von';

$strByContact = 'nach Kontaktperson';
$strByEngineer = 'nach Techniker/in';
$strByEscalation = 'nach Eskalation';
$strByGroup = 'nach Gruppe';
$strByMaintenance = 'nach Vertrag';
# e.g. Ordered By Product
$strByProduct = 'nach Produkt';
$strByReseller = 'nach Wiederverkäufer/in';
$strBySkill = 'nach Fachbereich';
$strBySite = 'nach Niederlassung';
$strBytes = 'Bytes';
$strByDate = 'nach Datum';
$strBySLA = 'nach SLA';
$strByVendor = 'nach Lieferant';
# e.g. By: Joe Bloggs
$strByX = 'Von: %s';

$strCalendar = 'Kalender';
# verb: Calculate, plural noun: Units
$strCalculateUnits = 'Einheiten berechnen';
# incident status: e.g. Made a phone call and left a message
$strCalledAndLeftMessage = 'Angerufen und Nachricht hinterlassen';
$strCallFromCustomer = 'Anruf von Kunde';
$strCallToCustomer = 'Kunde anrufen';
$strCallMustBeAssignedBeforeClosure = 'Anruf muss zugeordnet werde, bevor er geschlossen werden kann.';
# Data Protection message, happy to receive phone calls
$strCallsOK = 'Anrufe ok';
$strCancel = 'Abbrechen';
$strCannotDeleteSkill = 'Bedaure, dieser Fachbereich kann nicht gelöscht werden, weil er mit Anfragen in Verbindung steht.';
$strCannotResetThisPassword = 'Sie können das Passwort nicht zurücksetzen';
$strCannotResetPasswordInDemoMode = 'Sie können keine Passwörter zurücksetzen, solange sie sich im Demo-Mode befinden.';
$strCannotWriteFile = 'Konnte auf %s nicht schreiben, Sie müssen die Datei manuell sichern.';
$strCategory = 'Kategorie';
$strCause = 'Anlass';
$strCC = 'CC';
$strChange = 'Ändern';
$strCannotEditUserAndRole = 'Sie können Nutzerkonten und Rollen nicht gleichzeitig ändern.';
$strChangeExternalDetailsOnAllOpenForSelected = 'Alle dem/der externen Bearbeiter/in zugeordneten Aufträge werden geändert!';
$strChangeStateFailed = 'Status konnte nicht geändert werden';
$strChangePassword = 'Passwort ändern';
$strChangeTemporaryOwner = 'Temporäre/n Besitzer/in ändern';
$strChangeOwner = 'Besitzer/in ändern';
$strChangingContact = 'Wenn Sie die Kontaktperson oder ihre Fachbereiche ändern, bleibt die Zuordnung der Tickets zum Vertrag erhalten.';
$strCharsToKeepWhenTranslating = 'Bitte lassen Sie bei Übersetzungen folgende Teile unberührt: [b] {word} %s. Das sind Platzhalter, die genau so erhalten bleiben müssen.';
# Chased to mean followed-up for information
$strChased = 'Chased';
$strCheckEnteredData = 'Bitte die eingegeben Daten überprüfen';
$strCheckLDAPDetails = 'LDAP Details überprüfen';
$strCheckUserGroupMembership = 'Gruppenzugehörigkeit überprüfen';
$strCheckWhoHasPermission = 'Prüfen, wer diese Berechtigungen besitzt';
$strCheckingDetails = 'Details werden geprüft';
$strChooseLanguage = 'Bitte Sprache wählen';
$strCity = 'Ort';
$strClearFilter = 'Filter löschen';
$strClickOnDayToSelect = 'Klicken Sie zur Auswahl auf den Tag';
$strClickTitleHeaders = 'Klicken sie auf die Überschrift um den Abschnitt zu aktivieren.';
# e.g. close an incident
$strClose = 'Abschliessen';
# e.g. incident is closed
$strClosed = 'geschlossen';
$strClosedAfterX = 'geschlossen nach %s';
$strClosedBeforeX = 'geschlossen vor %s';
$strClosedBy = 'geschlossen durch';
$strClosedbyX = 'geschlossen durch %s';
$strClosedOnX = 'Geschlossen am %s';
$strCloseImmediately = 'Sofort Beenden';
$strCloseWindow = 'Fenster schliessen';
# i.e. the status at the time of closure
$strClosingStatus = 'Abschluss';
$strClosingThanks = 'Abschlussmeldung';
$strClosureRequested = 'Abschluss angefordert';
$strClosureRequestForIncident = 'Ticket schliessen';
$strCode = 'Code';
$strCollapseData = 'Kompakte Datenansicht';
$strConfiguration = 'Konfiguration';
$strConfigure = 'Konfigurieren';
$strConfirmNewPassword = 'Neues Passwort bestätigen';
# noun, he is a contact
$strContact = 'Kontakt';
$strContactAddedSuccessfully = 'Kontaktperson wurde hinzugefügt';
$strContactID = 'ID Kontaktperson';
$strContinue = 'Weiter';
$strContactDetails = 'Kontaktdaten';
$strContactRecordExists = 'Es gibt bereits einen Kontakt mit diesem Namen und dieser E-Mail Adresse.';
$strContactResetPassword = 'Passwort des Kontakt zurücksetzen';
$strContactNotes = 'Anmerkungen:';
$strContacts = 'Kontaktpersonen';
$strContactsForename = 'Vorname der Kontaktperson';
$strContactsPassword = 'Password der Kontaktperson (nur bei Erzeugung des Nutzerkontos)';
$strContactsPhone = 'Telefonnummer der Kontaktperson';
$strContactsName = 'Nachname Kontaktperson';
$strContactsUsername = 'Portalnutzername der Kontaktperson';
$strContactHasBillableContract = 'Die Kontaktperson hat einen kostenpflichtigen Vertrag';
# e.g. 5 contacts
$strContactsMulti = '%d Kontaktpersonen';
# i.e. legal agreement
$strContract = 'Vertrag';
$strContractAreYouSure = 'Dieses Ticket wird dem Vertrag des Kunden zugeordnet. Fortsetzen?';
$strContractDetails = 'Vertragsdaten';
$strContractID = 'Vertrags-ID';
$strContractProduct = 'Vertragsleistung oder -produkt';
$strContractNum = 'Vertrag %d';
$strContracts = 'Verträge';
$strContractsExpiredXdaysAgo = 'Verträge, die bis vor %s Tagen abgelaufen sind';
$strContractsExpiringWithinXdays = 'Der Vertrag läuft in den nächsten %s Tagen ab';
$strContractsSLA = 'Die Dienstezusage (SLA) dieses Vertrages';
$strControlPanel = 'Systemeinstellungen';
$strComplete = 'Vollständig';
$strCompleted = 'Abgeschlossen';
$strCompletion = 'Bearbeitungsstand';
$strCommentsSentWithRequest = 'Die folgenden Kommentare werden mit der Anfrage';
$strComponentMustBePlacedInDashboardDir = 'Beachten Sie, dass die Komponente im Verzeichnis des Armaturenbretts abgelegt und wie folgt benannt werden muss: %s';
$strCopyFrom = 'Von Kopie';
$strCreateANotice = 'Erstelle eine Anmerkung basierend auf %s';
$strCreateANoticeWhen = 'Erstelle eine Anmerkung basierend auf %s, wenn %s';
$strCreateANoticeForWhen = 'Erstelle eine Anmerkung basierend auf %s für %s, wenn %s';
$strCreatedBy = 'Erstellt von';
$strCreateNewForm = 'Neues Formular erstellen';
$strCredit = 'Kredit';
# e.g. Amount paid into an account
$strCreditAmount = 'Kreditbetrag';
# e.g. film credits
$strCredits = 'Dank';
$strCreateANotice = 'Erstelle eine Anmerkung basierend auf %s';
$strCriteria = 'Kriterien';
$strCritical = 'Kritisch';
$strCriticalPriority = 'Kritische Priorität';
# e.g. John Acme of ACME Widgets Co.
$strContactofSite = '%s von %s';
$strCompassionateLeave = 'Mutterschaft/Vaterschaft/Familiäre Gründe';
$strCount = 'Anzahl';
$strCountContractsByProduct = 'Anzahl Verträge nach Produkt';
# Region / State
$strCounty = 'Bundesland/Kanton';
$strCountry = 'Land';
$strCourtesyTitle = 'Ehrentitel';
$strCreate = 'Erstellen';
$strCSVfile = 'CSV-Datei';
$strCSVFileFormatAsFollows = 'CSV-Format wie folgt';
$strCurrentDate = 'Aktuelles Datum';
$strCurrentLanguage = 'Aktuelle Spracheinstellung';
$strCurrentLanguageDiffers = 'Vom Standard abweichende Spracheinstellung';
$strCurrentOwner = 'Inhaber des Nutzerkontos';
$strCurrentUserEmailAddress = 'E-Mail Adresse dieses Nutzerkontos';
$strCurrentUsersSignature = 'Signatur dieses Nutzerkontos';
$strCurrentlyOpen = 'momentan offen';
$strCurrentlyNoOpenEscalatedIncidentsToModify = 'Zur Zeit sind keine eskalierten Aufträge zur Bearbeitung vorhanden';
$strCustomer = 'Kunde';
$strCustomerFeedback = 'Rückmeldung des Kunden';
$strCustomerFeedbackReportSiteMsg = 'Der Report zeigt die Antworten der Kundenumfrage und ein Diagramm, das prozentual darstelle, wie zufrieden die Kunden mit der Bearbeitung der Kundenanfragen insgesamt sind.';
$strCustomerExport = 'Kunden exportieren';
$strCustomerImpact = 'Drohender Schaden für den Kunden';
$strCustomerImpactCustomerText = 'Wie viele Personen sind betroffen? Handelt es sich um totalen Systemausfall oder nur eine kleinere Störung? Können die Anwender nicht mehr arbeiten?';
$strCustomerProductsMaintDesc = 'Der Report listet für die gewählten Niederlassungen deren Produkte mit aktuellem oder vergangenem Wartungsvertrag auf.';
$strCustomerReference = 'Kundenreferenz';
$strCustomerReferenceDate = 'Datum der Kundenreferenz';
$strCustomerReminded = 'Kunde wurde erinnert';
$strCustomerRemindedByPhone = 'Kunde wurde per Telefon erinnert';
$strCustomerReminderUpdate = 'War dieses eine Erinnerung an den Kunden?';
$strCustomerRequestedClosure = 'Kunde beantragt die Schliessung des Tickets';
$strCustomers = 'Kunden';
# Visible for customers
$strCustomerVisible = 'Dem Kunden sichtbar';

$strDailyRate = 'Tagesvotum';

$strCustomers = 'Kunden';

# i.e. place for widgets
$strDashboard = 'Armaturenbrett';
$strDashboardComponentDoesntExist = 'Die Armatur %s existiert nicht';
$strDataProtection = 'geschützt';
# i.e. 25th December
$strDate = 'Datum';
$strDateAndTime = 'Datum und Zeit';
$strDatesAre = 'Die Daten sind';
$strDatesAwaitingApproval = 'Termine warten auf die Genehmigung';
$strDatesNotRequested = 'Termin nicht angefragt';
$strDatesNotYetApproved = 'Termine noch nicht bestätigt';
$strDay = 'Tag';
$strDayOfMonth = 'Tag %s jeden Monats';
$strDayOfYear = 'Tag %s jeden Jahres';
$strDays = 'Tage';
$strDayView = 'Tagesansicht';

$strdaysother = 'Tage sonstige Abwesenheit';
$strdayssick = 'Krankheitstage';
$strdaystraining = 'Tage Fortbildung';
$strdaysworkingaway = 'Tage ausser Haus';

$strDebit = 'Schuldner';
# Short for December
$strDecAbbr = 'Dez';
# Month number 12: December
$strDecember = 'Dezember';
$strDecline = 'Ablehnen';
$strDeclined = 'Absteigend';
$strDefault = 'Standard';
$strDefaultNewEntitlement = 'Vorgabe Urlaubsanspruch';
$strDefaultSubstitute = 'Standard-Stellvertreter/in';
$strDefineSubstituteEngineer = 'Festlegung stellvertretende/r Techniker/in';
$strDefineSubstituteEngineersFor = 'Stellvertreter/in für %s festlegen';
$strDelete = 'Löschen';
$strDeleteContact = 'Kontakt löschen';
$strDeleteSite = 'Niederlassung löschen';
$strDeleteAllSpam = 'Alle Mails aus der Spam-Schlange löschen';
$strDeleted = 'Gelöscht';
$strDeleteTask = 'Aufgabe löschen';
$strDenied = 'Verweigert';
$strDepartment = 'Abteilung';
$strDescendingDateOrder = 'Absteigend nach Datum sortiert';
$strDescription = 'Beschreibung';
$strDestinationService = 'Ziel';
$strDetails = 'Details';
$strDetailsAndLog = 'Details und Log';
$strDetailsSend = 'Details senden';
$strDidYouPasteFullURL = 'Haben Sie die vollständige URL aus der E-Mail eingefügt?';
$strDidYourBrowserBlockPopupWindow = 'Sind PopUp-Windows im Browser geblockt?';
$strDifference = 'Differenz';
$strDisassociateSkillWithProduct = 'Fachbereich vom Produkt lösen';
$strDisable = 'deaktivieren';
# i.e. not available
$strDisabled = 'Ausgeschaltet';
$strDisclaimer = 'Widerruf';
# i.e. make it go away
$strDismiss = 'Verwerfen';
$strDismissAll = 'Alles verwerfen';
# i.e. show
$strDisplay = 'Anzeige';
$strDisplaying = 'Anzeigen';
$strDisplayingXcontactMatchingY = 'Anzeige von %s Kontaktpersonen passend zum Suchmuster %s';
$strDisplayPreferences = 'Anzeige Einstellungen';
$strDistribution = 'Auslieferung';
$strDocumentIDX = 'Dokument ID %s %s';
$strDoesNOTApply = 'Passt NICHT';
$strDoesThisUpdateMeetSLA = 'Schliesst diese Tätigkeit einen Schritt des SLA ab?';
$strDoNothing = 'Keine Aktion';
$strDraftChoose = 'Mehrere Entwürfe existieren. Bitte wählen Sie einen aus.';
$strDraftDelete = 'Entwurf löschen';
$strDraftEdit = 'Entwurf bearbeiten';
$strDraftsEmailExist = 'Mailentwürfe existieren';
$strDraftsExist = 'Vorlagen existieren';
$strDraftsUpdateExist = 'Aktualisierte Entwürfe existieren';
$strDraftLastSaved = 'Entwurf zuletzt gespeichert';
$strDueDate = 'Fälligkeitsdatum';
$strDueNow = 'Fälligkeit jetzt';
# the noun; 'a duplicate'
$strDuplicate = 'Dublette';
$strDurability = 'Haltbarkeit';
$strDuration = 'Dauer';
# When the passed duration is not the same as the entry in the database
$strDurationMismatch = 'Zeitraum passt nicht';
$strDurationUpdated = 'Zeitraum aktualisiert';

$strEarliestExpiry = 'Frühester Ablauf:';
# verb, i.e. to change
$strEdit = 'Bearbeiten';
$strEditContact = 'Kontaktperson bearbeiten';
$strEditContract = 'Vertrag bearbeiten';
$strEditFeedbackQuestion = 'Frage bearbeiten';
$strEditFTPdetailsUpload = 'Details zur Datei bearbeiten und veröffentlichen';
$strEditGlobalSignature = 'Globale Signatur bearbeiten';
$strEdited = 'Bearbeitet';
$strEditedBy = 'Bearbeitet durch %s';
$strEditBalance = 'Kontostand bearbeiten';
$strEditEmail = 'Email bearbeiten';
$strEditEscalationPath = 'Eskalations-Pfad bearbeiten';
$strEditEscalationPathFailed = 'Bearbeitung des Eskalations-Pfades fehlgeschlagen';
$strEditHolidays = 'Urlaub bearbeiten';
$strEditHolidayEntitlement = 'Urlaubsanspruch bearbeiten';
$strEditKBArticle = 'Wissensfundus Artikel bearbeiten';
$strEditProduct = 'Produkt bearbeiten';
$strEditProfile = 'Profil bearbeiten';
$strEditProfileFor = 'Profil bearbeiten von %s';
$strEditRole = 'Rolle bearbeiten';
$strEditRSSAtomFeed = 'RSS/Atom-Feed bearbeiten';
$strEditService = 'Dienstleistung bearbeiten';
$strEditServiceLevel = 'Dienstezusagen bearbeiten';
$strEditSite = 'Niederlassung bearbeiten';
$strEditSiteType = 'Typ der Niederlassung bearbeiten';
$strEditSkill = 'Fachbereiche bearbeiten';
$strEditTask = 'Aufgabe bearbeiten';
$strEditTemplate = 'Vorlage bearbeiten';
$strEditUserSkills = 'Fachbereiche bearbeiten';
$strEditVendor = 'Lieferant/in bearbeiten';
$strEditWatchedIncidents = 'Angezeigte Aufgaben ändern';
# Punctuation mark 'Ellipsis' to indcate an unfinished phrase or sentence. (dot dot dot "..." in English)
$strEllipsis = '&hellip;';
$strEmail = 'E-Mail';
$strEmailAddress = 'E-Mail Adresse';
# Do you want to send an email with login details to the contact?
$strEmailContactLoginDetails = 'Logindaten an die Kontaktperson versenden?';
$strEmailDetails = 'E-Mail Details';
# eg novell.com
$strEmailDomain = 'E-Mail Domäne bearbeiten';
$strEmailFromCustomer = 'E-Mail des Kunden';
$strEmailMustBeUnique = 'E-Mail muss eindeutig sein';
$strEmailOK = 'E-Mail OK';
$strEmailReceivedAbbrev = 'E-Mail Empf.';
$strEmailreceivedby = 'E-Mail entgegen genommen von %s';
$strEmailsentby = 'E-Mail gesendet von %s';
$strEmailSendFeedbackDesc = 'Sendet dem Kunden eine Abfrage.';
$strEmailSent = 'E-Mail gesendet';
$strEmailSettings = 'E-Mail-Einstellungen';
$strEmailSignature = 'E-Mail-Signatur';
$strEmailTemplate = 'E-Mail-Vorlage';
$strEmailToCustomer = 'E-Mail zum Kunden';
$strEmailTransmittedAbbrev = 'E-Mail ges.';
$strEmailIncidentClosureDesc = 'Benachrichtigt die Kontaktperson, dass dis Ticket zum Abschluss vorgesehen und bald geschlossen wird.';
$strEmailIncidentLoggedContactDesc = 'Bestätigt die Kontaktdaten und teilt die neue Ticket-ID mit';
$strEmailIncidentOutOfSlaDesc = 'Nachricht, dass ein Ticket die Bearbeitungsfrist überschreitet.';
$strEmailIncidentOutOfReviewWDesc = 'Nachricht, dass die Frist zur Nachprüfung des Tickets überschritten wurde.';
$strEmailIncidentCreatedUserDesc = 'Informiert Bearbeiter/in, dass ein neues Ticket erstellt wurde.';
$strEmailIncidentReassignedUserNotifyDesc = 'Informiert Bearbeiter/in, wenn ein Ticket zugeordnet wurde';
$strEmailIncidentNearingSlaDesc = 'Informiert, wenn ein Ticket droht, die Bearbeitungsfrist zu überschreiten.';
$strEmailContactResetPasswordDesc = 'Nachricht an die Kontaktperson um das Passwort zurückzusetzen';
$strEmailUserResetPasswordDesc = 'Nachricht an Eigentümer/in des Nutzerkontos um das Passwort zurückzusetzen';
$strEmailNewContactDetailsDesc = 'Information über neu angelegte Kontaktperson';
$strEmailIncidentReviewDueDesc = 'Information über Fristablauf der Ticket-Nachprüfung';
$strEmailKbArticleCreatedDesc = 'Informiert darüber, dass ein neuer Artikel im Wissensfundus erstellt wurde';
$strEmailHeldEmailReceivedDesc = 'Information über neu eingegangene E-Mail';
$strEmailHeldEmailMinsDesc = 'Information, dass sich eine E-Mail seit x Minuten in der Zuweisungsstation befindet';
$strEmailUserChangedStatusDesc = 'Information, dass Bearbeiter/in den Status geändert hat';
$strEmailSitUpgradedDesc = 'Information über einen System-Upgrade';
$strEmailContactCreatedDesc = 'Information über eine neue Kontaktperson';
$strEmailIncidentClosedContactDesc = 'Informiert die Kontaktperson, dass ein Ticket geschlossen wurde';
$strEmailIncidentClosedUserDesc = 'Informiert Bearbeiter/in, dass ein Ticket geschlossen wurde';
$strEmailContractAddedDesc = 'Informiert über neu angelegten Vertrag';
$strEmailUserCreatedDesc = 'Informiert über Neuzugang Bearbeiter/in';
$strEmailSiteCreatedDesc = 'Informiert über neu angelegte Niederlassung';
$strEmailExternalIncidentClosureDesc = 'Informiert externe/n Bearbeiter/in, dass ein Ticket geschlossen wurde';
$strEmailHolidaysRequestedDesc = 'Informiert die Bearbeiter/innen, dass sie ihren Urlaub bestätigen müssen';
$strEmailServiceLevelDesc = 'Informiert die Vertriebsleute, wenn ein Wert unter ein vorgegebenes Limit fällt';
$strEmailIncidentUpdatedCustomerDesc = 'Nachricht an Kunden, wenn der Bearbeiter das Ticket aktualisiert hat.';
$strEmailSupportEmailDesc = 'Allgemeine Vorlage für E-Mails an die Kunden';
$strEnabled = 'Aktiviert';
$strEndDate = 'Enddatum';
$strEndOfLife = 'Ende der Nutzungsdauer';
$strEngineer = 'Bearbeiter';
$strEngineers = 'Bearbeiter';
$strEngineerMonthlyActivityTotals = 'Monatliche Tätigkeiten insgesamt';
$strEngineersStatisticsForXMonths = 'Bearbeiter Statistik für %s Monate';
$strEngineerUtilisation = 'Auslastung Bearbeiter/in';
$strEnglish = 'Englisch';
$strEnterCredentials = 'Geben Sie Ihre Zugangsdaten für %s ein';
$strEnterDetailsAboutIncidentToBeStoredInLog = 'Machen Sie Angaben zu Ihrem Anliegen. Diese werden im System für die weitere Bearbeitung gespeichert.';
$strEnterNumericValue = 'Hier wird eine numerische Angabe erwartet';
$strEnterNumberOfDays = 'Geben Sie die Anzahl der Tage an';
$strEnterTheIncidentID = 'Ticket ID eingeben';
$strEnterTheCallID = 'Ticket ID eingeben';
$strEntitlement = 'Bezeichnung';
#computer environment
$strEnvironment = 'Umgebung';
# Acronym for end of life
$strEOL = 'END';
$strError = 'Fehler';
$strErrorAssigningUpdate = 'Fehler beim Speichern der Änderung. Ursache kann sein, dass kein Ticket mit dieser ID existiert oder es zwischenzeitlich geschlossen wurde.';
$strErrorNoEmptyForm = 'Fehler: Kein leeres Formular gefunden um die Ergebnisse zu speichern.';
$strErrorRequiredQuestionsNotCompleted = 'Fehler: Sie haben nicht alle erforderlichen Angaben gemacht. Prüfen Sie Ihre Angaben und versuchen es noch einmal.';
$strErrorSendingEmail = 'Fehler beim E-Mail-Versand';
$strErrorUploading = 'Fehler beim Hochladen';
$strEscalated = 'Eskaliert';
$strEscalatedIncidents = 'Eskalierte Tickets';
$strEscalation = 'Eskalation';
$strEscalationPaths = 'Eskalationswege';
$strEvent = 'Ereignis';
$strEverybodysTasks = 'Allgemeine Aufgaben';
$strExceeded = 'Überschritten';
$strExclude = 'ausklammern';
$strExcludeSitesWith = 'Schliesse Niederlassungen aus, die';
$strExpire = 'Ablaufen';
$strExpired = 'Abgelaufen';
$strExpiryDate = 'Ablaufdatum';
$strExpiryDateCannotBeInThePast = 'Das Ablaufdatum kann nicht in der Vergangenheit liegen';
$strExternalEmail = 'Externe E-Mail';
$strExternalEngineer = 'Externe/r Bearbeiter/in';
$strExternalEngineerEmail = 'E-Mail-Adresse d. Externen';
$strExternalEngineersFirstName = 'Vorname d. Externen';
$strExternalEngineersName = 'Nachname d. Externen';
$strExternalEscalation = 'Externe Eskalation';
$strExternalEngineerCallDistribution = 'Externe/r Bearbeiter/in fordert Auslieferung';
$strExternalID = 'Externe ID';
$strExternalInfo = 'Externe Information';
$strExternalInfoAddedBy = 'Externe Information ergänzt von %s';

$strFailed = 'Misslungen';
$strFailedOnPass2 = 'Misslungen im zweiten Schritt';
$strFailedtoApproveTransactID = 'Bestätigung der Transaktions-ID misslungen';
$strFailedToFindDateIncidentClosed = 'Kein Abschlussdatum gefunden';
$strFatalError = 'Fataler Fehler';
$strFax = 'Fax';
$strFeatures = 'Komponenten';
# Short for February
$strFebAbbr = 'Feb';
# Month number 2: February
$strFebruary = 'Februar';
$strFeedback = 'Abfragen';
$strFeedbackAfterX = 'Rückmeldung nach %s';
$strFeedbackBeforeX = 'Rückmeldung vor %s';
$strFeedbackBetweenXandY = 'Rückmeldung zwischen %s und %s';
$strFeedbackForm = 'Abfrageformular';
$strFeedbackForms = 'Abfrageformulare';
$strFeedbackReport = 'Bericht über Rückmeldungen';
$strFeedbackFormsRequested = 'Es gibt %s Abfrage(n), die nicht beantwortet wurde(n)';
$strFeedbackFormsWaiting = 'Es gibt %s Abfrage(n), die noch nicht beantwortet wurde(n)';
$strFeedbackRequested = 'Abfrage bislang unbeantwortet';
$strFeedbackURL = 'Rückmelde-URL';
# e.g. rss feeds
$strFeeds = 'RSS Feeds';
$strFeedIcon = 'RSS Feed Icon';
$strFewMinutesAgo = 'Vor ein paar Minuten';
# e.g. spreadsheet field
$strField = 'Feld';
$strField1 = 'Feld 1';
$strField2 = 'Feld 2';
$strField3 = 'Feld 3';
$strField4 = 'Feld 4';
$strField5 = 'Feld 5';
$strField6 = 'Feld 6';
$strField7 = 'Feld 7';
$strField8 = 'Feld 8';
$strField9 = 'Feld 9';
$strField10 = 'Feld 10';
$strField11 = 'Feld 11';
$strField12 = 'Feld 12';
$strFieldMustNotBeBlank = 'Formularfeld %s darf nicht leer bleiben';
# e.g. form fields
$strFields = 'Felder';
$strFileManagement = 'Dateimanagement';
$strFilename = 'Dateiname';
$strFile = 'Datei';
# e.g. computer files
$strFiles = 'Dateien';
$strFileDate = 'Dateidatum';
$strFileSavedAs = 'Datei gespeichert als: %s';
$strFileUploaded = 'Datei hochgeladen';
$strFileVersion = 'Dateiversion';
# e.g. File filename.txt (Text file 100 bytes) uploaded OK
$strFileXUploadedOK = 'Datei %s (%s %d bytes) hochgeladen. OK.';
$strFilter = 'Filter';
$strFilterActiveOnlyShowingIncidentsForX = 'Filter aktiv: Zeige nur Anfragen für Suchmuster %s';
$strFinalUpdate = 'Letztes Update';
$strFinalSolutionby = 'Endgültige Lösung von %s';
$strFindContact = 'Kontaktperson auswählen';
$strFirstCustomerVisibleUpdate = 'Die erste für den Kunden sichtbare Fortschreibung des Tickets';
$strFollowingSpecialIdentifiers = 'Die folgenden Variablen können in den Feldern verwendet werden:';
$strFollowThisLink = 'diesem Link folgen';
#e.g. for a person
$strFor = 'für';
$strForce = 'Erzwingen';
$strForceTo = 'Erzwingen zu';
$strForenames = 'Vorname';
$strForFurtherAssistance = 'Für weitere Hilfestellung kontaktieren Sie bitte %s';
$strForgottenDetails = 'Passwort vergessen?';
$strForIncident = 'Für Ticket';
$strForThePeriodXToY = 'Für den Zeitraum von %s bis %s';
$strForgottenPasswordDetails = 'Details zu Password vergessen';
$strForm = 'Formular';
$strFormInvalidExpired = 'Das Formular war ungültig. Ursache war möglicherweise, dass es abgelaufen war, bevor Sie es versandt haben. Bitte versuchen Sie es noch einmal.';
$strForRefundsThisShouldBeNegative = 'Für Erstattungen muss dieser Wert negativ sein';
$strForwardOneYear = 'Um ein Jahr verschieben';
$strForXDaysHoursMinutes = 'Für <em>x</em> Tage, Stunden, Minuten';
$strFoundNoUsersToReport = 'Keine Bearbeiter/innen gefunden über die zu berichten wäre';
$strFreeOfCharge = 'Gebührenfrei';
$strFrequency = 'Häufigkeit (oder Frequenz?)';
# Short for 'Friday'
$strFri = 'Fr';
$strFriday = 'Freitag';
# Two character (Maximum) abbreviation for 'Friday'
$strFridayAbbr = 'Fr';
# e.g. from x to y
$strFrom = 'Von';
$strFromXResults = 'von %s Ergebnissen';
# FTP - File Transfer Protocol
$strFTP = 'FTP';
$strFTPFailedCreatingDirectoryX = 'FTP konnte Verzeichnis %s nicht anlegen';
$strFTPFileDetails = 'FTP Dateiinfo';
$strFTPFileXUploaded = 'FTP Datei %s hochgeladen';
$strFTPFilesDB = 'FTP Dateien DB';
$strFTPPublish = 'FTP Veröffentlichen';
$strFullDay = 'Ganzer Tag';
$strFullDetails = 'Alle Details';
$strFullNameCurrentUser = 'Kompletter Name';

$strGBytes = 'GBytes';
$strGeneral = 'Allgemein';
$strGetHelpOnline = 'Online-Hilfe';
$strGlobalSignature = 'Globale E-Mail-Signatur';
$strGlobalSignatureDescription = 'Signatur, die am Fuss ausgehender E-Mails eingefügt wird.  Diese sollte mit zwei Bindestrichen, einem Leerzeichen und anschließenden Zeilensprung eingeleitet werden.';
$strGlobalSignatureRemember = 'Denken Sie daran, dass jede Änderung sofort wirksam wird und ausgehende E-Mails mit der neuen Signatur versehen werden.';
$strGo = 'Weiter';
$strGracePeriod = 'Gnadenfrist';
$strGrandTotal = 'Gesamtsumme';
$strGroup = 'Gruppe';
$strGroupMembersAway = 'Abwesende Gruppenmitglieder';
$strGroupMembership = 'Gruppenmitgliedschaft';
$strGroupNameMustNotBeEmpty = 'Gruppenname darf nicht leer sein';


$strHandled = 'behandelt';
# Incident 3 has been automatically moved to John's Action Needed queue, three %s variables in this: incident number, queue name, users name
$strHasBeenAutoMovedToX = 'Ticket %s wurde automatisch in %s\'s %s Schlange verschoben';
# Incident 3 has been moved to John's Action Needed queue, three %s variables in this: incident number, queue name, users name
$strHasBeenMovedToX = 'Ticket %s wurde in %s\'s %s Schlange verschoben';
$strHAVESkills = 'Meine Fachbereiche';
$strHeldEmailsNum = '%d wartende E-Mails';
$strHelp = 'Hilfe';
$strHelpAbout = 'Über';
# A single character (e.g. question mark) used as a Help link,
$strHelpChar = '?';
$strHelpContents = 'Hilfe-Inhalte';
$strHelpToTranslate = 'Diese Seite soll Übersetzern von SiT! helfen!';
$strHide = 'verstecken';
$strHideInPortal = 'Im Portal verbergen';
$strHidingIncidentsOlderThan = 'Aufträge, die älter als %d Tage alt sind, ausblenden';
$strHigh = 'Hoch';
$strHigherPriority = 'Höhere Priorität';
$strHighPriority = 'Hohe Priorität';
$strHoldingQueue = 'Zuweisungsstation';
$strHoldingQueueMinutes = 'Anzahl von Minuten, während der sich die E-Mail in der Zuweisungsstation befindet.';
$strHoliday = 'Urlaub';
$strHolidayAfternoon = 'Nur diesen Nachmittag';
$strHolidayAfternoonOnly = 'Urlaub nur an diesem Nachmittag';
$strHolidayAfternoonOnlyConfirm = 'Sind sie sicher, dass Sie nur diesen Nachmittag Urlaub machen wollen?';
$strHolidayApproverEmail = 'E-Mail Adresse der Urlaub genehmigenden Person';
$strHolidayCancelConfirm = 'Wirklich stornieren?';
$strHolidayCancel = 'Urlaub stornieren';
$strHolidayFullDayConfirm = 'Sind sie sicher, dass Sie einen ganzen Tag in Anspruch nehmen wollen?';
$strHolidayFullDay = 'Den ganzen Tag in Anspruch nehmen';
$strHolidayList = 'Urlaubsliste';
$strHolidayMorningOnly = 'Nur an diesem Vormittag';
$strHolidayMorningOnlyConfirm = 'Sind Sie sicher, dass Sie nur den Vormittag in Anspruch nehmen wollen?';
$strHolidays = 'Urlaube';
$strHolidayEntitlement = 'Urlaubsanspruch';
$strHolidayPlanner = 'Urlaubsplaner';
$strHolidayRequested = 'Urlaubsantrag';
$strHolidayRequests = 'Urlaubsanträge';
$strHolidayType = 'Art von Urlaub';
$strHolidayUsage = 'Genommener Urlaub';
$strHomeURL = 'Startseite';
$strHours = 'Stunden';

# i.e. short for identification; unique number
$strID = 'ID';
$strIfYourBrowserNotReload = 'Wenn Ihr Browser die Seite nicht innerhalb der nächsten Sekunden erneut lädt';
$strIfYouShouldHaveAccess = 'Sprechen Sie die Systemverwalter an, wenn Sie diese Funktionen des Systems benötigen.';
$strImportant = 'Wichtig';
$strInactive = 'Inaktiv';
$strInbound = 'Eingehend';
$strInboundEmailIsDisabled = 'Eingehende E-Mail ist in Ihrer SiT-Konfiguration deaktiviert';
$strInbox = 'Posteingang';
$strIncident = 'Ticket';
$strIncidentActivitiesIntro = 'Diese Seite behandelt Tätigkeiten, deren Zeitverbrauch überwacht werden soll.';
$strIncidentAdded = 'Ticket hinzugefügt';
$strIncidentAssigned = 'Ticket zugeordnet';
$strIncidentAssignmentWasForcedUserNotAccept = 'Das Ticket wurde zwangsweise zugeordnet, weil Bearbeiter/in keine Tickets akzeptierte';
$strIncidentsBySiteReportDesc = 'Dieser Bericht listet alle Tickets für die ausgewählten Niederlassungen.';
$strIncidentCCList = 'Weitere E-Mail-Adressen, die in Kopie unterrichtet werden sollen';
$strIncidentClosed = 'Ticket geschlossen';
$strIncidentCreated = 'Ticket erstellt';
$strIncidentEmail = 'Ticket-E-Mail';
$strIncidentEscalatedReportDesc = 'Dieser Bericht listet %s ausgewählte Tickets von denen %s eskaliert sind';
$strIncidentID = 'Ticket-ID';
$strIncidentIsOpen = 'Ticket eröffnet und erwarte Aktion';
$strIncidentLogOrder = 'Sortierung der Ticket-Anzeige';
$strIncidentLoggedEngineer = 'Anfrage wurde mit der Ticket-ID %s hinzugefügt, bitte jetzt Bearbeiter/in auswählen';
$strIncidentMonitor = 'Anfragemonitor';
$strIncidentNearingSLA = 'Fristende nähert sich bei Ticket';
$strIncidentNoContract = 'Dieses Ticket ist unter diesem Vertrag nicht vorhanden';
$strIncidentNum = 'Ticket-ID %d';
$strIncidentNumOrSearchTerm = 'Ticket-ID oder Suchbegriff';
# Abbreviation of incidents per owner
$strIncidentPerOwnerAbbrev = 'Tickets nach Eigentümer';
$strIncidentPool = 'Anfragepool';
$strIncidentRate = 'Ticket-Bewertung';
$strIncidentPriority = 'Ticket-Priorität';
$strIncidentRefresh = 'Ticket neu laden';
$strIncidentResolved = 'Ticket wurde gelöst oder neu priorisiert.\nDie Problembeschreibung muss innerhalb der Servicezusage noch entsprechend angepasst oder neu formuliert werden';
$strIncidentReviewDue = 'Ticket-Nachprüfungprüfung ist fällig';
$strIncidentTypeWasBlank = 'Typ des Tickets nicht definiert';
$strIncidentUpdatedExternally = 'Ticket wurde von extern geändert';
$strIncidentUpdatedExternallyDesc = 'Erscheint, wenn ein Ticket von extern geändert wurde';
$strIncidentUpdatedInternally = 'Ticket von intern geändert';
$strIncidentUpdatedInternallyDesc = 'Erscheint, wenn ein Ticket von intern geändert wurde';
$strIncidents = 'Tickets';
$strIncidentsAvailable = 'Vorhandene Tickets';
$strIncidentsByEngineer = 'Tickets nach Bearbeiter/in';
$strIncidentsBySite = 'Tickets nach Niederlassung';
$strIncidentsBySkill = 'Tickets nach Fachbereich';
$strIncidentsByVendor = 'Tickets nach Hersteller';
$strIncidentsClosedToday = '%s Tickets heute abgeschlossen';
$strIncidentsContactEmail = 'E-Mail-Adresse der Kontaktperson';
$strIncidentsDailySummary = 'Tagesbericht Tickets';
$strIncidentsForEngineer = 'Tickets von Bearbeiter/in %s';
$strIncidentsinQueue = 'Tickets in dieser Schlange';
$strIncidentsList = 'Ticket-Liste';
$strIncidentsLoggedOpenClosed = 'Tickets (neu/laufend/geschlossen)';
$strIncidentsLoggedToday = '%s Tickets heute erstellt';
$strIncidentsMulti = '%d Tickets';
$strIncidentsOpenedEachDay = 'Dieser Bericht zeigt, wieviele Tickets täglich eröffnet wurden. Fahren Sie mit dem Mauszeiger über den Balken um die Tagesgrafik zu sehen.';
$strIncidentsRequiringReminderByPhone = 'Tickets, bei denen eine telefonische Erinnerung angefordert wurde';
# e.g. Incidents opened on 2007-12-03
$strIncidentsVerbOnDate = '%s Tickets am %s';
# e.g. Incidents opened between 2007-12-03 and 2007-12-04
$strIncidentsVerbBetweenDates = '%s Tickets eröffnet zwischen %s und %s';
$strIncidentOwnerID = 'Ticket-Eigentümer ID';
$strIncidentOwnersFullName = 'Voller Name der Person, welche das Ticket erstellte (oder bearbeitet?)';
$strIncidentOwnersEmail = 'E-Mail-Adresse des Ticket-Eigentümers';
$strIncidentsUsed = 'Tickets bearbeitet';
$strIncidentTitle = 'Betreff des Tickets';
$strIncidentUpdatesPerPage = 'Ticket-Fortschreibungen pro Seite';
$strIncidentXIsClosed = 'Ticket [%s] ist geschlossen';
$strInclude = 'Einbinden';
$strIncoming = 'Eingehend';
$strIncomingEmail = 'Eingehende E-Mail';
$strIncomingEmailSpam = 'Eingehende E-Mail unter SPAM-Verdacht';
$strIncomingEmailText = 'Eingehende E-Mail, die nicht automatisch verarbeitet werden konnte';
$strInfo = 'Info';
$strInformationSent = 'Information gesendet';
$strInformationSentRegardingSettingPassword = 'Anleitung zum Passwort zurücksetzen wurde an die angegebene Adresse versandt.';
$strInformX = 'Informiere %s';
$strInitialResponse = 'Anfängliche Reaktion';
# e.g. An abbreviated version of 'Initial Response'
$strInitialResponseAbv = 'AR';
$strInitialResponseBy = 'Anfängliche Reaktion von %s';
$strInitialResponseHasBeenMade = 'Die anfängliche Reaktion ist erfolgt';
$strInMeeting = 'In Besprechung';
$strInMinutes = 'in Minuten';
$strInOffice = 'Im Büro';
$strInOrderToDelete = 'Um den Datensatz zu löschen, müssen Sie einen anderen angeben, der die angehängten Objekte übernehmen soll';
$strInstall = 'Installieren';
$strInstallDashboardComponents = 'Neue Armatur installieren';
$strInterfaceStyle = 'Oberflächengestaltung';
$strInternalEngineer = 'Interne/r Bearbeiter/in';
$strInternalEscalation = 'Interne Eskalation';
$strInternalUseNotDisplayed = 'Nur zum internen Gebrauch. Wird nicht angezeigt.';
$strInterval = 'Intervall';
$strIntroduction = 'Einführung';
$strInvalidCredentials = 'Ungültige Nutzername/Passwort Kombination';
$strInvalidDetails = 'Ungültige Angaben';
$strInvalidEmailAddress = 'Ungültige E-Mail-Adresse';
$strInvalidParameter = 'Ungültiger Parameter';
$strInvalidUserID = 'Ungültige Nutzerkennung';
$strInvalidUsername = 'Ungültiger Nutzername. Bitte benutzen Sie einen anderen';
$strInventory = 'Inventar';
$strInventoryDesc = 'Inventar sind Gegenstände in der Niederlassung wie Workstations, Software, Netzwerkgeräten';
$strInventoryItems = 'Inventarobjekte';
$strIgnore = 'Ignorieren';

$strIgnoreThisAndDelete ='Ignorieren Sie die Neuzuordnung und löschen diese Meldung';

# short for January
$strJanAbbr = 'Jan';
# Month number 1: January
$strJanuary = 'Januar';
$strJobTitle = 'Anrede';
$strJournal = 'Journal';
# Short for July
$strJulAbbr = 'Jul';
# Month number 7: July
$strJuly = 'Juli';
$strJumpTo = 'Springe zu';
$strJumpToEntryLog = 'Springe zum Starteintrag';
$strJumpToIncident = 'Springe zum Ticket';
# Short for June
$strJunAbbr = 'Jun';
# Month number 6: June
$strJune = 'Juni';
# i.e. A moment ago
$strJustNow = 'Gerade eben';


# Abbreviation for Knowledge base
$strKBabbr = 'WB';
$strKBytes = 'KBytes';
$strKBID = 'ID des Artikels im Wissensfundus';
$strKeepCurrentLanguage = 'Aktuelle Sprache beibehalten';
#e.g. graph legend
$strKey = 'Schlüssel';
$strKeywords = 'Stichworte';
$strKnowledgeBase = 'Wissensfundus';
$strKnowledgeBaseArticle = 'Der Wissensfundus Artikel';
$strKnowledgeBaseArticleCreated = 'Wissensfundus Artikel erstellt';
$strKnowledgeBaseArticles = 'Die Wissensfundus Artikel';

$strLanguage = 'Sprache';
$strLatestExpiry = 'Spätestes Ablaufdatum:';
# Last date a bill was generated
$strLastBilled = 'zuletzt verrechnet';
$strLastModifiedBy = 'Zuletzt bearbeitet von';
$strLastMonth = 'letzten Monat';
# Last time an action was executed
$strLastRan = 'Letzter Durchlauf';
$strLastUpdated = 'letztes Update';
# The previous week to this one
$strLastWeek = 'Letzte Woche';
# The previous year to this one
$strLastYear = 'Letztes Jahr';
# LDAP - Lightweight Directory Access Protocol
$strLDAP = 'LDAP';
$strLDAPTestSucessful = 'LDAP Verbindung erfolgreich';
$strLDAPTestFailed = 'LDAP Verbindung fehlgeschlagen';
$strLeaveBlankForNewSection = 'Wenn diese Frage einem neuen Abschnitt zugeordnet werden soll, ergänzen Sie die Bezeichnung hier oder lassen Sie das Feld leer um keinen neuen Abschnitt zu eröffnen';
$strLength = 'Länge';
$strLicense = 'Lizenz';
$strLicenseAndCopyright = 'Lizenz- und Copyright Information';
$strLicenseType = 'Lizenztyp';
$strLicenseQuantity = 'Lizenzmenge';
$strLifetime = 'Laufzeit';
$strLink = 'Link';
$strLinkedSkills = 'Zugeordnete Fachbereiche';
$strLinkedToNumProducts = 'Zugeordnete Produkte';
$strLinkProducts = 'Produkte zuordnen';
$strLinkText = 'Linkbeschriftung';
$strLinks = 'Links';
$strLimit = 'Limitierung';
$strLimitTo = 'Limitiert auf';
$strList = 'Zeige';
$strListsAllTheCustomersProducts = 'Listet alle Produkte des Kunden unabhängig von der oben getroffenen Auswahl';
$strListOfHolidays = 'Liste der Urlaubsanträge';
$strListProducts = 'Produkte auflisten';
$strListShowsContacts = 'Diese Liste zeigt Kontaktpersonen, die den Suchkriterien entsprechen. Wenn ein Wartungsvertrag besteht, können Tickets dazu eingetragen werden';
$strListShowsContracts = 'Diese Liste zeigt Verträge, berechtigte Kontaktpersonen und Produkte für die Unterstützung zur Verfügung steht. Klicken Sie auf den entsprechenden \'%s\' Link um ein Ticket zu erstellen';
$strListSkills = 'Fachbereiche auflisten';
$strLinkSkillToX = 'Ordne Fachbereich zu %s';
$strLoading = 'Lade';
# Parameters defining location, language and regional preferences
$strLocale = 'Spracheinstellung';
$strLocation = 'Ort';
$strLock = 'Sperre';
$strLocked = 'gesperrt';
$strLockedByX = 'Gesperrt von %s';
$strLoggedExternally = 'Erstellt von extern';
$strLogged = 'erstellt';
# E.g. Logged in as: admin, currently On Holiday and Not Accepting calls
$strLoggedInAsXAndCurrentlyXAndX = 'Angemeldet als: %s, aktuell %s und %s';
$strLoggedUnder = 'Ticket wurde unter Vertrag %d eingetragen';
# Title for sign in page
$strLogIn = 'Anmelden';
# Label on sign in button
$strLogin = 'Einloggen';
# Label on sign out button
$strLogout = 'Ausloggen';
$strLogTriggerInJournal = 'Trigger im System Journal protokollieren';
$strLow = 'Niedrig';
$strLowPriority = 'Niedrige Priorität';

$strMaintenance = 'Vertrag';
$strMakeVisibleInPortal = 'Im Portal anzeigen';
$strMap = 'Karte';
$strManageDashboardComponents = 'Armaturen verwalten';
$strManageEmailTemplates = 'Verwalte E-Mail-Vorlagen';
$strManageFTPFiles = 'FTP Dateien verwalten';
$strManageUsers = 'Bearbeiter/innen verwalten';
$strManageYourDashboard = 'Armaturenbrett konfigurieren';
$strMandatoryMarked = 'Erforderliche Felder sind markiert %s';
$strManyThanks = 'vielen Dank an alle, die Kommentare, Ideen, Vorschläge, Fehlerberichte beigesteuert haben, beim Testen geholfen haben oder Programmcode gestiftet haben. Besonderer Dank geht an: (in zufälliger Reihenfolge)';
# Short for March
$strMarAbbr = 'Mär';
# Month number 3: March
$strMarch = 'März';
$strMarkComplete = 'Als erledigt kennzeichnen';
$strMarkedComplete = 'Als erledigt gekennzeichnet';
$strMarkedforclosure = 'Als abgeschlossen kennzeichnen';
$strMarkedforclosureby = 'Als abgeschlossen gekennzeichnet von %s';
$strMarketingMailshot = 'Werbeversand';
$strMarketingMailshotDesc = 'Dieser Bericht listet die Details zu allen Kunden, die aktuell (oder früher) Verträge für die Produkte besitzen, die Sie ausgewählt haben. Dabei dürfen diese keines der ausgewählten Produkte ausgeschlossen haben.';
$strMarkForClosure = 'Als abgeschlossen kennzeichnen';
$strMaxCarryOverXDays = 'Maximale Überschreitung von %s Tagen';
$strMaxResults = 'Es werden maximal %d Treffer angezeigt. Die wirkliche Anzahl von Treffern kann größer sein.';
# Short for the month of May (these happen to be the same in english)
$strMayAbbr = 'Mai';
# Month number 5: May
$strMay = 'Mai';
$strMaxVersion = 'Maximale Version';
$strMBytes = 'MBytes';
$strMedium = 'Mittel';
$strMediumPriority = 'Mittlere Priorität';
$strMenu = 'Menü';
$strMessage = 'Meldung';
# As in "The target was met"
$strMet = 'Erreicht';
$strMidnight = 'Mitternacht';
$strMine = 'Mein';
$strMinutes = 'Minuten';
$strMinVersion = 'Minimale Version';
$strMobile = 'Mobil';
# Short for 'mobile'
$strMob = 'Mob';
# Short for 'Monday'
$strMon = 'Mon';
$strMonday = 'Montag';
# Two character (Maximum) abbreviation for 'Monday'
$strMondayAbbr = 'Mo';
$strMonth = 'Monat';
$strMonthly = 'Monatlich';
$strMonthlyActivityTotals = 'Monatliche Tätigkeiten insgesamt';
$strMonthBreakdown = 'Heruntergebrochen auf Monat';
$strMonthView = 'Ansicht Monat';
$strMore = 'mehr...';
$strMoreContactsThanContractSupports = 'Es sind mehr Kontaktpersonen zugeordnet als im Vertrag erlaubt';
$strMorning = 'Vormittag';
$strMoveUpdate = 'Verschiebe den Update';
$strMovedFromXtoXbyX = 'Verschoben von %s -&gt; %s durch %s';
$strMultipleActivitiesRunning = 'Verschiedene Tätigkeiten in Arbeit';
$strMultipleOptions = 'Mehrere Optionen';
$strMustCompleteActivitiesBeforeClosure = 'Sie müssen zunächst alle Tätigkeiten bei Ticket abschliessen, bevor dieses geschlossen werden kann.';
$strMyDashboard = 'Armaturenbrett';
$strMyDetails = 'Meine Einstellungen';
$strMyHolidays = 'Urlaub';
$strMyIncidents = 'Meine Tickets';
$strMyNotifications = 'Benachrichtigungen';
$strMyProfile = 'Profil';
$strMySkills = 'Fachbereiche';
$strMySubstitutes = 'Vertreter/in';
$strMyTriggers = 'Trigger';

$strName = 'Name';
$strNamedContacts = 'Kontaktpersonen';
#English suffix for second - 2nd
$strnd = 'nd';
$strNeedsSubstitueEngineers = '%s benötigt die Benennung von Vertreter/innen';
$strNegative = 'Negativ';
$strNever = 'Niemals';
$strNewContact = 'Neue Kontaktperson';
$strNewContract = 'Neuer Vertrag';
$strNewDuration = 'Neue Laufzeit';
$strNewEmail = 'Neue E-Mail (keine der obigen)';
$strNewEntitlement = 'Neue Bezeichnung';
$strNewEscalationPath = 'Neuer Eskalationsweg';
$strNewHeldEmail = 'Neue Mail in Zuweisungsstation';
$strNewestAtBottom = 'Neuestes unten';
$strNewestAtTop = 'Neuestes oben';
$strNewIncidentStatus = 'Neuer Ticket-Status';
$strNewKBArticle = 'Neuer Artikel';
$strNewNoteByX = 'Neue Anmerkung von %s';
$strNewPassword = 'Neues Passwort';
$strNewProduct = 'Neues Produkt';
$strNewReseller = 'Neue/r Wiederverkäufer/in';
$strNewPriority = 'Neue Priorität';
$strNewService = 'Neuer Service';
$strNewSite = 'Neue Niederlassung';
$strNewSiteType = 'Neuer Niederlassungstyp';
$strNewSkill = 'Neuer Fachbereich';
$strNewStatus = 'Neuer Status';
$strNewTemplate = 'Neue E-Mail-Vorlage';
$strNewUser = 'Neue/r Bearbeiter/in';
$strNext = 'Nächster';
$strNextAction = 'Nächste Aktion';
# Next time a scheduled task is scheduled to run
$strNextRun = 'Nächster Lauf';
$strNextSLATarget = 'Nächste Servicezusage';
$strNextUpdate = 'Nächste Änderung';
# No being the opposite of Yes
$strNo = 'Nein';
$strNobody = 'Niemand';
$strNoAnswerGiven = 'Keine Antwort erhalten';
$strNoActionSpecified = 'Keine Aktitvität festgelegt';
$strNoBillableIncidents = 'Keine in Rechnung zu stellenden Tickets';
$strNoFiles = 'Keine Dateien';
$strNoneAvailable = 'Keine(r) verfügbar';
$strNonTerminatedContractsExpiredXdaysAgo = 'Nicht beendete Verträge, die vor %s Tagen ausgelaufen sind';
$strNoCalls = 'Keine Anrufe';
$strNoChangesToMake = 'Keine Änderungen zu machen';
$strNoContactsForSite = 'Es gibt keine Kontaktpersonen für diese Niederlassung';
$strNoContractsForSite = 'Es gibt keine Verträge für diese Niederlassung';
$strNoContractsFound = 'Keine Verträge gefunden';
$strNoDashletsInstalled = 'Es sind keine Komponenten für die Übersichtsseite vorhanden. Bitte sprechen Sie Ihre/n Systemverwalter/in an, solche zu installieren';
$strNoDurationOnActivity = 'Keine Dauer für die Tätigkeit angegeben';
$strNoEmail = 'Keine E-Mail';
$strNoEmailSet = 'Sie haben keine E-Mail-Adresse angegeben. Tun Sie es bitte jetzt.';
$strNoFeedbackFound = 'Keine Rückmeldung gefunden';
$strNoFeedbackFormsDefined = 'Es sind keine Abfrageformulare eingerichtet';
$strNoFeedBackFormToCompleteHere = 'Es gibt keine unbeantworteten Abfragen unter dieser Adresse. Möglicherweise, weil Sie Ihre Rückmeldung bereits abgegeben haben. Bitte überprüfen Sie, dass die URL korrekt angegeben ist.';
$strNoFeedsCurrentlyPresent = 'Zur zeit keine RSS-Feeds vorhanden';
$strNoHolidayEntitlement = 'Kein Urlaubsanspruch übrig für dieses Jahr';
$strNoIncidents = 'Keine Tickets';
$strNoIncidentsBeingWatchOfType = 'Keine Beobachtung eingerichtet für diesen Typ';
$strNoLicense = 'keine Lizenz';
$strNoLongerRelevant = 'Nicht länger relevant';
$strNoMatchingTaskFound = 'Keine passende Aufgabe gefunden';
$strNoNameAssociated = 'Kein Name angegeben';
$strNoSLA = 'Keine Servicezusage';
$strNone = 'Keine';
$strNoNewDashboardComponentsToInstall = 'Keine neuen Armaturen verfügbar';
$strNoMatchingTask = 'Keine passende Aufgabe gefunden';
$strNoMatchingProduct = 'Kein passendes Produkt';
$strNoOpenIncidents = 'Keine offenen Tickets';
$strNoOrphandedContacts = 'Keine verwaisten Kontaktpersonen';
$strNotificationEmail = 'E-Mail-Adresse für Benachrichtigungen';
$strNotifications = 'Benachrichtigungen';
$strNotificationsMovedToTriggersPage = 'Benachrichtigungen wurden auf die Trigger-Seite verschoben';
$strNotifyContact = 'Kontaktperson informieren';
$strNotifyContactEmail = 'E-Mail-Adresse für Benachrichtungen an Kontaktperson (wenn gesetzt)';
$strNotifyContactOnClose = 'Wenn Kontaktperson eine Benachrichtigung über das Schliessen des Tickets erhalten soll (wahr oder falsch)';
$strNotifyExternalEngineerOnClose = 'Wenn externe/r Bearbeiter/in eine Benachrichtigung über das Schliessen des Tickets erhalten soll (wahr oder falsch)';
$strNotEscalated = 'Nicht eskaliert';
$strNoServiceWithIDXFound = 'Kein Service mit ID %s gefunden';
$strNoPermission = 'Sie haben keine Berechtigung zur Anzeige dieser Seite';
$strNoPost = 'Keine Zustellung';
$strNoProductInfo = 'Keine Produktinformation';
$strNoProductsForThisVendor = 'Kein Produkt für diesen Hersteller';
$strNoPublicTasks = 'Keine öffentlichen Aufgaben';
$strNoRecords = 'Keine Daten';
$strNoReseller = 'Kein/e Wiederverkäufer/in';
$strNoResponseFound = 'Keine Antwort gefunden';
$strNoResults = 'Kein Treffer';
$strNoResultsFor = 'Kein Treffer für %s';
$strNoRoleSpecified = 'Keine Rolle spezifiziert';
$strNoSchemaAvailableToUpgrade = 'Kein Schema zum Upgrade vorhanden';
$strNOSkills = 'Restliche Fachbereiche';
$strNoSkillsDefined = 'Keine Fachbereiche definiert';
$strNoSkillsLinkedToProduct = 'Dem Produkt ist kein Fachbereich zugeordnet';
$strNoSubstitute = 'Kein/e Vertreter/in angegeben';
$strNoSubstitutes = 'Keine Vertreter/innen angegeben';
$strNoTransactionsMatchYourSearch = 'Keine zum Suchkriterium passende Transaktion gefunden';
$strNoTransactionsFoundWithID = 'Keine Transaktion gefunden mit ID';
$strNoUpgradesForDashboardComponent = 'Keine Aktualisierungen für %s Armatur';
$strNoTasks = 'keine Aufgaben';
$strNotAccepting = 'Keine Annahme';
$strNotAcceptingIncidents = '<strong>Keine Annahme</strong> von Tickets';
# Short for not applicable
$strNotApplicableAbbrev = 'N/A';
$strNotApproved = 'Nicht bewilligt';
$strNotCompleted = 'Nicht beendet';
$strNoticeTemplate = 'Mitteilungsvorlage';
$strNote = 'Anmerkung';
$strNoteAddedBy = 'Anmerkung ergänzt von %s';
$strNoteInsertExternalID = 'Hinweis: Angabe von \'%externalid%\' um die Ticket-ID automatisch vom System einfügen zu lassen';
$strNotes = 'Anmerkungen';
$strNothingToDisplay = 'Nichts anzuzeigen';
$strNothingToLink = 'Nichts zuzuordnen';
$strNotice = 'Meldung';
$strNoticeIncidentAssignedDesc = 'Meldung, wenn Bearbeiter/in ein Ticket zugeordnet wurde';
$strNoticeIncidentAssigned = 'Ticket [{incidentid}] mit Prio {incidentpriority} - {incidenttitle} gemeldet von {contactname} aus Niederlassung {sitename} wurde {incidentowner} zugeordnet';
$strNoticeIncidentClosedDesc = 'Benachrichtigung über das Schliessen eines Tickets';
$strNoticeIncidentClosed = 'Ticket [{incidentid}] - {incidenttitle} wurde von {userrealname} geschlossen';
$strNoticeIncidentCreatedDesc = 'Benachrichtigung über das Anlegen eines neuen Tickets';
$strNoticeIncidentCreated = 'Ticket [{incidentid}] mit Prio {incidentpriority} - {incidenttitle} gemeldet von {contactname} aus Niederlassung {sitename}';
$strNoticeIncidentNearingSLADesc = 'Benachrichtigung über bevorstehende Überschreitung der Bearbeitungsfrist';
$strNoticeIncidentNearingSLA = '{incidentowner}s Ticket [{incidentid}] - {incidenttitle} hat Dienstezusage {nextsla} nicht erfüllt';
$strNoticeIncidentReviewDueDesc = 'Benachrichtigung über bevorstehende Nachprüfung eines Tickets';
$strNoticeIncidentReviewDue = '{incidentowner}s Ticket [{incidentid}] - {incidenttitle} hat die Frist zur Nachprüfung überschritten';
$strNoInicdentsToApprove = 'Keine Tickets zur Übernahme vorhanden';
$strNoticeKBCreatedDesc = 'Benachrichtigung über neuen Artikel im Wissensfundus';
$strNoticeKBCreated = 'Neuer Artikel im Wissensfundus erstellt von {userrealname}: {kbname}';
$strNoticeLanguageDiffersDesc = 'Benachrichtigt die Bearbeiter/innen, dass sie eine von der üblichen Einstellung abweichende Sprache nutzen';
$strNoticeLanguageDiffers = 'Ihre aktuelle Spracheinstellung ({currentlang}) unterscheidet sich von der im Profil eingestellten ({profilelang})';
$strNoticeMinsHeldEmailDesc = 'Benachrichtigung über wartende E-Mail';
$strNoticeMinsHeldEmail = 'Eine E-Mail steht seit {holdingmins} Minuten in der Zuweisungsstation';
$strNoticeNewContactDesc = 'Benachrichtigung, dass eine neue Kontaktperson ergänzt wurde';
$strNoticeNewContact = '{contactname} wurde als neue Kontaktperson für Niederlassung {sitename} ergänzt von {userrealname}';
$strNoticeNewHeldEmailDesc = 'Benachrichtigung über Eingang einer neuen E-Mail';
$strNoticeNewHeldEmail = 'Eine neue E-Mail ist in der Zuweisungsstation';
$strNoticeNewContractDesc = 'Benachrichtigung über einen neuen Vertrag';
$strNoticeNewContract = 'Neuer Vertrag zu {contractproduct} in der Niederlassung {sitename} erstellt von {userrealname}';
$strNoticeNewSite = 'Neue Niederlassung {sitename} erstellt von {userrealname}';
$strNoticeNewSiteDesc = 'Benachrichtigung über neue Niederlassung';
$strNoticeNewUserDesc = 'Benachrichtigung über neue/n Bearbeiter/in';
$strNoticeNewUser = '{userrealname} wurde mit Nutzerkonto in {applicationshortname} ausgestattet';
$strNotices = 'Mitteilungen';
$strNoticeSitUpgradedDesc = 'Benachrichtigung über einen System-Upgrade';
$strNoticeSitUpgraded ='{applicationshortname} wurde auf neue Version {applicationversion} gebracht';
$strNoticeTaskDue = 'Aufgabe {taskid} - {taskname} ist fällig';
$strNoticeTaskDueDesc = 'Benachrichtigung über eine fällige Aufgabe.';
$strNoticeSchedulerTaskFailed = 'Folgende Aufgabe des Zeitplanungsprogramms schlug fehl: {schedulertask}';
$strNoticeSchedulerTaskFailedDesc = 'Benachrichtigung über fehlgeschlagene Zeitplanungsaufgabe';
$strNoticeUserChangedStatusDesc = 'Benachrichgigung über geänderten Status bei Bearbeiter/in';
$strNoticeUserChangedStatus = '{userrealname} hat ihren Status wie folgt geändert: {userstatus} und {useraccepting} von Tickets';
$strNoticesBlurb = 'Hier können Sie eine Nachricht an alle verfassen. BB Code ist erlaubt.';
$strNotifications = 'Benachrichtigungen';
$strNotInOffice = 'Nicht im Büro';
$strNotRequested = 'Nicht gefordert';
$strNotSet = 'Nicht gesetzt';
$strNotSettingArea = '<strong>Hinweis</strong>: Ohne Auswahl des Fachbereichs kann sich die Bearbeitung verzögern.';
$strNotUpdated = 'Nicht aktualisiert';
$strNoUpgradesForDashboardComponent = 'Keine Aktualisierungen für Armatur %s';
# Short for November
$strNovAbbr = 'Nov';
$strNoVendorsDefined = 'Keine Hersteller eingetragen';
# Month number 11: November
$strNovember = 'November';
$strNow = 'jetzt';
$strNumContactsAssignedToSite = 'Es gibt %s Kontaktpersonen in dieser Niederlassung';
$strNumContractsAssignedToSite = 'Es gibt %s Verträge mit dieser Niederlassung';
$strNumOfIncidents = 'Es sind %s Tickets vorhanden';
$strNumOfIncidentsLoggedByX = 'Anzahl Tickets erstellt von %s';
$strNumOfCalls = '# Anrufe';
$strNumOpenIncidents = '%s offen';


$strOccurance = 'Vorfall';
# Short for October
$strOctAbbr = 'Okt';
# Month number 10: October
$strOctober = 'Oktober';
$strOffset = 'Offset';
$strOK = 'OK';
$strOldPassword = 'Altes Passwort';
$strOnHoliday = 'Im Urlaub';
$strOffline = 'Offline';
$strOneOfTheSignaturesWillBeInserted = 'Eine der unten angegebenen Signaturen wird per Zufall ausgewählt und ausgehenden Mails angehängt. Leiten Sie die Signatur bitte mit zwei Bindestrichen gefolgt von einem Leerzeichen und Zeilenumbruch ein.';
$strOneTimeBillingEditor = 'Werkzeug zur Erstellung von Einmal-Rechnungen';
$strOnline = 'Online';
$strOnlyShowsClosedCalls = 'Zeige nur geschlossene Tickets';
$strOnlyShowNewerThan = 'Nur diejenigen älter als %d Tage zeigen';
$strOnlyShowSitesWithActiveContracts = 'Zeige nur Niederlassungen mit aktiven Verträgen';
$strOnTrainingCourse = 'Auf Fortbildung';
# e.g. on 16 July at 8:00am
$strOnxAtY = 'Am %s um %s';
$strOpen = 'Offen';
$strOpened = 'Geöffnet';
$strOpenActivities = 'Nicht abgeschlossene Tätigkeiten';
$strOpenedby = 'Eröffnet von %s';
$strOpenedbyXonY = 'Eröffnet von %s am %s';
$strOpenedViaThePortalByX = 'Eröffnet im Portal von %s';
$strOpenForX = 'Offen für %s';
$strOperation = 'Tätigkeit';
$strOptions = 'Auswahl';
$strOptionsOnePerLine = 'Optionen (eine pro Zeile)';
$strOriginalMessageReceivedAt = 'Originalnachricht erhalten am: %s';
$strOrphanedSites = 'Verwaiste Kunden/Niederlassungen';
$strOther = 'anderes';
$strOtherIncidents = 'Andere Tickets';
$strOtherLeave = 'Andere Gründe';
$strOutbound = 'Ausgehend';
$strOutput = 'Ausgabe';
$strOwnedBy = 'gehört';
$strOwner = 'Bearbeiter/in';
$strOwners = 'Bearbeiter/innen';
$strOwnerXAcctingAgain = 'Bearbeiter/in %s wieder am Platz';
$strOwnerXAndNotAccepting = 'Bearbeiter/in %s nicht am Platz';
$strOverview = 'Übersicht';
$strOverXHoursAgo = 'Vor über %x Stunden';

$strParameters = 'Die Parameter';
$strPassword = 'Passwort';
$strPasswordHasBeenReset = 'Ihr Passwort wurde zurückgesetzt, Sie können sich nun mit den neuen Daten einloggen.';
$strPasswordReset = 'Passwort zurücksetzen';
$strPasswordResetURL = 'Hashed URL zum Passwort rücksetzen';
$strPasswordsDoNotMatch = 'Passworte stimmen nicht überein';
$strPastXDays = 'Nach %s Tagen';
$strPastXMonths = 'Nach %s Monaten';
# e.g. File system directory paths
$strPaths = 'Pfad';
$strPercentageEscalated = 'Prozent eskalierte Tickets';
$strPeriod = 'Zeitraum';
$strPeriodStarted = 'Zeitraum gestartet';
$strPendingReassignments = 'Wartende Zuweisungen';
$strPermission = 'Erlaubnis';
$strPermissionDenied = 'Erlaubnis verweigert';
$strPermissionDeniedForX = 'Erlaubnis verweigert fürr %s';
$strPermissions = 'Rechte';
$strPermissionsInhereitedCannotBeChanged = 'Verborgene Rechte können nicht geändert werden.';
$strPerIncident = 'je Ticket';
$strPerUnit = 'je Abteilung';
$strPerUser = 'je Bearbeiter/in';
$strPreferred = 'Bevorzugt';
$strPreReleaseNotice = 'Sie nutzen eine Vorabversion von SiT %s, diese ist nur zum Testen, für Rückmeldungen und als Unterstützung der Entwicklung gedacht und nicht(!)  zum Einsatz in produktiver Umgebung';
$strPreviousIncidentOwner = 'Vorherige/r Bearbeiter/in';
$strPreviousUpdate = 'Vorheriges Update';
$strPreviousXDays = 'Vorhergehende %s Tage';
$strPreviousXMonths = 'Vorhergehende %s Monate';
$strProblemSettingPassiveFTPMode = 'Problem beim Setzen des passiven FTP Modus';
$strProductX = 'Produkt: %s';
$strProductInformation = 'Produktinformation';
$strProfileLanguage = 'Spracheinstellung im Profil';
$strPhonecallmadeby = 'Anruf getätigt durch %s';
$strPhonecalltakenby = 'Anruf angenommen von %s';
$strPlaceIncidentInWaitingQueue = 'Ticket in die Warteschlange stellen?';
$strPleaseCheckData = 'Überprüfen Sie bitte die eingetragenen Daten';
$strPleaseConfirmUsername = 'Bitte Nutzernamen bestätigen';
$strPleaseWaitRedirect = 'Bitte warten, Sie werden weitergeleitet.';
$strPlugins = 'Plugins';
$strPopularity = 'Popularität';
$strPortal = 'Portal';
$strPositive = 'Positiv';
$strPositivity = 'Zufriedenheit';
$strPossibleNewIncident = 'Mögliches neues Ticket';
# Postal code
$strPostcode = 'Postleitzahl';
$strPostNewNotice = 'Neue Mitteilung veröffentlichen';
$strPostOK = 'Versand OK';
$strPostpone = 'Verschieben';
# pm = After noon
$strPM = 'Nachmittag';
$strPrevious = 'vorherige';
$strPriority = 'Priorität';
$strPrivacy = 'Privatbereich';
$strPrivate = 'Privat';
$strProblemDefinition = 'Problembeschreibung';
$strProblemDefinitionby = 'Problembeschreibung von %s';
$strProblemDescription = 'Problembeschreibung';
$strProblemDescriptionCustomerText = 'Geben Sie soviel Informationen über das Problem wie möglich, genug Information so dass wir ohne Nachfragen mit der Bearbeitung beginnen können.';
$strProblemHasBeenDefined = 'Das Problem wurde beschrieben';

$strProblemReproduction = 'Problem reproduzieren';
$strProblemReproductionCustomerText = 'Existiert das Problem mit mehr als einer Maschine? Welche Schritte erlauben uns, das Problem zu reproduzieren?';
$strProduct = 'Produkt';
$strProductOnly = 'Nur Produkte';
$strProductQuestions = 'Fragen zum Produkt';
$strProducts = 'Produkte';
$strPublic = 'Öffentlich';
$strPublicHoliday = 'Gesetzlicher Feiertag';
$strPublicSharedComputerIncreasedSecurity = 'Öffentlicher oder gemeinsam genutzter Computer (Erhöhte Sicherheitsanforderungen)';
$strPublish = 'veröffentlichen';
$strPublished = 'veröffentlicht';
$strPublishedToday = 'heute veröffentlicht';
$strPublishedOnX = 'Veröffentlicht am %s';

$strQualifications = 'Qualifikation';
$strQueryByExample = 'Eigenen Bericht erstellen';
$strQuestion = 'Frage';
$strQuestions = 'Fragen';
$strQuestionText = 'Text der Frage';
$strQuestionRequired = 'Zum Fortsetzen müssen zunächst, die mit dem Symbol gekennzeichneten, Fragen beantwortet werden';
$strQuestionXNeedsAnsweringBeforeContinuing = 'Frage %s muss zunächst beantwortet werden.';
$strQueue = 'Schlange';

$strRandomTip = 'Zufallstipp';
$strRating = 'Bewertung';
#English suffix for third - 3rd
$strrd = 'rd';
$strRealName = 'Echter Name';
$strReassign = 'Neu zuordnen';
$strReassignIncident = 'Ticket neu zuordnen';
$strReason = 'Grund';
$strReassignTo = 'Neu zuordnen an';
$strReassignedToBy = 'Neu zugeordnet an %s von %s';
$strReassignText = 'Geben Sie den Grund an, warum das Ticket neu zugeordnet wurde. Fügen Sie Erklärungen an die übernehmende Person bei und teilen mit, welches die nächsten Schritte in der Bearbeitung sind. Bitte seien Sie dabei so ausführlich wie möglich und beschreiben eingehend, was Sie in dem Fall bisher getan haben.';
$strReceivedByEmail = 'Diese Information ging per E-Mail ein und kann nicht geändert werden.';
$strRecent = 'neu';
$strRecentIncidents = 'neue Tickets';
$strReducedPrioritySLA = 'Prio in Übereinstimmung mit der Dienstezusage(SLA) herabgestuft';
$strReferences = 'Hinweise';
$strRefresh = 'aktualisieren';
#Abbreviation for Reference ID
$strRefID = 'Ref ID';
$strRegister = 'Registrieren';
$strRelated = 'In Beziehung stehend';
$strRelatedContracts = 'In Beziehung stehende Verträge';
$strRelatedIncidents = 'In Beziehung stehende Tickets';
$strRelatingToIncident = 'Bezugnahme auf Ticket';
$strRelations = 'Beziehungen';
$strRelationship = 'Beziehung';
$strRelationshipRemoved = 'Bezugnahme entfernt';
$strReleaseNotes = 'Versionshinweise';
$strReleaseNotesFor = 'Versionshinweise für %s';
$strRemaining = '%s verbleibend';
$strRemainingBalance = 'Verbleibender Kontostand';
$strRememberToSave = 'Denken Sie daran alle Änderungen abzuspeichern';
$strRemind = 'Erinnern';
$strRemindByPhone = 'Kunden per Telefon erinnern';
$strRemindCustomer = 'Kunde erinnern';
$strReminded = 'Wurde erinnert';
$strRemove = 'Entfernen';
$strRemoveASupportedContact = 'Kontaktperson löschen';
$strRemoveLinkContractAndSupportContact = 'Die Verbindung zwischen Vertrag und Kontaktperson lösen';
$strRemoveLinkContractAndSupportContactText = 'Das bedeutet, dass die Kontaktperson keine weiteren Tickets für das Produkt stellen kann.';
$strRemoveTemporaryOwner = 'Temporäre/n Besitzer/in entfernen';
$strRemoveThisPermanently = 'Dauerhaft entfernen';
$strReopen = 'wieder öffnen';
$strReopenIncident = 'Ticket wieder öffnen';
$strReopenIncidentAndAddUpdate = 'Ticket wieder öffnen und Infomationen ergänzen?';
$strReopenedby = 'wieder geöffnet von %s';
$strRepeat = 'Wiederholen';
$strReply = 'Antworten';
$strReplyTo = 'Antworten an';
$strReportBug = 'Fehler melden';
$strReportedBug = 'Fehler gemeldet';
$strReportIncidentsBySiteDesc = 'Gesamtanzahl Tickets: %s, Von Extern erstellt: %s (%s%%)';
$strReportListsIncidentsLoggedThatEachSiteLoggedOverPastXMonths = 'Dieser Bericht listet die Tickets der vergangenen %s Monate für jede Niederlassung';
$strReports = 'Berichte';
$strRequested = 'gefordert';
$strRequestClosure = 'Ticket soll geschlossen werden';
$strRequestNoUsersToApprovePermissions = 'Es gibt keine Bearbeiter/innen, die den Antrag bewilligen können, nur diejenigen mit entsprechenden Berechtigungen können das. Und Sie können nicht Ihren eigenen Urlaubsantrag bewilligen.';
$strRequestNoHolidaysAwaitingYourApproval = 'Es gibt zur Zeit keine auf Bewilligung wartenden Urlaubsanträge';
$strRequestNotSent = 'Anforderung wurde nicht gesendet';
$strRequestSendComments = 'Kommentar zum Antrag: (oder leer lassen)';
$strRequestSent = 'Anforderung gesendet';
$strRequestSentToX = 'Anforderung gesendet an %s';
$strRequired = 'Benötigt';
$strRequiredDataMissing = 'Benötigte Daten fehlen';
$strResearchedby = 'Analysiert von %s';
$strResearching = 'Analyse';
$strResearchNeeded = 'Analyse erforderlich';
$strResearchNotes = 'Analysebericht';
$strReserved = 'Reserviert';
$strReset = 'zurücksetzen';
$strResetHolidayEntitlementCarryOverNDaysOfUnusedHoliday = 'Urlaubsanspruch zurücksetzen und Übertrag von bis zu <em>n</em> Tagen ungenutzten Urlaubs';
$strResetPassword = 'Passwort zurücksetzen';
$strResolutionReprioritisation = 'Lösung/Priorität anpassen';
$strResolvedby = 'Gelöst durch %s';
$strReseller = 'Wiederverkäufer/in';
$strResponsesToFeedbackForm = 'Antworten auf diese Abfrage';
$strResponsesToAllFeedbackForms = 'Antworten auf alle Abfragen';
$strRestricted = 'Eingeschränkt';
$strResult = 'Ergebnis';
$strResults = 'Ergebnisse';
$strResultsNum = '%d Resultate';
$strReturnAfterSaving = 'Nach Speicherung zurück zu dieser Seite';
$strReturnToOriginalOwner = 'Zurück an Originalbearbeiter/in';
$strReturnToPreviousPage = 'Zur vorherigen Seite';
$strReturnToProductList = 'Zurück zur Produktliste';
$strReturnWithoutSaving = 'Ohne speichern zurück';
# Show
$strReveal = 'Anzeigen';
$strReverseLinks = 'Verbindungen hierher';
$strReview = 'Nachprüfung';
$strReviewby = 'Nachprüfung %s durch %s';
$strReviewDueAgo = 'Nachprüfung überfällig seit %s!';
$strReviewDueNow = 'Nachprüfung jetzt fällig!';
$strReviewHeldUpdates = 'Nachprüfung ergab Änderungen';
$strReviewIn = 'Nachprüfung in %s';
$strRevoke = 'Widerrufen';
$strRole = 'Rolle';
$strRolePermissions = 'Rollenberechtigungen';
# eg. Role Permission: 3 - Edit existing site details
$strRolePermissionsXY = 'Rollenberechtigungen: %s - %s';
$strRSSAtomURL = 'RSS/Atom Feed URL';
$strRules = 'Regeln';
$strRulesNotDefinable = 'Bei dieser Trigger-Aktion ist es nicht möglich Regeln zu erstellen';
$strRunReport = 'Report ausführen';

$strSalesperson = 'Vertriebsbeauftragte/r';
$strSalespersonSite = 'Vertriebsbeauftragte/r der Niederlassung';
$strSalespersonAssignedToContactsSiteEmail = 'Die E-Mail-Adresse d. Vertriebsbeauftragte/n wurde bei der Niederlassung gespeichert';
# short for 'Saturday'
$strSat = 'Sa';
$strSaturday = 'Samstag';
# Two character (Maximum) abbreviation for 'Saturday'
$strSaturdayAbbr = 'Sa';
$strSave = 'Speichern';
$strSaveAsCSV = 'Als CSV speichern';
$strSaveDashbaordLayout = 'Layout der Übersichtsseite speichern';
$strSaveDraft = 'Vorlage speichern';
$strSaveTheMainFormFirst = 'Speichern Sie das Grundformular, bevor Sie Fragen ergänzen';
$strSavePublish = 'Speichern und veröffentlichen';
$strScheduledTask = 'Name der Steuerungsaufgabe';
$strScheduler = 'Auftragsplanung';
$strSchedulerActionFailed = 'In Auftrag gegebene Aktion schlug fehl';
# Database structure version
$strSchemaVersion = 'Schemaversion';
$strScore = 'Stand';
$strScores = 'Stände';
$strScreen = 'Bildschirm';
$strSearch = 'Suche';
$strSearchAgain = 'Suche wiederholen';
$strSearchInDomain = 'Suche nach \"%s\" in %s';
$strSearchInDomainNotAvailableYet = 'In dieser Domain kann zur Zeit noch nicht gesucht werden';
$strSearchTooShort = 'Der eingegebene Suchbegriff ist zur kurz, er muss mindestens 3 oder mehr Zeichen lang sein';
$strSearchYielded = 'Innerhalb der Treffermenge suchen';
$strSeconds = 'Sekunden';
$strSectionText = 'Frageblock';
$strSeeHere = 'Siehe hier';
$strSeeOlderVersions = 'Siehe ältere Versionen';
$strSelect = 'Auswählen';
$strSelectAction = 'Aktion auswählen';
$strSelectAFieldForTemplates = 'In Feldern, die Template Variablen unterstützen, klicken Sie zum Einfügen auf eine Variable';
$strSelectDays = 'Tage auswählen';
$strSelectionXmustNotBeEmpty = 'Die Auswahl %s darf nicht leer bleiben';
$strSelectKBSections = 'Durch Klick auf die Boxen neben den Überschriften wählen Sie die Abschnitte, die der Artikel enthalten soll. Sie können später noch weitere hinzufügen. Aktivieren Sie nur die Abschnitte, die Sie brauchen.';
$strSelectNoneAssumesAll = 'Keine Auswahl aktiviert alle';
$strSelectSkillsApplyToArticle = 'Wählen Sie die Fachbereiche, für die der Artikel gelten soll';
$strSelectYourSkills = 'Wählen Sie die Fachbereiche aus, in denen Sie Tickets bearbeiten.';
$strSelf = 'sich selbst';
$strSendAnEmail = 'E-Mail auf Basis der Vorlage %s verfassen';
$strSendEmail = 'E-Mail senden';
$strSendEmailExplainingIncidentClosure = 'E-Mail an den Kunden bzgl. eines geschlossenen oder zu schliessenden Tickets.';
$strSendEmailExternalIncidentClosure = 'E-Mail an %s bzgl. Schliessung eines externen Tickets.';
$strSendOpeningEmail = 'Eröffnungsnachricht';
$strSendOpeningEmailDesc = 'Eröffnungsnachricht an Anfrager/in?';
$strSendPassword = 'Passwort senden';
$strSendRequest = 'Anfrage senden';
$strSendReminderRequest = 'Erinnerungsmail senden';
$strSendRequestsTo = 'Die Anfrage senden an';
$strSentInformation = 'Informationen versandt';
$strSendTranslation = 'Den Text unten als %s speichern und zur Verwendung im Verzeichnis %s ablegen. Senden Sie ihn zum Nutzen aller auch an %s, damit er in zukünftige Versionen von SiT! eingeht.';
# Short for September
$strSepAbbr = 'Sep';
# Month number 9: September
$strSeptember = 'September';
$strService = 'Dienstleistung';
$strServiceBalance = 'Dienstekontostand';
$strServiceBalanceInfo = 'Verbleibendes Diensteguthaben als Zahl, z.B. \"0,34\"';
$strServiceBalanceString = 'Verbleibendes Diensteguthaben als prozentuale Angabe, z.B. \"34%\"';
$strServiceHistory = 'SLA-Chronik';
$strServiceID = 'Dienstleistungs-ID';
$strServiceLevel = 'Dienstezusage (SLA)';
$strServiceLevelPreventsReopen = 'Die Dienstezusage dieses Tickets sieht nicht vor, dass es wieder geöffnet werden kann';
$strServiceLevels = 'Dienstezusagen (SLA)';
$strServicePacksApplied = 'Angewandte Service Packs';
$strServicePeriod = 'Unterstützungszeitraum';
$strSession = 'Sitzung';
$strSessionExpired = 'Sie waren zu lange inaktiv oder noch nicht angemeldet, bitte neu einloggen';
$strSetPassword = 'Passwort setzen';
$strSetPermissions = 'Berechtigungen vergeben';
$strSetPermissionsForRoleX = 'Vergebe Rechte an Rolle: %s';
$strSetPermissionsForUserX = 'Vergebe Rechte an Bearbeiter/in: %s';
$strSetPublicHolidays = 'Gesetzliche Feiertage eintragen';
$strSetRolePermissions = 'Rollenberechtigungen vergeben';
$strSettings = 'Einstellungen';
$strSetYourStatus = 'Status setzen';
$strShowActiveOnly = 'Nur Aktive anzeigen';
$strShowAll = 'Alles anzeigen';
$strShowApproved = 'Zeige bewilligte';
$strShowClosedIncidents = 'Zeige geschlossene Tickets';
$strShowEmoticons = 'Zeige Emoticons';
$strShowExpired = 'Zeige abgelaufene';
$strShowEverybodys = 'Zeige alle';
$strShowExpiredAsZero = 'Zeige abgelaufene als Null';
$strShowExpiredContracts = 'Zeige ausgelaufene Verträge';
$strShowingAllArticles = 'Zeige alle Artikel';
$strShowingAllClosedIncidents = 'Zeige alle geschlossenen Tickets';
$strShowingXtoXofX = 'Zeige %s für %s von %s';
$strShowingXofX = 'Zeige %s von %s';
$strShowingOnlyRelevantArticles = 'Zeige nur relevante Artikel';
$strShowFreeOfCharge = 'Zeige von den Kosten befreite';
$strShowFreeOfChargeAsZero = 'Zeige von den Kosten befreite als Null';
$strShowIncidentDetails = 'Zeige Details zum Ticket';
$strShowMine = 'Meine zeigen';
$strShowOnlyRelevant = 'Zeige nur relevante';
$strShowOpenIncidents = 'Zeige offene Tickets';
$strShowOrphandedContacts = 'Zeige verwaiste Kontaktpersonen (keine Niederlassung)';
$strShowPaged = 'Seitenweise Anzeige zum Blättern';
$strShowPositivityGraph = 'Dieses Diagramm zeigt den Grad der Zufriedenheit der oben aufgeführten Kontaktpersonen';
$strShowProducts = 'Zeige Produkte';
$strShowRenewals = 'Zeige Erneuerungen';
$strShowSitesThatHaveLoggedNoIncidents = 'Zeige Niederlassungen, die keine Tickets erstellt haben';
$strShowSitesWhichHaveLoggedLessThanCalls = 'Zeige Niederlassungen, die weniger als x Anfragen gestellt haben';
$strShowSiteTotals = 'Zeige summierte Bilanz der Niederlassungen';
$strShowTotals = 'Zeige summierte Bilanz';
$strSicknessOnlyBookedNowOrPast = 'Krankmeldungen können nur für heute oder zurückliegende Tage eingetragen werden';
$strSimpleHTMLallowed = 'Einfaches HTML zugelassen';
$strSinceX = 'seit %s';
$strSingleIncident = '%ds Ticket';
$strSite = 'Niederlassung';
$strSiteAreYouSure = 'Dieses Ticket wird der Niederlassung zugeordnet und nicht(!) dem Vertrag. Sie erhalten eine Abfrage zur Zuordnung der Dienstezusage (SLA). Fortsetzen?';
# Break down the report by site
$strSiteBreakDown = 'Herunterbrechen auf Ebene der Niederlassungen';
$strSiteContracts = 'Verträge der Niederlassung';
$strSiteEdited = 'Niederlassung wurde überarbeitet';
$strSiteHasBillableContract = 'Niederlassung hat kostenpflichtigen Vertrag';
$strSiteIncidents = 'Tickets der Niederlassung';
$strSiteName = 'Name der Niederlassung';
$strSiteNotes = 'Anmerkungen zur Niederlassung:';
$strSiteNotListed = 'Niederlassung nicht aufgeführt?';
$strSiteProducts = 'Produkte der Niederlassung';
$strSiteProductsMatrix = 'Produktmatrix der Niederlassung';
$strSites = 'Niederlassungen';
$strSiteSupport = 'Support für die Niederlassung';
$strSiteType = 'Art der Niederlassung';
$strSiteTypes = 'Arten von Niederlassungen';
$strSiteXEdited = 'Niederlassung %s überarbeitet';
$strSitUpgraded = "SiT! upgraded";
$strSitUpgradedTo = '%s hat einen Upgrade zu %s durchgeführt';
$strSitUpgradedLink = 'Was gibt\'s Neues?';
$strSize = 'Grösse';
$strSkill = 'Fachbereich';
$strSkills = 'Fachbereiche';
$strSkillAssignedToIncident = 'Ticket dem Fachbereich zugeordnet';
$strSkillsFor = 'Fachbereiche von %s';
$strSkillsMatrix = 'Fachbereichsmatrix';
$strSkillsSupportedUnderContract = 'Unterstützungsbereiche dieses Vertrags';
# abbr. for Service Level Agreement
$strSLA = 'SLA';
$strSLAApproaching = 'Dienstezusagefrist nähert sich';
$strSLAby = 'SLA: %s von %s';
$strSLADue = 'Dienstezusage fällig';
$strSLAXDueNow = '%s ist nun fällig';
#E.g. Initial Response in 3 hours
$strSLAInX = '%s in %s';
#E.g. Initial Response 3 hours late
$strSLAXLate = '%s %s verspätet';
$strSLAMissed = 'Dienstezusage nicht eingehalten';
$strSLAPerformance = 'Einhaltung der Dienstezusagen';
$strSLATarget = 'Ziel der Dienstezusage';
# Simple Object Access Protocol
$strSOAP = 'SOAP';
$strSoftware = 'Software';
$strSoftwareVersion = 'Softwareversion';
$strSolution = 'Lösung';
$strSolvedProblem = 'Problem gelöst';
$strSomeOfTheseIdentifiers = 'Nach Zuodnung eines Triggers, können einige der Variablen nicht mehr verfügbar sein.';
$strSorryNoPermissionToAreas = 'Sorry, Sie haben keinen Zugang zu diesen Fachbereichen';
$strSorryNoRecordsMatchingX = 'Sorry, es wurden keine passenden Datensätze %s gefunden ';
$strSorryNoSearchResults = 'Sorry, Ihre Suche verlief erfolglos';
$strSorryProductCantBeDeleted = 'Sorry, das Produkt kann nicht gelöscht werden. Prüfen Sie, ob ihm noch Fachbereiche oder Verträge zugeordnet sind.';
$strSorryUnableToFindAnyContactsMatchingX = 'Sorry, es ist nicht möglich eine Kontaktperson zu finden, die zu <em>%s</em> passt';
$strSort = 'sortieren';
$strSortAscending = 'Aufsteigend sortiert';
$strSortDescending = 'Absteigend sortiert';
$strSortResults = 'Ergebnise sortieren';
$strSource = 'Quelldateien';
$strSourceFailCannotBeFoundX = 'Quelldateien wurden nicht gefunden %s';
$strSpamEmail = 'Spam E-Mail';
$strSpecifyAddress = 'Geben Sie eine Adresse an, die sich von der der Niederlassung unterscheidet';
#English suffix for first - 1st
$strst = 'st';
$strStartDate = 'Start Datum';
$strStartNewActivity = 'Neue Tätigkeit beginnen';
$strStatsFromDayStatistics = 'Statistik vom %s';
$strStatisticsOnly = 'Nur für statistische Zwecke';
$strStatisticsWarningReassign = 'Bei den Statistiken handelt es sich nur um Schätzungen. Sie beziehen Neuzuordnungen von Ticket-Bearbeiter/innen nicht mit ein';
$strStatus = 'Status';
$strStatusSummary = 'Kurzdarstellung';
# i.e. permanent
$strSticky = 'Anheften';
$strStopActivity = 'Beende Tätigkeit';
$strStoreInLog = 'Details mitloggen';
$strSubject = 'Betreff';
$strSubstitute = 'Vertretung';
$strSubstitutes = 'Vertretungen';
$strSuccess = 'Erfolg';
$strSuccessfully = 'Erfolgreich';
$strSuccessfullyUpdated = 'Erfolgreich geändert';
$strSummary = 'Zusammenfassung';
$strSummaryOfProblem = 'Eine kurze aber vollständige Zusammenfassung der Probleme, die festgestellt wurden.';
$strSummaryOfProblemAndResolution = 'Geben Sie eine Zusammenfassung des Problems und wie es gelöst wurde.';
# Short for 'Sunday'
$strSun = 'So';
$strSunday = 'Sonntag';
# Two character (Maximum) abbreviation for 'Sunday'
$strSundayAbbr = 'So';
$strSupport = 'Support';
$strSupportEmailAddress = 'Support E-Mail-Adresse';
$strSupportEmailDesc = 'Freitext Supportmail';
$strSupportExpired = 'Support abgelaufen';
$strSupportManagersEmailAddress = 'E-Mail-Adresse des Support Managers';
$strSupportedContacts = 'Unterstützte Kontaktpersonen';
$strSupportedContactsbySite = 'Unterstützte Kontaktpersonen je Niederlassung';
$strSurname = 'Nachname';
$strSwitchUser = 'Nutzerkonto wechseln';
$strSymptoms = 'Symptome';
$strSystem = 'System';
$strSystemActions = 'Systemaktionen';
$strSystemPath = 'System Basispfad';
$strSystemUrl = 'System URL';

$strTable = 'Tabelle';
$strTag = 'Tag';
$strTagCloud = 'Tag Cloud';
$strTags = 'Tags';
$strTagsMulti = '%d Tickets';
$strtaken = 'übernommen';
$strtakennextperiod = 'in nächsten Zeitraum übernommen';
$strTarget = 'Ziel';
$strTask = 'Aufgabe';
$strTaskDeletedSuccessfully = 'Aufgabe erfolgreich gelöscht';
$strTaskDue = 'Aufgabe fällig';
$strTaskDueDesc = 'Erscheint, wenn eine Aufgabe das Fristende erreicht';
$strTaskMarkedCompleteByX = 'Aufgabe markiert als zu 100%% erfüllt von %s';
$strTasks = 'Aufgaben';
$strTaskList = 'Aufgabenliste';
$strTaskPrivateError = 'Sorry, Sie können diese Aufgabe nicht ansehen, weil sie als privat gekennzeichnet wurde und sie nicht Eigentümer/in sind';
$srtrTaskStarted = 'Aufgabe begonnen';
$strTBytes = 'TBytes';
$strTechnicalSupportAdmin = 'Technischer Support-Admin';
# Abbreviation for 'Telephone'
$strTel = 'Tel';
$strTelephone = 'Telefon';
# Abbreviated 'Temporary';
$strTemp = 'Temp';
$strTemplate = 'Vorlage';
$strTemplates = 'Vorlagen';
$strTemplatesShouldNotBeginWith = 'Vorlagen sollten nicht mit einem Text beginnen, der wie ein E-Mail-Header aussieht  (z.B. <code>\'Name: \'</code>)';
$strTemplateType = 'Vorlagentyp';
$strTemplateVariables = 'Variable';
$strTemporarilyAssignedto = 'Vorübergehend zugewiesen an %s von %s';
$strTemporaryOwner = 'Vorübergehende/r Bearbeiter/in';
$strTerminated = 'Beendet';
$strTerminatedContractsExpiredXdaysAgo  = 'Beendete Verträge, die in den letzten %s Tagen abgelaufen sind';
# As in 'Click to test triggers'
$strTestTriggers = 'Trigger testen';
$strText = 'Text';
#English suffix for most numbers - 5th, 6th, 7th
$strth = 'th';
$strThankYou = 'Vielen Dank';
$strThankYouCompleteForm = 'Vielen Dank, dass Sie sich die Zeit zum Ausfüllen dieses Formulars genommen haben.';
$strTheFollowingVariables = 'Die folgenden Variablen können verwendet werden:';
$strThereAreXcontractsAssignedToThisPerson = 'Kontaktperson ist in %s Verträgen benannt';
$strThereAreXIncidentsAssignedToThisContact = 'Kontaktperson hat %s Tickets zugeordnet';
$strThereAreXIncidentsInThisList = 'Es gibt in dieser Liste %s Tickets';
$strThereWasAProblemSendingYourRequest = 'Es trat ein Problem beim Versenden der Anfrage auf';
$strTheInfoInThisArticle = 'Die Informationen dieses Artikels beziehen sich auf';
# These files arrived by 'email'
$strTheseFilesArrivedBy ='Die Dateien gingen ein über';
# Theme as in Interface Style
$strTheme = 'Layout';
$strTheMoreInformation = 'Beschreiben Sie den Fall eingehend, konkret und nachvollziehbar';
$strThisListShowsCustomers = 'Die Liste zeigt Kunden, die die Suchkriterien erfüllen. Wenn diese Supportverträge haben, können Sie Tickets für diese erstellen.';
$strThisMonth = 'Diesen Monat';
$strThisReportShowsIncidentsClosedInThisPeriod = 'Der Bericht zeigt Tickets, die im Zeitraum geschlossen wurden';
$strThisReportShowsContactForSelectedSites   = 'Der Bericht zeigt die Liste der (%s) Kontaktpersonen aus den Niederlassungen, die Sie ausgewählt haben';
$strThisWeek = 'Diese Woche';
$strThisYear = 'Dieses Jahr';
# Short for 'Thursday'
$strThu = 'Do';
$strThursday = 'Donnerstag';
# Two character (Maximum) abbreviation for 'Thursday'
$strThursdayAbbr = 'Do';
$strTime = 'Uhrzeit';
$strTimed = 'Mit Zeitaufschreibung';
$strTimesheet = 'Stundenzettel';
$strTimesheets = 'Stundenzettel';
$strTimeToNextAction = 'Wiedervorlage am';
$strTitle = 'Titel';
$strTo = 'An';
$strToChangeBrackets = '(zu ändern)';
$strToChangeContract = 'Um den Vertrag zu ändern, schliessen Sie das Ticket und erstellen es anschliessend neu';
$strToChangePassword = 'Um das Passwort zu ändern, geben Sie als Erstes Ihr altes Passwort an und dann Ihr neues Passwort sowie zur Bestätigung das Neue ein zweites Mal';
$strToday = 'Heute';
$strTodaysDate = 'Heutiges Datum';
$strTodaysStats = 'Heutige Statistik';
$strToIncidentID = 'Zur Ticket-ID';
$strTotal = 'Insgesamt';
# Totals capitalised
$strTOTALS = 'Summen';
$strTotalBillableUnits = 'Kostenpflichtige Einheiten insgesamt';
$strTotalCredit = 'Guthaben insgesamt';
$strTotalDebit = 'Forderungen insgesamt';
$strTotalMinutes = 'Minuten insgesamt';
$strTotalOpen = 'Offen insgesamt';
$strTotalUnits = 'Einheiten insgesamt';
$strTrackURL = 'Track URL';
$strTraining = 'Fortbildung';
$strTransactionApproved = 'Transaktion freigegeben';
$strTransactions = 'Transaktionen';
$strTransactionXnotAwaitingApproval = 'Transaktion %s braucht keine Bestätigung';
$strTransfer = 'Transfer';
# An example of transfering amounts between services
$strTransferExamplePositiveService = 'Wählen Sie die Dienstleistung für die Forderungen bestehen und übertragen den Betrag hierher. Zum Beispiel: Dienstleistung A ist -100. Um sie auszugleichen, übertragen Sie den Betrag von 100.';
$strTransferExampleNegativeService = 'Wählen Sie die Dienstleistung für die Guthaben bestehen und übertragen den Betrag hierher. Zum Beispiel: Dienstleistung A ist 100. Um sie auszugleichen, übertragen Sie den Betrag von -100.';
$strTranslate = 'Übersetzen';
$strTranslateTheString = 'Übersetzen Sie die englische Zeichenkette auf der linken Seite in die gewünschte Sprache auf der rechten Seite';
$strTranslation = 'Übersetzung';
$strTrigger = 'Trigger';
$strTriggerActions = 'Trigger Aktionen';
$strTriggerContactResetPasswordDesc = 'Wird ausgeführt, wenn eine Kontaktperson ihr Passwort zurücksetzen will';
$strTriggerFooter = 'Sie erhalten diese Mail automatisch durch die SiT!-Systemsteuerung zugesandt. Ändern Sie Ihre entsprechenden Einstellungen dort oder wenden Sie sich an das Administrationspersonal';
$strTriggerHolidayRequestedDesc = 'Wird ausgeführt, wenn ein/e Bearbeiter/in einen Urlaubsantrag stellt';
$strTriggerIncidentClosedDesc ='Wird ausgeführt, wenn ein Ticket geschlossen wird';
$strTriggerIncidentNearingSLADesc = 'Wird ausgeführt, wenn sich ein Ticket dem Fristende der Dienstezusage (SLA) nähert';
$strTriggerIncidentReviewDueDesc = 'Wird ausgeführt, wenn die Nachprüfung für ein Ticket fällig wird';
$strTriggerKBArticleCreatedDesc = 'Wird ausgeführt, wenn ein Artikel für den Wissensfundus erstellt wurde';
$strTriggerLanguageDiffersDesc = 'Wird ausgeführt, wenn Ihre Spracheinstellung nicht mit der im Profil gesetzten übereinstimmt';
$strTriggerNewContactDesc = 'Wird ausgeführt, wenn eine neue Kontaktperson eingetragen wurde';
$strTriggerNewContractDesc = 'Wird ausgeführt, wenn ein neuer Vertrag eingetragen wurde';
$strTriggerNewHeldEmailDesc = 'Wird ausgeführt, wenn eine neue E-Mail in der Zuweisungsstation eingetroffen ist';
$strTriggerNewHeldEmailMinsDesc = 'Wird ausgeführt, wenn sich eine neue E-Mail seit x Minuten in der Zuweisungsstation befindet';
$strTriggerNewIncidentAssignedDesc = 'Wird ausgeführt, wenn ein neues Ticket zugewiesen wurde';
$strTriggerNewIncidentCreatedDesc = 'Wird ausgeführt, wenn ein neues Ticket erstellt wurde';
$strTriggerNewSiteDesc = 'Wird ausgeführt, wenn eine neue Niederlassung eingetragen wurde';
$strTriggerNewUserDesc ='Wird ausgeführt, wenn ein neues Nutzerkonto erstellt wurde';
$strTriggerSchedulerTaskFailedDesc = 'Wird ausgeführt, wenn eine Aufgabe der Zeitplanungssteuerung fehl geschlagen ist';
$strTriggerSitUpgradedDesc = 'Wird ausgeführt, wenn ein System-Upgrade durchgeführt wurde';
$strTriggerUserChangedStatusDesc = 'Wird ausgeführt, wenn eine/r der beobachteten Bearbeiter/innen den Status wechselt';
$strTriggerUserResetPasswordDesc = 'Wird ausgeführt, wenn ein/e Nutzer/in das Passwort ändern will';
$strTriggers = 'Trigger';
$strTriggersFooter = 'Die Fußzeile am Ende der E-Mail, die erläutert, von wem die Mail stammt';
$strTriggerUserEmail = 'E-Mail-Adresse an die durch Systemaktionen ausgelöste E-Mail gesandt werden soll (falls nicht an den/die Bearbeiter/in)';
# Short for 'Tuesday'
$strTue = 'Di';
$strTuesday = 'Dienstag';
# Two character (Maximum) abbreviation for 'Tuesday'
$strTuesdayAbbr = 'Tu';
$strType = 'Typ';

$strURLTitle = 'URL Titel';
$strUpgrade = 'Upgrade';
$strUpdate = 'Fortschreiben';
$strUpdateFailed = 'Fortschreibung fehlgeschlagen';
$strUpdated = 'Fortschreibungen';
$strUpdatedAutomaticallyBy = 'Automatische Fortschreibung durch %s';
$strUpdatedby = 'Fortschreibung durch %s';
$strUpdatedFromTask = 'Fortschreibung durch Aufgabe';
$strUpdatedXbyX = '%s fortgeschrieben von %s';
$strUpdateIncident = 'Ticket fortschreiben';
$strUpdateIncidentFailed = 'Änderung am Ticket schlug fehl';
$strUpdateIncidentXsBalance = 'Ändere Kontostand bei Ticket [%s]';
$strUpdateNewUpdate = 'Neue Änderung (keine der obigen)';
$strUpdatePerUserAbbrev = 'upd. user';
$strUpdateRolePermissionsFailed = 'Änderung der Rollenberechtigung schlug fehl im ersten Schritt';
$strUpdates = 'Änderungen';
$strUpdatedFromActivity = 'Fortschreibung der Tätigkeit von %s';
$strUpdateUserPermission = 'Änderung der Berechtigungen von Bearbeiter/in';
$strUpdatedViaThePortalBy = 'Geändert via Portal von %s %s';
$strUpdateSuccessful = 'Änderungen erfolgreich';
$strUploadFailed = 'Hochladen fehlgeschlagen!';
$strUpdateType = 'Art der Änderung';
$strUploadedBy = 'Hochgeladen durch %s';
$strUploadedXtoYAsZ = 'Geändert %s zu %s als %s';
$strUnableToChangeServiceAsUsed = 'Beträge oder Gebühren können nicht geändert werden, weil die Dienstleistung bereits in Anspruch genommen wurde';
$strUnapprovable = 'Bestätigung nicht möglich';
$strUnapprovableBilledIncidentsDesc = 'Einige Tickets können nicht bestätigt werden. Mögliche Gründe: Keine Dienstleistung vorhanden, Keine Dienstleistungen aktiviert im aktuellen Zeitraum, Überziehungen des Kontos sind ausgeschlossen und kein Dienstleistungskonto mit Guthaben gefunden.';
$strUnassigned = 'Nicht zugewiesen';
$strUnassignedIncidents = 'Nicht zugewiesene Tickets';
$strUnitRate = 'Gebühren pro Einheit';
$strUnits = 'Einheiten';
$strUnitsUsedLastXdays = 'Einheiten gebraucht in den letzten %d Tagen';
$strUnitsRemaingSingleTime = 'Verbleibende einzelne Einheiten';
$strUnknown = 'Unbekannt';
$strUnknownServiceLevel = 'Unbekannte Dienstezusage (SLA)';
$strUnlimited = 'Unbegrenzt';
$strUnlink = 'Verbindung lösen';
$strUnlock = 'Aufschliessen';
$strUnlockThisToBeModifiedByOther = 'Aufschliessen um anderen die Bearbeitung zu ermöglichen';
$strUnsolved = 'Ungelöst';
$strUnsupported = 'Kein Support';
$strUntilSpecificDateAndTime = 'Bis zu einem konkreten Datum und Uhrzeit';
$strUntilX = 'Bis %s';
$strUntitled = 'unbegrenzt';
$strUsed = 'genutzt';
$strUsedNofN = '%s von %s gebraucht';
$strUsedNofNDaysEntitlement = '%s von %s Urlaubstagen genommen';
$strUser = 'Bearbeiter/in';
$strUserGroups = 'Gruppen';
$strUsername = 'Nutzername';
$strUsernameNotUnique = 'Nutzername muss eindeutig sein';
$strUsers = 'Bearbeiter/innen';
$strUserChangedStatus = 'Bearbeiter/in änderte den Status';
$strUserPermissionsEdited = 'Berechtigungen geändert';
$strUserXPermissionsEdited = 'Berechtigungen für Bearbeiter/in %s geändert';
# User Permission 3 - Edit existing site details
$strUserPermissionXY = 'Berechtigungen: %s - %s';
$strUserResetPassword = 'Passwort zurücksetzen';
$strUserSettings = 'Einstellungen Nutzerkonto';
$strUsersHolidays = 'Urlaub vn %s';
$strUserStatus = 'Status von Bearbeiter/in';
$strUserStillAway = 'Ihr aktueller Status wurde nicht geändert. Sie können ihn am Fuß Ihrer Übersichtsseite ändern';
$strUserIncidents = 'Tickets von %s';
$strUsersNoGroup = 'Bearbeiter/innen ohne Gruppe';
$strUsersBoldSkills = 'Bearbeiter/innen, deren Name fett gedruckt ist, bearbeiten die gefragten Fachbereiche';
$strUseThisInFuture = 'Dies in Zukunft benutzen';
# Offset from Coordinated Universal Time / Temps Universel Coordonné
$strUTCOffset = 'UTC Abweichung (Zeitzone)';

$strValid = 'Gültig';
$strValue = 'Wert';
$strVariable = 'Variable';
$strVendor = 'Lieferant/in';
$strVendorName = 'Lieferantenname';
$strVersion = 'Version';
$strView = 'Ansicht';
$strViewAndLockHeldEmail = 'Wartende Mail anzeigen und sperren';
$strViewActivity = 'Tätigkeit anzeigen';
$strViewArticle = 'Artikel anzeigen';
$strViewContact = 'Kontaktperson anzeigen';
$strViewContract = 'Vertrag anzeigen';
$strViewHoldingQueue = 'Zuweisungsstation';
$strViewIncident = 'Ticket anzeigen';
$strViewResponse = 'Antwort anzeigen';
$strViewSite = 'Niederlassung anzeigen';
$strViewTask = 'Aufgabe anzeigen';
$strViewTasks = 'Aufgaben anzeigen';
$strViewUsers = 'Zeige Bearbeiter/innnen';
$strViewingAllIncidents = 'Alle Tickets anzeigen';
$strVisibleToCustomer = 'Sichtbar für Kunden';
$strVisibility = 'Sichtbarkeit';

$strWaiting = 'Warten';
$strWaitingForCustomer = 'Warten auf Kunde';
$strWaitingForSupport = 'Warten auf Support';
$strWaitingHeldEmail = 'Wartende E-Mail';
$strWarning = 'Warnung';
$strWatchAddFailed = 'Beobachtung für Ticket fehlgeschlagen';
$strWatchAddSet = 'Tickets in Beobachtung nehmen';
$strWatchDeleteFailed = 'Aufhebung der Beobachtung fehlgeschlagen';
$strWatchIncidents = 'Beobachtete Tickets';
$strWatchIncidentsAdded = 'Tickets werden nun beobachtet';
$strWatchIncidentsRemovalSucceded = 'Beobachtung wurde aufgehoben';
$strWebupdate = 'Webaktualisierung';
$strWebupdateBy = 'Webaktualisierung durch %s';
# Short for 'Wednesday'
$strWed = 'Mi';
$strWednesday = 'Mittwoch';
# Two character (Maximum) abbreviation for 'Wednesday'
$strWednesdayAbbr = 'We';
$strWeek = 'Woche';
$strWelcome = 'Willkommen';
$strWeekView = 'Wochenansicht';
$strWhatsNew = 'Was gibt\'s Neues?';
$strWhosAwayToday = 'Wer ist heute abwesend?';
$strWordList = 'Wortliste';
$strWorkaround = 'Übergangslösung';
$strWorkAroundsAttempted = 'Bemühungen um Abhilfe';
$strWorkAroundsAttemptedCustomerText = 'Was haben Sie getan um das Problem zu beheben? Welche Konfigurationsänderungen gemacht? Welche Patches oder Service Packs installiert?';
$strWorkingAway = 'Von ausserhalb arbeitend';
$strWorkingFromHome = 'Von zuhause aus arbeitend';
$strWorkStatus = 'Anwesenheitsstatus';
$strWebsite = 'Website';

$strWithheld = 'Zurückhalten';
$strXDays = '%s Tage';
$strXIncidentsLoggedViaPortal = '%s Tickets via Portal erstellt';
$strXIncidentsLeft = '%s Tickets verbleiben';
$strXHasAction = '%s hat Aktion';
$strXHour = '%s Stunde';
$strXHours = '%s Stunden';
# e.g. '5 minutes late'
$strXLate = '%s zu spät';
$strXMinutes = '%s Minuten';
$strXMonths = '%s Monate';
# e.g. '5 days old'
$strXold = '%s alt';
# e.g. 'Fred of ACME Inc'. i.e. 'Name' of 'Site'
$strXofX = '%s von %s';
# e.g. '5 Records'
$strXRecords = '%s Datensätze';
# e.g. John's Activities
$strXsActivities = '%s\'s Tätigkeiten';
$strXSeconds = '%s Sekunden';
# e.g. John's Tasks
$strXsTasks = '%s\'s Aufgaben';
$strXWorkingDay = '%s Werktag';
$strXWorkingDays = '%s Werktage';
$strXYears = '%s Jahre';

$strYear = 'Jahr';
$strYearly = 'Jährlich';
$strYearView = 'Jahresansicht';
$strYes = 'Ja';
$strYesterday = 'Gestern';
# Second person, singular
$strYou = 'Sie';
$strYouMissedARequiredField = 'Sie haben ein benötigtes Feld vergessen';
$strYouShouldNowDefineSubstituteEngineers = 'Sie sollten nun eine/n Vertreter/in für jeden Fachbereich benennen';
$strYouACurrentlyNotAccepting = 'Sie nehmen zur Zeit keine Tickets an. Sie können den Status am Fuß der Übersichtsseite ändern';
$strYouMustEnterIncidentTitle = 'Sie müssen einen Betreff eingeben.';
$strYouMustEnterYourNewPasswordTwice = 'Sie müssen Ihr neues Passwort zweimal angeben';
$strYouMustSelectAcontact = 'Sie müssen eine Kontaktperson wählen.';
$strYouMustSelectAmaintenanceContract = 'Sie müssen einen Vertrag auswählen.';
$strYouMustSelectAserviceLevel = 'Sie müssen eine Dienstezusage-Stufe (SLA) wählen';
$strYouMustSelectAsupportContact = 'Sie müssen einen Supportvertrag auswählen.';
$strYourClosedIncidents = 'Ihre geschlossenen Tickets';
$strYourCurrentIncidents = 'Ihre laufenden Tickets';
$strYourCurrentOpenIncidents = 'Ihre aktuell offenen Tickets';
$strYourCurrentLanguage = 'Die aktuell gewählte Spracheinstellung unterscheidet sich von der in Ihrem Profil gesetzen.';
$strYourDetails = 'Ihre Details';
$strYourSitesClosedIncidents = 'Weitere geschlossene Tickets Ihrer Niederlasssung';
$strYourSitesIncidents = 'Weitere Tickets Ihrer Niederlassung';
$strYouHaveAction = 'Sie haben die Aktivität';
$strYourSupportEntitlement = 'Ihr Supportvertrag';

$strZeroRemaining = 'Keine übrig';
?>