<div id="top"></div>

<!-- PROJECT SHIELDS -->
[![Contributors][contributors-shield]][contributors-url]
[![Stargazers][stars-shield]][stars-url]
[![Commits][commit-shield]][commit-url]
[![GPL License][license-shield]][license-url]

<div align="center">

  <h3 align="center">ITFlow</h3>

  <p align="center">
    IT documentation, ticketing and accounting system for small MSPs.
    <br />
    <br />
    <a href="https://demo.itflow.org"><strong>View demo</strong></a>
    <br />
    Username: <b>demo@demo</b> | Password: <b>demo</b>
    <br />
    <br />
    <a href="https://itflow.org/#about">About</a>
    ·
    <a href="https://docs.itflow.org">Docs</a>
    ·
    <a href="https://forum.itflow.org/">Forum</a>
    ·
    <a href="https://forum.itflow.org/t/bug">Report Bug</a>
    ·
    <a href="https://forum.itflow.org/t/features">Request Feature</a>
    ·
    <a href="https://github.com/itflow-org/itflow/security/policy">Security</a>
  </p>
</div>

<!-- ABOUT THE PROJECT -->
## About

<b>A comprehensive, free & open-source documentation, ticket management, and accounting platform.</b>

[![ITFlow][product-screenshot]](https://itflow.org)


### The Problem
- You're a small but busy managed service provider with 101 things to do. Information about your clients is unorganised, unstructured and outdated.
- For some work, you seem to spend longer looking for the relevant documentation than actually working on the issue/project. 
- On top of the technical day to day, you also have to take care of the financial side of the business - consistent pricing, quotes/invoicing, and accounting. 

### The Solution: ITFlow
- ITFlow consolidates common MSP needs (documentation, ticketing and billing) into one unified system.

<!-- GETTING STARTED -->
## Getting Started

### Self Hosting
- The best installation method is to use the [install script](https://docs.itflow.org/installation_script) on Ubuntu/Debian. A video walk through is available [here](https://www.youtube.com/watch?v=kKz9NOU_1XE).
```
  wget -O itflow_install.sh https://github.com/itflow-org/itflow-install-script/raw/main/itflow_install.sh
  bash itflow_install.sh
```
- Other manual installation methods are available in the [docs](https://docs.itflow.org/installation).

### Managed Hosting
- If you'd prefer, we can [host ITFlow for you](https://services.itflow.org/hosting.php).

<!-- FEATURES -->
## Key Features
* Client documentation - assets, contacts, domains, docs, files, passwords, and more 
* Accounting / Billing - finance dashboard, quotes, invoices, accounting, expenses, etc
* Client Portal - self service quote/invoice/ticket management for clients
* Alerting - account balance, invoices, domain/SSL renewals
* Completely free & open-source alternative to ITGlue and Hudu
  
<!-- ROADMAP -->
## Roadmap / Future to-do
We track the implementation of confirmed features and bugs via [TaskFlow](https://tasks.dev.itflow.org/tasks.php). Use the [forum](https://forum.itflow.org) to request features or raise bug reports. 

<!-- CONTRIBUTING -->
## Support & Contributions

### Forum
For help using ITFlow, bugs, feature requests, and general ideas / discussions please use the community [forum](https://forum.itflow.org).

### Contributing
If you want to improve ITFlow, feel free to fork the repo and create a pull reques. Make sure to discuss significant changes or new features with fellow contributors on the forum first. This helps ensure that your contributions are aligned with project goals, and saves time for everyone. All contributions should follow our [code standards](https://docs.itflow.org/code_standards). See the [contributing guide](https://docs.itflow.org/contribute).

#### Contributors
<a href="https://github.com/itflow-org/itflow/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=itflow-org/itflow" />
</a>

### Supporters
We’re incredibly grateful to the organizations and individuals who support the project - a big thank you to:
- CompuMatter
- F1 for HELP
- JetBrains (PhpStorm)

## License
ITFlow is distributed "as is" under the GPL License, WITHOUT WARRANTY OF ANY KIND. See [`LICENSE`](https://github.com/itflow-org/itflow/blob/master/LICENSE) for details.

## Security
* As of 2025, we now have a stable release of the project.
* Whilst we are confident in the safety of the code, no system is risk-free. Nearly all software has bugs. Use your best judgement before storing highly confidential information in ITFlow.
* If you have a security concern, privately report it [here](https://github.com/itflow-org/itflow/security/policy).

<!-- MARKDOWN LINKS & IMAGES -->
<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->
[contributors-shield]: https://img.shields.io/github/contributors/itflow-org/itflow.svg?style=for-the-badge
[contributors-url]: https://github.com/itflow-org/itflow/graphs/contributors
[forks-shield]: https://img.shields.io/github/forks/itflow-org/itflow.svg?style=for-the-badge
[forks-url]: https://github.com/itflow-org/itflow/network/members
[stars-shield]: https://img.shields.io/github/stars/itflow-org/itflow.svg?style=for-the-badge
[stars-url]: https://github.com/itflow-org/itflow/stargazers
[issues-shield]: https://img.shields.io/github/issues/itflow-org/itflow.svg?style=for-the-badge
[issues-url]: https://github.com/itflow-org/itflow/issues
[license-shield]: https://img.shields.io/github/license/itflow-org/itflow.svg?style=for-the-badge
[license-url]: https://github.com/itflow-org/itflow/blob/master/LICENSE
[commit-shield]: https://img.shields.io/github/last-commit/itflow-org/itflow?style=for-the-badge
[commit-url]: https://github.com/itflow-org/itflow/commits/master
[product-screenshot]: .github/readme.gif

<!-- https://github.com/othneildrew/Best-README-Template -->
