<?php

// Default Column Sortby Filter
$sort = "contact_name";
$order = "ASC";

// If client_id is in URI then show client Side Bar and client header
if (isset($_GET['client_id'])) {
    require_once "includes/inc_all_client.php";
    $client_query = "AND contact_client_id = $client_id";
    $client_url = "client_id=$client_id&";
    // Overide Filter Header Archived
    if (isset($_GET['archived']) && $_GET['archived'] == 1) {
        $archived = 1;
        $archive_query = "contact_archived_at IS NOT NULL";
    } else {
        $archived = 0;
        $archive_query = "contact_archived_at IS NULL";
    }
} else {
    require_once "includes/inc_client_overview_all.php";
    $client_query = '';
    $client_url = '';
    // Overide Filter Header Archived
    if (isset($_GET['archived']) && $_GET['archived'] == 1) {
        $archived = 1;
        $archive_query = "(client_archived_at IS NOT NULL OR contact_archived_at IS NOT NULL)";
    } else {
        $archived = 0;
        $archive_query = "(client_archived_at IS NULL AND contact_archived_at IS NULL)";
    }
}

// Tags Filter
if (isset($_GET['tags']) && is_array($_GET['tags']) && !empty($_GET['tags'])) {
    // Sanitize each element of the tags array
    $sanitizedTags = array_map('intval', $_GET['tags']);
    // Convert the sanitized tags into a comma-separated string
    $tag_filter = implode(",", $sanitizedTags);
    $tag_query = "AND tags.tag_id IN ($tag_filter)";
} else {
    $tag_filter = 0;
    $tag_query = '';
}

if (!$client_url) {
    // Client Filter
    if (isset($_GET['client']) & !empty($_GET['client'])) {
        $client_query = 'AND (contact_client_id = ' . intval($_GET['client']) . ')';
        $client = intval($_GET['client']);
    } else {
        // Default - any
        $client_query = '';
        $client = '';
    }
}

if ($client_url && isset($_GET['location']) && !empty($_GET['location'])) {
    // Location Filter
    $location_query = 'AND (contact_location_id = ' . intval($_GET['location']) . ')';
    $location_filter = intval($_GET['location']);
} else {
    // Default - any
    $location_query = '';
    $location_filter = 0;
}

$sql = mysqli_query($mysqli, "SELECT SQL_CALC_FOUND_ROWS contacts.*, clients.*, locations.*, users.*, GROUP_CONCAT(tags.tag_name) FROM contacts
    LEFT JOIN clients ON client_id = contact_client_id
    LEFT JOIN locations ON location_id = contact_location_id
    LEFT JOIN users ON user_id = contact_user_id
    LEFT JOIN contact_tags ON contact_tags.contact_id = contacts.contact_id
    LEFT JOIN tags ON tags.tag_id = contact_tags.tag_id
    WHERE $archive_query
    $tag_query
    AND (contact_name LIKE '%$q%' OR contact_title LIKE '%$q%' OR location_name LIKE '%$q%'  OR contact_email LIKE '%$q%' OR contact_department LIKE '%$q%' OR contact_phone LIKE '%$phone_query%' OR contact_extension LIKE '%$q%' OR contact_mobile LIKE '%$phone_query%' OR tag_name LIKE '%$q%' OR client_name LIKE '%$q%')
    $access_permission_query
    $client_query
    $location_query
    GROUP BY contact_id
    ORDER BY contact_primary DESC, contact_important DESC, $sort $order LIMIT $record_from, $record_to"
);

$num_rows = mysqli_fetch_row(mysqli_query($mysqli, "SELECT FOUND_ROWS()"));

?>

<div class="card card-dark">
    <div class="card-header py-2">
        <h3 class="card-title mt-2"><i class="fa fa-fw fa-address-book mr-2"></i>Contacts</h3>
        <div class="card-tools">
            <div class="btn-group">
                <button type="button" class="btn btn-primary ajax-modal" data-modal-url="modals/contact/contact_add.php?client_id=<?= $client_id ?>">
                    <i class="fas fa-plus mr-2"></i>New Contact
                </button>
                <button type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split" data-toggle="dropdown"></button>
                <div class="dropdown-menu">
                    <?php if ($client_url) { ?>
<!--                    <a class="dropdown-item text-dark" href="#" data-toggle="modal" data-target="#contactInviteModal"><i class="fas fa-fw fa-paper-plane mr-2"></i>Invite</a>-->
<!--                    <div class="dropdown-divider"></div>-->
                    <a class="dropdown-item text-dark ajax-modal" href="#"
                        data-modal-url="modals/contact/contact_import.php?<?= $client_url ?>">
                        <i class="fa fa-fw fa-upload mr-2"></i>Import
                    </a>
                    <div class="dropdown-divider"></div>
                    <?php } ?>
                    <a class="dropdown-item text-dark ajax-modal" href="#"
                        data-modal-url="modals/contact/contact_export.php?<?= $client_url ?>">
                        <i class="fa fa-fw fa-download mr-2"></i>Export
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <form autocomplete="off">
            <?php if ($client_url) { ?>
            <input type="hidden" name="client_id" value="<?php echo $client_id; ?>">
            <?php } ?>
            <input type="hidden" name="archived" value="<?php echo $archived; ?>">
            <div class="row">

                <div class="col-md-4">
                    <div class="input-group mb-3 mb-md-0">
                        <input type="search" class="form-control" name="q" value="<?php if (isset($q)) { echo stripslashes(nullable_htmlentities($q)); } ?>" placeholder="Search Contacts">
                        <div class="input-group-append">
                            <button class="btn btn-dark"><i class="fa fa-search"></i></button>
                        </div>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="input-group mb-3 mb-md-0">
                        <select onchange="this.form.submit()" class="form-control select2" name="tags[]" data-placeholder="- Select Tags -" multiple>

                            <?php
                            $sql_tags_filter = mysqli_query($mysqli, "
                                SELECT tags.tag_id, tags.tag_name
                                FROM tags
                                LEFT JOIN contact_tags ON contact_tags.tag_id = tags.tag_id
                                LEFT JOIN contacts ON contact_tags.contact_id = contacts.contact_id
                                WHERE tag_type = 3
                                $client_query OR tags.tag_id IN ($tag_filter)
                                GROUP BY tags.tag_id
                                HAVING COUNT(contact_tags.contact_id) > 0 OR tags.tag_id IN ($tag_filter)
                            ");
                            while ($row = mysqli_fetch_array($sql_tags_filter)) {
                                $tag_id = intval($row['tag_id']);
                                $tag_name = nullable_htmlentities($row['tag_name']); ?>

                                <option value="<?php echo $tag_id ?>" <?php if (isset($_GET['tags']) && in_array($tag_id, $_GET['tags'])) { echo 'selected'; } ?>> <?php echo $tag_name ?> </option>

                            <?php } ?>
                        </select>
                    </div>
                </div>

                <?php if ($client_url) { ?>
                <div class="col-md-2">
                    <div class="input-group mb-3 mb-md-0">
                        <select class="form-control select2" name="location" onchange="this.form.submit()">
                            <option value="">- All Locations -</option>

                            <?php
                            $sql_locations_filter = mysqli_query($mysqli, "
                                SELECT DISTINCT location_id, location_name
                                FROM locations
                                WHERE location_client_id = $client_id
                                AND ( EXISTS (SELECT 1 FROM contacts WHERE contact_location_id = location_id  AND $archive_query) OR location_id = $location_filter)
                                ORDER BY location_name ASC
                            ");
                            while ($row = mysqli_fetch_array($sql_locations_filter)) {
                                $location_id = intval($row['location_id']);
                                $location_name = nullable_htmlentities($row['location_name']);
                            ?>
                                <option <?php if ($location_filter == $location_id) { echo "selected"; } ?> value="<?php echo $location_id; ?>"><?php echo $location_name; ?></option>
                            <?php
                            }
                            ?>

                        </select>
                    </div>
                </div>
                <?php } else { ?>
                <div class="col-md-2">
                    <div class="input-group mb-3 mb-md-0">
                        <select class="form-control select2" name="client" onchange="this.form.submit()">
                            <option value="" <?php if ($client == "") { echo "selected"; } ?>>- All Clients -</option>

                            <?php
                            $sql_clients_filter = mysqli_query($mysqli, "
                                SELECT DISTINCT client_id, client_name
                                FROM clients
                                JOIN contacts ON contact_client_id = client_id
                                WHERE $archive_query
                                $access_permission_query
                                ORDER BY client_name ASC
                            ");
                            while ($row = mysqli_fetch_array($sql_clients_filter)) {
                                $client_id = intval($row['client_id']);
                                $client_name = nullable_htmlentities($row['client_name']);
                            ?>
                                <option <?php if ($client == $client_id) { echo "selected"; } ?> value="<?php echo $client_id; ?>"><?php echo $client_name; ?></option>
                            <?php
                            }
                            ?>

                        </select>
                    </div>
                </div>
                <?php } ?>

                <div class="col-md-3">
                    <div class="btn-group float-right">
                        <a href="?<?php echo $client_url; ?>archived=<?php if($archived == 1){ echo 0; } else { echo 1; } ?>"
                            class="btn btn-<?php if($archived == 1){ echo "primary"; } else { echo "default"; } ?>">
                            <i class="fa fa-fw fa-archive mr-2"></i>Archived
                        </a>
                        <div class="dropdown ml-2" id="bulkActionButton" hidden>
                            <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown">
                                <i class="fas fa-fw fa-layer-group mr-2"></i>Bulk Action (<span id="selectedCount">0</span>)
                            </button>
                            <div class="dropdown-menu">
                                <?php if ($client_url) { ?>
                                <a class="dropdown-item ajax-modal" href="#"
                                    data-modal-url="modals/contact/contact_bulk_assign_location.php?<?= $client_url ?>"
                                    data-bulk="true">
                                    <i class="fas fa-fw fa-map-marker-alt mr-2"></i>Assign Location
                                </a>
                                <div class="dropdown-divider"></div>
                                <?php } ?>
                                <a class="dropdown-item ajax-modal" href="#"
                                    data-modal-url="modals/contact/contact_bulk_edit_phone.php"
                                    data-bulk="true">
                                    <i class="fas fa-fw fa-phone-alt mr-2"></i>Set Phone Number
                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item ajax-modal" href="#"
                                    data-modal-url="modals/contact/contact_bulk_edit_department.php"
                                    data-bulk="true">
                                    <i class="fas fa-fw fa-users mr-2"></i>Set Department
                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item ajax-modal" href="#"
                                    data-modal-url="modals/contact/contact_bulk_edit_role.php"
                                    data-bulk="true">
                                    <i class="fas fa-fw fa-user-shield mr-2"></i>Set Roles
                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item ajax-modal" href="#"
                                    data-modal-url="modals/contact/contact_bulk_assign_tags.php"
                                    data-bulk="true">
                                    <i class="fas fa-fw fa-tags mr-2"></i>Assign Tags
                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item ajax-modal" href="#"
                                    data-modal-url="modals/contact/contact_bulk_email.php"
                                    data-modal-size="lg"
                                    data-bulk="true">
                                    <i class="fas fa-fw fa-paper-plane mr-2"></i>Send Email
                                </a>
                                <?php if ($archived) { ?>
                                <div class="dropdown-divider"></div>
                                <button class="dropdown-item text-info"
                                    type="submit" form="bulkActions" name="bulk_unarchive_contacts">
                                    <i class="fas fa-fw fa-redo mr-2"></i>Unarchive
                                </button>
                                <div class="dropdown-divider"></div>
                                <button class="dropdown-item text-danger text-bold"
                                    type="submit" form="bulkActions" name="bulk_delete_contacts">
                                    <i class="fas fa-fw fa-trash mr-2"></i>Delete
                                </button>
                                <?php } else { ?>
                                <div class="dropdown-divider"></div>
                                <button class="dropdown-item text-danger confirm-link"
                                    type="submit" form="bulkActions" name="bulk_archive_contacts">
                                    <i class="fas fa-fw fa-archive mr-2"></i>Archive
                                </button>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </form>
        <hr>
        <form id="bulkActions" action="post.php" method="post" enctype="multipart/form-data">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token'] ?>">

            <div class="table-responsive-sm">
                <table class="table border">
                    <thead class="thead-light <?php if (!$num_rows[0]) { echo "d-none"; } ?>">
                    <tr>
                        <td class="bg-light pr-0">
                            <div class="form-check">
                                <input class="form-check-input" id="selectAllCheckbox" type="checkbox" onclick="checkAll(this)">
                            </div>
                        </td>
                        <th>
                            <a class="text-secondary ml-3" href="?<?php echo $url_query_strings_sort; ?>&sort=contact_name&order=<?php echo $disp; ?>">
                                Name <?php if ($sort == 'contact_name') { echo $order_icon; } ?>
                            </a>
                        </th>
                        <th>
                            <a class="text-secondary" href="?<?php echo $url_query_strings_sort; ?>&sort=contact_department&order=<?php echo $disp; ?>">
                                Department <?php if ($sort == 'contact_department') { echo $order_icon; } ?>
                            </a>
                        </th>
                        <th>Contact</th>
                        <th>
                            <a class="text-secondary" href="?<?php echo $url_query_strings_sort; ?>&sort=location_name&order=<?php echo $disp; ?>">
                                Location <?php if ($sort == 'location_name') { echo $order_icon; } ?>
                            </a>
                        </th>
                        <th></th>
                        <?php if (!$client_url) { ?>
                        <th>
                            <a class="text-secondary" href="?<?php echo $url_query_strings_sort; ?>&sort=client_name&order=<?php echo $disp; ?>">
                                Client <?php if ($sort == 'client_name') { echo $order_icon; } ?>
                            </a>
                        </th>
                        <?php } ?>
                        <th class="text-center">Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php

                    while ($row = mysqli_fetch_array($sql)) {
                        $client_id = intval($row['client_id']);
                        $client_name = nullable_htmlentities($row['client_name']);
                        $contact_id = intval($row['contact_id']);
                        $contact_name = nullable_htmlentities($row['contact_name']);
                        $contact_title = nullable_htmlentities($row['contact_title']);
                        if (empty($contact_title)) {
                            $contact_title_display = "";
                        } else {
                            $contact_title_display = "<small class='text-secondary'>$contact_title</small>";
                        }
                        $contact_department = getFallBack(nullable_htmlentities($row['contact_department']));
                        $contact_extension = nullable_htmlentities($row['contact_extension']);
                        if (empty($contact_extension)) {
                            $contact_extension_display = "";
                        } else {
                            $contact_extension_display = "<small class='text-secondary ml-1'>x$contact_extension</small>";
                        }
                        $contact_phone_country_code = nullable_htmlentities($row['contact_phone_country_code']);
                        $contact_phone = nullable_htmlentities(formatPhoneNumber($row['contact_phone'], $contact_phone_country_code));
                        if (empty($contact_phone)) {
                            $contact_phone_display = "";
                        } else {
                            $contact_phone_display = "<div><i class='fas fa-fw fa-phone mr-2'></i><a href='tel:$contact_phone'>$contact_phone$contact_extension_display</a></div>";
                        }
                        $contact_mobile_country_code = nullable_htmlentities($row['contact_mobile_country_code']);
                        $contact_mobile = nullable_htmlentities(formatPhoneNumber($row['contact_mobile'], $contact_mobile_country_code));
                        if (empty($contact_mobile)) {
                            $contact_mobile_display = "";
                        } else {
                            $contact_mobile_display = "<div class='mt-2'><i class='fas fa-fw fa-mobile-alt mr-2'></i><a href='tel:$contact_mobile'>$contact_mobile</a></div>";
                        }
                        $contact_email = nullable_htmlentities($row['contact_email']);
                        if (empty($contact_email)) {
                            $contact_email_display = "";
                        } else {
                            $contact_email_display = "<div class='mt-1'><i class='fas fa-fw fa-envelope mr-2'></i><a href='mailto:$contact_email'>$contact_email</a><button class='btn btn-sm clipboardjs' type='button' data-clipboard-text='$contact_email'><i class='far fa-copy text-secondary'></i></button></div>";
                        }
                        $contact_info_display = "$contact_phone_display $contact_mobile_display $contact_email_display";
                        if (empty($contact_info_display)) {
                            $contact_info_display = "-";
                        }
                        $contact_pin = nullable_htmlentities($row['contact_pin']);
                        $contact_photo = nullable_htmlentities($row['contact_photo']);
                        $contact_initials = initials($contact_name);
                        $contact_notes = nullable_htmlentities($row['contact_notes']);
                        $contact_primary = intval($row['contact_primary']);
                        $contact_important = intval($row['contact_important']);
                        $contact_billing = intval($row['contact_billing']);
                        $contact_technical = intval($row['contact_technical']);
                        $contact_created_at = nullable_htmlentities($row['contact_created_at']);
                        $contact_archived_at = nullable_htmlentities($row['contact_archived_at']);
                        if ($contact_primary == 1) {
                            $contact_primary_display = "<small class='text-success'>Primary Contact</small>";
                        } else {
                            $contact_primary_display = false;
                        }
                        $contact_location_id = intval($row['contact_location_id']);
                        $location_name = nullable_htmlentities($row['location_name']);
                        if (empty($location_name)) {
                            $location_name = "<span class='text-muted'>N/A</span>";
                        }
                        $location_archived_at = nullable_htmlentities($row['location_archived_at']);
                        if ($location_archived_at) {
                            $location_name_display = "<div class='text-danger' title='Archived'><s>$location_name</s></div>";
                        } else {
                            $location_name_display = $location_name;
                        }
                        $auth_method = nullable_htmlentities($row['user_auth_method']);
                        $contact_user_id = intval($row['contact_user_id']);
                        if ($contact_user_id) {
                            $user_exists_display = "<span class='badge badge-pill badge-dark p-1' title='User: $auth_method'><i class='fas fa-fw fa-user'></i></span>";
                        } else {
                            $user_exists_display = "";
                        }

                        // Counts

                        // Asset Count
                        $row = mysqli_fetch_assoc(mysqli_query($mysqli, "SELECT COUNT('asset_id') AS num FROM assets WHERE asset_contact_id = $contact_id AND asset_archived_at IS NULL"));
                        $asset_count = $row['num'];
                        if ($asset_count) {
                            $asset_count_display = "<a href='contact_details.php?client_id=$client_id&contact_id=$contact_id#assets' class='mr-2 mb-1 badge badge-pill badge-dark p-2' title='Assets ($asset_count)'><i class='fas fa-fw fa-desktop mr-2'></i>$asset_count</a>";
                        } else {
                            $asset_count_display = '';
                        }

                        // Credential Count
                        $row = mysqli_fetch_assoc(mysqli_query($mysqli, "SELECT COUNT('credential_id') AS num FROM credentials WHERE credential_contact_id = $contact_id AND credential_archived_at IS NULL"));
                        $credential_count = $row['num'];
                        if ($credential_count) {
                            $credential_count_display = "<a href='contact_details.php?client_id=$client_id&contact_id=$contact_id#credentials' class='mr-2 mb-1 badge badge-pill badge-secondary p-2' title='Credentials ($credential_count)'><i class='fas fa-fw fa-key mr-2'></i>$credential_count</a>";
                        } else {
                            $credential_count_display = '';
                        }

                        // Software Count
                        $row = mysqli_fetch_assoc(mysqli_query($mysqli, "SELECT COUNT('software_id') AS num FROM software, software_contacts WHERE software.software_id = software_contacts.software_id AND software_contacts.contact_id = $contact_id AND software_archived_at IS NULL"));
                        $software_count = $row['num'];
                        if ($software_count) {
                            $software_count_display = "<a href='contact_details.php?client_id=$client_id&contact_id=$contact_id#software' class='mr-2 mb-1 badge badge-pill badge-secondary p-2' title='Licenses ($software_count)'><i class='fas fa-fw fa-cube mr-2'></i>$software_count</a>";
                        } else {
                            $software_count_display = '';
                        }

                        // Ticket Count
                        $row = mysqli_fetch_assoc(mysqli_query($mysqli, "SELECT COUNT('ticket_id') AS num FROM tickets WHERE ticket_contact_id = $contact_id AND ticket_archived_at IS NULL"));
                        $ticket_count = $row['num'];
                        if ($ticket_count) {
                            $ticket_count_display = "<a href='contact_details.php?client_id=$client_id&contact_id=$contact_id#tickets' class='mr-2 mb-1 badge badge-pill badge-secondary p-2' title='Tickets ($ticket_count)'><i class='fas fa-fw fa-life-ring mr-2'></i>$ticket_count</a>";
                        } else {
                            $ticket_count_display = '';
                        }

                        // Tags
                        $contact_tag_name_display_array = array();
                        $contact_tag_id_array = array();
                        $sql_contact_tags = mysqli_query($mysqli, "SELECT * FROM contact_tags LEFT JOIN tags ON contact_tags.tag_id = tags.tag_id WHERE contact_id = $contact_id ORDER BY tag_name ASC");
                        while ($row = mysqli_fetch_array($sql_contact_tags)) {

                            $contact_tag_id = intval($row['tag_id']);
                            $contact_tag_name = nullable_htmlentities($row['tag_name']);
                            $contact_tag_color = nullable_htmlentities($row['tag_color']);
                            if (empty($contact_tag_color)) {
                                $contact_tag_color = "dark";
                            }
                            $contact_tag_icon = nullable_htmlentities($row['tag_icon']);
                            if (empty($contact_tag_icon)) {
                                $contact_tag_icon = "tag";
                            }

                            $contact_tag_id_array[] = $contact_tag_id;
                            $contact_tag_name_display_array[] = "<a href='contacts.php?$client_url tags[]=$contact_tag_id'><span class='badge text-light p-1 mr-1' style='background-color: $contact_tag_color;'><i class='fa fa-fw fa-$contact_tag_icon mr-2'></i>$contact_tag_name</span></a>";
                        }
                        $contact_tags_display = implode('', $contact_tag_name_display_array);

                        ?>
                        <tr>
                            <td class="pr-0 bg-light">
                                <div class="form-check">
                                    <input class="form-check-input bulk-select" type="checkbox" name="contact_ids[]" value="<?php echo $contact_id ?>">
                                </div>
                            </td>
                            <td>
                                <a class="text-dark" href="contact_details.php?client_id=<?php echo $client_id; ?>&contact_id=<?php echo $contact_id; ?>">
                                    <div class="media">
                                        <?php if ($contact_photo) { ?>
                                            <span class="fa-stack fa-2x mr-3 text-center">
                                                <img class="img-size-50 img-circle" src="<?php echo "../uploads/clients/$client_id/$contact_photo"; ?>">
                                            </span>
                                        <?php } else { ?>
                                            <span class="fa-stack fa-2x mr-3">
                                                <i class="fa fa-circle fa-stack-2x text-secondary"></i>
                                                <span class="fa fa-stack-1x text-white"><?php echo $contact_initials; ?></span>
                                            </span>
                                        <?php } ?>

                                        <div class="media-body">
                                            <div class="<?php if($contact_important) { echo "text-bold"; } ?>"><?php echo $contact_name; ?> <?php echo $user_exists_display; ?></div>
                                            <?php echo $contact_title_display; ?>
                                            <div><?php echo $contact_primary_display; ?></div>
                                            <?php
                                            if (!empty($contact_tags_display)) { ?>
                                                <div class="mt-1">
                                                    <?php echo $contact_tags_display; ?>
                                                </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </a>

                            </td>
                            <td><?php echo $contact_department; ?></td>
                            <td><?php echo $contact_info_display; ?></td>
                            <td><?php echo $location_name_display; ?></td>
                            <td>
                                <?php echo "$asset_count_display$credential_count_display$software_count_display$ticket_count_display"; ?>
                            </td>
                            <?php if (!$client_url) { ?>
                            <td><a href="contacts.php?client_id=<?php echo $client_id; ?>"><?php echo $client_name; ?></a></td>
                            <?php } ?>
                            <td>
                                <div class="dropdown dropleft text-center">
                                    <button class="btn btn-secondary btn-sm" type="button" data-toggle="dropdown">
                                        <i class="fas fa-ellipsis-h"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="contact_details.php?<?= $client_url ?>contact_id=<?= $contact_id ?>">
                                            <i class="fas fa-fw fa-eye mr-2"></i>Details
                                        </a>
                                        <a class="dropdown-item ajax-modal" href="#" data-modal-url="modals/contact/contact_note_add.php?id=<?= $contact_id ?>">
                                            <i class="fas fa-fw fa-sticky-note mr-2"></i>Make Note
                                        </a>
                                        <a class="dropdown-item ajax-modal" href="#" data-modal-url="modals/contact/contact_edit.php?id=<?= $contact_id ?>">
                                            <i class="fas fa-fw fa-edit mr-2"></i>Edit
                                        </a>
                                        <?php if ($session_user_role == 3 && $contact_primary == 0) { ?>
                                            <?php if ($contact_archived_at) { ?>
                                            <div class="dropdown-divider"></div>
                                            <a class="dropdown-item text-info confirm-link" href="post.php?unarchive_contact=<?php echo $contact_id; ?>">
                                                <i class="fas fa-fw fa-redo mr-2"></i>Unarchive
                                            </a>
                                            <?php } else { ?>
                                            <div class="dropdown-divider"></div>
                                            <a class="dropdown-item text-danger confirm-link" href="post.php?archive_contact=<?php echo $contact_id; ?>">
                                                <i class="fas fa-fw fa-archive mr-2"></i>Archive
                                            </a>
                                            <div class="dropdown-divider"></div>
                                            <a class="dropdown-item text-danger confirm-link" href="post.php?anonymize_contact=<?php echo $contact_id; ?>">
                                                <i class="fas fa-fw fa-user-secret mr-2"></i>Anonymize & Archive
                                            </a>
                                            <?php } ?>

                                            <?php if ($config_destructive_deletes_enable) { ?>
                                            <div class="dropdown-divider"></div>
                                            <a class="dropdown-item text-danger text-bold confirm-link" href="post.php?delete_contact=<?php echo $contact_id; ?>">
                                                <i class="fas fa-fw fa-trash mr-2"></i>Delete
                                            </a>
                                            <?php } ?>
                                        <?php } ?>
                                    </div>
                                </div>
                            </td>
                        </tr>

                        <?php
                    }

                    ?>

                    </tbody>
                </table>
            </div>
        </form>
        <?php require_once "../includes/filter_footer.php"; ?>
    </div>
</div>

<script src="../js/bulk_actions.js"></script>

<?php
require_once "../includes/footer.php";
