<?php

require_once '../../../includes/modal_header.php';

$expense_ids = array_map('intval', $_GET['expense_ids'] ?? []);

$count = count($expense_ids);

// Generate the HTML form content using output buffering.
ob_start();

?>
<div class="modal-header bg-dark">
    <h5 class="modal-title"><i class="fa fa-fw fa-list mr-2"></i>Set Category: <strong><?= $count ?></strong> Expense<?= $count == 1 ? '' : 's' ?></h5>
    <button type="button" class="close text-white" data-dismiss="modal">
        <span>&times;</span>
    </button>
</div>

<form action="post.php" method="post" autocomplete="off">
    <div class="modal-body">
        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
        <?php
        foreach ($expense_ids as $expense_id) { ?>
            <input type="hidden" name="expense_ids[]" value="<?= $expense_id ?>">
        <?php
        }
        ?>

        <div class="form-group">
            <label>Category <strong class="text-danger">*</strong></label>
            <div class="input-group">
                <div class="input-group-prepend">
                    <span class="input-group-text"><i class="fa fa-fw fa-list"></i></span>
                </div>
                <select class="form-control select2" name="bulk_category_id" data-placeholder="- Select a Category -" required>
                    <option></option>
                    <?php

                    $sql = mysqli_query($mysqli, "SELECT category_id, category_name FROM categories WHERE category_type = 'Expense' AND category_archived_at IS NULL ORDER BY category_name ASC");
                    while ($row = mysqli_fetch_array($sql)) {
                        $category_id = intval($row['category_id']);
                        $category_name = nullable_htmlentities($row['category_name']);
                        ?>
                        <option value="<?php echo $category_id; ?>"><?php echo $category_name; ?></option>

                        <?php
                    }
                    ?>
                </select>
            </div>
        </div>

    </div>
    <div class="modal-footer">
        <button type="submit" name="bulk_edit_expense_category" class="btn btn-primary text-bold"><i class="fa fa-fw fa-check mr-2"></i>Set</button>
        <button type="button" class="btn btn-light" data-dismiss="modal"><i class="fa fa-times mr-2"></i>Cancel</button>
    </div>
</form>

<?php
require_once '../../../includes/modal_footer.php';
