<?php

require_once '../../../includes/modal_header.php';

$client_id = intval($_GET['client_id'] ?? 0);

ob_start();

?>
<div class="modal-header bg-dark">
    <h5 class="modal-title"><i class="fas fa-fw fa-project-diagram mr-2"></i>New Project</h5>
    <button type="button" class="close text-white" data-dismiss="modal">
        <span>&times;</span>
    </button>
</div>
<form action="post.php" method="post" autocomplete="off">

    <div class="modal-body">

        <?php if ($client_id) { ?>
            <input type="hidden" name="client_id" value="<?= $client_id ?>">
        <?php } else { ?>
            <div class="form-group">
                <label>Client</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fa fa-fw fa-users"></i></span>
                    </div>
                    <select class="form-control select2" name="client_id">
                        <option value="0">- No Client -</option>
                        <?php
                        $sql = mysqli_query($mysqli, "SELECT * FROM clients WHERE client_archived_at IS NULL $access_permission_query ORDER BY client_name ASC");
                        while ($row = mysqli_fetch_array($sql)) {
                            $client_id_select = intval($row['client_id']);
                            $client_name = nullable_htmlentities($row['client_name']);
                        ?>
                        <option value="<?php echo $client_id_select; ?>"><?php echo $client_name; ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>
        <?php } ?>

        <div class="form-group">
            <label>Project Name <strong class="text-danger">*</strong></label>
            <div class="input-group">
                <div class="input-group-prepend">
                    <span class="input-group-text"><i class="fa fa-fw fa-project-diagram"></i></span>
                </div>
                <input type="text" class="form-control" name="name" placeholder="Project Name" maxlength="255" required autofocus>
            </div>
        </div>

        <div class="form-group">
            <label>Template</label>
            <div class="input-group">
                <div class="input-group-prepend">
                    <span class="input-group-text"><i class="fa fa-fw fa-cube"></i></span>
                </div>
                <select class="form-control select2" name="project_template_id">
                    <option value="">- Template -</option>
                    <?php
                    $sql = mysqli_query($mysqli, "SELECT * FROM project_templates WHERE project_template_archived_at IS NULL ORDER BY project_template_name ASC");
                    while ($row = mysqli_fetch_array($sql)) {
                        $project_template_id = intval($row['project_template_id']);
                        $project_template_name = nullable_htmlentities($row['project_template_name']);
                    ?>
                    <option value="<?php echo $project_template_id; ?>"><?php echo $project_template_name; ?></option>
                    <?php } ?>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label>Description</label>
            <div class="input-group">
                <div class="input-group-prepend">
                    <span class="input-group-text"><i class="fa fa-fw fa-angle-right"></i></span>
                </div>
                <input type="text" class="form-control" name="description" placeholder="Description">
            </div>
        </div>


        <div class="form-group">
            <label>Date Due <strong class="text-danger">*</strong></label>
            <div class="input-group">
                <div class="input-group-prepend">
                    <span class="input-group-text"><i class="fa fa-fw fa-calendar"></i></span>
                </div>
                <input type="date" class="form-control" name="due_date" required>
            </div>
        </div>

        <div class="form-group">
            <label>Project Manager</label>
            <div class="input-group">
                <div class="input-group-prepend">
                    <span class="input-group-text"><i class="fa fa-fw fa-user-tie"></i></span>
                </div>
                <select class="form-control select2" name="project_manager">
                    <option value="0">No Manager</option>
                    <?php

                    $sql = mysqli_query(
                        $mysqli,
                        "SELECT user_id, user_name FROM users
                        WHERE user_role_id > 1 AND user_status = 1 AND user_archived_at IS NULL ORDER BY user_name ASC"
                    );
                    while ($row = mysqli_fetch_array($sql)) {
                        $user_id = intval($row['user_id']);
                        $user_name = nullable_htmlentities($row['user_name']); ?>
                        <option value="<?php echo $user_id; ?>"><?php echo $user_name; ?></option>
                    <?php } ?>
                </select>
            </div>
        </div>

    </div>
    <div class="modal-footer">
        <button type="submit" name="add_project" class="btn btn-primary text-bold"><i class="fas fa-check mr-2"></i>Create</button>
        <button type="button" class="btn btn-light" data-dismiss="modal"><i class="fa fa-times mr-2"></i>Cancel</button>
    </div>
</form>

<?php
require_once '../../../includes/modal_footer.php';
