<?php

require_once '../../../includes/modal_header.php';

ob_start();

?>
<div class="modal-header bg-dark">
    <h5 class="modal-title"><i class="fas fa-fw fa-hand-holding-usd mr-2"></i>New Revenue</h5>
    <button type="button" class="close text-white" data-dismiss="modal">
        <span>&times;</span>
    </button>
</div>
<form action="post.php" method="post" autocomplete="off">
    <div class="modal-body">

        <div class="form-row">

            <div class="form-group col-md">
                <label>Date <strong class="text-danger">*</strong></label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fa fa-fw fa-calendar"></i></span>
                    </div>
                    <input type="date" class="form-control" name="date" max="2999-12-31" value="<?php echo date("Y-m-d"); ?>" required>
                </div>
            </div>

            <div class="form-group col-md">
                <label>Amount <strong class="text-danger">*</strong></label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fa fa-fw fa-dollar-sign"></i></span>
                    </div>
                    <input type="text" class="form-control" inputmode="decimal" pattern="[0-9]*\.?[0-9]{0,2}" name="amount" placeholder="0.00" required>
                </div>
            </div>

        </div>

        <div class="form-row">

            <div class="form-group col-md">
                <label>Account <strong class="text-danger">*</strong></label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fa fa-fw fa-piggy-bank"></i></span>
                    </div>
                    <select class="form-control select2" name="account" required>
                        <option value="">- Account -</option>
                        <?php

                        $sql = mysqli_query($mysqli, "SELECT * FROM accounts WHERE account_archived_at IS NULL ORDER BY account_name ASC");
                        while ($row = mysqli_fetch_array($sql)) {
                            $account_id = intval($row['account_id']);
                            $account_name = nullable_htmlentities($row['account_name']);
                            $account_currency_code = nullable_htmlentities($row['account_currency_code']);
                            $opening_balance = floatval($row['opening_balance']);

                            $sql_payments = mysqli_query($mysqli, "SELECT SUM(payment_amount) AS total_payments FROM payments WHERE payment_account_id = $account_id");
                            $row = mysqli_fetch_array($sql_payments);
                            $total_payments = floatval($row['total_payments']);

                            $sql_revenues = mysqli_query($mysqli, "SELECT SUM(revenue_amount) AS total_revenues FROM revenues WHERE revenue_account_id = $account_id");
                            $row = mysqli_fetch_array($sql_revenues);
                            $total_revenues = floatval($row['total_revenues']);

                            $sql_expenses = mysqli_query($mysqli, "SELECT SUM(expense_amount) AS total_expenses FROM expenses WHERE expense_account_id = $account_id");
                            $row = mysqli_fetch_array($sql_expenses);
                            $total_expenses = floatval($row['total_expenses']);

                            $balance = $opening_balance + $total_payments + $total_revenues - $total_expenses;

                            ?>
                            <option <?php if ($config_default_payment_account == $account_id) { echo "selected"; } ?> value="<?php echo $account_id; ?>"><?php echo $account_name; ?> [ <?php echo numfmt_format_currency($currency_format, $balance, $account_currency_code); ?> ]</option>

                            <?php
                        }
                        ?>
                    </select>
                </div>
            </div>

            <div class="form-group col-md">
                <label>Category <strong class="text-danger">*</strong></label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fa fa-fw fa-money-check-alt"></i></span>
                    </div>
                    <select class="form-control select2" name="category" required>
                        <option value="">- Category -</option>
                        <?php

                        $sql = mysqli_query($mysqli, "SELECT * FROM categories WHERE category_type = 'Income' AND category_archived_at IS NULL ORDER BY category_name ASC");
                        while ($row = mysqli_fetch_array($sql)) {
                            $category_id = intval($row['category_id']);
                            $category_name = nullable_htmlentities($row['category_name']);
                            ?>
                            <option value="<?php echo $category_id; ?>"><?php echo $category_name; ?></option>

                            <?php
                        }
                        ?>
                    </select>
                    <div class="input-group-append">
                        <button class="btn btn-secondary ajax-modal" type="button"
                            data-modal-url="../admin/modals/category/category_add.php?category=Income">
                            <i class="fas fa-fw fa-plus"></i>
                        </button>
                    </div>
                </div>
            </div>

        </div>

        <div class="form-group">
            <label>Description</label>
            <textarea class="form-control" rows="5" name="description" placeholder="Enter a description"></textarea>
        </div>

        <div class="form-row">

            <div class="form-group col-md">
                <label>Payment Method <strong class="text-danger">*</strong></label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fa fa-fw fa-money-check-alt"></i></span>
                    </div>
                    <select class="form-control select2" name="payment_method" required>
                        <option value="">- Method of Payment -</option>
                        <?php

                        $sql = mysqli_query($mysqli, "SELECT * FROM payment_methods ORDER BY payment_method_name ASC");
                        while ($row = mysqli_fetch_array($sql)) {
                            $payment_method_name = nullable_htmlentities($row['payment_method_name']);
                            ?>
                            <option><?php echo $payment_method_name; ?></option>

                            <?php
                        }
                        ?>
                    </select>
                </div>
            </div>

            <div class="form-group col-md">
                <label>Reference</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fa fa-fw fa-file-alt"></i></span>
                    </div>
                    <input type="text" class="form-control" name="reference" placeholder="Check #, trans #, etc" maxlength="200">
                </div>
            </div>

        </div>

    </div>
    <div class="modal-footer">
        <button type="submit" name="add_revenue" class="btn btn-primary text-bold"><i class="fas fa-check mr-2"></i>Add Revenue</button>
        <button type="button" class="btn btn-light" data-dismiss="modal"><i class="fas fa-times mr-2"></i>Cancel</button>
    </div>
</form>

<?php
require_once '../../../includes/modal_footer.php';
