<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2017 Zurmo Inc.
     *
     * Zurmo is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Affero General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * Zurmo is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
     * details.
     *
     * You should have received a copy of the GNU Affero General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 27 North Wacker Drive
     * Suite 370 Chicago, IL 60606. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in original and modified versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU Affero General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the Zurmo
     * logo and Zurmo copyright notice. If the display of the logo is not reasonably
     * feasible for technical reasons, the Appropriate Legal Notices must display the words
     * "Copyright Zurmo Inc. 2017. All rights reserved".
     ********************************************************************************/

    Yii::import('application.modules.productTemplates.controllers.DefaultController', true);
    class ProductTemplatesDemoController extends ProductTemplatesDefaultController
    {
        /**
         * Special method to load product template.
         */
        public function actionLoadProductTemplatesSampler()
        {
            if (!Group::isUserASuperAdministrator(Yii::app()->user->userModel))
            {
                throw new NotSupportedException();
            }

            //Load 12 so there is sufficient data for product template related view pagination testing.
            for ($i = 1; $i <= 12; $i++)
            {
                $currencies = Currency::getAll('id');
                $currencyIndex                   = array_rand($currencies);

                $productTemplate                            = new ProductTemplate();
                $productTemplate->name                      = 'Product Template '. $i;
                $productTemplate->status                    = 2;
                $productTemplate->type                      = 1;
                $productTemplate->priceFrequency            = 2;
                $sellPriceFormula                           = new SellPriceFormula();
                $sellPriceFormula->type                     = SellPriceFormula::TYPE_EDITABLE;
                $productTemplate->sellPriceFormula          = $sellPriceFormula;
                $currencyValue                              = new CurrencyValue();
                $currencyValue->currency                    = $currencies[$currencyIndex];
                $productTemplate->cost                      = $currencyValue;
                $productTemplate->cost->value               = 200;
                $currencyValue                              = new CurrencyValue();
                $currencyValue->currency                    = $currencies[$currencyIndex];
                $productTemplate->sellPrice                 = $currencyValue;
                $productTemplate->sellPrice->value          = 200;
                $currencyValue                              = new CurrencyValue();
                $currencyValue->currency                    = $currencies[$currencyIndex];
                $productTemplate->listPrice                 = $currencyValue;
                $productTemplate->listPrice->value          = 200;

                $saved                                      = $productTemplate->save();

                if (!$saved)
                {
                    throw new NotSupportedException();
                }
            }
        }
    }
?>
