<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2017 Zurmo Inc.
     *
     * Zurmo is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Affero General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * Zurmo is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
     * details.
     *
     * You should have received a copy of the GNU Affero General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 27 North Wacker Drive
     * Suite 370 Chicago, IL 60606. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in original and modified versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU Affero General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the Zurmo
     * logo and Zurmo copyright notice. If the display of the logo is not reasonably
     * feasible for technical reasons, the Appropriate Legal Notices must display the words
     * "Copyright Zurmo Inc. 2017. All rights reserved".
     ********************************************************************************/

    /**
     * Import rules for any derived attributes that are of type Password
     */
    class UserStatusAttributeImportRules extends AfterSaveActionDerivedAttributeImportRules
    {
        protected static function getAllModelAttributeMappingRuleFormTypesAndElementTypes()
        {
            return array('UserStatusDefaultValue' => 'ImportMappingRuleUserStatusDropDown');
        }

        public function getDisplayLabel()
        {
            return Zurmo::t('ZurmoModule', 'Status');
        }

        /**
         * @return array
         */
        public function getRealModelAttributeNames()
        {
            return array();
        }

        public static function getSanitizerUtilTypesInProcessingOrder()
        {
            return array('UserStatus');
        }

        public function resolveValueForImport($value, $columnName, $columnMappingData, ImportSanitizeResultsUtil $importSanitizeResultsUtil)
        {
            assert('is_string($columnName)');
            assert('is_array($columnMappingData)');
            $modelClassName = $this->getModelClassName();
            $value          = ImportSanitizerUtil::
                              sanitizeValueBySanitizerTypes(static::getSanitizerUtilTypesInProcessingOrder(),
                                                            $modelClassName, null, $value, $columnName, $columnMappingData,
                                                            $importSanitizeResultsUtil);
            if ($value == null)
            {
                $mappingRuleFormClassName = 'UserStatusDefaultValueMappingRuleForm';
                $mappingRuleData          = $columnMappingData['mappingRulesData'][$mappingRuleFormClassName];
                assert('$mappingRuleData != null');
                if (isset($mappingRuleData['defaultValue']))
                {
                    $value = $mappingRuleData['defaultValue'];
                }
                else
                {
                    //The default value dropdown will be either active or inactive. There is no blank.
                    throw new NotSupportedException();
                }
            }
            return array('status' => $value);
        }

        /**
         * @param RedBeanModel $model
         * @param array $attributeValueData
         */
        public static function processAfterSaveAction(RedBeanModel $model, $attributeValueData)
        {
            assert('$model instanceof User');
            assert('is_array($attributeValueData) && count($attributeValueData) == 1');
            assert('isset($attributeValueData["status"]) && ($attributeValueData["status"] == UserStatusUtil::ACTIVE ||
                    $attributeValueData["status"] == UserStatusUtil::INACTIVE)');
            $userStatus = new UserStatus();

            if ($attributeValueData['status'] == UserStatusUtil::INACTIVE)
            {
                $userStatus->setInactive();
            }
            UserStatusUtil::resolveUserStatus($model, $userStatus);
        }
    }
?>